/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.server;

import com.vaadin.featurepack.server.Resource;
import com.vaadin.featurepack.util.FileTypeResolver;
import java.io.Serializable;
import java.net.URL;

public class ExternalResource
implements Resource,
Serializable {
    private String sourceURL = null;
    private String mimeType = null;

    public ExternalResource(URL sourceURL) {
        if (sourceURL == null) {
            throw new RuntimeException("Source must be non-null");
        }
        this.sourceURL = sourceURL.toString();
    }

    public ExternalResource(URL sourceURL, String mimeType) {
        this(sourceURL);
        this.mimeType = mimeType;
    }

    public ExternalResource(String sourceURL) {
        if (sourceURL == null) {
            throw new RuntimeException("Source must be non-null");
        }
        this.sourceURL = sourceURL.toString();
    }

    public ExternalResource(String sourceURL, String mimeType) {
        this(sourceURL);
        this.mimeType = mimeType;
    }

    public String getURL() {
        return this.sourceURL;
    }

    @Override
    public String getMIMEType() {
        if (this.mimeType == null) {
            this.mimeType = FileTypeResolver.getMIMEType(this.getURL().toString());
        }
        return this.mimeType;
    }

    public void setMIMEType(String mimeType) {
        this.mimeType = mimeType;
    }
}

