/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.server;

import com.vaadin.featurepack.server.AbstractErrorMessage;
import com.vaadin.featurepack.server.ErrorMessage;
import com.vaadin.featurepack.shared.ui.ErrorLevel;
import java.util.Collection;
import java.util.Iterator;

public class CompositeErrorMessage
extends AbstractErrorMessage {
    public CompositeErrorMessage(ErrorMessage ... errorMessages) {
        super(null);
        this.setErrorLevel(ErrorLevel.INFO);
        for (ErrorMessage errorMessage : errorMessages) {
            this.addErrorMessage(errorMessage);
        }
        if (this.getCauses().isEmpty()) {
            throw new IllegalArgumentException("Composite error message must have at least one error");
        }
    }

    public CompositeErrorMessage(Collection<? extends ErrorMessage> errorMessages) {
        super(null);
        this.setErrorLevel(ErrorLevel.INFO);
        for (ErrorMessage errorMessage : errorMessages) {
            this.addErrorMessage(errorMessage);
        }
        if (this.getCauses().isEmpty()) {
            throw new IllegalArgumentException("Composite error message must have at least one error");
        }
    }

    private void addErrorMessage(ErrorMessage error) {
        if (error != null && !this.getCauses().contains(error)) {
            this.addCause(error);
            if (error.getErrorLevel().intValue() > this.getErrorLevel().intValue()) {
                this.setErrorLevel(error.getErrorLevel());
            }
        }
    }

    public Iterator<ErrorMessage> iterator() {
        return this.getCauses().iterator();
    }

    @Override
    public String toString() {
        Object retval = "[";
        int pos = 0;
        for (ErrorMessage errorMessage : this.getCauses()) {
            if (pos > 0) {
                retval = (String)retval + ",";
            }
            ++pos;
            retval = (String)retval + errorMessage.toString();
        }
        retval = (String)retval + "]";
        return retval;
    }
}

