/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.event;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.Set;

public class SelectionEvent
extends EventObject {
    private final LinkedHashSet<Object> oldSelection;
    private final LinkedHashSet<Object> newSelection;

    public SelectionEvent(Object source, Collection<Object> oldSelection, Collection<Object> newSelection) {
        super(source);
        this.oldSelection = new LinkedHashSet<Object>(oldSelection);
        this.newSelection = new LinkedHashSet<Object>(newSelection);
    }

    public Set<Object> getAdded() {
        return SelectionEvent.setDifference(this.newSelection, this.oldSelection);
    }

    public Set<Object> getRemoved() {
        return SelectionEvent.setDifference(this.oldSelection, this.newSelection);
    }

    private static <T> Set<T> setDifference(Set<T> set1, Set<T> set2) {
        if (set2.isEmpty()) {
            return set1;
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(set1);
        set.removeAll(set2);
        return set;
    }

    public Set<Object> getSelected() {
        return Collections.unmodifiableSet(this.newSelection);
    }

    public static interface SelectionNotifier
    extends Serializable {
        public void addSelectionListener(SelectionListener var1);

        public void removeSelectionListener(SelectionListener var1);
    }

    public static interface SelectionListener
    extends Serializable {
        public void select(SelectionEvent var1);
    }
}

