/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.data.util;

import com.vaadin.featurepack.data.Property;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.logging.Logger;

public abstract class AbstractProperty<T>
implements Property<T>,
Property.ValueChangeNotifier,
Property.ReadOnlyStatusChangeNotifier {
    private LinkedList<Property.ReadOnlyStatusChangeListener> readOnlyStatusChangeListeners = null;
    private LinkedList<Property.ValueChangeListener> valueChangeListeners = null;
    private boolean readOnly;

    @Override
    public boolean isPropertyReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setPropertyReadOnly(boolean newStatus) {
        boolean oldStatus = this.isPropertyReadOnly();
        this.readOnly = newStatus;
        if (oldStatus != this.isPropertyReadOnly()) {
            this.fireReadOnlyStatusChange();
        }
    }

    @Override
    public void addReadOnlyStatusChangeListener(Property.ReadOnlyStatusChangeListener listener) {
        if (this.readOnlyStatusChangeListeners == null) {
            this.readOnlyStatusChangeListeners = new LinkedList();
        }
        this.readOnlyStatusChangeListeners.add(listener);
    }

    @Override
    public void removeReadOnlyStatusChangeListener(Property.ReadOnlyStatusChangeListener listener) {
        if (this.readOnlyStatusChangeListeners != null) {
            this.readOnlyStatusChangeListeners.remove(listener);
        }
    }

    protected void fireReadOnlyStatusChange() {
        if (this.readOnlyStatusChangeListeners != null) {
            Object[] l = this.readOnlyStatusChangeListeners.toArray();
            ReadOnlyStatusChangeEvent event = new ReadOnlyStatusChangeEvent(this);
            for (int i = 0; i < l.length; ++i) {
                ((Property.ReadOnlyStatusChangeListener)l[i]).readOnlyStatusChange(event);
            }
        }
    }

    @Override
    public void addValueChangeListener(Property.ValueChangeListener listener) {
        if (this.valueChangeListeners == null) {
            this.valueChangeListeners = new LinkedList();
        }
        this.valueChangeListeners.add(listener);
    }

    @Override
    public void removeValueChangeListener(Property.ValueChangeListener listener) {
        if (this.valueChangeListeners != null) {
            this.valueChangeListeners.remove(listener);
        }
    }

    protected void fireValueChange() {
        if (this.valueChangeListeners != null) {
            Object[] l = this.valueChangeListeners.toArray();
            ValueChangeEvent event = new ValueChangeEvent(this);
            for (int i = 0; i < l.length; ++i) {
                ((Property.ValueChangeListener)l[i]).valueChange(event);
            }
        }
    }

    public Collection<?> getListeners(Class<?> eventType) {
        if (Property.ValueChangeEvent.class.isAssignableFrom(eventType)) {
            if (this.valueChangeListeners == null) {
                return Collections.EMPTY_LIST;
            }
            return Collections.unmodifiableCollection(this.valueChangeListeners);
        }
        if (Property.ReadOnlyStatusChangeEvent.class.isAssignableFrom(eventType)) {
            if (this.readOnlyStatusChangeListeners == null) {
                return Collections.EMPTY_LIST;
            }
            return Collections.unmodifiableCollection(this.readOnlyStatusChangeListeners);
        }
        return Collections.EMPTY_LIST;
    }

    private static Logger getLogger() {
        return Logger.getLogger(AbstractProperty.class.getName());
    }

    protected static class ReadOnlyStatusChangeEvent
    extends EventObject
    implements Property.ReadOnlyStatusChangeEvent {
        protected ReadOnlyStatusChangeEvent(Property source) {
            super(source);
        }

        @Override
        public Property getProperty() {
            return (Property)this.getSource();
        }
    }

    private static class ValueChangeEvent
    extends EventObject
    implements Property.ValueChangeEvent {
        protected ValueChangeEvent(Property source) {
            super(source);
        }

        @Override
        public Property getProperty() {
            return (Property)this.getSource();
        }
    }
}

