/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.data.ui;

import com.vaadin.featurepack.data.Buffered;
import com.vaadin.featurepack.data.Property;
import com.vaadin.featurepack.data.Validatable;
import com.vaadin.featurepack.data.Validator;
import com.vaadin.featurepack.data.converter.Converter;
import com.vaadin.featurepack.data.ui.AbstractField;
import com.vaadin.featurepack.data.ui.Field;
import com.vaadin.featurepack.data.ui.Select;
import com.vaadin.featurepack.data.util.FSharedUtil;
import com.vaadin.featurepack.data.util.converter.ConversionException;
import com.vaadin.featurepack.data.util.converter.ConverterUtil;
import com.vaadin.featurepack.server.AbstractErrorMessage;
import com.vaadin.featurepack.server.CompositeErrorMessage;
import com.vaadin.featurepack.server.ErrorMessage;
import com.vaadin.featurepack.ui.FAbstractComponent;
import com.vaadin.featurepack.ui.FDateField;
import com.vaadin.featurepack.ui.HasFInternalValue;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;

@Tag(value="div")
public class FAbstractField<T>
extends com.vaadin.flow.component.AbstractField<AbstractField<T>, T>
implements Field<T>,
ComponentEventListener {
    Map<Object, Registration> listenerToRegistrationMap = new HashMap<Object, Registration>();
    private T value;
    private Converter<T, Object> converter = null;
    protected Property<?> dataSource = null;
    private LinkedList<Validator> validators;
    private boolean buffered;
    private boolean committingValueToDataSource = false;
    private Buffered.SourceException currentBufferedSourceException = null;
    private boolean invalidAllowed = true;
    private boolean invalidCommitted = false;
    private String requiredError = "";
    private String conversionError = "Could not convert value to {0}";
    private boolean validationVisible = true;
    private boolean valueWasModifiedByDataSourceDuringCommit;
    private boolean isListeningToPropertyEvents = false;
    private Locale valueLocale = null;
    private Component component;
    public boolean modified = false;
    private boolean required = false;
    public static final String VALUE_CHANGE_LISTENER_DISABLED = "value-change-listener-disabled";
    private static final Method READ_ONLY_STATUS_CHANGE_METHOD;

    public boolean shouldHideErrors() {
        return this.getField().isRequired() && this.getField().isEmpty() && this.component instanceof FAbstractComponent && ((FAbstractComponent)this.component).getComponentError() == null;
    }

    public FAbstractField() {
        super(null);
    }

    public FAbstractField(Component component) {
        this();
        this.setupForComponent(component);
    }

    public void setupForComponent(Component component) {
        this.component = component;
        ComponentUtil.addListener((Component)component, AbstractField.ComponentValueChangeEvent.class, (ComponentEventListener)this);
    }

    @Override
    public boolean isInvalidCommitted() {
        return this.invalidCommitted;
    }

    @Override
    public void setInvalidCommitted(boolean isCommitted) {
        this.invalidCommitted = isCommitted;
    }

    @Override
    public void commit() throws Buffered.SourceException, Validator.InvalidValueException {
        if (this.dataSource != null && !this.dataSource.isPropertyReadOnly()) {
            if (this.getField().isInvalidCommitted() || this.getField().isValid()) {
                try {
                    this.valueWasModifiedByDataSourceDuringCommit = false;
                    this.committingValueToDataSource = true;
                    this.getField().getPropertyDataSource().setValue(this.getConvertedValue());
                }
                catch (Throwable e) {
                    Buffered.SourceException sourceException = new Buffered.SourceException(this, e);
                    this.setCurrentBufferedSourceException(sourceException);
                    throw sourceException;
                }
                finally {
                    this.committingValueToDataSource = false;
                }
            } else {
                this.doValidate();
            }
        }
        if (this.getField().isModified()) {
            this.setModified(false);
        }
        if (this.getCurrentBufferedSourceException() != null) {
            this.setCurrentBufferedSourceException(null);
        }
        if (this.valueWasModifiedByDataSourceDuringCommit) {
            this.valueWasModifiedByDataSourceDuringCommit = false;
            this.fireValueChange(false);
        }
    }

    @Override
    public void discard() throws Buffered.SourceException {
        this.updateValueFromDataSource();
    }

    protected Object getDataSourceValue() {
        return this.dataSource.getValue();
    }

    private T getFieldValue() {
        if (this.dataSource == null || this.getField().isBuffered() || this.getField().isModified()) {
            return this.getInternalValue();
        }
        return this.convertFromModel(this.getDataSourceValue());
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    protected void setModified(boolean modified) {
        this.modified = modified;
    }

    @Override
    public void setBuffered(boolean buffered) {
        if (this.buffered == buffered) {
            return;
        }
        this.buffered = buffered;
        if (!buffered) {
            this.getField().commit();
        }
    }

    @Override
    public boolean isBuffered() {
        return this.buffered;
    }

    @Override
    public T getValue() {
        return this.getFieldValue();
    }

    @Override
    public void setValue(T newFieldValue) throws Property.ReadOnlyException, ConversionException {
        this.setValue(newFieldValue, false);
    }

    protected void setValue(T newFieldValue, boolean repaintIsNotNeeded) {
        this.setValue(newFieldValue, repaintIsNotNeeded, false);
    }

    protected void setValue(T newFieldValue, boolean repaintIsNotNeeded, boolean ignoreReadOnly) throws Property.ReadOnlyException, ConversionException, Validator.InvalidValueException {
        if (!FSharedUtil.equals(newFieldValue, this.getInternalValue())) {
            if (!ignoreReadOnly && this.getField().isPropertyReadOnly()) {
                throw new Property.ReadOnlyException();
            }
            try {
                T doubleConvertedFieldValue = this.convertFromModel(this.convertToModel(newFieldValue));
                if (!FSharedUtil.equals(newFieldValue, doubleConvertedFieldValue)) {
                    newFieldValue = doubleConvertedFieldValue;
                    repaintIsNotNeeded = false;
                }
            }
            catch (Throwable doubleConvertedFieldValue) {
                // empty catch block
            }
            if (repaintIsNotNeeded && (this.getField().isRequired() || this.hasValidators() || this.getField().getConverter() != null)) {
                repaintIsNotNeeded = false;
            }
            if (!this.getField().isInvalidAllowed()) {
                this.validate(newFieldValue);
            }
            this.setInternalValue(newFieldValue);
            this.setModified(this.dataSource != null);
            this.valueWasModifiedByDataSourceDuringCommit = false;
            if (!this.getField().isBuffered() && this.dataSource != null && (this.getField().isInvalidCommitted() || this.getField().isValid())) {
                try {
                    this.committingValueToDataSource = true;
                    this.getField().getPropertyDataSource().setValue(this.convertToModel(newFieldValue));
                    this.setModified(false);
                }
                catch (Throwable e) {
                    this.currentBufferedSourceException = new Buffered.SourceException(this, e);
                    this.doMarkAsDirty();
                    throw this.currentBufferedSourceException;
                }
                finally {
                    this.committingValueToDataSource = false;
                }
            }
            if (this.getCurrentBufferedSourceException() != null) {
                this.setCurrentBufferedSourceException(null);
            }
            if (this.valueWasModifiedByDataSourceDuringCommit) {
                repaintIsNotNeeded = false;
                this.valueWasModifiedByDataSourceDuringCommit = false;
            }
            this.fireValueChange(repaintIsNotNeeded);
        }
    }

    @Deprecated
    static boolean equals(Object value1, Object value2) {
        return FSharedUtil.equals(value1, value2);
    }

    @Override
    public Property getPropertyDataSource() {
        return this.dataSource;
    }

    @Override
    public void setPropertyDataSource(Property newDataSource) {
        T value;
        Collection<Validator> validators;
        T oldValue = this.getInternalValue();
        this.removePropertyListeners();
        this.dataSource = newDataSource;
        ((HasValue)this.component).setReadOnly(this.dataSource == null ? false : this.dataSource.isPropertyReadOnly());
        if (newDataSource != null && !ConverterUtil.canConverterPossiblyHandle(this.getField().getConverter(), this.getField().getType(), newDataSource.getType())) {
            this.setConverter(newDataSource.getType());
        }
        try {
            if (this.dataSource != null) {
                T fieldValue = this.convertFromModel(this.getDataSourceValue());
                this.setInternalValue(fieldValue);
            }
            this.setModified(false);
            if (this.getCurrentBufferedSourceException() != null) {
                this.setCurrentBufferedSourceException(null);
            }
        }
        catch (Throwable e) {
            this.setCurrentBufferedSourceException(new Buffered.SourceException(this, e));
            this.setModified(true);
            throw this.getCurrentBufferedSourceException();
        }
        this.addPropertyListeners();
        if (this.dataSource instanceof Validatable && (validators = ((Validatable)((Object)this.dataSource)).getValidators()) != null) {
            Iterator<Validator> i = validators.iterator();
            while (i.hasNext()) {
                this.addValidator(i.next());
            }
        }
        if ((value = this.getInternalValue()) != oldValue && (value != null && !value.equals(oldValue) || value == null)) {
            this.fireValueChange(false);
        }
    }

    public void setConverter(Class<?> datamodelType) {
        Converter<T, ?> c = ConverterUtil.getConverter(this.getType(), datamodelType);
        this.getField().setConverter(c);
    }

    private T convertFromModel(Object newValue) {
        return ConverterUtil.convertFromModel(this.component, newValue, this.getType(), this.getConverter());
    }

    private Object convertToModel(T fieldValue) throws ConversionException {
        Class<?> modelType = this.getModelType();
        try {
            return ConverterUtil.convertToModel(this.component, fieldValue, modelType, this.getField().getConverter());
        }
        catch (ConversionException e) {
            throw new ConversionException(this.getConversionError(modelType, e), e);
        }
    }

    protected Class<?> getModelType() {
        Property pd = this.getField().getPropertyDataSource();
        if (pd != null) {
            return pd.getType();
        }
        if (this.getField().getConverter() != null) {
            return this.getField().getConverter().getClass().getTypeParameters()[1].getClass();
        }
        return null;
    }

    protected String getConversionError(Class<?> dataSourceType, ConversionException e) {
        String conversionError = this.getConversionError();
        if (conversionError != null) {
            if (dataSourceType != null) {
                conversionError = conversionError.replace("{0}", dataSourceType.getSimpleName());
            }
            if (e != null) {
                conversionError = conversionError.replace("{1}", e.getLocalizedMessage());
            }
        }
        return conversionError;
    }

    @Override
    public Object getConvertedValue() {
        return this.convertToModel(this.getFieldValue());
    }

    public void setConvertedValue(Object value) {
        this.setValue(this.convertFromModel(value));
    }

    @Override
    public void addValidator(Validator validator) {
        if (this.validators == null) {
            this.validators = new LinkedList();
        }
        this.validators.add(validator);
        this.doMarkAsDirty();
    }

    @Override
    public Collection<Validator> getValidators() {
        if (this.validators == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.validators);
    }

    private boolean hasValidators() {
        return this.validators != null && !this.validators.isEmpty();
    }

    @Override
    public void removeValidator(Validator validator) {
        if (this.validators != null) {
            this.validators.remove(validator);
        }
        this.doMarkAsDirty();
    }

    @Override
    public void removeAllValidators() {
        if (this.validators != null) {
            this.validators.clear();
        }
        this.doMarkAsDirty();
    }

    @Override
    public boolean isValid() {
        try {
            this.doValidate();
            return true;
        }
        catch (Validator.InvalidValueException e) {
            return false;
        }
    }

    @Override
    public void validate() throws Validator.InvalidValueException {
        if (this.getField().isRequired() && this.getField().isEmpty()) {
            throw new Validator.EmptyValueException(this.requiredError);
        }
        this.validate(this.getFieldValue());
    }

    protected void validate(T fieldValue) throws Validator.InvalidValueException {
        Object valueToValidate = fieldValue;
        if (this.getField().getConverter() != null) {
            try {
                valueToValidate = this.getField().getConverter().convertToModel(fieldValue, new ValueContext(null, this.component)).getOrThrow(ConversionException::new);
            }
            catch (ConversionException e) {
                throw new Validator.InvalidValueException(this.getConversionError(this.getField().getConverter().getModelType(), e));
            }
        }
        ArrayList<Validator.InvalidValueException> validationExceptions = new ArrayList<Validator.InvalidValueException>();
        if (this.validators != null) {
            for (Validator v : this.validators) {
                try {
                    v.validate(valueToValidate);
                }
                catch (Validator.InvalidValueException e) {
                    validationExceptions.add(e);
                }
            }
        }
        if (validationExceptions.isEmpty()) {
            return;
        }
        if (validationExceptions.size() == 1) {
            this.revertValueWhenInvalidNotAllowed();
            throw (Validator.InvalidValueException)validationExceptions.get(0);
        }
        Validator.InvalidValueException[] exceptionArray = validationExceptions.toArray(new Validator.InvalidValueException[validationExceptions.size()]);
        this.revertValueWhenInvalidNotAllowed();
        throw new Validator.InvalidValueException(null, exceptionArray);
    }

    private void revertValueWhenInvalidNotAllowed() {
        if (!this.getField().isInvalidAllowed()) {
            ((HasValue)this.component).setValue(this.getInternalValue());
        }
    }

    @Override
    public boolean isInvalidAllowed() {
        return this.invalidAllowed;
    }

    @Override
    public void setInvalidAllowed(boolean invalidAllowed) throws UnsupportedOperationException {
        this.invalidAllowed = invalidAllowed;
    }

    public ErrorMessage getErrorMessage() {
        Validator.InvalidValueException validationError;
        block4: {
            validationError = null;
            if (this.isValidationVisible()) {
                try {
                    this.doValidate();
                }
                catch (Validator.InvalidValueException e) {
                    if (e.isInvisible()) break block4;
                    validationError = e;
                }
            }
        }
        if (validationError == null && this.getCurrentBufferedSourceException() == null) {
            return null;
        }
        return new CompositeErrorMessage(AbstractErrorMessage.getErrorMessageForException(validationError), AbstractErrorMessage.getErrorMessageForException(this.getCurrentBufferedSourceException()));
    }

    private void doValidate() {
        Component component = this.component;
        if (component instanceof FDateField) {
            FDateField fDateField = (FDateField)component;
            fDateField.validate();
        } else {
            this.validate();
        }
    }

    @Override
    public void addValueChangeListener(Property.ValueChangeListener listener) {
        this.listenerToRegistrationMap.put(listener, (Registration & Serializable)() -> this.listenerToRegistrationMap.remove(listener));
        this.doMarkAsDirty();
    }

    @Override
    public void removeValueChangeListener(Property.ValueChangeListener listener) {
        this.listenerToRegistrationMap.get(listener).remove();
        this.doMarkAsDirty();
    }

    protected void fireValueChange(boolean repaintIsNotNeeded) {
        this.listenerToRegistrationMap.forEach((listener, reg) -> {
            if (listener instanceof Property.ValueChangeListener) {
                ((Property.ValueChangeListener)listener).valueChange(new Property.ValueChangeEvent(){

                    @Override
                    public Property getProperty() {
                        return FAbstractField.this.dataSource != null ? FAbstractField.this.dataSource : (Property)FAbstractField.this.component;
                    }
                });
            }
        });
        if (!repaintIsNotNeeded) {
            this.doMarkAsDirty();
        }
    }

    @Override
    public void readOnlyStatusChange(Property.ReadOnlyStatusChangeEvent event) {
        boolean shouldFireChange;
        boolean readOnly = event.getProperty().isPropertyReadOnly();
        boolean bl = shouldFireChange = this.component.getElement().getProperty("readonly", false) != readOnly;
        if (shouldFireChange) {
            this.component.getElement().setProperty("readonly", readOnly);
        }
    }

    @Override
    public void valueChange(Property.ValueChangeEvent event) {
        if (!this.getField().isBuffered()) {
            if (this.committingValueToDataSource) {
                boolean propertyNotifiesOfTheBufferedValue = FSharedUtil.equals(event.getProperty().getValue(), this.getInternalValue());
                if (!propertyNotifiesOfTheBufferedValue) {
                    this.readValueFromProperty(event);
                    this.valueWasModifiedByDataSourceDuringCommit = true;
                }
            } else if (!this.getField().isModified()) {
                this.readValueFromProperty(event);
                this.fireValueChange(false);
            }
        }
    }

    private void readValueFromProperty(Property.ValueChangeEvent event) {
        this.setInternalValue(this.convertFromModel(event.getProperty().getValue()));
    }

    protected T getInternalValue() {
        Component component = this.component;
        if (component instanceof HasFInternalValue) {
            HasFInternalValue hasFInternalValue = (HasFInternalValue)component;
            return hasFInternalValue.getFInternalValue();
        }
        return this.getFInternalValue();
    }

    public T getFInternalValue() {
        return this.value;
    }

    protected void setInternalValue(T newValue) {
        Component component = this.component;
        if (component instanceof HasFInternalValue) {
            HasFInternalValue hasFInternalValue = (HasFInternalValue)component;
            hasFInternalValue.setFInternalValue(newValue);
        } else {
            this.setFInternalValue(newValue);
        }
    }

    public void setFInternalValue(T newValue) {
        this.value = newValue;
        if (this.component == this) {
            super.setValue(newValue);
        } else {
            ((HasValue)this.component).setValue(newValue);
        }
        if (UI.getCurrent() != null) {
            this.valueLocale = UI.getCurrent().getLocale();
        }
        if (this.validators != null && !this.validators.isEmpty()) {
            this.doMarkAsDirty();
        }
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        Component component = this.component;
        if (component instanceof HasValue) {
            HasValue hasValue = (HasValue)component;
            hasValue.setRequiredIndicatorVisible(required);
        }
        this.required = required;
        this.doMarkAsDirty();
    }

    @Override
    public void setRequiredError(String requiredMessage) {
        this.requiredError = requiredMessage;
        this.doMarkAsDirty();
    }

    @Override
    public String getRequiredError() {
        return this.requiredError;
    }

    public String getConversionError() {
        return this.conversionError;
    }

    public void setConversionError(String valueConversionError) {
        this.conversionError = valueConversionError;
        this.doMarkAsDirty();
    }

    @Override
    public boolean isEmpty() {
        Component component = this.component;
        if (component instanceof Field) {
            Field field = (Field)component;
            return field.isEmpty();
        }
        return this.getFieldValue() == null;
    }

    public boolean isValidationVisible() {
        return this.validationVisible;
    }

    public void setValidationVisible(boolean validateAutomatically) {
        if (this.validationVisible != validateAutomatically) {
            this.doMarkAsDirty();
            this.validationVisible = validateAutomatically;
        }
    }

    public void setCurrentBufferedSourceException(Buffered.SourceException currentBufferedSourceException) {
        this.currentBufferedSourceException = currentBufferedSourceException;
        this.doMarkAsDirty();
    }

    protected Buffered.SourceException getCurrentBufferedSourceException() {
        return this.currentBufferedSourceException;
    }

    private void updateValueFromDataSource() {
        if (this.dataSource != null) {
            T newFieldValue;
            try {
                newFieldValue = this.convertFromModel(this.getDataSourceValue());
                if (this.getCurrentBufferedSourceException() != null) {
                    this.setCurrentBufferedSourceException(null);
                }
            }
            catch (Throwable e) {
                this.currentBufferedSourceException = new Buffered.SourceException(this, e);
                this.doMarkAsDirty();
                throw this.currentBufferedSourceException;
            }
            boolean wasModified = this.getField().isModified();
            this.setModified(false);
            if (!FSharedUtil.equals(newFieldValue, this.getInternalValue())) {
                this.setInternalValue(newFieldValue);
                this.fireValueChange(false);
            } else if (wasModified) {
                this.doMarkAsDirty();
            }
        }
    }

    @Override
    public Converter<T, Object> getConverter() {
        return this.converter;
    }

    @Override
    public void setConverter(Converter<T, ?> converter) {
        this.converter = converter;
        this.doMarkAsDirty();
    }

    protected void addPropertyListeners() {
        if (!this.isListeningToPropertyEvents) {
            if (this.dataSource instanceof Property.ValueChangeNotifier) {
                ((Property.ValueChangeNotifier)((Object)this.dataSource)).addValueChangeListener(this);
            }
            if (this.dataSource instanceof Property.ReadOnlyStatusChangeNotifier) {
                ((Property.ReadOnlyStatusChangeNotifier)((Object)this.dataSource)).addReadOnlyStatusChangeListener(this);
            }
            this.isListeningToPropertyEvents = true;
        }
    }

    protected void removePropertyListeners() {
        if (this.isListeningToPropertyEvents) {
            if (this.dataSource instanceof Property.ValueChangeNotifier) {
                ((Property.ValueChangeNotifier)((Object)this.dataSource)).removeValueChangeListener(this);
            }
            if (this.dataSource instanceof Property.ReadOnlyStatusChangeNotifier) {
                ((Property.ReadOnlyStatusChangeNotifier)((Object)this.dataSource)).removeReadOnlyStatusChangeListener(this);
            }
            this.isListeningToPropertyEvents = false;
        }
    }

    @Override
    public boolean isPropertyReadOnly() {
        return this.component.getElement().getProperty("readonly", false) || this.dataSource != null && this.dataSource.isPropertyReadOnly();
    }

    @Override
    public void setPropertyReadOnly(boolean newStatus) {
        this.component.getElement().setProperty("readonly", newStatus);
        if (this.dataSource != null) {
            this.dataSource.setPropertyReadOnly(newStatus);
        }
    }

    @Override
    public Class<? extends T> getType() {
        return ((Field)this.component).getType();
    }

    public void onComponentEvent(ComponentEvent event) {
        if (event instanceof HasValue.ValueChangeEvent) {
            HasValue.ValueChangeEvent valueChangeEvent = (HasValue.ValueChangeEvent)event;
            if (ComponentUtil.getData((Component)this.component, (String)VALUE_CHANGE_LISTENER_DISABLED) == "true") {
                return;
            }
            if (this.getField() instanceof Select && !((Select)this.getField()).getFAbstractSelect().isComponentOverridesSetValue()) {
                ((Select)this.getField()).getFAbstractSelect().setValue(valueChangeEvent.getValue());
            } else {
                this.setValue(valueChangeEvent.getValue());
            }
        }
    }

    private void doMarkAsDirty() {
        Component component = this.component;
        if (component instanceof FAbstractComponent) {
            FAbstractComponent fAbstractComponent = (FAbstractComponent)component;
            fAbstractComponent.markAsDirty();
        }
    }

    private Field<T> getField() {
        return (Field)this.component;
    }

    protected void setPresentationValue(T newPresentationValue) {
        this.setInternalValue(newPresentationValue);
    }

    static {
        try {
            READ_ONLY_STATUS_CHANGE_METHOD = Property.ReadOnlyStatusChangeListener.class.getDeclaredMethod("readOnlyStatusChange", Property.ReadOnlyStatusChangeEvent.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Internal error finding methods in AbstractField");
        }
    }

    public static class ReadOnlyStatusChangeEvent<T>
    extends ComponentEvent
    implements Property.ReadOnlyStatusChangeEvent,
    Serializable {
        public ReadOnlyStatusChangeEvent(Component source) {
            super(source, true);
        }

        @Override
        public Property getProperty() {
            return (Property)this.getSource();
        }
    }
}

