/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.data.fieldgroup;

import com.vaadin.featurepack.data.Item;
import com.vaadin.featurepack.data.Property;
import com.vaadin.featurepack.data.Validator;
import com.vaadin.featurepack.data.fieldgroup.Caption;
import com.vaadin.featurepack.data.fieldgroup.DefaultFieldGroupFieldFactory;
import com.vaadin.featurepack.data.fieldgroup.FieldGroupFieldFactory;
import com.vaadin.featurepack.data.fieldgroup.PropertyId;
import com.vaadin.featurepack.data.util.TransactionalPropertyWrapper;
import com.vaadin.featurepack.ui.FAbstractComponent;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.shared.util.SharedUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FieldGroup
implements Serializable {
    private Item itemDataSource;
    private boolean buffered = true;
    private boolean enabled = true;
    private boolean readOnly = false;
    private HashMap<Object, com.vaadin.featurepack.data.ui.Field<?>> propertyIdToField = new HashMap();
    private LinkedHashMap<com.vaadin.featurepack.data.ui.Field<?>, Object> fieldToPropertyId = new LinkedHashMap();
    private List<CommitHandler> commitHandlers = new ArrayList<CommitHandler>();
    private FieldGroupFieldFactory fieldFactory = DefaultFieldGroupFieldFactory.get();

    public FieldGroup() {
    }

    public FieldGroup(Item itemDataSource) {
        this.setItemDataSource(itemDataSource);
    }

    public void setItemDataSource(Item itemDataSource) {
        this.itemDataSource = itemDataSource;
        this.bindFields();
    }

    protected void bindFields() {
        for (com.vaadin.featurepack.data.ui.Field<?> f : this.fieldToPropertyId.keySet()) {
            this.bind(f, this.fieldToPropertyId.get(f));
        }
    }

    public Item getItemDataSource() {
        return this.itemDataSource;
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public void setBuffered(boolean buffered) {
        if (buffered == this.buffered) {
            return;
        }
        this.buffered = buffered;
        for (com.vaadin.featurepack.data.ui.Field<?> field : this.getFields()) {
            field.setBuffered(buffered);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean fieldsEnabled) {
        this.enabled = fieldsEnabled;
        for (com.vaadin.featurepack.data.ui.Field<?> field : this.getFields()) {
            if (!(field instanceof HasEnabled)) continue;
            HasEnabled hasEnabled = (HasEnabled)field;
            hasEnabled.setEnabled(fieldsEnabled);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean fieldsReadOnly) {
        this.readOnly = fieldsReadOnly;
        for (com.vaadin.featurepack.data.ui.Field<?> field : this.getFields()) {
            if (!(field instanceof HasValue)) continue;
            HasValue hasValue = (HasValue)field;
            if (field.getPropertyDataSource() == null || !field.getPropertyDataSource().isPropertyReadOnly()) {
                hasValue.setReadOnly(fieldsReadOnly);
                continue;
            }
            hasValue.setReadOnly(true);
        }
    }

    public Collection<com.vaadin.featurepack.data.ui.Field<?>> getFields() {
        return this.fieldToPropertyId.keySet();
    }

    public void bind(com.vaadin.featurepack.data.ui.Field<?> field, Object propertyId) throws BindException {
        this.throwIfFieldIsNull(field, propertyId);
        this.throwIfPropertyIdAlreadyBound(field, propertyId);
        this.fieldToPropertyId.put(field, propertyId);
        this.propertyIdToField.put(propertyId, field);
        if (this.itemDataSource == null) {
            this.clearField(field);
            return;
        }
        field.setPropertyDataSource(this.wrapInTransactionalProperty(this.getItemProperty(propertyId)));
        this.configureField(field);
    }

    protected void clearField(com.vaadin.featurepack.data.ui.Field<?> field) {
        field.setPropertyDataSource(null);
        if (field instanceof HasValue) {
            HasValue hasValue = (HasValue)field;
            boolean fieldReadOnly = hasValue.isReadOnly();
            if (!fieldReadOnly) {
                hasValue.clear();
            } else {
                hasValue.setReadOnly(false);
                hasValue.clear();
                hasValue.setReadOnly(true);
            }
        }
    }

    protected <T> Property.Transactional<T> wrapInTransactionalProperty(Property<T> itemProperty) {
        return new TransactionalPropertyWrapper<T>(itemProperty);
    }

    private void throwIfFieldIsNull(com.vaadin.featurepack.data.ui.Field<?> field, Object propertyId) {
        if (field == null) {
            throw new BindException(String.format("Cannot bind property id '%s' to a null field.", propertyId));
        }
    }

    private void throwIfPropertyIdAlreadyBound(com.vaadin.featurepack.data.ui.Field<?> field, Object propertyId) {
        if (this.propertyIdToField.containsKey(propertyId) && this.propertyIdToField.get(propertyId) != field) {
            throw new BindException("Property id " + String.valueOf(propertyId) + " is already bound to another field");
        }
    }

    protected Property getItemProperty(Object propertyId) throws BindException {
        Item item = this.getItemDataSource();
        if (item == null) {
            throw new BindException("Could not lookup property with id " + String.valueOf(propertyId) + " as no item has been set");
        }
        Property p = item.getItemProperty(propertyId);
        if (p == null) {
            throw new BindException("A property with id " + String.valueOf(propertyId) + " was not found in the item");
        }
        return p;
    }

    public void unbind(com.vaadin.featurepack.data.ui.Field<?> field) throws BindException {
        Object propertyId = this.fieldToPropertyId.get(field);
        if (propertyId == null) {
            throw new BindException("The given field is not part of this FieldBinder");
        }
        TransactionalPropertyWrapper wrapper = null;
        Property fieldDataSource = field.getPropertyDataSource();
        if (fieldDataSource instanceof TransactionalPropertyWrapper) {
            wrapper = (TransactionalPropertyWrapper)fieldDataSource;
            fieldDataSource = ((TransactionalPropertyWrapper)fieldDataSource).getWrappedProperty();
        }
        if (this.getItemDataSource() != null && fieldDataSource == this.getItemProperty(propertyId)) {
            if (null != wrapper) {
                wrapper.detachFromProperty();
            }
            field.setPropertyDataSource(null);
        }
        this.fieldToPropertyId.remove(field);
        this.propertyIdToField.remove(propertyId);
    }

    protected void configureField(com.vaadin.featurepack.data.ui.Field<?> field) {
        field.setBuffered(this.isBuffered());
        if (field instanceof HasEnabled) {
            HasEnabled hasEnabled = (HasEnabled)field;
            hasEnabled.setEnabled(this.isEnabled());
        }
        if (field instanceof HasValue) {
            HasValue hasValue = (HasValue)field;
            if (field.getPropertyDataSource().isPropertyReadOnly()) {
                hasValue.setReadOnly(true);
            } else {
                hasValue.setReadOnly(this.isReadOnly());
            }
        }
    }

    protected Class<?> getPropertyType(Object propertyId) throws BindException {
        if (this.getItemDataSource() == null) {
            throw new BindException("Property type for '" + String.valueOf(propertyId) + "' could not be determined. No item data source has been set.");
        }
        Property p = this.getItemDataSource().getItemProperty(propertyId);
        if (p == null) {
            throw new BindException("Property type for '" + String.valueOf(propertyId) + "' could not be determined. No property with that id was found.");
        }
        return p.getType();
    }

    public Collection<Object> getBoundPropertyIds() {
        return Collections.unmodifiableCollection(this.propertyIdToField.keySet());
    }

    public Collection<Object> getUnboundPropertyIds() {
        if (this.getItemDataSource() == null) {
            return new ArrayList<Object>();
        }
        ArrayList<Object> unboundPropertyIds = new ArrayList<Object>();
        unboundPropertyIds.addAll(this.getItemDataSource().getItemPropertyIds());
        unboundPropertyIds.removeAll(this.propertyIdToField.keySet());
        return unboundPropertyIds;
    }

    public void commit() throws CommitException {
        if (!this.isBuffered()) {
            return;
        }
        this.startTransactions();
        try {
            this.firePreCommitEvent();
            Map<com.vaadin.featurepack.data.ui.Field<?>, Validator.InvalidValueException> invalidValueExceptions = this.commitFields();
            if (!invalidValueExceptions.isEmpty()) {
                throw new FieldGroupInvalidValueException(invalidValueExceptions);
            }
            this.firePostCommitEvent();
            this.commitTransactions();
        }
        catch (Exception e) {
            this.rollbackTransactions();
            throw new CommitException("Commit failed", this, e);
        }
    }

    private Map<com.vaadin.featurepack.data.ui.Field<?>, Validator.InvalidValueException> commitFields() {
        HashMap invalidValueExceptions = new HashMap();
        for (com.vaadin.featurepack.data.ui.Field<?> f : this.fieldToPropertyId.keySet()) {
            try {
                f.commit();
            }
            catch (Validator.InvalidValueException e) {
                invalidValueExceptions.put(f, e);
            }
        }
        return invalidValueExceptions;
    }

    private void startTransactions() throws CommitException {
        for (com.vaadin.featurepack.data.ui.Field<?> f : this.fieldToPropertyId.keySet()) {
            Property.Transactional property = (Property.Transactional)f.getPropertyDataSource();
            if (property == null) {
                throw new CommitException("Property \"" + String.valueOf(this.fieldToPropertyId.get(f)) + "\" not bound to datasource.");
            }
            property.startTransaction();
        }
    }

    private void commitTransactions() {
        for (com.vaadin.featurepack.data.ui.Field<?> f : this.fieldToPropertyId.keySet()) {
            ((Property.Transactional)f.getPropertyDataSource()).commit();
        }
    }

    private void rollbackTransactions() {
        for (com.vaadin.featurepack.data.ui.Field<?> f : this.fieldToPropertyId.keySet()) {
            try {
                ((Property.Transactional)f.getPropertyDataSource()).rollback();
            }
            catch (Exception exception) {}
        }
    }

    private void firePreCommitEvent() throws CommitException {
        CommitHandler[] handlers;
        for (CommitHandler handler : handlers = this.commitHandlers.toArray(new CommitHandler[this.commitHandlers.size()])) {
            handler.preCommit(new CommitEvent(this));
        }
    }

    private void firePostCommitEvent() throws CommitException {
        CommitHandler[] handlers;
        for (CommitHandler handler : handlers = this.commitHandlers.toArray(new CommitHandler[this.commitHandlers.size()])) {
            handler.postCommit(new CommitEvent(this));
        }
    }

    public void discard() {
        for (com.vaadin.featurepack.data.ui.Field<?> f : this.fieldToPropertyId.keySet()) {
            try {
                f.discard();
            }
            catch (Exception exception) {}
        }
    }

    public com.vaadin.featurepack.data.ui.Field<?> getField(Object propertyId) {
        return this.propertyIdToField.get(propertyId);
    }

    public Object getPropertyId(com.vaadin.featurepack.data.ui.Field<?> field) {
        return this.fieldToPropertyId.get(field);
    }

    public void addCommitHandler(CommitHandler commitHandler) {
        this.commitHandlers.add(commitHandler);
    }

    public void removeCommitHandler(CommitHandler commitHandler) {
        this.commitHandlers.remove(commitHandler);
    }

    protected Collection<CommitHandler> getCommitHandlers() {
        return Collections.unmodifiableCollection(this.commitHandlers);
    }

    public boolean isValid() {
        try {
            for (com.vaadin.featurepack.data.ui.Field<?> field : this.getFields()) {
                field.validate();
            }
            return true;
        }
        catch (Validator.InvalidValueException e) {
            return false;
        }
    }

    public boolean isModified() {
        for (com.vaadin.featurepack.data.ui.Field<?> field : this.getFields()) {
            if (!field.isModified()) continue;
            return true;
        }
        return false;
    }

    public FieldGroupFieldFactory getFieldFactory() {
        return this.fieldFactory;
    }

    public void setFieldFactory(FieldGroupFieldFactory fieldFactory) {
        this.fieldFactory = fieldFactory;
    }

    public void bindMemberFields(Object objectWithMemberFields) throws BindException {
        this.buildAndBindMemberFields(objectWithMemberFields, false);
    }

    public void buildAndBindMemberFields(Object objectWithMemberFields) throws BindException {
        this.buildAndBindMemberFields(objectWithMemberFields, true);
    }

    protected void buildAndBindMemberFields(Object objectWithMemberFields, boolean buildFields) throws BindException {
        Class<?> objectClass = objectWithMemberFields.getClass();
        for (Field memberField : FieldGroup.getFieldsInDeclareOrder(objectClass)) {
            com.vaadin.featurepack.data.ui.Field<Object> field;
            Class<?> propertyType;
            if (!com.vaadin.featurepack.data.ui.Field.class.isAssignableFrom(memberField.getType())) continue;
            PropertyId propertyIdAnnotation = memberField.getAnnotation(PropertyId.class);
            Class<?> fieldType = memberField.getType();
            Object propertyId = null;
            if (propertyIdAnnotation != null) {
                propertyId = propertyIdAnnotation.value();
            } else {
                try {
                    propertyId = this.findPropertyId(memberField);
                }
                catch (SearchException e) {
                    continue;
                }
                if (propertyId == null) continue;
            }
            try {
                propertyType = this.getPropertyType(propertyId);
            }
            catch (BindException e) {
                continue;
            }
            try {
                field = (com.vaadin.featurepack.data.ui.Field)ReflectTools.getJavaFieldValue((Object)objectWithMemberFields, (Field)memberField, com.vaadin.featurepack.data.ui.Field.class);
            }
            catch (Exception e) {
                continue;
            }
            if (field == null && buildFields) {
                Caption captionAnnotation = memberField.getAnnotation(Caption.class);
                String caption = captionAnnotation != null ? captionAnnotation.value() : SharedUtil.propertyIdToHumanFriendly((Object)propertyId);
                field = this.build(caption, propertyType, fieldType);
                try {
                    ReflectTools.setJavaFieldValue((Object)objectWithMemberFields, (Field)memberField, (Object)field);
                }
                catch (IllegalArgumentException e) {
                    throw new BindException("Could not assign value to field '" + memberField.getName() + "'", e);
                }
            }
            if (field == null) continue;
            this.bind(field, propertyId);
        }
    }

    protected Object findPropertyId(Field memberField) {
        String fieldName = memberField.getName();
        if (this.getItemDataSource() == null) {
            throw new SearchException("Property id type for field '" + fieldName + "' could not be determined. No item data source has been set.");
        }
        Item dataSource = this.getItemDataSource();
        if (dataSource.getItemProperty(fieldName) != null) {
            return fieldName;
        }
        String minifiedFieldName = FieldGroup.minifyFieldName(fieldName);
        for (Object itemPropertyId : dataSource.getItemPropertyIds()) {
            String itemPropertyName;
            if (!(itemPropertyId instanceof String) || !minifiedFieldName.equals(FieldGroup.minifyFieldName(itemPropertyName = (String)itemPropertyId))) continue;
            return itemPropertyName;
        }
        return null;
    }

    protected static String minifyFieldName(String fieldName) {
        return fieldName.toLowerCase().replace("_", "");
    }

    public com.vaadin.featurepack.data.ui.Field<?> buildAndBind(Object propertyId) throws BindException {
        String caption = SharedUtil.propertyIdToHumanFriendly((Object)propertyId);
        return this.buildAndBind(caption, propertyId);
    }

    public com.vaadin.featurepack.data.ui.Field<?> buildAndBind(String caption, Object propertyId) throws BindException {
        return this.buildAndBind(caption, propertyId, com.vaadin.featurepack.data.ui.Field.class);
    }

    public <T extends com.vaadin.featurepack.data.ui.Field> T buildAndBind(String caption, Object propertyId, Class<T> fieldType) throws BindException {
        Class<?> type = this.getPropertyType(propertyId);
        T field = this.build(caption, type, fieldType);
        this.bind((com.vaadin.featurepack.data.ui.Field<?>)field, propertyId);
        return field;
    }

    protected <T extends com.vaadin.featurepack.data.ui.Field> T build(String caption, Class<?> dataType, Class<T> fieldType) throws BindException {
        T field = this.getFieldFactory().createField(dataType, fieldType);
        if (field == null) {
            throw new BindException("Unable to build a field of type " + fieldType.getName() + " for editing " + dataType.getName());
        }
        if (field instanceof FAbstractComponent) {
            FAbstractComponent abstractComponent = (FAbstractComponent)field;
            abstractComponent.setCaption(caption);
        } else if (field instanceof HasLabel) {
            ((HasLabel)field).setLabel(caption);
        }
        return field;
    }

    protected static List<Field> getFieldsInDeclareOrder(Class searchClass) {
        ArrayList<Field> memberFieldInOrder = new ArrayList<Field>();
        while (searchClass != null) {
            for (Field memberField : searchClass.getDeclaredFields()) {
                memberFieldInOrder.add(memberField);
            }
            searchClass = searchClass.getSuperclass();
        }
        return memberFieldInOrder;
    }

    public void clear() {
        for (com.vaadin.featurepack.data.ui.Field<?> f : this.getFields()) {
            if (!(f instanceof HasValue)) continue;
            HasValue hasValue = (HasValue)f;
            hasValue.clear();
        }
    }

    public static class BindException
    extends RuntimeException {
        public BindException(String message) {
            super(message);
        }

        public BindException(String message, Throwable t) {
            super(message, t);
        }
    }

    public static class FieldGroupInvalidValueException
    extends Validator.InvalidValueException {
        private Map<com.vaadin.featurepack.data.ui.Field<?>, Validator.InvalidValueException> invalidValueExceptions;

        public FieldGroupInvalidValueException(Map<com.vaadin.featurepack.data.ui.Field<?>, Validator.InvalidValueException> invalidValueExceptions) {
            super(null, invalidValueExceptions.values().toArray(new Validator.InvalidValueException[invalidValueExceptions.size()]));
            this.invalidValueExceptions = invalidValueExceptions;
        }

        public Map<com.vaadin.featurepack.data.ui.Field<?>, Validator.InvalidValueException> getInvalidFields() {
            return this.invalidValueExceptions;
        }
    }

    public static class CommitException
    extends Exception {
        private FieldGroup fieldGroup;

        public CommitException() {
        }

        public CommitException(String message, FieldGroup fieldGroup, Throwable cause) {
            super(message, cause);
            this.fieldGroup = fieldGroup;
        }

        public CommitException(String message, Throwable cause) {
            super(message, cause);
        }

        public CommitException(String message) {
            super(message);
        }

        public CommitException(Throwable cause) {
            super(cause);
        }

        public Map<com.vaadin.featurepack.data.ui.Field<?>, Validator.InvalidValueException> getInvalidFields() {
            if (this.getCause() instanceof FieldGroupInvalidValueException) {
                return ((FieldGroupInvalidValueException)this.getCause()).getInvalidFields();
            }
            return new HashMap();
        }

        public FieldGroup getFieldGroup() {
            return this.fieldGroup;
        }
    }

    public static interface CommitHandler
    extends Serializable {
        public void preCommit(CommitEvent var1) throws CommitException;

        public void postCommit(CommitEvent var1) throws CommitException;
    }

    public static class CommitEvent
    implements Serializable {
        private FieldGroup fieldBinder;

        private CommitEvent(FieldGroup fieldBinder) {
            this.fieldBinder = fieldBinder;
        }

        public FieldGroup getFieldBinder() {
            return this.fieldBinder;
        }
    }

    public static class SearchException
    extends RuntimeException {
        public SearchException(String message) {
            super(message);
        }

        public SearchException(String message, Throwable t) {
            super(message, t);
        }
    }
}

