/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.data.converter;

import com.vaadin.featurepack.data.converter.AbstractStringToNumberConverter;
import com.vaadin.featurepack.data.converter.Converter;
import java.text.NumberFormat;
import java.util.Locale;

public class StringToByteConverter
extends AbstractStringToNumberConverter<Byte> {
    @Override
    protected NumberFormat getFormat(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return NumberFormat.getIntegerInstance(locale);
    }

    @Override
    public Byte convertToModel(String value, Class<? extends Byte> targetType, Locale locale) throws Converter.ConversionException {
        Number n = this.convertToNumber(value, targetType, locale);
        if (n == null) {
            return null;
        }
        byte byteValue = n.byteValue();
        if ((long)byteValue == n.longValue()) {
            return byteValue;
        }
        throw new Converter.ConversionException("Could not convert '" + value + "' to " + Byte.class.getName() + ": value out of range");
    }

    @Override
    public Class<Byte> getModelType() {
        return Byte.class;
    }
}

