/**
 * @license
 * Copyright 2000-2024 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full
 * license.
 */
const tryCatchWrapper = function(callback) {
	return window.Vaadin.Flow.tryCatchWrapper(callback, 'Feature Pack GridBagLayout');
};

window.Vaadin.Flow.gridBagLayout = {
	init: tryCatchWrapper((container) => {
		container.attachShadow({ mode: 'open' });
		container.shadowRoot.innerHTML = `
      <div part="grid">
        <slot></slot>
      </div>
    `;
	}),
	destroy: tryCatchWrapper((container) => {
		if (container.shadowRoot) {
			container.shadowRoot.innerHTML = '<slot></slot>';
		}
	}),
};
