/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.util;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.renderer.BasicRenderer;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.Optional;

public class RendererAdapter<T, V>
extends BasicRenderer<T, V> {
    private final ValueProvider<T, V> valueProvider;
    private final Renderer<V> renderer;

    protected RendererAdapter(ValueProvider<T, V> valueProvider, Renderer<V> renderer) {
        super(valueProvider);
        this.valueProvider = valueProvider;
        this.renderer = renderer;
    }

    public Component createComponent(T item) {
        if (this.renderer instanceof ComponentRenderer) {
            return ((ComponentRenderer)this.renderer).createComponent(item);
        }
        return super.createComponent(item);
    }

    public Component updateComponent(Component currentComponent, T item) {
        if (this.renderer instanceof ComponentRenderer) {
            return ((ComponentRenderer)this.renderer).updateComponent(currentComponent, item);
        }
        return super.updateComponent(currentComponent, item);
    }

    public Rendering<T> render(Element container, DataKeyMapper<T> keyMapper, String rendererName) {
        Rendering rendering = this.renderer.render(container, keyMapper, rendererName);
        DataGenerator renderingDataGenerator = (DataGenerator)rendering.getDataGenerator().orElseThrow(IllegalStateException::new);
        DataGenerator & Serializable dataGeneratorAdapter = (DataGenerator & Serializable)(item, json) -> renderingDataGenerator.generateData(this.valueProvider.apply(item), json);
        return (Rendering & Serializable)() -> Optional.of(dataGeneratorAdapter);
    }
}

