/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.util;

import com.vaadin.featurepack.server.IconResource;
import com.vaadin.featurepack.server.Resource;
import com.vaadin.flow.component.icon.VaadinIcon;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;

public class FileTypeResolver
implements Serializable {
    public static Resource DEFAULT_ICON = new IconResource(VaadinIcon.FILE.create());
    public static String DEFAULT_MIME_TYPE = "application/octet-stream";
    private static String initialExtToMIMEMap = "application/cu-seeme                            csm cu,application/dsptype                             tsp,application/futuresplash                        spl,application/mac-binhex40                        hqx,application/msaccess                            mdb,application/msword                              doc dot,application/octet-stream                        bin,application/oda                                 oda,application/pdf                                 pdf,application/pgp-signature                       pgp,application/postscript                          ps ai eps,application/rtf                                 rtf,application/vnd.ms-excel                        xls xlb,application/vnd.ms-powerpoint                   ppt pps pot,application/vnd.wap.wmlc                        wmlc,application/vnd.wap.wmlscriptc                  wmlsc,application/wordperfect5.1                      wp5,application/zip                                 zip,application/x-123                               wk,application/x-bcpio                             bcpio,application/x-chess-pgn                         pgn,application/x-cpio                              cpio,application/x-debian-package                    deb,application/x-director                          dcr dir dxr,application/x-dms                               dms,application/x-dvi                               dvi,application/x-xfig                              fig,application/x-font                              pfa pfb gsf pcf pcf.Z,application/x-gnumeric                          gnumeric,application/x-gtar                              gtar tgz taz,application/x-hdf                               hdf,application/x-httpd-php                         phtml pht php,application/x-httpd-php3                        php3,application/x-httpd-php3-source                 phps,application/x-httpd-php3-preprocessed           php3p,application/x-httpd-php4                        php4,application/x-ica                               ica,application/x-java-archive                      jar,application/x-java-serialized-object            ser,application/x-java-vm                           class,application/x-javascript                        js,application/x-kchart                            chrt,application/x-killustrator                      kil,application/x-kpresenter                        kpr kpt,application/x-kspread                           ksp,application/x-kword                             kwd kwt,application/x-latex                             latex,application/x-lha                               lha,application/x-lzh                               lzh,application/x-lzx                               lzx,application/x-maker                             frm maker frame fm fb book fbdoc,application/x-mif                               mif,application/x-msdos-program                     com exe bat dll,application/x-msi                               msi,application/x-netcdf                            nc cdf,application/x-ns-proxy-autoconfig               pac,application/x-object                            o,application/x-ogg                               ogg,application/x-oz-application                    oza,application/x-perl                              pl pm,application/x-pkcs7-crl                         crl,application/x-redhat-package-manager            rpm,application/x-shar                              shar,application/x-shockwave-flash                   swf swfl,application/x-star-office                       sdd sda,application/x-stuffit                           sit,application/x-sv4cpio                           sv4cpio,application/x-sv4crc                            sv4crc,application/x-tar                               tar,application/x-tex-gf                            gf,application/x-tex-pk                            pk PK,application/x-texinfo                           texinfo texi,application/x-trash                             ~ % bak old sik,application/x-troff                             t tr roff,application/x-troff-man                         man,application/x-troff-me                          me,application/x-troff-ms                          ms,application/x-ustar                             ustar,application/x-wais-source                       src,application/x-wingz                             wz,application/x-x509-ca-cert                      crt,audio/basic                                     au snd,audio/midi                                      mid midi,audio/mpeg                                      mpga mpega mp2 mp3,audio/mpegurl                                   m3u,audio/prs.sid                                   sid,audio/x-aiff                                    aif aiff aifc,audio/x-gsm                                     gsm,audio/x-pn-realaudio                            ra rm ram,audio/x-scpls                                   pls,audio/x-wav                                     wav,audio/ogg                                       ogg,audio/mp4                                       m4a,audio/x-aac                                     aac,image/bitmap                                    bmp,image/gif                                       gif,image/ief                                       ief,image/jpeg                                      jpeg jpg jpe,image/pcx                                       pcx,image/png                                       png,image/svg+xml                                   svg svgz,image/tiff                                      tiff tif,image/vnd.wap.wbmp                              wbmp,image/x-cmu-raster                              ras,image/x-coreldraw                               cdr,image/x-coreldrawpattern                        pat,image/x-coreldrawtemplate                       cdt,image/x-corelphotopaint                         cpt,image/x-jng                                     jng,image/x-portable-anymap                         pnm,image/x-portable-bitmap                         pbm,image/x-portable-graymap                        pgm,image/x-portable-pixmap                         ppm,image/x-rgb                                     rgb,image/x-xbitmap                                 xbm,image/x-xpixmap                                 xpm,image/x-xwindowdump                             xwd,text/comma-separated-values                     csv,text/css                                        css,text/html                                       htm html xhtml,text/mathml                                     mml,text/plain                                      txt text diff,text/richtext                                   rtx,text/tab-separated-values                       tsv,text/vnd.wap.wml                                wml,text/vnd.wap.wmlscript                          wmls,text/xml                                        xml,text/x-c++hdr                                   h++ hpp hxx hh,text/x-c++src                                   c++ cpp cxx cc,text/x-chdr                                     h,text/x-csh                                      csh,text/x-csrc                                     c,text/x-java                                     java,text/x-moc                                      moc,text/x-pascal                                   p pas,text/x-setext                                   etx,text/x-sh                                       sh,text/x-tcl                                      tcl tk,text/x-tex                                      tex ltx sty cls,text/x-vcalendar                                vcs,text/x-vcard                                    vcf,video/dl                                        dl,video/fli                                       fli,video/gl                                        gl,video/mpeg                                      mpeg mpg mpe,video/quicktime                                 qt mov,video/x-mng                                     mng,video/x-ms-asf                                  asf asx,video/x-msvideo                                 avi,video/x-sgi-movie                               movie,video/ogg                                       ogv,video/mp4                                       mp4,x-world/x-vrml                                  vrm vrml wrl";
    private static Hashtable<String, String> extToMIMEMap = new Hashtable();
    private static Hashtable<String, Resource> MIMEToIconMap = new Hashtable();

    public static String getMIMEType(String fileName) {
        if (fileName == null) {
            throw new NullPointerException("Filename can not be null");
        }
        int dotIndex = fileName.indexOf(".");
        while (dotIndex >= 0 && fileName.indexOf(".", dotIndex + 1) >= 0) {
            dotIndex = fileName.indexOf(".", dotIndex + 1);
        }
        if (fileName.length() > ++dotIndex) {
            String type;
            String ext = fileName.substring(dotIndex);
            int queryStringStart = ext.indexOf(63);
            if (queryStringStart > 0) {
                ext = ext.substring(0, queryStringStart);
            }
            if ((type = extToMIMEMap.get(ext.toLowerCase())) != null) {
                return type;
            }
        }
        return DEFAULT_MIME_TYPE;
    }

    public static Resource getIcon(String fileName) {
        return FileTypeResolver.getIconByMimeType(FileTypeResolver.getMIMEType(fileName));
    }

    private static Resource getIconByMimeType(String mimeType) {
        Resource icon = MIMEToIconMap.get(mimeType);
        if (icon != null) {
            return icon;
        }
        return DEFAULT_ICON;
    }

    public static Resource getIcon(File file) {
        return FileTypeResolver.getIconByMimeType(FileTypeResolver.getMIMEType(file));
    }

    public static String getMIMEType(File file) {
        if (file == null) {
            throw new NullPointerException("File can not be null");
        }
        if (file.isDirectory()) {
            if (file.getParentFile() == null) {
                return "inode/drive";
            }
            return "inode/directory";
        }
        return FileTypeResolver.getMIMEType(file.getName());
    }

    public static void addExtension(String extension, String MIMEType) {
        extToMIMEMap.put(extension.toLowerCase(), MIMEType);
    }

    public static void addIcon(String MIMEType, Resource icon) {
        MIMEToIconMap.put(MIMEType, icon);
    }

    public static Map<String, String> getExtensionToMIMETypeMapping() {
        return Collections.unmodifiableMap(extToMIMEMap);
    }

    public static Map<String, Resource> getMIMETypeToIconMapping() {
        return Collections.unmodifiableMap(MIMEToIconMap);
    }

    static {
        StringTokenizer lines = new StringTokenizer(initialExtToMIMEMap, ",");
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            StringTokenizer exts = new StringTokenizer(line);
            String type = exts.nextToken();
            while (exts.hasMoreTokens()) {
                String ext = exts.nextToken();
                FileTypeResolver.addExtension(ext, type);
            }
        }
    }
}

