/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui;

import com.vaadin.featurepack.event.FieldEvents;
import com.vaadin.featurepack.server.ErrorMessage;
import com.vaadin.featurepack.server.FAbstractClientConnector;
import com.vaadin.featurepack.server.IconResource;
import com.vaadin.featurepack.server.Resource;
import com.vaadin.featurepack.shared.ui.ContentMode;
import com.vaadin.featurepack.ui.AbstractComponentContainer;
import com.vaadin.featurepack.ui.ComponentContainer;
import com.vaadin.featurepack.ui.Event;
import com.vaadin.featurepack.ui.FAbstractComponent;
import com.vaadin.featurepack.ui.Focusable;
import com.vaadin.featurepack.util.ComponentDataUtil;
import com.vaadin.featurepack.util.TooltipUtils;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.IconFactory;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.tabs.TabSheet;
import com.vaadin.flow.data.provider.KeyMapper;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

@Tag(value="div")
@CssImport(value="./tab-sheet.css")
public class FTabSheet
extends AbstractComponentContainer
implements Focusable,
FieldEvents.FocusNotifier,
FieldEvents.BlurNotifier {
    private final TabSheet tabSheet;
    private final ArrayList<Component> components = new ArrayList();
    private final HashMap<Component, Tab> tabs = new HashMap();
    private Component selected = null;
    private final KeyMapper<Component> keyMapper = new KeyMapper();
    private CloseHandler closeHandler;
    private boolean tabCaptionsAsHtml;
    private Component labelComponent;

    public FTabSheet() {
        this.tabSheet = new TabSheet();
        this.setWidth(100.0f, Unit.PERCENTAGE);
        this.setCloseHandler(new CloseHandler(){

            @Override
            public void onTabClose(FTabSheet tabsheet, Component c) {
                tabsheet.removeComponent(c);
            }
        });
        this.tabSheet.addSelectedChangeListener((ComponentEventListener & Serializable)event -> {
            if (event.isFromClient()) {
                Component component = null;
                if (event.getSelectedTab() != null) {
                    component = ((TabSheet)event.getSource()).getComponent(event.getSelectedTab());
                }
                this.setSelectedTab(component);
            }
        });
        super.addComponent((Component)this.tabSheet);
    }

    public FTabSheet(Component ... components) {
        this();
        this.addComponents(components);
    }

    @Override
    public void setLabelComponent(Component labelComponent) {
        super.setLabelComponent(labelComponent);
        if (this.labelComponent != null) {
            this.labelComponent.removeFromParent();
        }
        this.labelComponent = labelComponent;
        if (labelComponent != null) {
            this.addComponentAsFirst(labelComponent);
        }
    }

    @Override
    public void setWidth(float width, Unit unit) {
        super.setWidth(width, unit);
        this.tabSheet.setWidth(width, unit);
    }

    @Override
    public void setHeight(float height, Unit unit) {
        super.setHeight(height, unit);
        this.tabSheet.setHeight(height, unit);
    }

    @Override
    public Iterator<Component> iterator() {
        return Collections.unmodifiableList(this.components).iterator();
    }

    @Override
    public int getComponentCount() {
        return this.components.size();
    }

    @Override
    public void removeComponent(Component component) {
        if (component != null && this.components.contains(component)) {
            int componentIndex = this.components.indexOf(component);
            this.keyMapper.remove((Object)component);
            this.components.remove(component);
            Tab removedTab = this.tabs.remove(component);
            this.tabSheet.remove((com.vaadin.flow.component.tabs.Tab)removedTab);
            if (component.equals(this.selected)) {
                if (this.components.isEmpty()) {
                    this.setSelected(null);
                } else {
                    Component newSelectedComponent;
                    Tab newSelectedTab;
                    int newSelectedIndex = this.selectedTabIndexAfterTabRemove(componentIndex);
                    if (0 <= newSelectedIndex && newSelectedIndex < this.components.size() && (newSelectedTab = this.tabs.get(newSelectedComponent = this.components.get(newSelectedIndex))).isEnabled()) {
                        this.setSelected(newSelectedComponent);
                    }
                    this.updateSelection();
                    this.fireSelectedTabChange();
                }
            }
        }
    }

    protected int selectedTabIndexAfterTabRemove(int removedTabIndex) {
        Tab tab;
        int i;
        for (i = removedTabIndex; i < this.components.size(); ++i) {
            tab = this.getTab(i);
            if (!tab.isEnabled()) continue;
            return i;
        }
        for (i = removedTabIndex - 1; i >= 0; --i) {
            tab = this.getTab(i);
            if (!tab.isEnabled()) continue;
            return i;
        }
        return -1;
    }

    public void removeTab(Tab tab) {
        this.removeComponent(tab.getComponent());
    }

    @Override
    public void addComponent(Component c) {
        this.addTab(c);
    }

    public Tab addTab(Component c, String caption) {
        return this.addTab(c, caption, null);
    }

    public Tab addTab(Component c, String caption, Resource icon) {
        return this.addTab(c, caption, icon, this.components.size());
    }

    public Tab addTab(Component tabComponent, String caption, Resource icon, int position) {
        if (tabComponent == null) {
            return null;
        }
        if (this.tabs.containsKey(tabComponent)) {
            Tab tab = this.tabs.get(tabComponent);
            tab.setCaption(caption);
            tab.setIcon(icon);
            return tab;
        }
        this.components.add(position, tabComponent);
        TabSheetTabImpl tab = new TabSheetTabImpl(this.keyMapper.key((Object)tabComponent), caption, icon);
        this.tabSheet.add((com.vaadin.flow.component.tabs.Tab)tab, tabComponent, position);
        this.tabs.put(tabComponent, tab);
        if (this.selected == null) {
            this.setSelected(tabComponent);
            this.fireSelectedTabChange();
        }
        return tab;
    }

    public Tab addTab(Component c) {
        return this.addTab(c, this.components.size());
    }

    public Tab addTab(Component component, int position) {
        Tab result = this.tabs.get(component);
        if (result == null) {
            String caption = null;
            Resource icon = null;
            if (component instanceof Tab) {
                caption = ((Tab)component).getCaption();
                icon = ((Tab)component).getIcon();
            } else if (component instanceof FAbstractComponent) {
                caption = ((FAbstractComponent)component).getCaption();
                icon = ((FAbstractComponent)component).getIconResource();
            }
            result = this.addTab(component, caption, icon, position);
        }
        return result;
    }

    @Override
    public void moveComponentsFrom(ComponentContainer source) {
        for (Component c : source) {
            Tab tab;
            String caption = null;
            Resource icon = null;
            String iconAltText = "";
            if (FTabSheet.class.isAssignableFrom(source.getClass())) {
                tab = ((FTabSheet)source).getTab(c);
                caption = tab.getCaption();
                icon = tab.getIcon();
                iconAltText = tab.getIconAlternateText();
            }
            source.removeComponent(c);
            tab = this.addTab(c, caption, icon);
            tab.setIconAlternateText(iconAltText);
        }
    }

    public void setTabsVisible(boolean tabsVisible) {
        SlotUtils.getChildInSlot((HasElement)this.tabSheet, (String)"tabs").setVisible(tabsVisible);
    }

    public boolean isTabsVisible() {
        return SlotUtils.getChildInSlot((HasElement)this.tabSheet, (String)"tabs").isVisible();
    }

    public Tab getTab(Component c) {
        return this.tabs.get(c);
    }

    public Tab getTab(int position) {
        if (position >= 0 && position < this.getComponentCount()) {
            return this.getTab(this.components.get(position));
        }
        return null;
    }

    public void setSelectedTab(Component c) {
        if (c != null && this.components.contains(c) && !c.equals(this.selected)) {
            this.setSelected(c);
            this.updateSelection();
            this.fireSelectedTabChange();
            this.markAsDirty();
        }
    }

    private void setSelected(Component component) {
        this.selected = component;
        if (this.selected != null) {
            Tab tab = this.getTab(component);
            if (tab != null && tab.getDefaultFocusComponent() != null) {
                tab.getDefaultFocusComponent().focus();
            }
            this.keyMapper.key((Object)this.selected);
            this.tabSheet.setSelectedTab((com.vaadin.flow.component.tabs.Tab)((TabSheetTabImpl)tab));
            if (component instanceof FAbstractClientConnector) {
                ((FAbstractClientConnector)component).markAsDirtyRecursive();
            }
        } else {
            this.tabSheet.setSelectedTab(null);
        }
    }

    public void setSelectedTab(Tab tab) {
        if (tab != null) {
            this.setSelectedTab(tab.getComponent());
        }
    }

    public void setSelectedTab(int position) {
        this.setSelectedTab(this.getTab(position));
    }

    private boolean updateSelection() {
        Component originalSelection = this.selected;
        for (Component component : this) {
            Tab tab = this.tabs.get(component);
            Tab selectedTabInfo = null;
            if (this.selected != null) {
                selectedTabInfo = this.tabs.get(this.selected);
            }
            if (this.selected != null && selectedTabInfo != null && selectedTabInfo.isVisible() && selectedTabInfo.isEnabled()) continue;
            if (tab.isEnabled() && tab.isVisible()) {
                this.setSelected(component);
                break;
            }
            this.setSelected(null);
        }
        return originalSelection != this.selected;
    }

    public Component getSelectedTab() {
        return this.selected;
    }

    @Override
    public void replaceComponent(Component oldComponent, Component newComponent) {
        boolean selectAfterInserting = false;
        if (this.selected == oldComponent) {
            selectAfterInserting = true;
        }
        Tab newTab = this.tabs.get(newComponent);
        Tab oldTab = this.tabs.get(oldComponent);
        int oldLocation = -1;
        int newLocation = -1;
        int location = 0;
        for (Component component : this.components) {
            if (component == oldComponent) {
                oldLocation = location;
            }
            if (component == newComponent) {
                newLocation = location;
            }
            ++location;
        }
        if (oldLocation == -1) {
            this.addComponent(newComponent);
        } else if (newLocation == -1) {
            if (this.selected == oldComponent) {
                this.setSelected(null);
            }
            this.removeComponent(oldComponent);
            newTab = this.addTab(newComponent, oldLocation);
            if (selectAfterInserting) {
                this.setSelected(newComponent);
            }
            FTabSheet.copyTabMetadata(oldTab, newTab);
        } else {
            this.components.set(oldLocation, newComponent);
            this.components.set(newLocation, oldComponent);
            if (selectAfterInserting) {
                this.setSelected(newComponent);
                this.fireSelectedTabChange();
            }
            TabSheetTabImpl tmp = new TabSheetTabImpl(null, null, null);
            FTabSheet.copyTabMetadata(newTab, tmp);
            FTabSheet.copyTabMetadata(oldTab, newTab);
            FTabSheet.copyTabMetadata(tmp, oldTab);
            this.markAsDirty();
        }
    }

    public Registration addSelectedTabChangeListener(SelectedTabChangeListener listener) {
        return ComponentDataUtil.put("tabsheet-selectedTabChangeListener", this, listener, ComponentUtil.addListener((Component)this, SelectedTabChangeEvent.class, listener::selectedTabChange));
    }

    public void removeSelectedTabChangeListener(SelectedTabChangeListener listener) {
        ComponentDataUtil.remove("tabsheet-selectedTabChangeListener", this, listener).map(Registration.class::cast).ifPresent(Registration::remove);
    }

    protected void fireSelectedTabChange() {
        this.fireEvent(new SelectedTabChangeEvent(this));
    }

    public void setCloseHandler(CloseHandler handler) {
        this.closeHandler = handler;
    }

    public void setTabPosition(Tab tab, int position) {
        int oldPosition = this.getTabPosition(tab);
        this.components.remove(oldPosition);
        this.components.add(position, tab.getComponent());
        this.tabSheet.remove(oldPosition);
        this.tabSheet.add((com.vaadin.flow.component.tabs.Tab)((TabSheetTabImpl)tab), tab.getComponent(), position);
    }

    public int getTabPosition(Tab tab) {
        return this.components.indexOf(tab.getComponent());
    }

    @Override
    public void focus() {
        super.focus();
    }

    @Override
    public int getTabIndex() {
        return this.getElement().getProperty("tabIndex", -1);
    }

    @Override
    public void setTabIndex(int tabIndex) {
        this.getElement().setProperty("tabIndex", (double)tabIndex);
    }

    @Override
    public void addBlurListener(FieldEvents.BlurListener listener) {
        FieldEvents.BlurNotifier.super.addBlurListener(listener);
    }

    @Override
    public void removeBlurListener(FieldEvents.BlurListener listener) {
        FieldEvents.BlurNotifier.super.removeBlurListener(listener);
    }

    @Override
    public void addFocusListener(FieldEvents.FocusListener listener) {
        FieldEvents.FocusNotifier.super.addFocusListener(listener);
    }

    @Override
    public void removeFocusListener(FieldEvents.FocusListener listener) {
        FieldEvents.FocusNotifier.super.removeFocusListener(listener);
    }

    public boolean isRendered(Component childComponent) {
        return childComponent == this.getSelectedTab();
    }

    private static void copyTabMetadata(Tab from, Tab to) {
        to.setCaption(from.getCaption());
        to.setIcon(from.getIcon(), from.getIconAlternateText());
        to.setDescription(from.getDescription());
        to.setVisible(from.isVisible());
        to.setEnabled(from.isEnabled());
        to.setClosable(from.isClosable());
        to.setStyleName(from.getStyleName());
        to.setComponentError(from.getComponentError());
    }

    public void setTabCaptionsAsHtml(boolean tabCaptionsAsHtml) {
        this.tabCaptionsAsHtml = tabCaptionsAsHtml;
    }

    public boolean isTabCaptionsAsHtml() {
        return this.tabCaptionsAsHtml;
    }

    public static interface CloseHandler
    extends Serializable {
        public void onTabClose(FTabSheet var1, Component var2);
    }

    public static interface Tab
    extends Serializable {
        public boolean isVisible();

        public void setVisible(boolean var1);

        public boolean isClosable();

        public void setClosable(boolean var1);

        public void setDefaultFocusComponent(Focusable var1);

        public Focusable getDefaultFocusComponent();

        public boolean isEnabled();

        public void setEnabled(boolean var1);

        public void setCaption(String var1);

        public String getCaption();

        public Resource getIcon();

        public void setIcon(Resource var1);

        public void setIcon(Icon var1);

        public void setIcon(IconFactory var1);

        public void setIcon(Resource var1, String var2);

        public String getIconAlternateText();

        public void setIconAlternateText(String var1);

        public String getDescription();

        public void setDescription(String var1);

        public void setComponentError(ErrorMessage var1);

        public ErrorMessage getComponentError();

        public Component getComponent();

        public void setStyleName(String var1);

        public String getStyleName();

        public void setId(String var1);

        public String getFId();
    }

    public class TabSheetTabImpl
    extends com.vaadin.flow.component.tabs.Tab
    implements Tab {
        private boolean closable;
        private String caption;
        private String iconAltText;
        private String key;
        private String styleName;
        private Focusable defaultFocus;
        private ErrorMessage componentError;
        private Component labelComponent;

        public TabSheetTabImpl(String key, String caption, Resource icon) {
            if (caption == null) {
                caption = "";
            }
            this.key = key;
            this.setCaption(caption);
            this.setIcon(icon);
        }

        private void updateForTooltipAndErrorMessage() {
            ErrorMessage error = this.getComponentError();
            if (error != null) {
                String className = "v-errormessage-" + error.getErrorLevel().name().toLowerCase(Locale.ENGLISH);
                if (this.getDescription() != null) {
                    TooltipUtils.setTooltip((Component)this, "<div><div class=\"v-errormessage " + className + "\">" + error.getFormattedHtmlMessage() + "</div><div class=\"v-tooltip-text\">" + TooltipUtils.getFormattedMessage(this.getDescription(), TooltipUtils.getDescriptionContentMode((Component)this)) + "</div></div>", ContentMode.HTML);
                } else {
                    TooltipUtils.setTooltip((Component)this, "<div><div class=\"v-errormessage " + className + "\">" + error.getFormattedHtmlMessage() + "</div></div>", ContentMode.HTML);
                }
            } else if (this.getDescription() != null) {
                TooltipUtils.setTooltip((Component)this, this.getDescription(), TooltipUtils.getDescriptionContentMode((Component)this));
            } else {
                TooltipUtils.setTooltip((Component)this, null, null);
            }
        }

        private void updateCaption(String caption) {
            this.caption = caption;
            this.updateForTooltipAndErrorMessage();
            Object labelComponent = FTabSheet.this.isTabCaptionsAsHtml() ? new Html("<span>" + (caption == null ? "" : caption) + "</span>") : new Span(this.getCaption());
            labelComponent = this.getIcon() != null ? new Span(new Component[]{(Component)this.getIcon(), labelComponent, this.getErrorIndicator()}) : new Span(new Component[]{labelComponent, this.getErrorIndicator()});
            if (this.isClosable()) {
                labelComponent.add(new Component[]{this.createCloseButton()});
            }
            labelComponent.addClassName("v-caption");
            this.setLabelComponent((Component)labelComponent);
        }

        private Component createCloseButton() {
            Button closeButton = new Button();
            closeButton.setIcon((Component)VaadinIcon.CLOSE_SMALL.create());
            closeButton.getElement().addEventListener("click", (DomEventListener & Serializable)e -> FTabSheet.this.closeHandler.onTabClose(FTabSheet.this, (Component)FTabSheet.this.keyMapper.get(this.key))).preventDefault();
            closeButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY, ButtonVariant.LUMO_SMALL});
            return closeButton;
        }

        private void setLabelComponent(Component labelComponent) {
            if (this.labelComponent != null) {
                this.labelComponent.removeFromParent();
            }
            this.labelComponent = labelComponent;
            if (labelComponent != null) {
                this.add(new Component[]{labelComponent});
            }
        }

        private Component getErrorIndicator() {
            ErrorMessage error;
            Component indicator = (Component)ComponentUtil.getData((Component)this, (String)"component-errorIndicator");
            if (indicator == null) {
                indicator = new Span();
                ComponentUtil.setData((Component)this, (String)"component-errorIndicator", (Object)indicator);
            }
            if ((error = this.getComponentError()) != null) {
                indicator.addClassNames(new String[]{"v-errorindicator", "v-errorindicator-" + error.getErrorLevel().name().toLowerCase(Locale.ENGLISH)});
                indicator.getStyle().setDisplay(Style.Display.INLINE);
            } else {
                indicator.getClassNames().clear();
                indicator.getStyle().setDisplay(Style.Display.NONE);
            }
            return indicator;
        }

        @Override
        public String getCaption() {
            return this.caption;
        }

        @Override
        public void setCaption(String caption) {
            this.updateCaption(caption);
            FTabSheet.this.markAsDirty();
        }

        @Override
        public Resource getIcon() {
            return FTabSheet.this.getResource("icon" + this.key);
        }

        @Override
        public void setIcon(Resource icon) {
            this.setIcon(icon, "");
            this.updateCaption(this.getCaption());
        }

        @Override
        public void setIcon(Icon icon) {
            this.setIcon(icon != null ? new IconResource(icon) : null);
        }

        @Override
        public void setIcon(IconFactory icon) {
            this.setIcon(icon.create());
        }

        @Override
        public String getIconAlternateText() {
            return this.iconAltText;
        }

        @Override
        public void setIconAlternateText(String iconAltText) {
            this.iconAltText = iconAltText;
            this.updateIcon(this.getIcon());
            this.updateCaption(this.getCaption());
            FTabSheet.this.markAsDirty();
        }

        @Override
        public void setDefaultFocusComponent(Focusable defaultFocus) {
            this.defaultFocus = defaultFocus;
        }

        @Override
        public Focusable getDefaultFocusComponent() {
            return this.defaultFocus;
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled();
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (FTabSheet.this.updateSelection()) {
                FTabSheet.this.fireSelectedTabChange();
            }
            FTabSheet.this.markAsDirty();
        }

        @Override
        public boolean isVisible() {
            return super.isVisible();
        }

        @Override
        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (FTabSheet.this.updateSelection()) {
                FTabSheet.this.fireSelectedTabChange();
            }
            FTabSheet.this.markAsDirty();
        }

        @Override
        public boolean isClosable() {
            return this.closable;
        }

        @Override
        public void setClosable(boolean closable) {
            this.closable = closable;
            this.updateCaption(this.getCaption());
            FTabSheet.this.markAsDirty();
        }

        @Override
        public String getDescription() {
            return TooltipUtils.getDescription((Component)this);
        }

        @Override
        public void setDescription(String description) {
            TooltipUtils.setDescription((Component)this, description);
            this.updateCaption(this.getCaption());
            FTabSheet.this.markAsDirty();
        }

        @Override
        public ErrorMessage getComponentError() {
            return this.componentError;
        }

        @Override
        public void setComponentError(ErrorMessage componentError) {
            this.componentError = componentError;
            this.updateCaption(this.getCaption());
            FTabSheet.this.markAsDirty();
        }

        @Override
        public Component getComponent() {
            for (Map.Entry<Component, Tab> entry : FTabSheet.this.tabs.entrySet()) {
                if (!this.equals(entry.getValue())) continue;
                return entry.getKey();
            }
            return null;
        }

        @Override
        public void setStyleName(String styleName) {
            if (styleName != null) {
                super.getElement().getClassList().add((Object)("v-tabsheet-tabitemcell-" + styleName));
            } else if (this.styleName != null) {
                super.getElement().getClassList().remove((Object)("v-tabsheet-tabitemcell-" + this.styleName));
            }
            this.styleName = styleName;
            FTabSheet.this.markAsDirty();
        }

        @Override
        public String getStyleName() {
            return this.styleName;
        }

        @Override
        public void setId(String id) {
            super.setId(id);
            FTabSheet.this.markAsDirty();
        }

        @Override
        public String getFId() {
            return this.getId().orElse(null);
        }

        @Override
        public void setIcon(Resource icon, String iconAltText) {
            this.updateIcon(icon);
            this.iconAltText = iconAltText;
        }

        private void updateIcon(Resource icon) {
            if (this.getIcon() != null) {
                ((IconResource)this.getIcon()).removeFromParent();
            }
            FTabSheet.this.setResource("icon" + this.key, icon);
            if (icon != null) {
                IconResource iconResource = (IconResource)icon;
                if (this.iconAltText != null) {
                    iconResource.getElement().setAttribute("role", "img");
                    iconResource.getElement().setAttribute("aria-label", this.iconAltText);
                }
                this.getElement().insertChild(0, new Element[]{iconResource.getElement()});
            }
        }
    }

    public static class SelectedTabChangeEvent
    extends Event {
        public SelectedTabChangeEvent(Component source) {
            super(source);
        }

        public FTabSheet getTabSheet() {
            return (FTabSheet)this.getSource();
        }
    }

    public static interface SelectedTabChangeListener
    extends ComponentEventListener<SelectedTabChangeEvent> {
        default public void onComponentEvent(SelectedTabChangeEvent event) {
            this.selectedTabChange(event);
        }

        public void selectedTabChange(SelectedTabChangeEvent var1);
    }
}

