/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui;

import com.vaadin.featurepack.data.Container;
import com.vaadin.featurepack.data.Item;
import com.vaadin.featurepack.data.ItemDataProvider;
import com.vaadin.featurepack.data.Property;
import com.vaadin.featurepack.data.Validator;
import com.vaadin.featurepack.data.converter.Converter;
import com.vaadin.featurepack.data.fieldgroup.DefaultFieldGroupFieldFactory;
import com.vaadin.featurepack.data.fieldgroup.FieldGroup;
import com.vaadin.featurepack.data.fieldgroup.FieldGroupFieldFactory;
import com.vaadin.featurepack.data.sort.Sort;
import com.vaadin.featurepack.data.sort.SortDirection;
import com.vaadin.featurepack.data.sort.SortOrder;
import com.vaadin.featurepack.data.ui.Field;
import com.vaadin.featurepack.data.ui.Select;
import com.vaadin.featurepack.data.util.FSharedUtil;
import com.vaadin.featurepack.data.util.IndexedContainer;
import com.vaadin.featurepack.event.FieldEvents;
import com.vaadin.featurepack.event.ItemClickEvent;
import com.vaadin.featurepack.event.SelectionEvent;
import com.vaadin.featurepack.event.SortEvent;
import com.vaadin.featurepack.server.ClientConnector;
import com.vaadin.featurepack.server.ErrorMessage;
import com.vaadin.featurepack.server.FAbstractClientConnector;
import com.vaadin.featurepack.shared.ui.ContentMode;
import com.vaadin.featurepack.shared.ui.grid.HeightMode;
import com.vaadin.featurepack.ui.AbstractComponent;
import com.vaadin.featurepack.ui.AbstractComponentContainer;
import com.vaadin.featurepack.ui.Event;
import com.vaadin.featurepack.ui.FAbstractComponent;
import com.vaadin.featurepack.ui.FCheckBox;
import com.vaadin.featurepack.ui.FComboBox;
import com.vaadin.featurepack.ui.FGridEditorImpl;
import com.vaadin.featurepack.ui.renderers.Renderer;
import com.vaadin.featurepack.util.ComponentDataUtil;
import com.vaadin.featurepack.util.GridRendererAdapter;
import com.vaadin.featurepack.util.V8Utils;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutEventListener;
import com.vaadin.flow.component.Shortcuts;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.grid.FooterRow;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridMultiSelectionModel;
import com.vaadin.flow.component.grid.GridSelectionModel;
import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.grid.editor.Editor;
import com.vaadin.flow.component.grid.editor.EditorCancelListener;
import com.vaadin.flow.component.grid.editor.EditorCloseListener;
import com.vaadin.flow.component.grid.editor.EditorOpenListener;
import com.vaadin.flow.component.grid.editor.EditorSaveListener;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.menubar.MenuBarVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.Setter;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.ItemIndexProvider;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.selection.MultiSelectionEvent;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.data.selection.SelectionModel;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.ExecutionContext;
import com.vaadin.flow.internal.Pair;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.shared.util.SharedUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

@Tag(value="div")
@CssImport.Container(value={@CssImport(value="./fgrid.css"), @CssImport(value="@vaadin/vaadin-lumo-styles/lumo.css")})
@JsModule(value="./fgrid-styles.js")
public class FGrid
extends AbstractComponentContainer
implements FAbstractComponent,
FieldEvents.FocusNotifier,
FieldEvents.BlurNotifier,
SelectionEvent.SelectionNotifier,
SortEvent.SortNotifier,
ItemClickEvent.ItemClickNotifier {
    private static final String V_GRID = "v-grid";
    private static final String V_CAPTION = "v-caption";
    private static final String V_CAPTIONTEXT = "v-captiontext";
    private static final String V_GRID_COLUMN_COLLAPSING_MENU = "v-grid-column-collapsing-menu";
    private static final String V_GRID_MIN_WIDTH = "fgrid-min-width-";
    private static final String V_GRID_MAX_WIDTH = "fgrid-max-width-";
    private static final Method SELECTION_CHANGE_METHOD = ReflectTools.findMethod(SelectionEvent.SelectionListener.class, (String)"select", (Class[])new Class[]{SelectionEvent.class});
    private static final Method SORT_ORDER_CHANGE_METHOD = ReflectTools.findMethod(SortEvent.SortListener.class, (String)"sort", (Class[])new Class[]{SortEvent.class});
    private static final Method COLUMN_REORDER_METHOD = ReflectTools.findMethod(ColumnReorderListener.class, (String)"columnReorder", (Class[])new Class[]{ColumnReorderEvent.class});
    private static final Method COLUMN_RESIZE_METHOD = ReflectTools.findMethod(ColumnResizeListener.class, (String)"columnResize", (Class[])new Class[]{ColumnResizeEvent.class});
    private static final Method COLUMN_VISIBILITY_METHOD = ReflectTools.findMethod(ColumnVisibilityChangeListener.class, (String)"columnVisibilityChanged", (Class[])new Class[]{ColumnVisibilityChangeEvent.class});
    private static final double DEFAULT_HEIGHT_BY_ROWS = 10.0;
    private double heightByRows = 10.0;
    private HeightMode heightMode = HeightMode.CSS;
    private String heightInString;
    private Float heightInFloat;
    private Unit heightUnit;
    private SelectionModel selectionModel;
    private final Header header;
    private final Footer footer;
    private boolean editorEnabled = false;
    private Object editedItemId = null;
    private FieldGroup editorFieldGroup = new CustomFieldGroup();
    private final Map<Object, Field<?>> editorFields = new HashMap();
    private final FInternalGrid grid;
    private Container.Indexed dataSource;
    private final Map<Object, Column> columns = new HashMap<Object, Column>();
    private final List<SortOrder> sortOrder = new ArrayList<SortOrder>();
    private boolean defaultContainer = true;
    private EditorErrorHandler editorErrorHandler = new DefaultEditorErrorHandler();
    private final Container.ItemSetChangeListener itemSetChangeListener = event -> this.refreshAllRows();
    private final Map<Object, SerializableFunction<Item, String>> internalColumnPartNameGenerators = new HashMap<Object, SerializableFunction<Item, String>>();
    private CellStyleGenerator cellStyleGenerator;
    private RowStyleGenerator rowStyleGenerator;
    private boolean editorBuffered = true;
    private final Container.PropertySetChangeListener propertyListener = this::handleContainerPropertySetChange;
    private final Container.ItemSetChangeListener editorClosingItemSetListener = new Container.ItemSetChangeListener(){

        @Override
        public void containerItemSetChange(Container.ItemSetChangeEvent event) {
            FGrid.this.cancelEditor();
        }
    };
    private Registration selectionListenerRegistration;
    private Component captionComponent;
    private Item focusedItem;
    private Object focusedPropertyId;
    private HorizontalLayout editorFooterLayout;
    private Button saveEditorButton;
    private Button cancelEditorButton;
    private Div editorFooterErrorMessage;
    private StateTree.ExecutionRegistration beforeClientResponseRegistration;
    private final List<Object> columnOrder = new ArrayList<Object>();
    private Registration columnReorderListenerRegistration;
    private MenuBar columnCollapsingMenuBar;
    public ContentMode cellTooltipContentMode = ContentMode.HTML;
    private ContentMode rowTooltipContentMode = ContentMode.HTML;
    private CellDescriptionGenerator cellDescriptionGenerator;
    private RowDescriptionGenerator rowDescriptionGenerator;
    private Element columnMinMaxWidthsStyleElement;

    public FGrid() {
        this(null, null);
    }

    public FGrid(Container.Indexed dataSource) {
        this(null, dataSource);
    }

    public FGrid(String caption) {
        this(caption, null);
    }

    public FGrid(String caption, Container.Indexed dataSource) {
        this.grid = new FInternalGrid((SerializableSupplier<FieldGroup>)((SerializableSupplier & Serializable)this::getEditorFieldGroup));
        this.grid.setId("v-" + String.valueOf(UUID.randomUUID()));
        this.grid.addClassNames(new String[]{V_GRID});
        this.addComponent((Component)this.grid);
        this.getStyle().setPosition(Style.Position.RELATIVE);
        this.setCaption(caption);
        this.header = new Header(this);
        this.footer = new Footer(this);
        this.initEditorButtons();
        this.setSelectionMode(SelectionMode.SINGLE);
        Editor editor = this.grid.getEditor();
        editor.setBinder(new Binder(Item.class));
        this.setEditorBuffered(true);
        this.grid.addItemDoubleClickListener((ComponentEventListener & Serializable)event -> {
            if (this.isEditorEnabled()) {
                Field<?> editorComponent;
                this.editItem(this.toItemId((Item)event.getItem()));
                if (event.getColumn() != null && (editorComponent = this.getEditorField(event.getColumn().getKey())) instanceof Focusable) {
                    ((Focusable)editorComponent).focus();
                }
            }
        });
        this.grid.setMultiSort(true);
        this.grid.addSortListener((ComponentEventListener & Serializable)event -> {
            if (!event.isFromClient()) {
                return;
            }
            Map<String, Object> columnKeysToPropertyIds = this.getColumns().stream().collect(Collectors.toMap(column -> column.getInternalColumn().getKey(), Column::getPropertyId));
            List<SortOrder> sortOrders = Optional.ofNullable(event.getSortOrder()).orElseGet(Collections::emptyList).stream().map(gridSortOrder -> {
                Object propertyId = columnKeysToPropertyIds.get(gridSortOrder.getSorted().getKey());
                SortDirection direction = FGrid.convertSortDirection(gridSortOrder.getDirection());
                return new SortOrder(propertyId, direction);
            }).toList();
            this.setSortOrder(sortOrders);
        });
        this.grid.setDataProvider((DataProvider)new ItemDataProvider((SerializableSupplier<Container>)((SerializableSupplier & Serializable)this::getContainerDataSource)));
        this.grid.getLazyDataView().setItemIndexProvider((ItemIndexProvider & Serializable)(item, query) -> this.getContainerDataSource().indexOfId(this.toItemId((Item)item)));
        if (dataSource != null) {
            this.setContainerDataSource(dataSource);
        } else {
            this.internalSetContainerDataSource(new IndexedContainer());
        }
        this.initGrid();
    }

    private void initGrid() {
        this.grid.getEditor().addSaveListener((EditorSaveListener & Serializable)ev -> {
            try {
                this.saveEditor();
                this.doCancelEditor();
            }
            catch (FieldGroup.CommitException e) {
                try {
                    CommitErrorEvent event = new CommitErrorEvent(this, e);
                    this.getEditorErrorHandler().commitError(event);
                }
                catch (Exception ee) {
                    this.handleError(ee);
                }
            }
            catch (Exception e) {
                this.handleError(e);
            }
        });
        this.grid.getEditor().addOpenListener((EditorOpenListener & Serializable)event -> {
            this.editedItemId = this.toItemId((Item)event.getItem());
            this.doEditItem();
        });
        this.grid.getEditor().addCancelListener((EditorCancelListener & Serializable)event -> {
            if (this.isEditorActive()) {
                this.doCancelEditor();
            }
        });
        this.grid.getEditor().addCloseListener((EditorCloseListener & Serializable)event -> {
            this.grid.setDetailsVisible((Item)event.getItem(), false);
            this.editorFooterErrorMessage.getElement().setProperty("innerHTML", "");
        });
        Shortcuts.addShortcutListener((Component)this.grid, (ShortcutEventListener & Serializable)event -> {
            if (!this.grid.getEditor().isOpen() && this.focusedItem != null) {
                this.editItem(this.toItemId(this.focusedItem));
            } else if (this.grid.getEditor().isOpen()) {
                if (this.isEditorBuffered()) {
                    this.grid.getEditor().save();
                } else {
                    Object nextItemId = this.getContainerDataSource().nextItemId(this.editedItemId);
                    if (nextItemId != null) {
                        this.focusedItem = this.getContainerDataSource().getItem(nextItemId);
                        this.editItem(nextItemId);
                    }
                }
            }
        }, (Key)Key.ENTER, (KeyModifier[])new KeyModifier[0]).listenOn(new Component[]{this.grid});
        Shortcuts.addShortcutListener((Component)this.grid, (ShortcutEventListener & Serializable)event -> {
            if (this.grid.getEditor().isOpen()) {
                if (this.isEditorBuffered()) {
                    this.grid.getEditor().cancel();
                } else {
                    this.grid.getEditor().closeEditor();
                    this.editedItemId = null;
                }
            }
        }, (Key)Key.ESCAPE, (KeyModifier[])new KeyModifier[0]).listenOn(new Component[]{this.grid});
        ComponentUtil.addListener((Component)this.grid, ItemClickEvent.class, (ComponentEventListener & Serializable)event -> {
            this.focusedItem = event.getItem();
            this.focusedPropertyId = event.getPropertyId();
            if (this.getEditedItemId() != null) {
                if (this.toItemId(event.getItem()) == this.getEditedItemId()) {
                    this.updateCellFocus();
                } else if (!this.isEditorBuffered()) {
                    this.editItem(this.toItemId(this.focusedItem));
                }
            }
        });
        this.grid.addCellFocusListener((ComponentEventListener & Serializable)event -> {
            if (event.isFromClient()) {
                this.focusedItem = event.getItem().orElse(null);
                this.focusedPropertyId = event.getColumn().map(Grid.Column::getKey).orElse(null);
            }
        });
        this.grid.addColumnResizeListener((ComponentEventListener & Serializable)event -> this.fireColumnResizeEvent(this.getColumn(event.getResizedColumn().getKey()), true));
        this.updateSelectionListener();
    }

    private void initEditorButtons() {
        this.editorFooterErrorMessage = new Div();
        this.editorFooterErrorMessage.addClassName("v-grid-editor-message");
        this.saveEditorButton = new Button("Save");
        this.saveEditorButton.addClassName("v-grid-editor-save");
        this.saveEditorButton.addClickListener((ComponentEventListener & Serializable)event -> this.grid.getEditor().save());
        this.cancelEditorButton = new Button("Cancel");
        this.cancelEditorButton.addClassName("v-grid-editor-cancel");
        this.cancelEditorButton.addClickListener((ComponentEventListener & Serializable)event -> this.grid.getEditor().cancel());
        this.editorFooterLayout = new HorizontalLayout();
        this.editorFooterLayout.addClassName("v-grid-editor-footer");
        this.editorFooterLayout.setWidthFull();
        this.editorFooterLayout.getStyle().setDisplay(Style.Display.FLEX);
        this.editorFooterLayout.setSpacing("var(--lumo-space-s)");
        this.editorFooterLayout.addAndExpand(new Component[]{this.editorFooterErrorMessage});
        this.editorFooterLayout.add(new Component[]{this.saveEditorButton, this.cancelEditorButton});
        this.editorFooterLayout.setVisible(false);
        this.editorFooterLayout.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        this.grid.setDetailsVisibleOnClick(false);
    }

    private void updateCellFocus() {
        Field<?> editorComponent;
        if (this.focusedPropertyId != null && (editorComponent = this.getEditorField(this.focusedPropertyId)) instanceof Focusable) {
            ((Focusable)editorComponent).focus();
        }
    }

    private void updateSelectionListener() {
        Optional.ofNullable(this.selectionListenerRegistration).ifPresent(Registration::remove);
        this.selectionListenerRegistration = this.grid.addSelectionListener((SelectionListener & Serializable)event -> {
            if (event.isFromClient()) {
                SelectionModel selectionModel = this.getSelectionModel();
                if (selectionModel instanceof SelectionModel.Multi) {
                    MultiSelectionEvent multiEvent = (MultiSelectionEvent)event;
                    if (selectionModel instanceof MultiSelectionModel && ((MultiSelectionModel)selectionModel).isUserSelectionAllowed() && !this.isEditorActive()) {
                        ((SelectionModel.Multi)selectionModel).select(multiEvent.getAddedSelection().stream().map(this::toItemId).collect(Collectors.toSet()));
                        ((SelectionModel.Multi)selectionModel).deselect(multiEvent.getRemovedSelection().stream().map(this::toItemId).collect(Collectors.toSet()));
                    } else {
                        multiEvent.getAddedSelection().forEach(arg_0 -> this.getFlowGrid().deselect(arg_0));
                        multiEvent.getRemovedSelection().forEach(arg_0 -> this.getFlowGrid().select(arg_0));
                        if (!((MultiSelectionModel)selectionModel).isUserSelectionAllowed()) {
                            this.handleError(new IllegalStateException("Client tried to select '" + String.valueOf(event.getAllSelectedItems().stream().map(this::toItemId).collect(Collectors.toSet())) + "' although user selection is disallowed"));
                        }
                    }
                } else if (selectionModel instanceof SelectionModel.Single) {
                    if (selectionModel instanceof SingleSelectionModel && ((SingleSelectionModel)selectionModel).isUserSelectionAllowed() && !this.isEditorActive()) {
                        ((SelectionModel.Single)selectionModel).select(event.getFirstSelectedItem().map(this::toItemId).orElse(null));
                    } else {
                        event.getFirstSelectedItem().ifPresent(arg_0 -> this.getFlowGrid().deselect(arg_0));
                        Object itemId = ((SelectionModel.Single)selectionModel).getSelectedRow();
                        if (itemId != null) {
                            this.getFlowGrid().select((Object)this.getContainerDataSource().getItem(itemId));
                        }
                        if (!((SingleSelectionModel)selectionModel).isUserSelectionAllowed()) {
                            this.handleError(new IllegalStateException("Client tried to select '" + String.valueOf(event.getFirstSelectedItem().map(this::toItemId).orElse(null)) + "' although user selection is disallowed"));
                        }
                    }
                }
            }
        });
    }

    protected void handleError(Exception e) {
        ErrorEvent.findErrorHandler((VaadinSession)this.getSession()).error(new ErrorEvent((Throwable)e));
    }

    public Grid<Item> getFlowGrid() {
        return this.grid;
    }

    @Override
    public void setLabelComponent(Component labelComponent) {
        if (this.captionComponent != null) {
            this.removeComponent(this.captionComponent);
        }
        this.captionComponent = labelComponent;
        if (this.captionComponent instanceof Span) {
            Span captionSpan = (Span)this.captionComponent;
            captionSpan.addClassNames(new String[]{V_CAPTION});
            captionSpan.getChildren().filter(child -> child instanceof Span).findFirst().ifPresent(child -> child.addClassNames(new String[]{V_CAPTIONTEXT}));
        }
        this.addComponentAsFirst(this.captionComponent);
        String captionId = UUID.randomUUID().toString();
        this.captionComponent.setId(captionId);
        this.grid.getElement().setAttribute("labelledBy", captionId);
        this.grid.getId().ifPresent(gridId -> this.captionComponent.getElement().setAttribute("for", gridId));
    }

    private void registerInternalBeforeClientResponse() {
        if (this.beforeClientResponseRegistration == null) {
            this.getUI().ifPresent(ui -> {
                this.beforeClientResponseRegistration = ui.beforeClientResponse((Component)this, this::internalBeforeClientResponse);
            });
        }
    }

    private void internalBeforeClientResponse(ExecutionContext executionContext) {
        this.beforeClientResponseRegistration = null;
        this.updateEditorErrorMessage();
        this.updateColumnMinMaxWidths();
    }

    private void updateEditorErrorMessage() {
        List<Pair> invalidFields = this.getEditorFields().stream().filter(Objects::nonNull).filter(field -> field instanceof FAbstractComponent).map(field -> (FAbstractComponent)((Object)field)).map(field -> new Pair((Serializable)field, (Serializable)field.getFErrorMessage())).filter(pair -> pair.getSecond() != null).collect(Collectors.toList());
        invalidFields.forEach(pair -> {
            FAbstractComponent field = (FAbstractComponent)pair.getFirst();
            if (field instanceof HasValidation) {
                ((HasValidation)field).setInvalid(true);
            }
        });
        invalidFields.stream().findFirst().ifPresentOrElse(pair -> {
            ErrorMessage errorMessage = (ErrorMessage)pair.getSecond();
            String className = "v-errormessage-" + errorMessage.getErrorLevel().name().toLowerCase(Locale.ENGLISH);
            Span indicator = new Span();
            indicator.addClassNames(new String[]{"v-errorindicator", "v-errorindicator-" + errorMessage.getErrorLevel().name().toLowerCase(Locale.ENGLISH)});
            indicator.getStyle().setDisplay(Style.Display.INLINE);
            this.editorFooterErrorMessage.getElement().setProperty("innerHTML", indicator.getElement().getOuterHTML() + "<span class=\"v-errormessage " + className + "\">" + errorMessage.getFormattedHtmlMessage() + "</span>");
            if (!this.isEditorBuffered() && this.editedItemId != null) {
                this.grid.setDetailsVisible(this.getContainerDataSource().getItem(this.editedItemId), true);
            }
        }, () -> {
            if (!this.isEditorBuffered() && this.editedItemId != null) {
                this.grid.setDetailsVisible(this.getContainerDataSource().getItem(this.editedItemId), false);
            }
        });
    }

    private void updateColumnMinMaxWidths() {
        if (this.columnMinMaxWidthsStyleElement == null) {
            this.columnMinMaxWidthsStyleElement = new Element("style");
            this.columnMinMaxWidthsStyleElement.setAttribute("id", "v-grid-column-min-max-widths-" + this.grid.getElement().getAttribute("id"));
            this.getElement().appendVirtualChild(new Element[]{this.columnMinMaxWidthsStyleElement});
            this.getElement().executeJs("if (!document.getElementById($0)) { document.head.appendChild($1); }", new Object[]{this.columnMinMaxWidthsStyleElement.getAttribute("id"), this.columnMinMaxWidthsStyleElement});
        } else {
            this.columnMinMaxWidthsStyleElement.setText("");
        }
        String gridId = (String)this.grid.getId().orElseThrow(() -> new NullPointerException("Flow Grid ID is not set."));
        int index = 0;
        for (Column column : this.getColumns()) {
            Grid.Column<Item> internalColumn = this.getInternalColumn(column.getPropertyId());
            this.setMinMaxWidthColumnPartGenerator(column, index, internalColumn);
            this.setMinMaxWidthHeaderParts(column, internalColumn, index, gridId);
            this.setMinMaxWidthFooterParts(column, internalColumn, index, gridId);
            ++index;
        }
    }

    private void setMinMaxWidthFooterParts(Column column, Grid.Column<Item> internalColumn, int index, String gridId) {
        for (com.vaadin.flow.component.grid.FooterRow footerRow : this.grid.getFooterRows()) {
            String part = ((FooterRow.FooterCell)footerRow.getCell(internalColumn)).getPartName();
            this.generateMinMaxWidthPartsAndCss(column, part, index, gridId, newPart -> ((FooterRow.FooterCell)footerRow.getCell(internalColumn)).setPartName(newPart));
        }
    }

    private void setMinMaxWidthHeaderParts(Column column, Grid.Column<Item> internalColumn, int index, String gridId) {
        for (com.vaadin.flow.component.grid.HeaderRow headerRow : this.grid.getHeaderRows()) {
            String part = ((HeaderRow.HeaderCell)headerRow.getCell(internalColumn)).getPartName();
            this.generateMinMaxWidthPartsAndCss(column, part, index, gridId, newPart -> ((HeaderRow.HeaderCell)headerRow.getCell(internalColumn)).setPartName(newPart));
        }
    }

    private void setMinMaxWidthColumnPartGenerator(Column column, int index, Grid.Column<Item> internalColumn) {
        int columnIndex = index;
        this.internalColumnPartNameGenerators.put(column.getPropertyId(), (SerializableFunction<Item, String>)(SerializableFunction & Serializable)item -> {
            if (column.getMinimumWidth() > 0.0) {
                return column.getMaximumWidth() > 0.0 ? V_GRID_MIN_WIDTH + columnIndex + " fgrid-max-width-" + columnIndex : V_GRID_MIN_WIDTH + columnIndex;
            }
            if (column.getMaximumWidth() > 0.0) {
                return V_GRID_MAX_WIDTH + columnIndex;
            }
            return null;
        });
        internalColumn.setPartNameGenerator(this.createColumnPartNameGenerator(internalColumn));
    }

    private void generateMinMaxWidthPartsAndCss(Column column, String oldPart, int index, String gridId, Consumer<String> partSetter) {
        String newParts = oldPart;
        String minWidthPartName = V_GRID_MIN_WIDTH + index;
        if (column.getMinimumWidth() > 0.0) {
            newParts = this.addPartName(newParts, minWidthPartName);
            String css = this.generateCss(minWidthPartName, "min-width: " + column.getMinimumWidth() + "px;", gridId);
            if (!this.columnMinMaxWidthsStyleElement.getText().contains(css)) {
                this.columnMinMaxWidthsStyleElement.setText(this.columnMinMaxWidthsStyleElement.getText() + css);
            }
        }
        String maxWidthPartName = V_GRID_MAX_WIDTH + index;
        if (column.getMaximumWidth() > 0.0) {
            newParts = this.addPartName(newParts, maxWidthPartName);
            String css = this.generateCss(maxWidthPartName, "max-width: " + column.getMaximumWidth() + "px;", gridId);
            if (!this.columnMinMaxWidthsStyleElement.getText().contains(css)) {
                this.columnMinMaxWidthsStyleElement.setText(this.columnMinMaxWidthsStyleElement.getText() + css);
            }
        }
        partSetter.accept(newParts);
    }

    private String addPartName(String oldPart, String partName) {
        Object part = oldPart;
        if (part == null) {
            part = "";
        }
        if (!((String)part).contains(partName)) {
            part = (String)part + " " + partName;
        }
        return ((String)part).trim();
    }

    private String generateCss(String partName, String cssRule, String gridId) {
        return String.format("vaadin-grid#%s::part(%s) { %s }\n", gridId, partName, cssRule);
    }

    public Container.Indexed getContainerDataSource() {
        return this.dataSource;
    }

    public void setContainerDataSource(Container.Indexed container) {
        this.defaultContainer = false;
        this.internalSetContainerDataSource(container);
    }

    private void internalSetContainerDataSource(Container.Indexed container) {
        Container.ItemSetChangeNotifier itemSetChangeNotifier;
        Container.PropertySetChangeNotifier propertySetChangeNotifier;
        if (container == null) {
            throw new IllegalArgumentException("Cannot set the datasource to null");
        }
        if (this.dataSource == container) {
            return;
        }
        Object object = this.dataSource;
        if (object instanceof Container.PropertySetChangeNotifier) {
            propertySetChangeNotifier = (Container.PropertySetChangeNotifier)object;
            propertySetChangeNotifier.removePropertySetChangeListener(this.propertyListener);
        }
        if ((object = this.dataSource) instanceof Container.ItemSetChangeNotifier) {
            itemSetChangeNotifier = (Container.ItemSetChangeNotifier)object;
            itemSetChangeNotifier.removeItemSetChangeListener(this.itemSetChangeListener);
        }
        this.resetEditor();
        this.dataSource = container;
        if (container instanceof Container.Sortable) {
            Container.Sortable sortable = (Container.Sortable)((Object)container);
            Collection<?> sortableProps = sortable.getSortableContainerPropertyIds();
            this.sortOrder.removeIf(order -> !sortableProps.contains(order.getPropertyId()));
            this.sort(false);
        } else {
            this.sortOrder.clear();
        }
        object = this.dataSource;
        if (object instanceof Container.PropertySetChangeNotifier) {
            propertySetChangeNotifier = (Container.PropertySetChangeNotifier)object;
            propertySetChangeNotifier.addPropertySetChangeListener(this.propertyListener);
        }
        if ((object = this.dataSource) instanceof Container.ItemSetChangeNotifier) {
            itemSetChangeNotifier = (Container.ItemSetChangeNotifier)object;
            itemSetChangeNotifier.addItemSetChangeListener(this.itemSetChangeListener);
        }
        this.setFrozenColumnCount(0);
        if (this.grid.getColumns().isEmpty()) {
            this.dataSource.getContainerPropertyIds().forEach(this::appendColumn);
        } else {
            Map properties = this.dataSource.getContainerPropertyIds().stream().collect(Collectors.toMap(FGrid::propertyIdToColumnKey, Function.identity()));
            for (Grid.Column column : this.grid.getColumns()) {
                Object property = properties.get(column.getKey());
                if (property == null) {
                    throw new IllegalStateException("Found at least one column in Grid that does not exist in the given container: " + column.getKey() + " with the header \"" + column.getHeaderText() + "\". Call removeAllColumns() before setContainerDataSource() if you want to reconfigure the columns based on the new container.");
                }
                this.updateColumnSortable(this.columns.get(property));
            }
        }
        ((ItemDataProvider)this.getFlowGrid().getDataProvider()).clear();
        this.getFlowGrid().getDataProvider().refreshAll();
    }

    @Override
    public void replaceComponent(Component oldComponent, Component newComponent) {
        throw new UnsupportedOperationException("Replacing components is not supported");
    }

    @Override
    public int getComponentCount() {
        return 1;
    }

    public Column getColumn(Object propertyId) {
        Grid.Column<Item> internalColumn = this.getInternalColumn(propertyId);
        return internalColumn == null ? null : this.columns.get(propertyId);
    }

    public List<Column> getColumns() {
        Map propertyIds = this.getContainerDataSource().getContainerPropertyIds().stream().collect(Collectors.toMap(FGrid::propertyIdToColumnKey, Function.identity()));
        return this.grid.getColumns().stream().map(column -> this.columns.get(propertyIds.get(column.getKey()))).toList();
    }

    /*
     * Enabled aggressive block sorting
     */
    public Column addColumn(Object propertyId) throws IllegalStateException {
        String columnKey = FGrid.propertyIdToColumnKey(propertyId);
        if (this.getContainerDataSource().getContainerPropertyIds().contains(propertyId)) {
            if (this.grid.getColumns().stream().map(Grid.Column::getKey).noneMatch(columnKey::equals)) {
                this.appendColumn(propertyId);
                return this.getColumn(propertyId);
            }
        }
        if (this.defaultContainer) {
            this.addColumnProperty(propertyId, String.class, "");
            return this.getColumn(propertyId);
        }
        if (!this.grid.getColumns().stream().map(Grid.Column::getKey).anyMatch(columnKey::equals)) throw new IllegalStateException("Property id '" + String.valueOf(propertyId) + "' does not exist in the container");
        throw new IllegalStateException("A column for property id '" + String.valueOf(propertyId) + "' already exists in this grid");
    }

    public Column addColumn(Object propertyId, Class<?> type) {
        this.addColumnProperty(propertyId, type, null);
        return this.getColumn(propertyId);
    }

    public void removeAllColumns() {
        this.sortOrder.clear();
        this.grid.removeAllColumns();
    }

    public void removeColumn(Object propertyId) throws IllegalArgumentException {
        Grid.Column<Item> column = this.getInternalColumn(propertyId);
        if (column == null) {
            throw new IllegalArgumentException("There is no column for given property id " + String.valueOf(propertyId));
        }
        this.internalRemoveColumn(propertyId);
        this.grid.removeColumn(column);
    }

    private void internalRemoveColumn(Object propertyId) {
        if (this.getInternalColumn(propertyId) != null) {
            this.setEditorField(propertyId, null);
        }
        this.columns.remove(propertyId);
        this.columnOrder.remove(propertyId);
        this.header.removeColumn(propertyId);
        this.footer.removeColumn(propertyId);
        this.internalColumnPartNameGenerators.remove(propertyId);
        this.createColumnCollapsingMenuItems();
    }

    public boolean isColumnReorderingAllowed() {
        return this.grid.isColumnReorderingAllowed();
    }

    public void setColumnReorderingAllowed(boolean columnReorderingAllowed) {
        this.grid.setColumnReorderingAllowed(columnReorderingAllowed);
        Optional.ofNullable(this.columnReorderListenerRegistration).ifPresent(Registration::remove);
        if (columnReorderingAllowed) {
            this.columnReorderListenerRegistration = this.grid.addColumnReorderListener((ComponentEventListener & Serializable)event -> this.fireColumnReorderEvent(true));
        }
    }

    public void setColumns(Object ... propertyIds) {
        if (FSharedUtil.containsDuplicates(propertyIds)) {
            throw new IllegalArgumentException("The propertyIds array contains duplicates: " + FSharedUtil.getDuplicates(propertyIds));
        }
        Set newColumnKeys = Arrays.stream(propertyIds).map(FGrid::propertyIdToColumnKey).collect(Collectors.toSet());
        this.grid.getColumns().stream().filter(column -> !newColumnKeys.contains(column.getKey())).forEach(arg_0 -> ((FInternalGrid)this.grid).removeColumn(arg_0));
        Set currentColumnKeys = this.grid.getColumns().stream().map(Grid.Column::getKey).collect(Collectors.toSet());
        newColumnKeys.stream().filter(propertyId -> !currentColumnKeys.contains(FGrid.propertyIdToColumnKey(propertyId))).forEach(this::addColumn);
        this.setColumnOrder(propertyIds);
    }

    public void setColumnOrder(Object ... propertyIds) {
        if (FSharedUtil.containsDuplicates(propertyIds)) {
            throw new IllegalArgumentException("The propertyIds array contains duplicates: " + FSharedUtil.getDuplicates(propertyIds));
        }
        this.columnOrder.clear();
        ArrayList<Object> columnOrder = new ArrayList<Object>();
        LinkedHashMap columns = this.grid.getColumns().stream().collect(Collectors.toMap(Grid.Column::getKey, Function.identity(), (x, y) -> y, LinkedHashMap::new));
        for (Object propertyId : propertyIds) {
            String columnKey = FGrid.propertyIdToColumnKey(propertyId);
            if (!columns.containsKey(columnKey)) {
                throw new IllegalArgumentException("Grid does not contain column for property " + String.valueOf(propertyId));
            }
            columnOrder.add((Grid.Column)columns.get(columnKey));
            columns.remove(columnKey);
            this.columnOrder.add(propertyId);
        }
        columnOrder.addAll(columns.values());
        this.grid.setColumnOrder(columnOrder);
        this.fireColumnReorderEvent(false);
    }

    public void setFrozenColumnCount(int numberOfColumns) {
        List columns = this.grid.getColumns();
        if (numberOfColumns < -1 || numberOfColumns > columns.size()) {
            throw new IllegalArgumentException("count must be between -1 and the current number of columns (" + columns.size() + "): " + numberOfColumns);
        }
        IntStream.range(0, columns.size()).forEach((int index) -> ((Grid.Column)columns.get(index)).setFrozen(index < numberOfColumns));
    }

    public int getFrozenColumnCount() {
        return (int)this.grid.getColumns().stream().filter(col -> col.isFrozen()).count();
    }

    public void scrollTo(Object itemId) throws IllegalArgumentException {
        Item item = this.getContainerDataSource().getItem(itemId);
        if (item == null) {
            throw new IllegalArgumentException("Item with specified ID does not exist in data source");
        }
        ((ItemDataProvider)this.grid.getDataProvider()).put(item, itemId);
        this.grid.scrollToItem(item);
    }

    public void scrollToStart() {
        this.grid.scrollToStart();
    }

    public void scrollToEnd() {
        this.grid.scrollToEnd();
    }

    public void setHeightByRows(double rows) {
        if (rows <= 0.0) {
            throw new IllegalArgumentException("More than zero rows must be shown.");
        }
        if (Double.isInfinite(rows)) {
            throw new IllegalArgumentException("Grid doesn't support infinite heights");
        }
        if (Double.isNaN(rows)) {
            throw new IllegalArgumentException("NaN is not a valid row count");
        }
        this.heightByRows = rows;
        this.setHeightMode(HeightMode.ROW);
    }

    public double getHeightByRows() {
        return this.heightByRows;
    }

    @Override
    public void setHeight(String height) {
        this.heightInString = height;
        this.heightInFloat = null;
        this.heightUnit = null;
        this.setHeightMode(HeightMode.CSS);
    }

    @Override
    public void setHeight(float height, Unit unit) {
        this.heightInFloat = Float.valueOf(height);
        this.heightUnit = unit;
        this.heightInString = null;
        this.setHeightMode(HeightMode.CSS);
    }

    public void setHeightMode(HeightMode heightMode) {
        this.heightMode = heightMode;
        this.refreshHeight();
    }

    public HeightMode getHeightMode() {
        return this.heightMode;
    }

    public void setSelectionModel(SelectionModel selectionModel) throws IllegalArgumentException {
        if (selectionModel == null) {
            throw new IllegalArgumentException("Selection model may not be null");
        }
        if (this.selectionModel != selectionModel) {
            if (selectionModel instanceof SelectionModel.Multi) {
                this.grid.setSelectionMode(Grid.SelectionMode.MULTI);
                ((GridMultiSelectionModel)this.grid.getSelectionModel()).setSelectAllCheckboxVisibility(GridMultiSelectionModel.SelectAllCheckboxVisibility.VISIBLE);
                this.updateSelectionListener();
            } else if (selectionModel instanceof SelectionModel.Single) {
                this.grid.setSelectionMode(Grid.SelectionMode.SINGLE);
                this.updateSelectionListener();
            } else {
                this.grid.setSelectionMode(Grid.SelectionMode.NONE);
            }
            Collection<Object> oldSelection = this.selectionModel != null ? this.selectionModel.getSelectedRows() : Collections.emptyList();
            this.selectionModel = selectionModel;
            selectionModel.setGrid(this);
            Collection<Object> newSelection = this.selectionModel.getSelectedRows();
            if (!FSharedUtil.equals(oldSelection, newSelection)) {
                this.fireSelectionEvent(oldSelection, newSelection);
            }
        }
    }

    public SelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public SelectionModel setSelectionMode(SelectionMode selectionMode) throws IllegalArgumentException {
        if (selectionMode == null) {
            throw new IllegalArgumentException("selection mode may not be null");
        }
        SelectionModel newSelectionModel = selectionMode.createModel();
        this.setSelectionModel(newSelectionModel);
        return newSelectionModel;
    }

    public boolean isSelected(Object itemId) {
        return this.selectionModel.isSelected(itemId);
    }

    public Collection<Object> getSelectedRows() {
        return this.getSelectionModel().getSelectedRows();
    }

    public Object getSelectedRow() throws IllegalStateException {
        if (this.selectionModel instanceof SelectionModel.Single) {
            return ((SelectionModel.Single)this.selectionModel).getSelectedRow();
        }
        if (this.selectionModel instanceof SelectionModel.Multi) {
            throw new IllegalStateException("Cannot get unique selected row: Grid is in multiselect mode (the current selection model is " + this.selectionModel.getClass().getName() + ").");
        }
        if (this.selectionModel instanceof SelectionModel.None) {
            throw new IllegalStateException("Cannot get selected row: Grid selection is disabled (the current selection model is " + this.selectionModel.getClass().getName() + ").");
        }
        throw new IllegalStateException("Cannot get selected row: Grid selection model does not implement " + SelectionModel.Single.class.getName() + " or " + SelectionModel.Multi.class.getName() + "(the current model is " + this.selectionModel.getClass().getName() + ").");
    }

    public boolean select(Object itemId) throws IllegalArgumentException, IllegalStateException {
        if (this.selectionModel instanceof SelectionModel.Single) {
            return ((SelectionModel.Single)this.selectionModel).select(itemId);
        }
        if (this.selectionModel instanceof SelectionModel.Multi) {
            return ((SelectionModel.Multi)this.selectionModel).select(itemId);
        }
        if (this.selectionModel instanceof SelectionModel.None) {
            throw new IllegalStateException("Cannot select row '" + String.valueOf(itemId) + "': Grid selection is disabled (the current selection model is " + this.selectionModel.getClass().getName() + ").");
        }
        throw new IllegalStateException("Cannot select row '" + String.valueOf(itemId) + "': Grid selection model does not implement " + SelectionModel.Single.class.getName() + " or " + SelectionModel.Multi.class.getName() + "(the current model is " + this.selectionModel.getClass().getName() + ").");
    }

    public boolean deselect(Object itemId) throws IllegalStateException {
        if (this.selectionModel instanceof SelectionModel.Single) {
            if (this.isSelected(itemId)) {
                return ((SelectionModel.Single)this.selectionModel).select(null);
            }
            return false;
        }
        if (this.selectionModel instanceof SelectionModel.Multi) {
            return ((SelectionModel.Multi)this.selectionModel).deselect(itemId);
        }
        if (this.selectionModel instanceof SelectionModel.None) {
            throw new IllegalStateException("Cannot deselect row '" + String.valueOf(itemId) + "': Grid selection is disabled (the current selection model is " + this.selectionModel.getClass().getName() + ").");
        }
        throw new IllegalStateException("Cannot deselect row '" + String.valueOf(itemId) + "': Grid selection model does not implement " + SelectionModel.Single.class.getName() + " or " + SelectionModel.Multi.class.getName() + "(the current model is " + this.selectionModel.getClass().getName() + ").");
    }

    public boolean deselectAll() throws IllegalStateException {
        if (this.selectionModel instanceof SelectionModel.Single) {
            if (this.getSelectedRow() != null) {
                return this.deselect(this.getSelectedRow());
            }
            return false;
        }
        if (this.selectionModel instanceof SelectionModel.Multi) {
            return ((SelectionModel.Multi)this.selectionModel).deselectAll();
        }
        if (this.selectionModel instanceof SelectionModel.None) {
            throw new IllegalStateException("Cannot deselect all rows: Grid selection is disabled (the current selection model is " + this.selectionModel.getClass().getName() + ").");
        }
        throw new IllegalStateException("Cannot deselect all rows: Grid selection model does not implement " + SelectionModel.Single.class.getName() + " or " + SelectionModel.Multi.class.getName() + "(the current model is " + this.selectionModel.getClass().getName() + ").");
    }

    public void fireSelectionEvent(Collection<Object> oldSelection, Collection<Object> newSelection) {
        this.fireEvent(new SelectionEvent(this, oldSelection, newSelection));
    }

    @Override
    public void addSelectionListener(SelectionEvent.SelectionListener listener) {
        this.addListener(SelectionEvent.class, listener, SELECTION_CHANGE_METHOD);
    }

    @Override
    public void removeSelectionListener(SelectionEvent.SelectionListener listener) {
        this.removeListener(SelectionEvent.class, listener, SELECTION_CHANGE_METHOD);
    }

    public void addColumnReorderListener(ColumnReorderListener listener) {
        this.addListener(ColumnReorderEvent.class, listener, COLUMN_REORDER_METHOD);
    }

    public void removeColumnReorderListener(ColumnReorderListener listener) {
        this.removeListener(ColumnReorderEvent.class, listener, COLUMN_REORDER_METHOD);
    }

    public void addColumnResizeListener(ColumnResizeListener listener) {
        this.addListener(ColumnResizeEvent.class, listener, COLUMN_RESIZE_METHOD);
    }

    public void removeColumnResizeListener(ColumnResizeListener listener) {
        this.removeListener(ColumnResizeEvent.class, listener, COLUMN_RESIZE_METHOD);
    }

    public void sort(Sort s) {
        this.setSortOrder(s.build());
    }

    public void sort(Object propertyId) {
        this.sort(propertyId, SortDirection.ASCENDING);
    }

    public void sort(Object propertyId, SortDirection direction) {
        this.sort(Sort.by(propertyId, direction));
    }

    public void clearSortOrder() {
        this.sortOrder.clear();
        this.sort(false);
    }

    public void setSortOrder(List<SortOrder> order) {
        this.setSortOrder(order, false);
    }

    public List<SortOrder> getSortOrder() {
        return Collections.unmodifiableList(this.sortOrder);
    }

    @Override
    public void addSortListener(SortEvent.SortListener listener) {
        this.addListener(SortEvent.class, listener, SORT_ORDER_CHANGE_METHOD);
    }

    @Override
    public void removeSortListener(SortEvent.SortListener listener) {
        this.removeListener(SortEvent.class, listener, SORT_ORDER_CHANGE_METHOD);
    }

    protected Header getHeader() {
        return this.header;
    }

    public HeaderRow getHeaderRow(int rowIndex) {
        return (HeaderRow)this.header.getRow(rowIndex);
    }

    public HeaderRow addHeaderRowAt(int index) {
        return this.header.addRowAt(index);
    }

    public HeaderRow appendHeaderRow() {
        return (HeaderRow)this.header.appendRow();
    }

    public HeaderRow getDefaultHeaderRow() {
        return this.header.getDefaultRow();
    }

    public int getHeaderRowCount() {
        return this.header.getRowCount();
    }

    public HeaderRow prependHeaderRow() {
        return (HeaderRow)this.header.prependRow();
    }

    public void removeHeaderRow(HeaderRow row) {
        this.header.removeRow(row);
    }

    public void removeHeaderRow(int rowIndex) {
        this.header.removeRow(rowIndex);
    }

    public void setDefaultHeaderRow(HeaderRow row) {
        this.header.setDefaultRow(row);
    }

    public void setHeaderVisible(boolean visible) {
        this.header.setVisible(visible);
    }

    public boolean isHeaderVisible() {
        return this.header.isVisible();
    }

    protected Footer getFooter() {
        return this.footer;
    }

    public FooterRow getFooterRow(int rowIndex) {
        return (FooterRow)this.footer.getRow(rowIndex);
    }

    public FooterRow addFooterRowAt(int index) {
        return this.footer.addRowAt(index);
    }

    public FooterRow appendFooterRow() {
        return (FooterRow)this.footer.appendRow();
    }

    public int getFooterRowCount() {
        return this.footer.getRowCount();
    }

    public FooterRow prependFooterRow() {
        return (FooterRow)this.footer.prependRow();
    }

    public void removeFooterRow(FooterRow row) {
        this.footer.removeRow(row);
    }

    public void removeFooterRow(int rowIndex) {
        this.footer.removeRow(rowIndex);
    }

    public void setFooterVisible(boolean visible) {
        this.footer.setVisible(visible);
        this.grid.setClassName("hidden-grid-footer", visible);
    }

    public boolean isFooterVisible() {
        return this.footer.isVisible();
    }

    @Override
    public Iterator<Component> iterator() {
        LinkedHashSet<Component> componentList = new LinkedHashSet<Component>();
        Header header = this.getHeader();
        for (int i = 0; i < header.getRowCount(); ++i) {
            HeaderRow row = (HeaderRow)header.getRow(i);
            for (Object propId : this.getColumns().stream().map(Column::getPropertyId).collect(Collectors.toSet())) {
                HeaderCell cell = (HeaderCell)row.getCell(propId);
                if (cell.getCellType() != StaticSection.GridStaticCellType.WIDGET) continue;
                componentList.add(cell.getComponent());
            }
        }
        Footer footer = this.getFooter();
        for (int i = 0; i < footer.getRowCount(); ++i) {
            FooterRow row = (FooterRow)footer.getRow(i);
            for (Object propId : this.getColumns().stream().map(Column::getPropertyId).collect(Collectors.toSet())) {
                FooterCell cell = (FooterCell)row.getCell(propId);
                if (cell.getCellType() != StaticSection.GridStaticCellType.WIDGET) continue;
                componentList.add(cell.getComponent());
            }
        }
        this.getEditorFields().stream().map(Component.class::cast).forEach(componentList::add);
        return componentList.iterator();
    }

    public void setCellDescriptionGenerator(CellDescriptionGenerator generator) {
        this.setCellDescriptionGenerator(generator, ContentMode.HTML);
    }

    public void setCellDescriptionGenerator(CellDescriptionGenerator generator, ContentMode contentMode) {
        if (contentMode == null) {
            throw new IllegalArgumentException("Content mode cannot be null");
        }
        this.cellDescriptionGenerator = generator;
        this.cellTooltipContentMode = contentMode;
        this.grid.getColumns().forEach(column -> column.setTooltipGenerator((SerializableFunction & Serializable)item -> {
            RowReference rowRef = new RowReference(this);
            rowRef.set(this.toItemId((Item)item));
            CellReference cellRef = new CellReference(rowRef);
            cellRef.set(column.getKey());
            return generator.getDescription(cellRef);
        }));
        if (contentMode == ContentMode.HTML) {
            this.applyTooltipHtmlSupport();
        }
    }

    public CellDescriptionGenerator getCellDescriptionGenerator() {
        return this.cellDescriptionGenerator;
    }

    public ContentMode getCellDescriptionContentMode() {
        return this.cellTooltipContentMode;
    }

    public void setRowDescriptionGenerator(RowDescriptionGenerator generator) {
        this.setRowDescriptionGenerator(generator, ContentMode.HTML);
    }

    public void setRowDescriptionGenerator(RowDescriptionGenerator generator, ContentMode contentMode) {
        if (contentMode == null) {
            throw new IllegalArgumentException("Content mode cannot be null");
        }
        this.rowDescriptionGenerator = generator;
        this.rowTooltipContentMode = contentMode;
        this.grid.getColumns().forEach(column -> column.setTooltipGenerator((SerializableFunction & Serializable)item -> {
            RowReference rowRef = new RowReference(this);
            rowRef.set(this.toItemId((Item)item));
            return generator.getDescription(rowRef);
        }));
        if (contentMode == ContentMode.HTML) {
            this.applyTooltipHtmlSupport();
        }
    }

    public ContentMode getRowDescriptionContentMode() {
        return this.rowTooltipContentMode;
    }

    public RowDescriptionGenerator getRowDescriptionGenerator() {
        return this.rowDescriptionGenerator;
    }

    private void applyTooltipHtmlSupport() {
        Element tooltipElement = this.grid.getElement().getChildren().filter(child -> Objects.equals(child.getAttribute("slot"), "tooltip")).findFirst().orElse(null);
        if (tooltipElement == null) {
            return;
        }
        tooltipElement.executeJs("function htmlTooltipRenderer(root) {\n      var contentInHTML = this.generator(this.context);\n      if (contentInHTML !== undefined) {\n          root.innerHTML = contentInHTML;\n      } else {\n          root.textContent = \"\";\n      }\n  };\nthis._renderer = htmlTooltipRenderer.bind(this);\n", new Object[0]);
    }

    public void setCellStyleGenerator(CellStyleGenerator cellStyleGenerator) {
        this.cellStyleGenerator = cellStyleGenerator;
        if (cellStyleGenerator != null) {
            this.grid.getColumns().forEach(column -> column.setPartNameGenerator(this.createColumnPartNameGenerator((Grid.Column<?>)column)));
        }
    }

    private SerializableFunction<Item, String> createColumnPartNameGenerator(Grid.Column<?> column) {
        return (SerializableFunction & Serializable)item -> {
            SerializableFunction<Item, String> internalColumnPartNameGenerator = this.internalColumnPartNameGenerators.get(column.getKey());
            if (internalColumnPartNameGenerator == null && this.cellStyleGenerator == null) {
                return null;
            }
            if (this.cellStyleGenerator != null) {
                RowReference rowRef = new RowReference(this);
                rowRef.set(this.toItemId((Item)item));
                CellReference cellRef = new CellReference(rowRef);
                cellRef.set(column.getKey());
                return Stream.of(Optional.ofNullable(internalColumnPartNameGenerator).map(function -> (String)function.apply(item)).orElse(null), this.cellStyleGenerator.getStyle(cellRef)).filter(Objects::nonNull).collect(Collectors.joining(" "));
            }
            return (String)internalColumnPartNameGenerator.apply(item);
        };
    }

    public CellStyleGenerator getCellStyleGenerator() {
        return this.cellStyleGenerator;
    }

    public void setRowStyleGenerator(RowStyleGenerator rowStyleGenerator) {
        this.rowStyleGenerator = rowStyleGenerator;
        if (rowStyleGenerator != null) {
            this.grid.setPartNameGenerator((SerializableFunction & Serializable)item -> {
                if (this.rowStyleGenerator == null) {
                    return null;
                }
                RowReference rowRef = new RowReference(this);
                rowRef.set(this.toItemId((Item)item));
                return rowStyleGenerator.getStyle(rowRef);
            });
        }
    }

    public RowStyleGenerator getRowStyleGenerator() {
        return this.rowStyleGenerator;
    }

    public Object addRow(Object ... values) {
        if (values == null) {
            throw new IllegalArgumentException("Values cannot be null");
        }
        List columns = this.grid.getColumns();
        if (values.length != columns.size()) {
            throw new IllegalArgumentException("There are " + columns.size() + " visible columns, but " + values.length + " cell values were provided.");
        }
        Map columnKeysToPropertyIds = this.getContainerDataSource().getContainerPropertyIds().stream().collect(Collectors.toMap(FGrid::propertyIdToColumnKey, Function.identity()));
        for (int i = 0; i < columns.size(); ++i) {
            Object propertyId = columnKeysToPropertyIds.get(((Grid.Column)columns.get(i)).getKey());
            Class<?> propertyType = this.getContainerDataSource().getType(propertyId);
            if (values[i] == null || propertyType.isInstance(values[i])) continue;
            throw new IllegalArgumentException("Parameter " + i + "(" + String.valueOf(values[i]) + ") is not an instance of " + propertyType.getCanonicalName());
        }
        Object itemId = this.getContainerDataSource().addItem();
        try {
            Item item = this.getContainerDataSource().getItem(itemId);
            for (int i = 0; i < columns.size(); ++i) {
                Object propertyId = columnKeysToPropertyIds.get(((Grid.Column)columns.get(i)).getKey());
                Property property = item.getItemProperty(propertyId);
                property.setValue(values[i]);
            }
        }
        catch (RuntimeException e) {
            try {
                this.getContainerDataSource().removeItem(itemId);
            }
            catch (Exception e2) {
                FGrid.getLogger().log(Level.SEVERE, "Error recovering from exception in addRow", e);
            }
            throw e;
        }
        return itemId;
    }

    public void refreshRows(Object ... itemIds) {
        Arrays.stream(itemIds).map(this.getContainerDataSource()::getItem).filter(Objects::nonNull).forEach(arg_0 -> ((DataProvider)this.grid.getDataProvider()).refreshItem(arg_0));
    }

    public void refreshAllRows() {
        this.grid.getDataProvider().refreshAll();
    }

    public void setEditorEnabled(boolean isEnabled) throws IllegalStateException {
        if (this.isEditorActive()) {
            throw new IllegalStateException("Cannot disable the editor while an item (" + String.valueOf(this.getEditedItemId()) + ") is being edited");
        }
        this.editorEnabled = isEnabled;
    }

    public boolean isEditorEnabled() {
        return this.editorEnabled;
    }

    public Object getEditedItemId() {
        return this.editedItemId;
    }

    public FieldGroup getEditorFieldGroup() {
        return this.editorFieldGroup;
    }

    public void setEditorFieldGroup(FieldGroup fieldGroup) {
        if (this.isEditorActive()) {
            throw new IllegalStateException("Cannot change field group while an item (" + String.valueOf(this.getEditedItemId()) + ") is being edited");
        }
        this.editorFieldGroup = fieldGroup;
    }

    public boolean isEditorActive() {
        return this.grid.getEditor().isOpen();
    }

    public void editItem(Object itemId) throws IllegalStateException, IllegalArgumentException {
        if (!this.isEditorEnabled()) {
            throw new IllegalStateException("Item editor is not enabled");
        }
        if (this.isEditorBuffered() && this.editedItemId != null) {
            throw new IllegalStateException("Editing item " + String.valueOf(itemId) + " failed. Item editor is already editing item " + String.valueOf(this.editedItemId));
        }
        if (!this.getContainerDataSource().containsId(itemId)) {
            throw new IllegalArgumentException("Item with id " + String.valueOf(itemId) + " not found in current container");
        }
        if (!this.isEditorBuffered() && this.isEditorActive() && this.editedItemId != null && this.toItemId(this.getEditorFieldGroup().getItemDataSource()) == this.editedItemId && this.getEditorFieldGroup().getFields().stream().anyMatch(field -> !field.isValid())) {
            return;
        }
        this.editedItemId = itemId;
        Item item = this.getContainerDataSource().getItem(this.editedItemId);
        ((ItemDataProvider)this.grid.getDataProvider()).put(item, this.editedItemId);
        if (this.isEditorBuffered()) {
            this.grid.getEditor().cancel();
        } else {
            this.grid.getEditor().closeEditor();
            this.editorFieldGroup.setItemDataSource(null);
        }
        for (Column column : this.getColumns()) {
            Field<?> editorField;
            if (item.getItemProperty(column.getPropertyId()) == null || (editorField = this.getEditorField(column.getPropertyId())) == null) continue;
            column.setEditorField(editorField);
        }
        this.grid.getEditor().editItem((Object)item);
        this.editorFooterLayout.setVisible(true);
        this.grid.setDetailsVisible(item, this.isEditorBuffered());
        this.updateCellFocus();
    }

    protected void doEditItem() {
        Item item = this.getContainerDataSource().getItem(this.editedItemId);
        this.editorFieldGroup.setItemDataSource(item);
        for (Column column : this.getColumns()) {
            if (item.getItemProperty(column.getPropertyId()) == null) continue;
            this.getEditorField(column.getPropertyId());
        }
        if (this.dataSource instanceof Container.ItemSetChangeNotifier) {
            ((Container.ItemSetChangeNotifier)((Object)this.dataSource)).addItemSetChangeListener(this.editorClosingItemSetListener);
        }
    }

    public void saveEditor() throws FieldGroup.CommitException {
        this.editorFieldGroup.commit();
    }

    public void cancelEditor() {
        if (this.isEditorActive()) {
            this.grid.getEditor().cancel();
            this.doCancelEditor();
        }
    }

    protected void doCancelEditor() {
        this.editedItemId = null;
        this.editorFieldGroup.discard();
        this.editorFieldGroup.setItemDataSource(null);
        if (this.dataSource instanceof Container.ItemSetChangeNotifier) {
            ((Container.ItemSetChangeNotifier)((Object)this.dataSource)).removeItemSetChangeListener(this.editorClosingItemSetListener);
        }
        this.editorFooterLayout.setVisible(false);
        this.editorFooterErrorMessage.getElement().setProperty("innerHTML", "");
    }

    void resetEditor() {
        if (this.isEditorActive()) {
            this.cancelEditor();
        }
        for (Field<?> editor : this.getEditorFields()) {
            if (!(editor instanceof AbstractComponent)) continue;
            ((AbstractComponent)((Object)editor)).setParent(null);
        }
        this.editedItemId = null;
        this.editorFieldGroup = new CustomFieldGroup();
    }

    Collection<Field<?>> getEditorFields() {
        Collection<Field<?>> fields = this.editorFieldGroup.getFields();
        return fields;
    }

    public void setEditorFieldFactory(FieldGroupFieldFactory fieldFactory) {
        this.editorFieldGroup.setFieldFactory(fieldFactory);
    }

    public void setEditorErrorHandler(EditorErrorHandler editorErrorHandler) throws IllegalArgumentException {
        if (editorErrorHandler == null) {
            throw new IllegalArgumentException("The error handler cannot be null");
        }
        this.editorErrorHandler = editorErrorHandler;
    }

    public EditorErrorHandler getEditorErrorHandler() {
        return this.editorErrorHandler;
    }

    public FieldGroupFieldFactory getEditorFieldFactory() {
        return this.editorFieldGroup.getFieldFactory();
    }

    public void setEditorSaveCaption(String saveCaption) throws IllegalArgumentException {
        if (saveCaption == null) {
            throw new IllegalArgumentException("Save caption cannot be null");
        }
        this.saveEditorButton.setText(saveCaption);
    }

    public String getEditorSaveCaption() {
        return this.saveEditorButton.getText();
    }

    public void setEditorCancelCaption(String cancelCaption) throws IllegalArgumentException {
        if (cancelCaption == null) {
            throw new IllegalArgumentException("Cancel caption cannot be null");
        }
        this.cancelEditorButton.setText(cancelCaption);
    }

    public String getEditorCancelCaption() {
        return this.cancelEditorButton.getText();
    }

    public void setEditorBuffered(boolean editorBuffered) throws IllegalStateException {
        if (this.isEditorActive()) {
            throw new IllegalStateException("Can't change editor unbuffered mode while editor is active.");
        }
        this.editorBuffered = editorBuffered;
        this.editorFieldGroup.setBuffered(editorBuffered);
        this.grid.getEditor().setBuffered(editorBuffered);
        this.saveEditorButton.setVisible(this.isEditorBuffered());
        this.cancelEditorButton.setVisible(this.isEditorBuffered());
        this.grid.setItemDetailsRenderer((com.vaadin.flow.data.renderer.Renderer)new ComponentRenderer((SerializableSupplier & Serializable)() -> this.editorFooterLayout));
    }

    public boolean isEditorBuffered() {
        return this.editorBuffered;
    }

    @Override
    public void addItemClickListener(ItemClickEvent.ItemClickListener listener) {
        ComponentDataUtil.put("grid-itemClickListeners", this, listener, ComponentUtil.addListener((Component)this.grid, ItemClickEvent.class, listener::itemClick));
    }

    @Override
    public void removeItemClickListener(ItemClickEvent.ItemClickListener listener) {
        ComponentDataUtil.remove("grid-itemClickListeners", this, listener).map(Registration.class::cast).ifPresent(Registration::remove);
    }

    public void setDetailsVisible(Object itemId, boolean visible) {
        Optional.ofNullable(this.getContainerDataSource().getItem(itemId)).ifPresent(i -> this.grid.setDetailsVisible(i, visible));
    }

    public boolean isDetailsVisible(Object itemId) {
        return Optional.ofNullable(this.getContainerDataSource().getItem(itemId)).map(arg_0 -> ((FInternalGrid)this.grid).isDetailsVisible(arg_0)).orElse(false);
    }

    public void recalculateColumnWidths() {
        this.grid.recalculateColumnWidths();
    }

    public void addColumnVisibilityChangeListener(ColumnVisibilityChangeListener listener) {
        this.addListener(ColumnVisibilityChangeEvent.class, listener, COLUMN_VISIBILITY_METHOD);
    }

    public void removeColumnVisibilityChangeListener(ColumnVisibilityChangeListener listener) {
        this.removeListener(ColumnVisibilityChangeEvent.class, listener, COLUMN_VISIBILITY_METHOD);
    }

    private Object toItemId(Item item) {
        if (this.grid.getDataProvider() instanceof ItemDataProvider) {
            return ((ItemDataProvider)this.grid.getDataProvider()).getItemId(item);
        }
        return this.getContainerDataSource().getItemIds().stream().filter(i -> this.getContainerDataSource().getItem(i).equals(item)).findFirst().orElse(null);
    }

    @Override
    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (attachEvent.isInitialAttach()) {
            this.registerInternalBeforeClientResponse();
        }
        this.doConnectorOnAttach(attachEvent);
    }

    @Override
    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        if (this.columnMinMaxWidthsStyleElement != null) {
            this.getElement().removeVirtualChild(new Element[]{this.columnMinMaxWidthsStyleElement});
            UI.getCurrent().getPage().executeJs("document.head.removeChild(document.getElementById($0));", new Object[]{this.columnMinMaxWidthsStyleElement.getAttribute("id")});
            this.columnMinMaxWidthsStyleElement = null;
        }
        this.doConnectorOnDetach(detachEvent);
    }

    protected void addColumnProperty(Object propertyId, Class<?> type, Object defaultValue) throws IllegalStateException {
        if (!this.defaultContainer) {
            throw new IllegalStateException("Container for this Grid is not a default container from Grid() constructor");
        }
        String columnKey = FGrid.propertyIdToColumnKey(propertyId);
        if (this.grid.getColumns().stream().map(Grid.Column::getKey).anyMatch(columnKey::equals)) {
            throw new IllegalStateException("Grid already has a column for property " + String.valueOf(propertyId));
        }
        if (!this.getContainerDataSource().getContainerPropertyIds().contains(propertyId)) {
            this.getContainerDataSource().addContainerProperty(propertyId, type, defaultValue);
        } else {
            Property containerProperty = this.getContainerDataSource().getContainerProperty(this.getContainerDataSource().firstItemId(), propertyId);
            if (containerProperty.getType() != type) {
                throw new IllegalStateException("DataSource already has the given property " + String.valueOf(propertyId) + " with a different type");
            }
            this.appendColumn(propertyId);
        }
    }

    private Grid.Column<Item> getInternalColumn(Object propertyId) {
        return this.grid.getColumnByKey(FGrid.propertyIdToColumnKey(propertyId));
    }

    private void checkColumnExists(Object propertyId) {
        if (this.getInternalColumn(propertyId) == null) {
            throw new IllegalArgumentException("There is no column with the property id " + String.valueOf(propertyId));
        }
    }

    private void setEditorField(Object propertyId, Field<?> field) {
        this.checkColumnExists(propertyId);
        Field<?> oldField = this.editorFieldGroup.getField(propertyId);
        if (oldField != null) {
            this.editorFieldGroup.unbind(oldField);
        }
        if (field != null) {
            this.editorFieldGroup.bind(field, propertyId);
        }
        if (field == null) {
            Field<?> previousEditorField = this.editorFields.get(propertyId);
            if (previousEditorField != null) {
                this.grid.getEditor().getBinder().removeBinding((HasValue)previousEditorField);
            }
        } else {
            this.grid.getEditor().getBinder().bind((HasValue)field, (ValueProvider & Serializable)item -> this.getPropertyValueFromItemToSetToEditorField(propertyId, field, (Item)item), (Setter & Serializable)(item, value) -> this.registerInternalBeforeClientResponse());
        }
        Column column = this.getColumn(propertyId);
        column.getInternalColumn().setEditorComponent((Component)field);
        if (field != null) {
            ((HasEnabled)field).setEnabled(column.isEditable());
        }
        this.editorFields.put(propertyId, field);
    }

    private Object getPropertyValueFromItemToSetToEditorField(Object propertyId, Field<?> field, Item item) {
        Class fieldType = field.getType();
        Property property = item.getItemProperty(propertyId);
        if (property == null) {
            return null;
        }
        Class propertyType = property.getType();
        if (fieldType.isAssignableFrom(propertyType)) {
            return property.getValue();
        }
        if (field.getConverter() != null) {
            Converter<?, ?> converter = field.getConverter();
            return converter.convertToPresentation(property.getValue(), fieldType, null);
        }
        return String.valueOf(property.getValue());
    }

    private static void setPropertyValueFromEditorFieldToItem(Object propertyId, Field<?> field, Item item, Object value) {
        Class<?> fieldType = field.getType();
        Property property = item.getItemProperty(propertyId);
        if (property == null) {
            return;
        }
        if (field.getConverter() != null) {
            Converter<?, ?> converter = field.getConverter();
            property.setValue(converter.convertToModel(value, fieldType, null));
        } else {
            property.setValue(FGrid.getValueToSet(value, fieldType, property.getType()));
        }
    }

    private static Object getValueToSet(Object value, Class<?> fieldType, Class propertyType) {
        if (fieldType.isAssignableFrom(propertyType)) {
            return value;
        }
        if (String.class.isAssignableFrom(fieldType)) {
            String stringValue = (String)value;
            if (Enum.class.isAssignableFrom(propertyType)) {
                return Enum.valueOf(propertyType, "");
            }
            if (Boolean.class.isAssignableFrom(propertyType) || Boolean.TYPE.isAssignableFrom(propertyType)) {
                return Boolean.valueOf(stringValue);
            }
            if (Integer.class.isAssignableFrom(propertyType) || Integer.TYPE.isAssignableFrom(propertyType)) {
                return Integer.valueOf(stringValue);
            }
            if (Number.class.isAssignableFrom(propertyType) || Float.TYPE.isAssignableFrom(propertyType) || Double.TYPE.isAssignableFrom(propertyType)) {
                return Float.valueOf(stringValue);
            }
        }
        return value;
    }

    private Field<?> getEditorField(Object propertyId) {
        this.checkColumnExists(propertyId);
        if (!this.getColumn(propertyId).isEditable()) {
            return null;
        }
        Field<?> editor = this.editorFieldGroup.getField(propertyId);
        if (editor == null && (editor = this.editorFields.get(propertyId)) != null) {
            this.editorFieldGroup.bind(editor, propertyId);
        }
        try {
            if (editor == null) {
                editor = this.editorFieldGroup.buildAndBind(propertyId);
            }
        }
        finally {
            if (editor == null) {
                editor = this.editorFieldGroup.getField(propertyId);
            }
        }
        return editor;
    }

    private void sort(boolean userOriginated) {
        Set propertyIdKeys;
        Container.Indexed containerDataSource = this.getContainerDataSource();
        if (!(containerDataSource instanceof Container.Sortable)) {
            throw new IllegalStateException("Container is not sortable (does not implement Container.Sortable)");
        }
        Container.Sortable sortable = (Container.Sortable)((Object)containerDataSource);
        int sortOrderCount = this.sortOrder.size();
        Object[] propertyIds = new Object[sortOrderCount];
        boolean[] directions = new boolean[sortOrderCount];
        for (int i = 0; i < sortOrderCount; ++i) {
            SortOrder order = this.sortOrder.get(i);
            propertyIds[i] = order.getPropertyId();
            directions[i] = switch (order.getDirection()) {
                default -> throw new MatchException(null, null);
                case SortDirection.ASCENDING -> true;
                case SortDirection.DESCENDING -> false;
            };
        }
        List columns = this.grid.getColumns();
        Set columnKeys = columns.stream().map(Grid.Column::getKey).collect(Collectors.toSet());
        boolean allPropertiesStillInGrid = columnKeys.containsAll(propertyIdKeys = Arrays.stream(propertyIds).map(FGrid::propertyIdToColumnKey).collect(Collectors.toSet()));
        if (allPropertiesStillInGrid) {
            List<GridSortOrder<Item>> sortOrders = IntStream.range(0, propertyIds.length).boxed().map(idx -> {
                com.vaadin.flow.data.provider.SortDirection direction = directions[idx] ? com.vaadin.flow.data.provider.SortDirection.ASCENDING : com.vaadin.flow.data.provider.SortDirection.DESCENDING;
                return new GridSortOrder(this.getInternalColumn(propertyIds[idx]), direction);
            }).toList();
            sortable.sort(propertyIds, directions);
            this.refreshAllRows();
            this.doUpdateClientSideSorterIndicators(sortOrders);
        } else {
            this.sortOrder.clear();
            sortable.sort(new Object[0], new boolean[0]);
            this.refreshAllRows();
            this.doUpdateClientSideSorterIndicators(Collections.emptyList());
        }
        this.fireEvent(new SortEvent(this, new ArrayList<SortOrder>(this.sortOrder), userOriginated));
    }

    private void doUpdateClientSideSorterIndicators(List<GridSortOrder<Item>> sortOrders) {
        try {
            Method method = ReflectTools.findMethod(Grid.class, (String)"updateClientSideSorterIndicators", (Class[])new Class[]{List.class});
            method.setAccessible(true);
            method.invoke((Object)this.grid, sortOrders);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateColumnSortable(Column column) {
        Container.Sortable sortable;
        Container.Indexed indexed = this.dataSource;
        boolean isSortable = indexed instanceof Container.Sortable && (sortable = (Container.Sortable)((Object)indexed)).getSortableContainerPropertyIds().contains(column.getPropertyId());
        column.setSortable(isSortable);
    }

    private void refreshHeight() {
        switch (this.heightMode) {
            case CSS: {
                this.doSetHeightCss();
                break;
            }
            case ROW: {
                this.doSetHeightByRows();
                break;
            }
            default: {
                this.doSetHeightUndefined();
            }
        }
    }

    private void doSetHeightByRows() {
        this.grid.setAllRowsVisible(false);
        super.setHeightUndefined();
        V8Utils.setHeightByRows(this.grid, this.heightByRows);
    }

    private void doSetHeightCss() {
        this.grid.setAllRowsVisible(false);
        if (this.heightInString == null && this.heightInFloat != null) {
            super.setHeight(this.heightInFloat.floatValue(), this.heightUnit);
        } else {
            super.setHeight(this.heightInString);
        }
        this.grid.setHeightFull();
    }

    private void doSetHeightUndefined() {
        super.setHeight(null);
        this.grid.setAllRowsVisible(true);
    }

    private void appendColumn(Object datasourcePropertyId) {
        if (datasourcePropertyId == null) {
            throw new IllegalArgumentException("Property id cannot be null");
        }
        assert (this.getContainerDataSource().getContainerPropertyIds().contains(datasourcePropertyId)) : "Datasource should contain the property id";
        this.grid.addColumn((ValueProvider & Serializable)item -> item.getItemProperty(datasourcePropertyId).getValue()).setKey(FGrid.propertyIdToColumnKey(datasourcePropertyId)).setWidth("100px");
        this.header.addColumn(datasourcePropertyId);
        this.footer.addColumn(datasourcePropertyId);
        this.columnOrder.add(datasourcePropertyId);
        Column column = new Column(this, datasourcePropertyId);
        this.columns.put(datasourcePropertyId, column);
        column.setEditable(true);
        String humanFriendlyPropertyId = SharedUtil.propertyIdToHumanFriendly((Object)datasourcePropertyId);
        column.setHeaderCaption(humanFriendlyPropertyId);
        this.updateColumnSortable(column);
        this.createColumnCollapsingMenuItems();
    }

    private void fireColumnReorderEvent(boolean userOriginated) {
        this.fireEvent(new ColumnReorderEvent(this, userOriginated));
    }

    private void fireColumnResizeEvent(Column column, boolean userOriginated) {
        this.fireEvent(new ColumnResizeEvent(this, column, userOriginated));
    }

    private void setSortOrder(List<SortOrder> order, boolean userOriginated) throws IllegalStateException, IllegalArgumentException {
        Container.Indexed indexed = this.getContainerDataSource();
        if (!(indexed instanceof Container.Sortable)) {
            throw new IllegalStateException("Attached container is not sortable (does not implement Container.Sortable)");
        }
        Container.Sortable sortable = (Container.Sortable)((Object)indexed);
        if (order == null) {
            throw new IllegalArgumentException("Order list may not be null!");
        }
        this.sortOrder.clear();
        Collection<?> sortableProps = sortable.getSortableContainerPropertyIds();
        for (SortOrder o : order) {
            if (sortableProps.contains(o.getPropertyId())) continue;
            throw new IllegalArgumentException("Property " + String.valueOf(o.getPropertyId()) + " does not exist or is not sortable in the current container");
        }
        this.sortOrder.addAll(order);
        this.sort(userOriginated);
    }

    private void fireColumnVisibilityChangeEvent(Column column, boolean hidden, boolean isUserOriginated) {
        this.fireEvent(new ColumnVisibilityChangeEvent(this, column, hidden, isUserOriginated));
    }

    private void handleContainerPropertySetChange(Container.PropertySetChangeEvent event) {
        Container.Indexed indexed;
        HashSet properties = new HashSet(event.getContainer().getContainerPropertyIds());
        Map columnKeysInContainer = properties.stream().collect(Collectors.toMap(FGrid::propertyIdToColumnKey, Function.identity()));
        this.grid.getColumns().stream().filter(column -> !columnKeysInContainer.containsKey(column.getKey())).forEach(col -> {
            this.internalRemoveColumn(col.getKey());
            this.grid.removeColumn((Grid.Column)col);
        });
        Set currentColumnKeys = this.grid.getColumns().stream().map(Grid.Column::getKey).collect(Collectors.toSet());
        columnKeysInContainer.entrySet().stream().filter(entry -> !currentColumnKeys.contains(entry.getKey())).map(Map.Entry::getValue).forEach(id -> this.appendColumn(id));
        int columnCount = this.grid.getColumns().size();
        if (this.getFrozenColumnCount() > columnCount) {
            this.setFrozenColumnCount(columnCount);
        }
        if ((indexed = this.dataSource) instanceof Container.Sortable) {
            Container.Sortable sortable = (Container.Sortable)((Object)indexed);
            Set sortablePropertyColumnKeys = sortable.getSortableContainerPropertyIds().stream().map(FGrid::propertyIdToColumnKey).collect(Collectors.toSet());
            this.grid.getColumns().stream().filter(column -> column.isSortable() && !sortablePropertyColumnKeys.contains(column.getKey())).forEach(column -> column.setSortable(false));
        }
    }

    private static Logger getLogger() {
        return Logger.getLogger(FGrid.class.getName());
    }

    private static String propertyIdToColumnKey(Object propertyId) {
        if (propertyId == null) {
            throw new IllegalStateException("Column property id cannot be null!");
        }
        String stringValue = propertyId.toString();
        if (stringValue == null) {
            throw new IllegalStateException("Column property id toString cannot be null!");
        }
        return stringValue;
    }

    private static SortDirection convertSortDirection(com.vaadin.flow.data.provider.SortDirection flowSortDirection) {
        if (com.vaadin.flow.data.provider.SortDirection.ASCENDING.equals((Object)flowSortDirection)) {
            return SortDirection.ASCENDING;
        }
        if (com.vaadin.flow.data.provider.SortDirection.DESCENDING.equals((Object)flowSortDirection)) {
            return SortDirection.DESCENDING;
        }
        return null;
    }

    private MenuBar getColumnSelector() {
        MenuBar menuBar = new MenuBar();
        menuBar.addClassName(V_GRID_COLUMN_COLLAPSING_MENU);
        menuBar.addThemeVariants((ThemeVariant[])new MenuBarVariant[]{MenuBarVariant.LUMO_TERTIARY_INLINE, MenuBarVariant.LUMO_SMALL});
        menuBar.getStyle().setPosition(Style.Position.ABSOLUTE);
        menuBar.getStyle().setRight("16px");
        menuBar.getStyle().setTop("0");
        menuBar.getStyle().setTransform("translateY(100%) translateX(10%)");
        return menuBar;
    }

    private boolean hasHidableColumns() {
        return this.columnOrder.stream().anyMatch(propertyId -> this.getInternalColumn(propertyId) != null && this.getColumn(propertyId).isHidable());
    }

    private void createColumnCollapsingMenuItems() {
        boolean hasHidableColumns = this.hasHidableColumns();
        if (this.columnCollapsingMenuBar == null) {
            if (!hasHidableColumns) {
                return;
            }
            this.columnCollapsingMenuBar = this.getColumnSelector();
        } else {
            this.columnCollapsingMenuBar.removeAll();
        }
        if (!hasHidableColumns) {
            if (this.columnCollapsingMenuBar.isAttached()) {
                this.remove(new Component[]{this.columnCollapsingMenuBar});
                return;
            }
        } else if (!this.columnCollapsingMenuBar.isAttached()) {
            this.add(new Component[]{this.columnCollapsingMenuBar});
        }
        SubMenu submenu = (SubMenu)this.columnCollapsingMenuBar.addItem((Component)VaadinIcon.COG.create()).getSubMenu();
        for (Object propertyId : this.columnOrder) {
            Grid.Column gridColumn = this.grid.getColumnByKey(FGrid.propertyIdToColumnKey(propertyId));
            boolean collapsingAllowed = this.getColumn(propertyId).isHidable();
            if (!collapsingAllowed) continue;
            String headerText = gridColumn.getHeaderText();
            Component component = gridColumn.getHeaderComponent();
            if (component instanceof HasLabel) {
                HasLabel hasLabel = (HasLabel)component;
                headerText = hasLabel.getLabel();
            }
            MenuItem item = (MenuItem)submenu.addItem(headerText);
            item.setCheckable(true);
            item.setChecked(gridColumn.isVisible());
            item.addClickListener((ComponentEventListener & Serializable)e -> gridColumn.setVisible(item.isChecked()));
        }
    }

    private final class CustomFieldGroup
    extends FieldGroup {
        public CustomFieldGroup() {
            this.setFieldFactory(EditorFieldFactory.get());
        }

        @Override
        protected Class<?> getPropertyType(Object propertyId) throws FieldGroup.BindException {
            if (this.getItemDataSource() == null) {
                return FGrid.this.getContainerDataSource().getType(propertyId);
            }
            return super.getPropertyType(propertyId);
        }

        @Override
        protected <T extends Field> T build(String caption, Class<?> dataType, Class<T> fieldType) throws FieldGroup.BindException {
            T field = super.build(caption, dataType, fieldType);
            if (field instanceof FCheckBox) {
                FCheckBox checkBox = (FCheckBox)field;
                checkBox.setCaption(null);
            }
            return field;
        }

        @Override
        protected void bindFields() {
            ArrayList fields = new ArrayList(this.getFields());
            Item itemDataSource = this.getItemDataSource();
            if (itemDataSource == null) {
                this.unbindFields(fields);
            } else {
                this.bindFields(fields, itemDataSource);
            }
        }

        private void unbindFields(List<Field<?>> fields) {
            for (Field<?> field : fields) {
                this.clearField(field);
                this.unbind(field);
                if (!(field instanceof AbstractComponent)) continue;
                ((AbstractComponent)((Object)field)).setParent(null);
            }
        }

        private void bindFields(List<Field<?>> fields, Item itemDataSource) {
            for (Field<?> field : fields) {
                if (itemDataSource.getItemProperty(this.getPropertyId(field)) == null) continue;
                this.bind(field, this.getPropertyId(field));
            }
        }
    }

    public class DefaultEditorErrorHandler
    implements EditorErrorHandler {
        @Override
        public void commitError(CommitErrorEvent event) {
            Map<Field<?>, Validator.InvalidValueException> invalidFields = event.getCause().getInvalidFields();
            if (!invalidFields.isEmpty()) {
                Object firstErrorPropertyId = null;
                Field<?> firstErrorField = null;
                FieldGroup fieldGroup = event.getCause().getFieldGroup();
                for (Column column : FGrid.this.getColumns()) {
                    Object propertyId = column.getPropertyId();
                    Field<?> field = fieldGroup.getField(propertyId);
                    if (!invalidFields.keySet().contains(field)) continue;
                    event.addErrorColumn(column);
                    if (firstErrorPropertyId != null) continue;
                    firstErrorPropertyId = propertyId;
                    firstErrorField = field;
                }
                String caption = FGrid.this.getColumn(firstErrorPropertyId).getHeaderCaption();
                String message = invalidFields.get(firstErrorField).getLocalizedMessage();
                event.setUserErrorMessage(caption + ": " + message);
            } else {
                FGrid.this.handleError(event.getCause());
            }
        }

        private Object getFirstPropertyId(FieldGroup fieldGroup, Set<Field<?>> keySet) {
            for (Column c : FGrid.this.getColumns()) {
                Object propertyId = c.getPropertyId();
                Field<?> f = fieldGroup.getField(propertyId);
                if (!keySet.contains(f)) continue;
                return propertyId;
            }
            return null;
        }
    }

    public static interface EditorErrorHandler
    extends Serializable {
        public void commitError(CommitErrorEvent var1);
    }

    private static class FInternalGrid
    extends Grid<Item> {
        private final SerializableSupplier<FieldGroup> fieldGroupSupplier;

        public FInternalGrid(SerializableSupplier<FieldGroup> fieldGroupSupplier) {
            this.fieldGroupSupplier = fieldGroupSupplier;
        }

        protected void setSelectionModel(GridSelectionModel<Item> model, Grid.SelectionMode selectionMode) {
            super.setSelectionModel(model, selectionMode);
        }

        protected com.vaadin.flow.component.grid.HeaderRow getDefaultHeaderRow() {
            return super.getDefaultHeaderRow();
        }

        protected Editor<Item> createEditor() {
            return new FGridEditorImpl<Item>(this, this.getPropertySet(), this.fieldGroupSupplier);
        }
    }

    protected static class Header
    extends StaticSection<HeaderRow> {
        private HeaderRow defaultRow = null;

        protected Header(FGrid grid) {
            this.grid = grid;
            HeaderRow row = this.createRow();
            this.rows.add(row);
            row.flowHeaderRow = grid.getFlowGrid().appendHeaderRow();
            this.setDefaultRow(row);
        }

        public void setDefaultRow(HeaderRow row) {
            if (row == this.defaultRow) {
                return;
            }
            if (row != null && !this.rows.contains(row)) {
                throw new IllegalArgumentException("Cannot set a default row that does not exist in the section");
            }
            if (this.defaultRow != null) {
                this.defaultRow.setDefaultRow(false);
            }
            if (row != null) {
                row.setDefaultRow(true);
            }
            this.defaultRow = row;
            this.markAsDirty();
            this.reorganizeFlowRows(row);
        }

        public HeaderRow getDefaultRow() {
            return this.defaultRow;
        }

        @Override
        protected HeaderRow createRow() {
            return new HeaderRow(this);
        }

        @Override
        public HeaderRow removeRow(int rowIndex) {
            HeaderRow row = (HeaderRow)super.removeRow(rowIndex);
            row.flowHeaderRow.getCells().forEach(c -> c.setText(null));
            this.grid.getFlowGrid().removeHeaderRow(row.flowHeaderRow);
            if (row == this.defaultRow) {
                this.setDefaultRow(null);
            }
            return row;
        }

        @Override
        public HeaderRow addRowAt(int index) {
            HeaderRow row = (HeaderRow)super.addRowAt(index);
            this.reorganizeFlowRows(row);
            this.markAsDirty();
            return row;
        }

        private void reorganizeFlowRows(HeaderRow newRow) {
            int i;
            this.grid.getFlowGrid().removeAllHeaderRows();
            int startIndex = -1;
            if (this.defaultRow != null) {
                startIndex = this.rows.indexOf(this.defaultRow);
                this.setupNewFlowRow(this.defaultRow, this.grid.getFlowGrid().prependHeaderRow(), newRow == this.defaultRow);
            }
            for (i = startIndex - 1; i >= 0; --i) {
                this.setupNewFlowRow((HeaderRow)this.rows.get(i), this.grid.getFlowGrid().prependHeaderRow(), newRow == this.rows.get(i));
            }
            for (i = startIndex + 1; i < this.rows.size(); ++i) {
                this.setupNewFlowRow((HeaderRow)this.rows.get(i), this.grid.getFlowGrid().appendHeaderRow(), newRow == this.rows.get(i));
            }
            this.grid.registerInternalBeforeClientResponse();
        }

        private void setupNewFlowRow(HeaderRow sourceRow, com.vaadin.flow.component.grid.HeaderRow newFlowRow, boolean addCell) {
            sourceRow.flowHeaderRow = newFlowRow;
            for (Grid.Column column : this.grid.getFlowGrid().getColumns()) {
                if (addCell) {
                    sourceRow.addCell(column.getKey());
                }
                HeaderRow.HeaderCell newCell = (HeaderRow.HeaderCell)newFlowRow.getCell(column);
                if (((HeaderCell)sourceRow.getCell(column.getKey())).getComponent() != null) {
                    newCell.setComponent(((HeaderCell)sourceRow.getCell(column.getKey())).getComponent());
                    continue;
                }
                if (((HeaderCell)sourceRow.getCell(column.getKey())).getCellType() == StaticSection.GridStaticCellType.HTML) {
                    newCell.setComponent((Component)new Html(((HeaderCell)sourceRow.getCell(column.getKey())).getHtml()));
                    continue;
                }
                newCell.setText(Optional.ofNullable(((HeaderCell)sourceRow.getCell(column.getKey())).getText()).orElse(""));
            }
        }

        @Override
        protected void sanityCheck() throws IllegalStateException {
            super.sanityCheck();
            boolean hasDefaultRow = false;
            for (HeaderRow row : this.rows) {
                if (!row.isDefaultRow()) continue;
                if (!hasDefaultRow) {
                    hasDefaultRow = true;
                    continue;
                }
                throw new IllegalStateException("Multiple default rows in header");
            }
        }
    }

    protected static class Footer
    extends StaticSection<FooterRow> {
        protected Footer(FGrid grid) {
            this.grid = grid;
        }

        @Override
        protected FooterRow createRow() {
            return new FooterRow(this);
        }

        @Override
        public FooterRow removeRow(int rowIndex) {
            FooterRow row = (FooterRow)super.removeRow(rowIndex);
            this.grid.getFlowGrid().removeFooterRow(row.flowFooterRow);
            return row;
        }

        @Override
        public FooterRow addRowAt(int index) {
            FooterRow row = (FooterRow)super.addRowAt(index);
            this.reorganizeFlowRows(row);
            return row;
        }

        private void reorganizeFlowRows(FooterRow row) {
            this.grid.getFlowGrid().removeAllFooterRows();
            for (FooterRow footerRow : this.rows) {
                com.vaadin.flow.component.grid.FooterRow newFlowRow = this.grid.getFlowGrid().appendFooterRow();
                this.addNewFlowRow(row, footerRow, newFlowRow);
            }
            this.grid.registerInternalBeforeClientResponse();
        }

        private void addNewFlowRow(FooterRow row, FooterRow footerRow, com.vaadin.flow.component.grid.FooterRow newFlowRow) {
            footerRow.flowFooterRow = newFlowRow;
            for (Grid.Column column : this.grid.getFlowGrid().getColumns()) {
                if (row == footerRow) {
                    row.addCell(column.getKey());
                }
                FooterRow.FooterCell newCell = (FooterRow.FooterCell)newFlowRow.getCell(column);
                if (((FooterCell)footerRow.getCell(column.getKey())).getComponent() != null) {
                    newCell.setComponent(((FooterCell)footerRow.getCell(column.getKey())).getComponent());
                    continue;
                }
                if (((FooterCell)footerRow.getCell(column.getKey())).getCellType() == StaticSection.GridStaticCellType.HTML) {
                    newCell.setComponent((Component)new Html(((FooterCell)footerRow.getCell(column.getKey())).getHtml()));
                    continue;
                }
                newCell.setText(((FooterCell)footerRow.getCell(column.getKey())).getText());
            }
        }

        @Override
        protected void sanityCheck() throws IllegalStateException {
            super.sanityCheck();
        }
    }

    public static enum SelectionMode {
        SINGLE{

            @Override
            protected SelectionModel createModel() {
                return new SingleSelectionModel();
            }
        }
        ,
        MULTI{

            @Override
            protected SelectionModel createModel() {
                return new MultiSelectionModel();
            }
        }
        ,
        NONE{

            @Override
            protected SelectionModel createModel() {
                return new NoSelectionModel();
            }
        };


        protected abstract SelectionModel createModel();
    }

    public static interface SelectionModel
    extends Serializable {
        public boolean isSelected(Object var1);

        public Collection<Object> getSelectedRows();

        public void setGrid(FGrid var1);

        public void reset();

        public static interface None
        extends SelectionModel {
            @Override
            public boolean isSelected(Object var1);

            @Override
            public Collection<Object> getSelectedRows();
        }

        public static interface Single
        extends SelectionModel {
            public boolean select(Object var1) throws IllegalStateException, IllegalArgumentException;

            public Object getSelectedRow();

            public void setDeselectAllowed(boolean var1);

            public boolean isDeselectAllowed();
        }

        public static interface Multi
        extends SelectionModel {
            public boolean select(Object ... var1) throws IllegalArgumentException;

            public boolean select(Collection<?> var1) throws IllegalArgumentException;

            public boolean deselect(Object ... var1) throws IllegalArgumentException;

            public boolean deselect(Collection<?> var1) throws IllegalArgumentException;

            public boolean selectAll();

            public boolean deselectAll();

            public boolean setSelected(Collection<?> var1) throws IllegalArgumentException;

            public boolean setSelected(Object ... var1) throws IllegalArgumentException;
        }

        public static interface HasUserSelectionAllowed
        extends SelectionModel {
            public boolean isUserSelectionAllowed();

            public void setUserSelectionAllowed(boolean var1);
        }
    }

    public static class Column
    implements Serializable {
        private static final String EDITABLE_PROPERTY = "flow-column-editable";
        private final FGrid grid;
        private final Object propertyId;
        private Converter<?, ?> converter;
        private com.vaadin.flow.data.renderer.Renderer<?> renderer;
        private boolean hidable;
        private double maximumWidth = -1.0;
        private double minimumWidth = 10.0;

        Column(FGrid grid, Object propertyId) {
            this.grid = grid;
            this.propertyId = propertyId;
        }

        public Object getPropertyId() {
            return this.propertyId;
        }

        public String getHeaderCaption() throws IllegalStateException {
            this.checkColumnIsAttached();
            HeaderRow row = this.grid.getHeader().getDefaultRow();
            if (row != null) {
                return ((HeaderCell)row.getCell(this.getPropertyId())).getText();
            }
            return "";
        }

        public Column setHeaderCaption(String caption) throws IllegalStateException {
            HeaderRow row;
            this.checkColumnIsAttached();
            if (caption == null) {
                caption = "";
            }
            if ((row = this.grid.getHeader().getDefaultRow()) != null) {
                ((HeaderCell)row.getCell(this.getPropertyId())).setText(caption);
            }
            return this;
        }

        public double getWidth() throws IllegalStateException {
            this.checkColumnIsAttached();
            String width = this.getInternalColumn().getWidth();
            if (width == null || !width.endsWith("px")) {
                return -1.0;
            }
            return Double.parseDouble(width.replace("px", ""));
        }

        public Column setWidth(double pixelWidth) throws IllegalStateException, IllegalArgumentException {
            this.checkColumnIsAttached();
            if (pixelWidth < 0.0) {
                throw new IllegalArgumentException("Pixel width should be greater than 0 (in " + String.valueOf(this) + ")");
            }
            Grid.Column<Item> column = this.getInternalColumn();
            column.setAutoWidth(false);
            column.setFlexGrow(0);
            String newWidth = "%.0fpx".formatted(pixelWidth);
            if (!Objects.equals(column.getWidth(), newWidth)) {
                column.setWidth(newWidth);
                this.grid.markAsDirty();
                this.grid.fireColumnResizeEvent(this, false);
            }
            return this;
        }

        public boolean isWidthUndefined() {
            this.checkColumnIsAttached();
            Grid.Column<Item> column = this.getInternalColumn();
            return column.isAutoWidth() && column.getFlexGrow() > 0;
        }

        public Column setWidthUndefined() {
            this.checkColumnIsAttached();
            Grid.Column<Item> column = this.getInternalColumn();
            column.setAutoWidth(true);
            column.setFlexGrow(1);
            return this;
        }

        public Column setLastFrozenColumn() {
            this.checkColumnIsAttached();
            this.grid.setFrozenColumnCount(this.grid.getColumns().indexOf(this.grid.getColumn(this.propertyId)) + 1);
            return this;
        }

        public Column setSortable(boolean sortable) {
            this.checkColumnIsAttached();
            if (sortable) {
                Container.Indexed indexed = this.grid.getContainerDataSource();
                if (!(indexed instanceof Container.Sortable)) {
                    throw new IllegalStateException("Can't set column " + String.valueOf(this) + " sortable. The Container of Grid does not implement Sortable");
                }
                Container.Sortable sortableDataSource = (Container.Sortable)((Object)indexed);
                if (!sortableDataSource.getSortableContainerPropertyIds().contains(this.propertyId)) {
                    throw new IllegalStateException("Can't set column " + String.valueOf(this) + " sortable. Container doesn't support sorting by property " + String.valueOf(this.propertyId));
                }
            }
            this.getInternalColumn().setSortable(sortable);
            return this;
        }

        public boolean isSortable() {
            this.checkColumnIsAttached();
            return this.getInternalColumn().isSortable();
        }

        public String toString() {
            this.checkColumnIsAttached();
            return this.getClass().getSimpleName() + "[propertyId:" + String.valueOf(this.propertyId) + "]";
        }

        public Column setExpandRatio(int expandRatio) throws IllegalStateException {
            this.checkColumnIsAttached();
            if (expandRatio < 0) {
                return this.clearExpandRatio();
            }
            this.getInternalColumn().getElement().setProperty("flexGrow", (double)expandRatio);
            return this;
        }

        public int getExpandRatio() {
            this.checkColumnIsAttached();
            return this.getInternalColumn().getElement().getProperty("flexGrow", -1);
        }

        public Column clearExpandRatio() throws IllegalStateException {
            this.checkColumnIsAttached();
            this.getInternalColumn().getElement().removeProperty("flexGrow");
            return this;
        }

        public Column setMinimumWidth(double pixels) throws IllegalStateException {
            this.checkColumnIsAttached();
            double maxwidth = this.getMaximumWidth();
            if (pixels >= 0.0 && pixels > maxwidth && maxwidth >= 0.0) {
                throw new IllegalArgumentException("New minimum width (" + pixels + ") was greater than maximum width (" + maxwidth + ")");
            }
            this.minimumWidth = pixels;
            this.grid.markAsDirty();
            this.grid.registerInternalBeforeClientResponse();
            return this;
        }

        public double getMinimumWidth() {
            return this.minimumWidth;
        }

        public Column setMaximumWidth(double pixels) {
            this.checkColumnIsAttached();
            double minwidth = this.getMinimumWidth();
            if (pixels >= 0.0 && pixels < minwidth && minwidth >= 0.0) {
                throw new IllegalArgumentException("New maximum width (" + pixels + ") was less than minimum width (" + minwidth + ")");
            }
            this.maximumWidth = pixels;
            this.grid.markAsDirty();
            this.grid.registerInternalBeforeClientResponse();
            return this;
        }

        public double getMaximumWidth() {
            return this.maximumWidth;
        }

        public Column setEditable(boolean editable) {
            this.checkColumnIsAttached();
            if (this.grid.isEditorActive()) {
                throw new IllegalStateException("Cannot change column editable status while the editor is active");
            }
            ComponentUtil.setData(this.getInternalColumn(), (String)EDITABLE_PROPERTY, (Object)editable);
            return this;
        }

        public boolean isEditable() {
            this.checkColumnIsAttached();
            Object isEditable = ComponentUtil.getData(this.getInternalColumn(), (String)EDITABLE_PROPERTY);
            return Boolean.TRUE.equals(isEditable);
        }

        public Column setEditorField(Field<?> editor) {
            this.checkColumnIsAttached();
            if (editor != null && !(editor instanceof Component)) {
                throw new IllegalArgumentException("The editor should implement Component");
            }
            this.grid.setEditorField(this.propertyId, editor);
            if (editor != null) {
                ((Component)editor).getElement().setAttribute("editor", true);
            }
            return this;
        }

        public Field<?> getEditorField() {
            this.checkColumnIsAttached();
            return this.grid.getEditorField(this.propertyId);
        }

        public Column setHidden(boolean hidden) {
            this.checkColumnIsAttached();
            Grid.Column<Item> column = this.getInternalColumn();
            if (column.isVisible() == hidden) {
                column.setVisible(!hidden);
                this.grid.fireColumnVisibilityChangeEvent(this, hidden, false);
            }
            this.grid.createColumnCollapsingMenuItems();
            return this;
        }

        public boolean isHidden() {
            this.checkColumnIsAttached();
            return !this.getInternalColumn().isVisible();
        }

        public Column setHidable(boolean hidable) {
            this.hidable = hidable;
            this.grid.createColumnCollapsingMenuItems();
            return this;
        }

        public boolean isHidable() {
            return this.hidable;
        }

        public Column setResizable(boolean resizable) {
            this.checkColumnIsAttached();
            this.getInternalColumn().setResizable(resizable);
            return this;
        }

        public Column setRenderer(com.vaadin.flow.data.renderer.Renderer<?> renderer) {
            this.internalSetRenderer(renderer);
            return this;
        }

        public Column setRenderer(AbstractRenderer<?> renderer) {
            if (renderer != null) {
                renderer.setPropertyId(this.propertyId);
                renderer.setParent(this.grid);
            }
            this.internalSetRenderer(renderer != null ? renderer.getRenderer() : null);
            return this;
        }

        public <T> Column setRenderer(AbstractRenderer<?> renderer, Converter<? extends T, ?> converter) {
            if (renderer != null) {
                renderer.setPropertyId(this.propertyId);
                renderer.setParent(this.grid);
            }
            com.vaadin.flow.data.renderer.Renderer gridRenderer = renderer != null ? renderer.getRenderer() : null;
            this.setRenderer(gridRenderer, converter);
            return this;
        }

        public <T> Column setRenderer(com.vaadin.flow.data.renderer.Renderer<T> renderer, Converter<? extends T, ?> converter) {
            this.setConverter(converter);
            Grid.Column<Item> flowColumn = this.getInternalColumn();
            if (renderer instanceof GridRendererAdapter) {
                flowColumn.setRenderer((com.vaadin.flow.data.renderer.Renderer)((GridRendererAdapter)renderer));
                ((GridRendererAdapter)renderer).setConverter(this.converter);
            } else {
                flowColumn.setRenderer(new GridRendererAdapter((ValueProvider & Serializable)item -> ((Item)item).getItemProperty(this.getPropertyId()).getValue(), renderer, converter));
            }
            return this;
        }

        public Column setConverter(Converter<?, ?> converter) throws IllegalArgumentException {
            Class<?> modelType = this.getModelType();
            if (converter != null && !converter.getModelType().isAssignableFrom(modelType)) {
                throw new IllegalArgumentException("The converter model type " + String.valueOf(converter.getModelType()) + " is not compatible with the property type " + String.valueOf(modelType) + " (in " + this.toString() + ")");
            }
            Converter<?, ?> castConverter = converter;
            this.converter = castConverter;
            if (this.getInternalColumn().getRenderer() instanceof GridRendererAdapter) {
                ((GridRendererAdapter)this.getInternalColumn().getRenderer()).setConverter(this.converter);
            }
            return this;
        }

        public com.vaadin.flow.data.renderer.Renderer<?> getRenderer() {
            return this.renderer;
        }

        public Converter<?, ?> getConverter() {
            return this.converter;
        }

        private <T> boolean internalSetRenderer(com.vaadin.flow.data.renderer.Renderer<T> renderer) {
            Converter<?, ?> converter = this.getConverter();
            this.setRenderer(renderer, converter);
            return true;
        }

        private Class<?> getModelType() {
            return this.grid.getContainerDataSource().getType(this.getPropertyId());
        }

        public boolean isResizable() {
            this.checkColumnIsAttached();
            return this.getInternalColumn().isResizable();
        }

        protected void checkColumnIsAttached() throws IllegalStateException {
            if (this.getInternalColumn() == null) {
                throw new IllegalStateException("Column no longer exists.");
            }
        }

        private Grid.Column<Item> getInternalColumn() {
            return this.grid.getInternalColumn(this.propertyId);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof Column)) return false;
            Column other = (Column)obj;
            if (!this.propertyId.equals(other.propertyId)) return false;
            if (!this.grid.equals(other.grid)) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.propertyId, this.grid);
        }
    }

    public static class ColumnReorderEvent
    extends Event {
        private final boolean userOriginated;

        public ColumnReorderEvent(FGrid source, boolean userOriginated) {
            super(source);
            this.userOriginated = userOriginated;
        }

        public boolean isUserOriginated() {
            return this.userOriginated;
        }
    }

    public static class ColumnResizeEvent
    extends Event {
        private final Column column;
        private final boolean userOriginated;

        public ColumnResizeEvent(FGrid source, Column column, boolean userOriginated) {
            super(source);
            this.column = column;
            this.userOriginated = userOriginated;
        }

        public Column getColumn() {
            return this.column;
        }

        public boolean isUserOriginated() {
            return this.userOriginated;
        }
    }

    public static abstract class StaticSection<ROWTYPE extends StaticRow<?>>
    implements Serializable {
        protected FGrid grid;
        protected List<ROWTYPE> rows = new ArrayList<ROWTYPE>();
        private boolean visible;

        public void setVisible(boolean visible) {
            if (this.visible != visible) {
                this.visible = visible;
                this.markAsDirty();
            }
        }

        public boolean isVisible() {
            return this.visible;
        }

        public ROWTYPE removeRow(int rowIndex) {
            if (rowIndex >= this.rows.size() || rowIndex < 0) {
                throw new IllegalArgumentException("No row at given index " + rowIndex);
            }
            StaticRow row = (StaticRow)this.rows.remove(rowIndex);
            row.detach();
            this.markAsDirty();
            return (ROWTYPE)row;
        }

        public void removeRow(ROWTYPE row) {
            try {
                this.removeRow(this.rows.indexOf(row));
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Section does not contain the given row");
            }
        }

        public ROWTYPE getRow(int rowIndex) {
            if (rowIndex >= this.rows.size() || rowIndex < 0) {
                throw new IllegalArgumentException("No row at given index " + rowIndex);
            }
            return (ROWTYPE)((StaticRow)this.rows.get(rowIndex));
        }

        public ROWTYPE prependRow() {
            return this.addRowAt(0);
        }

        public ROWTYPE appendRow() {
            return this.addRowAt(this.rows.size());
        }

        public ROWTYPE addRowAt(int index) {
            if (index > this.rows.size() || index < 0) {
                throw new IllegalArgumentException("Unable to add row at index " + index);
            }
            ROWTYPE row = this.createRow();
            this.rows.add(index, row);
            return row;
        }

        public int getRowCount() {
            return this.rows.size();
        }

        protected abstract ROWTYPE createRow();

        protected void markAsDirty() {
            this.grid.markAsDirty();
        }

        protected void removeColumn(Object propertyId) {
            for (StaticRow row : this.rows) {
                row.removeCell(propertyId);
            }
        }

        protected void addColumn(Object propertyId) {
            for (StaticRow row : this.rows) {
                row.addCell(propertyId);
            }
        }

        protected void sanityCheck() throws IllegalStateException {
        }

        public static abstract class StaticRow<CELLTYPE extends StaticCell>
        implements Serializable {
            protected StaticSection<?> section;
            private Map<Object, CELLTYPE> cells = new LinkedHashMap<Object, CELLTYPE>();
            private Map<Set<CELLTYPE>, CELLTYPE> cellGroups = new HashMap<Set<CELLTYPE>, CELLTYPE>();
            private String styleName;

            protected StaticRow(StaticSection<?> section) {
                this.section = section;
            }

            protected void addCell(Object propertyId) {
                CELLTYPE cell = this.createCell();
                ((StaticCell)cell).setColumnId(String.valueOf(propertyId));
                this.cells.put(propertyId, cell);
                this.addFlowCell(cell);
            }

            abstract void addFlowCell(CELLTYPE var1);

            abstract void clearFlowCell(CELLTYPE var1);

            protected void removeCell(Object propertyId) {
                StaticCell cell = (StaticCell)this.cells.remove(propertyId);
                if (cell != null) {
                    Set<StaticCell> cellGroupForCell = this.getCellGroupForCell(cell);
                    if (cellGroupForCell != null) {
                        this.removeCellFromGroup(cell, cellGroupForCell);
                    } else {
                        cell.detach();
                        this.clearFlowCell(cell);
                    }
                }
            }

            private void removeCellFromGroup(CELLTYPE cell, Set<CELLTYPE> cellGroup) {
                for (Set<CELLTYPE> group : new HashSet<Set<CELLTYPE>>(this.cellGroups.keySet())) {
                    if (!group.contains(cell)) continue;
                    if (group.size() > 2) {
                        StaticCell mergedCell = (StaticCell)this.cellGroups.remove(cellGroup);
                        cellGroup.remove(cell);
                        this.cellGroups.put(cellGroup, mergedCell);
                    } else {
                        StaticCell mergedCell = (StaticCell)this.cellGroups.remove(cellGroup);
                        mergedCell.detach();
                    }
                    return;
                }
            }

            protected abstract CELLTYPE createCell();

            public CELLTYPE getCell(Object propertyId) {
                StaticCell cell = (StaticCell)this.cells.get(propertyId);
                Set<StaticCell> cellGroup = this.getCellGroupForCell(cell);
                if (cellGroup != null) {
                    cell = (StaticCell)this.cellGroups.get(cellGroup);
                }
                return (CELLTYPE)cell;
            }

            public CELLTYPE join(Object ... propertyIds) {
                if (propertyIds.length < 2) {
                    throw new IllegalArgumentException("You need to merge at least 2 properties");
                }
                HashSet<CELLTYPE> cells = new HashSet<CELLTYPE>();
                for (int i = 0; i < propertyIds.length; ++i) {
                    cells.add(this.getCell(propertyIds[i]));
                }
                return (CELLTYPE)this.join((Set<CELLTYPE>)cells);
            }

            public CELLTYPE join(CELLTYPE ... cells) {
                if (cells.length < 2) {
                    throw new IllegalArgumentException("You need to merge at least 2 cells");
                }
                return this.join((Set<CELLTYPE>)new HashSet<CELLTYPE>(Arrays.asList(cells)));
            }

            protected CELLTYPE join(Set<CELLTYPE> cells) {
                for (StaticCell cell : cells) {
                    if (this.getCellGroupForCell(cell) != null) {
                        throw new IllegalArgumentException("Cell already merged");
                    }
                    if (this.cells.containsValue(cell)) continue;
                    throw new IllegalArgumentException("Cell does not exist on this row");
                }
                CELLTYPE newCell = this.createCell();
                HashSet<String> columnGroup = new HashSet<String>();
                for (StaticCell cell : cells) {
                    columnGroup.add(cell.getColumnId());
                }
                this.cellGroups.put(cells, newCell);
                return newCell;
            }

            private Set<CELLTYPE> getCellGroupForCell(CELLTYPE cell) {
                for (Set<CELLTYPE> group : this.cellGroups.keySet()) {
                    if (!group.contains(cell)) continue;
                    return group;
                }
                return null;
            }

            protected abstract String getCellTagName();

            void detach() {
                for (StaticCell cell : this.cells.values()) {
                    cell.detach();
                }
                for (StaticCell cell : this.cellGroups.values()) {
                    cell.detach();
                }
            }

            public String getStyleName() {
                return this.styleName;
            }

            public void setStyleName(String styleName) {
                this.styleName = styleName;
                this.cells.values().forEach(cell -> cell.setStyleName(cell.getStyleName()));
            }
        }

        static abstract class StaticCell
        implements Serializable {
            private StaticRow<?> row;
            private String columnId;
            private String text;
            private String html;
            private Component component;
            private GridStaticCellType cellType;
            private String styleName;

            protected StaticCell(StaticRow<?> row) {
                this.row = row;
            }

            void setColumnId(String id) {
                this.columnId = id;
            }

            String getColumnId() {
                return this.columnId;
            }

            public StaticRow<?> getRow() {
                return this.row;
            }

            public void setText(String text) {
                this.text = text;
                this.cellType = GridStaticCellType.TEXT;
                this.row.section.markAsDirty();
            }

            public String getText() {
                return this.text;
            }

            public String getHtml() {
                if (this.cellType != GridStaticCellType.HTML) {
                    throw new IllegalStateException("Cannot fetch HTML from a cell with type " + String.valueOf((Object)this.cellType));
                }
                return this.html;
            }

            public void setHtml(String html) {
                this.html = html;
                this.cellType = GridStaticCellType.HTML;
                this.row.section.markAsDirty();
            }

            public Component getComponent() {
                return this.component;
            }

            public void setComponent(Component component) {
                this.component = component;
                this.cellType = GridStaticCellType.WIDGET;
                this.row.section.markAsDirty();
            }

            public GridStaticCellType getCellType() {
                return this.cellType;
            }

            public String getStyleName() {
                return this.styleName;
            }

            public void setStyleName(String styleName) {
                this.styleName = styleName;
                this.row.section.markAsDirty();
            }

            void detach() {
                if (this.getComponent() != null) {
                    this.setComponent(null);
                }
            }
        }

        public static enum GridStaticCellType {
            TEXT,
            HTML,
            WIDGET;

        }
    }

    public static class HeaderRow
    extends StaticSection.StaticRow<HeaderCell> {
        protected boolean defaultRow;
        protected com.vaadin.flow.component.grid.HeaderRow flowHeaderRow;

        protected HeaderRow(StaticSection<?> section) {
            super(section);
        }

        @Override
        protected void addFlowCell(HeaderCell cell) {
            HeaderRow.HeaderCell newCell;
            Grid.Column column = this.section.grid.getFlowGrid().getColumnByKey(cell.getColumnId());
            cell.flowHeaderCell = newCell = (HeaderRow.HeaderCell)this.flowHeaderRow.getCell(column);
            if (cell.getComponent() != null) {
                newCell.setComponent(cell.getComponent());
            } else if (cell.getCellType() == StaticSection.GridStaticCellType.HTML) {
                newCell.setComponent((Component)new Html(cell.getHtml()));
            } else {
                newCell.setText(cell.getText());
            }
        }

        @Override
        protected void clearFlowCell(HeaderCell cell) {
            Grid.Column column = this.section.grid.getFlowGrid().getColumnByKey(cell.getColumnId());
            HeaderRow.HeaderCell flowCell = (HeaderRow.HeaderCell)this.flowHeaderRow.getCell(column);
            flowCell.setComponent(null);
        }

        @Override
        protected HeaderCell join(Set<HeaderCell> cells) {
            HeaderCell joinedCell = super.join(cells);
            Set flowCells = cells.stream().map(cell -> this.section.grid.getFlowGrid().getColumnByKey(cell.getColumnId())).map(column -> (HeaderRow.HeaderCell)this.flowHeaderRow.getCell(column)).collect(Collectors.toSet());
            joinedCell.flowHeaderCell = this.flowHeaderRow.join(flowCells);
            return joinedCell;
        }

        private void setDefaultRow(boolean value) {
            this.defaultRow = value;
        }

        private boolean isDefaultRow() {
            return this.defaultRow;
        }

        @Override
        protected HeaderCell createCell() {
            return new HeaderCell(this);
        }

        @Override
        protected String getCellTagName() {
            return "th";
        }
    }

    public static class FooterRow
    extends StaticSection.StaticRow<FooterCell> {
        protected com.vaadin.flow.component.grid.FooterRow flowFooterRow;

        protected FooterRow(StaticSection<?> section) {
            super(section);
        }

        @Override
        protected void addFlowCell(FooterCell cell) {
            FooterRow.FooterCell newCell;
            Grid.Column column = this.section.grid.getFlowGrid().getColumnByKey(cell.getColumnId());
            cell.flowFooterCell = newCell = (FooterRow.FooterCell)this.flowFooterRow.getCell(column);
            if (cell.getComponent() != null) {
                newCell.setComponent(cell.getComponent());
            } else {
                newCell.setText(cell.getText());
            }
        }

        @Override
        protected void clearFlowCell(FooterCell cell) {
            Grid.Column column = this.section.grid.getFlowGrid().getColumnByKey(cell.getColumnId());
            FooterRow.FooterCell flowCell = (FooterRow.FooterCell)this.flowFooterRow.getCell(column);
            flowCell.setComponent(null);
        }

        @Override
        protected FooterCell createCell() {
            return new FooterCell(this);
        }

        @Override
        protected FooterCell join(Set<FooterCell> cells) {
            FooterCell joinedCell = super.join(cells);
            Set flowCells = cells.stream().map(cell -> this.section.grid.getFlowGrid().getColumnByKey(cell.getColumnId())).map(column -> (FooterRow.FooterCell)this.flowFooterRow.getCell(column)).collect(Collectors.toSet());
            joinedCell.flowFooterCell = this.flowFooterRow.join(flowCells);
            return joinedCell;
        }

        @Override
        protected String getCellTagName() {
            return "td";
        }
    }

    public static class HeaderCell
    extends StaticSection.StaticCell {
        protected HeaderRow.HeaderCell flowHeaderCell;

        protected HeaderCell(HeaderRow row) {
            super(row);
        }

        public HeaderRow getRow() {
            return (HeaderRow)super.getRow();
        }

        private HeaderRow.HeaderCell getFlowCell() {
            return this.flowHeaderCell;
        }

        @Override
        public void setText(String text) {
            super.setText(text);
            this.getFlowCell().setText(text);
        }

        @Override
        public void setHtml(String html) {
            super.setHtml(html);
            this.getFlowCell().setComponent((Component)new Html(html));
        }

        @Override
        public Component getComponent() {
            return super.getComponent();
        }

        @Override
        public void setComponent(Component component) {
            super.setComponent(component);
            this.getFlowCell().setComponent(component);
        }

        @Override
        public void setStyleName(String styleName) {
            super.setStyleName(styleName);
            this.getFlowCell().setPartName((String)(this.getRow().getStyleName() != null ? this.getRow().getStyleName() + " " + styleName : styleName));
        }
    }

    public static class FooterCell
    extends StaticSection.StaticCell {
        protected FooterRow.FooterCell flowFooterCell;

        protected FooterCell(FooterRow row) {
            super(row);
        }

        private FooterRow.FooterCell getFlowCell() {
            return this.flowFooterCell;
        }

        @Override
        public void setText(String text) {
            super.setText(text);
            this.getFlowCell().setText(text);
        }

        @Override
        public void setHtml(String html) {
            super.setHtml(html);
            this.getFlowCell().setComponent((Component)new Html(html));
        }

        @Override
        public Component getComponent() {
            return super.getComponent();
        }

        @Override
        public void setComponent(Component component) {
            super.setComponent(component);
            this.getFlowCell().setComponent(component);
        }

        @Override
        public void setStyleName(String styleName) {
            super.setStyleName(styleName);
            this.getFlowCell().setPartName(this.getStyleName());
        }
    }

    public static interface CellDescriptionGenerator
    extends Serializable {
        public String getDescription(CellReference var1);
    }

    public static interface RowDescriptionGenerator
    extends Serializable {
        public String getDescription(RowReference var1);
    }

    public static interface CellStyleGenerator
    extends Serializable {
        public String getStyle(CellReference var1);
    }

    public static interface RowStyleGenerator
    extends Serializable {
        public String getStyle(RowReference var1);
    }

    public static class ColumnVisibilityChangeEvent
    extends Event {
        private final Column column;
        private final boolean userOriginated;
        private final boolean hidden;

        public ColumnVisibilityChangeEvent(FGrid source, Column column, boolean hidden, boolean isUserOriginated) {
            super(source);
            this.column = column;
            this.hidden = hidden;
            this.userOriginated = isUserOriginated;
        }

        public Column getColumn() {
            return this.column;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public boolean isUserOriginated() {
            return this.userOriginated;
        }
    }

    public static class RowReference
    implements Serializable {
        private final FGrid grid;
        private Object itemId;

        public RowReference(FGrid grid) {
            this.grid = grid;
        }

        public void set(Object itemId) {
            this.itemId = itemId;
        }

        public FGrid getGrid() {
            return this.grid;
        }

        public Object getItemId() {
            return this.itemId;
        }

        public Item getItem() {
            return this.grid.getContainerDataSource().getItem(this.itemId);
        }
    }

    public static class CellReference
    implements Serializable {
        private final RowReference rowReference;
        private Object propertyId;

        public CellReference(RowReference rowReference) {
            this.rowReference = rowReference;
        }

        public void set(Object propertyId) {
            this.propertyId = propertyId;
        }

        public FGrid getGrid() {
            return this.rowReference.getGrid();
        }

        public Object getPropertyId() {
            return this.propertyId;
        }

        public Property<?> getProperty() {
            return this.getItem().getItemProperty(this.propertyId);
        }

        public Object getItemId() {
            return this.rowReference.getItemId();
        }

        public Item getItem() {
            return this.rowReference.getItem();
        }

        public Object getValue() {
            return this.getProperty().getValue();
        }
    }

    public static class MultiSelectionModel
    extends AbstractSelectionModel
    implements SelectionModel.Multi,
    SelectionModel.HasUserSelectionAllowed {
        private boolean userSelectionAllowed = true;
        public static final int DEFAULT_MAX_SELECTIONS = 1000;
        private int selectionLimit = 1000;

        @Override
        public boolean select(Object ... itemIds) throws IllegalArgumentException {
            if (itemIds != null) {
                return this.select(Arrays.asList(itemIds));
            }
            throw new IllegalArgumentException("Vararg array of itemIds may not be null");
        }

        @Override
        public boolean select(Collection<?> itemIds) throws IllegalArgumentException {
            return this.select(itemIds, true);
        }

        protected boolean select(Collection<?> itemIds, boolean refresh) {
            boolean selectionWillChange;
            if (itemIds == null) {
                throw new IllegalArgumentException("itemIds may not be null");
            }
            this.checkItemIdsExist(itemIds);
            boolean bl = selectionWillChange = !this.selection.containsAll(itemIds) && this.selection.size() < this.selectionLimit;
            if (selectionWillChange) {
                LinkedHashSet added = new LinkedHashSet();
                HashSet<Object> oldSelection = new HashSet<Object>(this.selection);
                if (this.selection.size() + itemIds.size() >= this.selectionLimit) {
                    Iterator<?> iterator = itemIds.iterator();
                    while (iterator.hasNext() && this.selection.size() < this.selectionLimit) {
                        Object itemId = iterator.next();
                        added.add(itemId);
                        this.selection.add(itemId);
                    }
                } else {
                    this.selection.addAll(itemIds);
                    added.addAll(itemIds);
                }
                Set addedItemIds = added.stream().map(this.getParentGrid().getContainerDataSource()::getItem).collect(Collectors.toSet());
                this.getParentGrid().getFlowGrid().asMultiSelect().updateSelection(addedItemIds, Collections.emptySet());
                this.fireSelectionEvent(oldSelection, this.selection);
            }
            if (refresh) {
                this.getParentGrid().refreshRows(itemIds.toArray());
            }
            return selectionWillChange;
        }

        public void setSelectionLimit(int selectionLimit) {
            if (selectionLimit < 0) {
                throw new IllegalArgumentException("The selection limit must be non-negative");
            }
            this.selectionLimit = selectionLimit;
        }

        public int getSelectionLimit() {
            return this.selectionLimit;
        }

        @Override
        public boolean deselect(Object ... itemIds) throws IllegalArgumentException {
            if (itemIds != null) {
                return this.deselect(Arrays.asList(itemIds));
            }
            throw new IllegalArgumentException("Vararg array of itemIds may not be null");
        }

        @Override
        public boolean deselect(Collection<?> itemIds) throws IllegalArgumentException {
            return this.deselect(itemIds, true);
        }

        protected boolean deselect(Collection<?> itemIds, boolean refresh) {
            boolean hasCommonElements;
            if (itemIds == null) {
                throw new IllegalArgumentException("itemIds may not be null");
            }
            boolean bl = hasCommonElements = !Collections.disjoint(itemIds, this.selection);
            if (hasCommonElements) {
                HashSet<Object> oldSelection = new HashSet<Object>(this.selection);
                this.selection.removeAll(itemIds);
                Set removedItemIds = itemIds.stream().map(this.getParentGrid().getContainerDataSource()::getItem).collect(Collectors.toSet());
                this.getParentGrid().getFlowGrid().asMultiSelect().updateSelection(Collections.emptySet(), removedItemIds);
                this.fireSelectionEvent(oldSelection, this.selection);
            }
            if (refresh) {
                this.getParentGrid().refreshRows(itemIds.toArray());
            }
            return hasCommonElements;
        }

        @Override
        public boolean selectAll() {
            return this.selectAll(true);
        }

        protected boolean selectAll(boolean refresh) {
            Container.Indexed container = this.getParentGrid().getContainerDataSource();
            if (container != null) {
                return this.select(container.getItemIds(), refresh);
            }
            if (this.selection.isEmpty()) {
                return false;
            }
            return this.deselectAll(false);
        }

        @Override
        public boolean deselectAll() {
            return this.deselectAll(true);
        }

        protected boolean deselectAll(boolean refresh) {
            return this.deselect(this.getSelectedRows(), refresh);
        }

        @Override
        public Collection<Object> getSelectedRows() {
            return super.getSelectedRows();
        }

        @Override
        public void reset() {
            this.deselectAll();
        }

        @Override
        public boolean setSelected(Collection<?> itemIds) throws IllegalArgumentException {
            Set<Object> removed;
            if (itemIds == null) {
                throw new IllegalArgumentException("itemIds may not be null");
            }
            this.checkItemIdsExist(itemIds);
            boolean changed = false;
            HashSet<Object> selectedRows = new HashSet<Object>(itemIds);
            Collection<Object> oldSelection = this.getSelectedRows();
            Set<Object> added = MultiSelectionModel.getDifference(selectedRows, this.selection);
            if (!added.isEmpty()) {
                changed = true;
                this.selection.addAll(added);
                this.getParentGrid().refreshRows(added.toArray());
            }
            if (!(removed = MultiSelectionModel.getDifference(this.selection, selectedRows)).isEmpty()) {
                changed = true;
                this.selection.removeAll(removed);
                this.getParentGrid().refreshRows(removed.toArray());
            }
            Set addedItemIds = added.stream().map(this.getParentGrid().getContainerDataSource()::getItem).collect(Collectors.toSet());
            Set removedItemIds = removed.stream().map(this.getParentGrid().getContainerDataSource()::getItem).collect(Collectors.toSet());
            this.getParentGrid().getFlowGrid().asMultiSelect().updateSelection(addedItemIds, removedItemIds);
            if (changed) {
                this.fireSelectionEvent(oldSelection, this.selection);
            }
            return changed;
        }

        private static Set<Object> getDifference(Set<Object> set1, Set<Object> set2) {
            HashSet<Object> diff = new HashSet<Object>(set1);
            diff.removeAll(set2);
            return diff;
        }

        @Override
        public boolean setSelected(Object ... itemIds) throws IllegalArgumentException {
            if (itemIds != null) {
                return this.setSelected(Arrays.asList(itemIds));
            }
            throw new IllegalArgumentException("Vararg array of itemIds may not be null");
        }

        @Override
        public boolean isUserSelectionAllowed() {
            return this.userSelectionAllowed;
        }

        @Override
        public void setUserSelectionAllowed(boolean userSelectionAllowed) {
            this.userSelectionAllowed = userSelectionAllowed;
        }
    }

    public static class SingleSelectionModel
    extends AbstractSelectionModel
    implements SelectionModel.Single,
    SelectionModel.HasUserSelectionAllowed {
        private boolean deselectAllowed = true;
        private boolean userSelectionAllowed = true;

        @Override
        public boolean select(Object itemId) {
            return this.select(itemId, true);
        }

        protected boolean select(Object itemId, boolean refresh) {
            if (itemId == null) {
                return this.deselect(this.getSelectedRow());
            }
            this.checkItemIdExists(itemId);
            Object selectedRow = this.getSelectedRow();
            boolean modified = this.selection.add(itemId);
            if (modified) {
                Set<Object> deselected;
                if (selectedRow != null) {
                    this.deselectInternal(selectedRow, false, true);
                    deselected = Collections.singleton(selectedRow);
                } else {
                    deselected = Collections.emptySet();
                }
                this.getParentGrid().getFlowGrid().asSingleSelect().setValue((Object)Optional.of(itemId).map(this.getParentGrid().getContainerDataSource()::getItem).orElse(null));
                this.fireSelectionEvent(deselected, this.selection);
            }
            if (refresh) {
                this.getParentGrid().refreshRows(itemId);
            }
            return modified;
        }

        private boolean deselect(Object itemId) {
            return this.deselectInternal(itemId, true, true);
        }

        private boolean deselectInternal(Object itemId, boolean fireEventIfNeeded, boolean refresh) {
            boolean modified = this.selection.remove(itemId);
            if (modified) {
                this.getParentGrid().getFlowGrid().asSingleSelect().setValue(null);
                if (refresh) {
                    this.getParentGrid().refreshRows(itemId);
                }
                if (fireEventIfNeeded) {
                    this.fireSelectionEvent(Collections.singleton(itemId), Collections.emptySet());
                }
            }
            return modified;
        }

        @Override
        public Object getSelectedRow() {
            if (this.selection.isEmpty()) {
                return null;
            }
            return this.selection.iterator().next();
        }

        @Override
        public void reset() {
            this.deselect(this.getSelectedRow());
        }

        @Override
        public void setDeselectAllowed(boolean deselectAllowed) {
            this.deselectAllowed = deselectAllowed;
            ((SelectionModel.Single)this.getParentGrid().getFlowGrid().getSelectionModel()).setDeselectAllowed(deselectAllowed);
        }

        @Override
        public boolean isDeselectAllowed() {
            return this.deselectAllowed;
        }

        @Override
        public boolean isUserSelectionAllowed() {
            return this.userSelectionAllowed;
        }

        @Override
        public void setUserSelectionAllowed(boolean userSelectionAllowed) {
            this.userSelectionAllowed = userSelectionAllowed;
        }
    }

    public static class CommitErrorEvent
    extends Event {
        private FieldGroup.CommitException cause;
        private Set<Column> errorColumns = new HashSet<Column>();
        private String userErrorMessage;

        public CommitErrorEvent(FGrid grid, FieldGroup.CommitException cause) {
            super(grid);
            this.cause = cause;
            this.userErrorMessage = cause.getLocalizedMessage();
        }

        public FieldGroup.CommitException getCause() {
            return this.cause;
        }

        @Override
        public FGrid getComponent() {
            return (FGrid)super.getComponent();
        }

        public boolean isValidationFailure() {
            return this.cause.getCause() instanceof Validator.InvalidValueException;
        }

        public void addErrorColumn(Column column) {
            this.errorColumns.add(column);
        }

        public Collection<Column> getErrorColumns() {
            return Collections.unmodifiableCollection(this.errorColumns);
        }

        public String getUserErrorMessage() {
            return this.userErrorMessage;
        }

        public void setUserErrorMessage(String userErrorMessage) {
            this.userErrorMessage = userErrorMessage;
        }
    }

    public static interface ColumnReorderListener
    extends Serializable {
        public void columnReorder(ColumnReorderEvent var1);
    }

    public static interface ColumnResizeListener
    extends Serializable {
        public void columnResize(ColumnResizeEvent var1);
    }

    public static interface ColumnVisibilityChangeListener
    extends Serializable {
        public void columnVisibilityChanged(ColumnVisibilityChangeEvent var1);
    }

    public static abstract class AbstractGridExtension
    implements FAbstractClientConnector,
    Serializable {
        private FGrid grid;

        public AbstractGridExtension() {
        }

        public AbstractGridExtension(FGrid grid) {
            this.grid = grid;
        }

        @Override
        public ClientConnector getFParent() {
            return this.grid;
        }

        protected Object getItemId(String rowKey) {
            return rowKey;
        }

        protected Object getItemId(Item item) {
            return this.getParentGrid().toItemId(item);
        }

        protected Column getColumn(String columnId) {
            return this.getParentGrid().getColumn(columnId);
        }

        protected FGrid getParentGrid() {
            return this.grid;
        }

        public void setParent(FGrid grid) {
            this.grid = grid;
        }

        protected void refreshRow(Object itemId) {
        }
    }

    public static abstract class AbstractRenderer<T>
    extends AbstractGridExtension
    implements Renderer<T> {
        private final Class<T> presentationType;
        private final String nullRepresentation;
        private Object propertyId;

        protected AbstractRenderer(Class<T> presentationType, String nullRepresentation) {
            this.presentationType = presentationType;
            this.nullRepresentation = nullRepresentation;
        }

        @Override
        public Class<T> getPresentationType() {
            return this.presentationType;
        }

        protected String getNullRepresentation() {
            return this.nullRepresentation;
        }

        public void setPropertyId(Object propertyId) {
            this.propertyId = propertyId;
        }

        public Object getPropertyId() {
            return this.propertyId;
        }
    }

    public static class NoSelectionModel
    extends AbstractSelectionModel
    implements SelectionModel.None {
        @Override
        public boolean isSelected(Object itemId) {
            return false;
        }

        @Override
        public Collection<Object> getSelectedRows() {
            return Collections.emptyList();
        }

        @Override
        public void reset() {
        }
    }

    public static abstract class AbstractSelectionModel
    implements SelectionModel {
        protected final LinkedHashSet<Object> selection = new LinkedHashSet();
        protected FGrid parentGrid;

        @Override
        public boolean isSelected(Object itemId) {
            return this.selection.contains(itemId);
        }

        @Override
        public Collection<Object> getSelectedRows() {
            return new ArrayList<Object>(this.selection);
        }

        @Override
        public void setGrid(FGrid grid) {
            this.parentGrid = grid;
        }

        protected FGrid getParentGrid() {
            return this.parentGrid;
        }

        protected void checkItemIdExists(Object itemId) throws IllegalArgumentException {
            if (!this.getParentGrid().getContainerDataSource().containsId(itemId)) {
                throw new IllegalArgumentException("Given item id (" + String.valueOf(itemId) + ") does not exist in the container");
            }
        }

        protected void checkItemIdsExist(Collection<?> itemIds) throws IllegalArgumentException {
            for (Object itemId : itemIds) {
                this.checkItemIdExists(itemId);
            }
        }

        protected void fireSelectionEvent(Collection<Object> oldSelection, Collection<Object> newSelection) {
            this.getParentGrid().fireSelectionEvent(oldSelection, newSelection);
        }
    }

    public static class EditorFieldFactory
    extends DefaultFieldGroupFieldFactory {
        private static final EditorFieldFactory INSTANCE = new EditorFieldFactory();

        protected EditorFieldFactory() {
        }

        public static EditorFieldFactory get() {
            return INSTANCE;
        }

        @Override
        public <T extends Field> T createField(Class<?> type, Class<T> fieldType) {
            T f = super.createField(type, fieldType);
            if (f instanceof HasSize) {
                ((HasSize)f).setWidth("100%");
            }
            return f;
        }

        @Override
        protected Select createCompatibleSelect(Class<?> fieldType) {
            Class fieldTypeToUse = this.anySelect(fieldType) ? FComboBox.class : fieldType;
            return super.createCompatibleSelect(fieldTypeToUse);
        }

        @Override
        protected void populateWithEnumData(Select select, Class<? extends Enum> enumClass) {
            EnumSet<? extends Enum> enumSet = EnumSet.allOf(enumClass);
            for (Object e : enumSet) {
                select.addItem(e);
            }
        }
    }
}

