/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui;

import com.vaadin.featurepack.data.Validator;
import com.vaadin.featurepack.server.HasSizeable;
import com.vaadin.featurepack.ui.FAbstractComponent;
import com.vaadin.featurepack.ui.Focusable;
import com.vaadin.featurepack.ui.HasComponents;
import com.vaadin.featurepack.ui.HasFInternalValue;
import com.vaadin.flow.component.AbstractCompositeField;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasValueAndElement;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementUtil;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Iterator;
import java.util.stream.Stream;

public abstract class CustomField<T>
extends AbstractCompositeField<Component, CustomField<T>, T>
implements FAbstractComponent,
HasFInternalValue<T>,
HasComponents,
Focusable,
com.vaadin.flow.component.Focusable<Div>,
HasValueAndElement<AbstractField.ComponentValueChangeEvent<CustomField<T>, T>, T>,
HasSizeable {
    private Component content = null;
    private Focusable focusDelegate;
    private transient boolean contentIsInitializing = false;
    private Div compositionRoot = new Div();

    public CustomField() {
        super(null);
        this.compositionRoot.setWidth(100.0f, Unit.PERCENTAGE);
        this.getFAbstractField();
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.doConnectorOnAttach(attachEvent);
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.doConnectorOnDetach(detachEvent);
    }

    @Override
    public void setLabelComponent(Component labelComponent) {
        if (this.compositionRoot.getComponentCount() > 1) {
            this.compositionRoot.remove(new Component[]{this.compositionRoot.getComponentAt(0)});
        }
        if (labelComponent != null) {
            labelComponent.getElement().getClassList().add((Object)"v-caption");
            this.compositionRoot.getElement().insertChild(0, new Element[]{labelComponent.getElement()});
        }
    }

    @Override
    public void attach() {
        FAbstractComponent.super.attach();
        this.getContent();
    }

    public Component getContent() {
        if (this.content == null) {
            try {
                if (this.contentIsInitializing) {
                    throw new IllegalStateException("The content is not yet initialized. Detected direct or indirect call to 'getContent' from 'initContent'. You may not call any framework method on a '" + Composite.class.getSimpleName() + "' instance before 'initContent' has completed initializing the component.");
                }
                this.contentIsInitializing = true;
                Component content = this.initContent();
                if (content == null) {
                    throw new IllegalStateException("initContent returned null instead of a component");
                }
                this.compositionRoot.removeAll();
                this.compositionRoot.add(new Component[]{content});
                this.setContent(content);
            }
            finally {
                this.contentIsInitializing = false;
            }
        }
        return this.content;
    }

    private void setContent(Component content) {
        assert (content.getElement().getComponent().isPresent()) : "Composite should never be attached to an element which is not attached to a component";
        assert (this.content == null) : "Content has already been initialized";
        this.content = content;
        Element element = this.content.getElement();
        ElementUtil.setComponent((Element)element, (Component)this);
    }

    public Element getElement() {
        this.getContent();
        return this.compositionRoot.getElement();
    }

    public Stream<Component> getChildren() {
        return Stream.of(this.getContent());
    }

    protected abstract Component initContent();

    @Override
    public void setHeight(float height, Unit unit) {
        if (this.compositionRoot != null) {
            this.compositionRoot.setHeight(height, unit);
        }
        this.markAsDirtyRecursive();
    }

    @Override
    public void setWidth(float width, Unit unit) {
        if (this.compositionRoot != null) {
            this.compositionRoot.setWidth(width, unit);
        }
        this.markAsDirtyRecursive();
    }

    @Override
    public void setSizeFull() {
        this.setWidth(100.0f, Unit.PERCENTAGE);
        this.setHeight(100.0f, Unit.PERCENTAGE);
    }

    @Override
    public void setSizeUndefined() {
        this.setWidthUndefined();
        this.setHeightUndefined();
    }

    @Override
    public void setWidthUndefined() {
        this.setWidth(-1.0f, Unit.PIXELS);
    }

    @Override
    public void setHeightUndefined() {
        this.setHeight(-1.0f, Unit.PIXELS);
    }

    @Override
    public Iterator<Component> iterator() {
        return new ComponentIterator();
    }

    public void setFocusDelegate(Focusable focusDelegate) {
        this.focusDelegate = focusDelegate;
    }

    private Focusable getFocusable() {
        return this.focusDelegate;
    }

    @Override
    public void focus() {
        if (this.getFocusable() != null) {
            this.getFocusable().focus();
        } else {
            super.focus();
        }
    }

    @Override
    public int getTabIndex() {
        if (this.getFocusable() != null) {
            return this.getFocusable().getTabIndex();
        }
        return super.getTabIndex();
    }

    @Override
    public void setTabIndex(int tabIndex) {
        if (this.getFocusable() != null) {
            this.getFocusable().setTabIndex(tabIndex);
        } else {
            super.setTabIndex(tabIndex);
        }
    }

    @Override
    public void validate() throws Validator.InvalidValueException {
        this.getFAbstractField().validate();
    }

    protected void setPresentationValue(T value) {
    }

    protected T getInternalValue() {
        return HasFInternalValue.super.getFInternalValue();
    }

    protected void setInternalValue(T newValue) {
        HasFInternalValue.super.setFInternalValue(newValue);
    }

    @Override
    public T getFInternalValue() {
        return this.getInternalValue();
    }

    @Override
    public void setFInternalValue(T newValue) {
        this.setInternalValue(newValue);
    }

    protected void fireEvent(ComponentEvent<?> componentEvent) {
        FAbstractComponent.super.fireEvent((EventObject)componentEvent, this.getEventBus());
    }

    private class ComponentIterator
    implements Iterator<Component>,
    Serializable {
        boolean first;

        private ComponentIterator() {
            this.first = CustomField.this.content != null;
        }

        @Override
        public boolean hasNext() {
            return this.first;
        }

        @Override
        public Component next() {
            this.first = false;
            CustomField.this.getContent();
            return CustomField.this.content;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

