/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui;

import com.vaadin.featurepack.ui.AbstractComponent;
import com.vaadin.featurepack.ui.ComponentContainer;
import com.vaadin.featurepack.ui.HasComponents;
import com.vaadin.featurepack.ui.SingleComponentContainer;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementDetachListener;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractSingleComponentContainer
extends AbstractComponent
implements SingleComponentContainer {
    private Element wrapper;
    private boolean internalRemoval;

    @Override
    public int getComponentCount() {
        return this.getContent() != null ? 1 : 0;
    }

    @Override
    public Iterator<Component> iterator() {
        if (this.getContent() != null) {
            return Collections.singletonList(this.getContent()).iterator();
        }
        return Collections.emptyIterator();
    }

    @Override
    public Registration addComponentAttachListener(HasComponents.ComponentAttachListener listener) {
        return this.getEventBus().addListener(HasComponents.ComponentAttachEvent.class, (ComponentEventListener)listener);
    }

    @Override
    public Registration addComponentDetachListener(HasComponents.ComponentDetachListener listener) {
        return this.getEventBus().addListener(HasComponents.ComponentDetachEvent.class, (ComponentEventListener)listener);
    }

    protected void fireComponentAttachEvent(Component component) {
        this.fireEvent(new HasComponents.ComponentAttachEvent((Component)this, component));
    }

    protected void fireComponentDetachEvent(Component component) {
        this.fireEvent(new HasComponents.ComponentDetachEvent((Component)this, component));
    }

    @Override
    public Component getContent() {
        return this.getContentWrapper().getChildren().findFirst().flatMap(Element::getComponent).orElse(null);
    }

    @Override
    public void setContent(Component content) {
        if (this.isOrHasAncestor(content)) {
            throw new IllegalArgumentException("Component cannot be added inside it's own content");
        }
        Component oldContent = this.getContent();
        if (oldContent == content) {
            return;
        }
        if (oldContent != null && this.equals(oldContent.getParent().orElse(null))) {
            if (this.getContentWrapper().indexOfChild(oldContent.getElement()) != -1) {
                this.internalRemoval = true;
                this.getContentWrapper().removeChild(new Element[]{oldContent.getElement()});
                this.internalRemoval = false;
            }
            this.fireComponentDetachEvent(oldContent);
        }
        if (content != null) {
            AbstractSingleComponentContainer.removeFromParent(content);
            this.getContentWrapper().appendChild(new Element[]{content.getElement()});
            this.fireComponentAttachEvent(content);
            if (this.isAttached()) {
                this.addDetachListener(content);
            }
        }
        this.markAsDirtyRecursive();
    }

    protected void setContentWrapper(Element wrapper) {
        if (this.wrapper != null) {
            throw new UnsupportedOperationException("Wrapper element can only be set once.");
        }
        if (this.getContent() != null) {
            throw new UnsupportedOperationException("Wrapper element can only be set if no content is defined");
        }
        assert (wrapper != null) : "Wrapper should be not null";
        this.wrapper = wrapper;
        this.getElement().appendChild(new Element[]{wrapper});
    }

    protected Element getContentWrapper() {
        return this.wrapper != null ? this.wrapper : this.getElement();
    }

    @Override
    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.getContent() != null) {
            this.addDetachListener(this.getContent());
        }
    }

    private void addDetachListener(Component component) {
        AtomicReference<Registration> holder = new AtomicReference<Registration>();
        holder.set(component.getElement().addDetachListener((ElementDetachListener & Serializable)event -> {
            if (!this.internalRemoval) {
                this.fireComponentDetachEvent(component);
                this.markAsDirty();
            }
            ((Registration)holder.get()).remove();
        }));
    }

    public static void removeFromParent(Component content) throws IllegalArgumentException {
        VaadinSession parentSession;
        UI parentUI = content.getUI().orElse(null);
        if (parentUI != null && (parentSession = parentUI.getSession()) != null && !parentSession.hasLock()) {
            Object message = "Cannot remove from parent when the session is not locked.";
            if (VaadinService.isOtherSessionLocked((VaadinSession)parentSession)) {
                message = (String)message + " Furthermore, there is another locked session, indicating that the component might be about to be moved from one session to another.";
            }
            throw new IllegalStateException((String)message);
        }
        Component parent = content.getParent().orElse(null);
        if (parent instanceof AbstractComponent) {
            if (parent instanceof ComponentContainer) {
                ComponentContainer oldParent = (ComponentContainer)parent;
                oldParent.removeComponent(content);
            } else if (parent instanceof SingleComponentContainer) {
                SingleComponentContainer oldParent = (SingleComponentContainer)parent;
                if (oldParent.getContent() == content) {
                    oldParent.setContent(null);
                }
            } else if (parent != null) {
                throw new IllegalArgumentException("Content is already attached to another parent");
            }
        }
    }

    @Override
    public void setHeight(float height, Unit unit) {
        if (height != this.getHeight() || unit != this.getHeightUnits()) {
            super.setHeight(height, unit);
            this.markAsDirtyRecursive();
        }
    }

    @Override
    public void setWidth(float width, Unit unit) {
        if (width != this.getWidth() || unit != this.getWidthUnits()) {
            super.setWidth(width, unit);
            this.markAsDirtyRecursive();
        }
    }
}

