/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui;

import com.vaadin.featurepack.server.AbstractClientConnector;
import com.vaadin.featurepack.server.ComponentSizeValidator;
import com.vaadin.featurepack.server.SizeWithUnit;
import com.vaadin.featurepack.server.Sizeable;
import com.vaadin.featurepack.ui.AbstractComponentContainer;
import com.vaadin.featurepack.ui.Event;
import com.vaadin.featurepack.ui.FAbstractComponent;
import com.vaadin.featurepack.ui.HasComponents;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.shared.HasTooltip;
import com.vaadin.flow.component.shared.Tooltip;
import com.vaadin.flow.dom.ClassList;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.server.VaadinSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractComponent
extends AbstractClientConnector
implements Sizeable,
HasEnabled,
HasTooltip,
HasLabel,
FAbstractComponent {
    private static final String HAS_HEIGHT_STYLE = "v-has-height";
    private static final String HAS_WIDTH_STYLE = "v-has-width";

    public AbstractComponent() {
        ArrayList<String> internalStyles = new ArrayList<String>();
        internalStyles.add("v-widget");
        internalStyles.add("v-lcp");
        FAbstractComponent.setInternalStyles(this, internalStyles);
    }

    @Override
    public void beforeClientResponse(boolean initial) {
        if (this.getHeight() >= 0.0f && (this.getHeightUnits() != Unit.PERCENTAGE || ComponentSizeValidator.parentCanDefineHeight(this))) {
            this.getElement().getStyle().set("height", this.getCSSHeight());
            this.addInternalStyles(HAS_HEIGHT_STYLE);
        } else {
            this.getElement().getStyle().set("height", null);
            this.removeInternalStyles(HAS_HEIGHT_STYLE);
        }
        if (this.getWidth() >= 0.0f && (this.getWidthUnits() != Unit.PERCENTAGE || ComponentSizeValidator.parentCanDefineWidth(this))) {
            this.getElement().getStyle().set("width", this.getCSSWidth());
            this.addInternalStyles(HAS_WIDTH_STYLE);
        } else {
            this.getElement().getStyle().set("width", null);
            this.removeInternalStyles(HAS_WIDTH_STYLE);
        }
        FAbstractComponent.super.beforeClientResponse(initial);
    }

    public void setParent(HasComponents parent) {
        Component oldParent = this.getParent().orElse(null);
        if (parent != null && oldParent != null) {
            throw new IllegalStateException(this.getClass().getName() + " already has a parent.");
        }
        if (Objects.equals(oldParent, parent)) {
            return;
        }
        if (oldParent instanceof AbstractComponent) {
            ((AbstractComponent)oldParent).markAsDirtyRecursive();
        }
    }

    protected void fireComponentEvent() {
        this.fireEvent(new Event(this));
    }

    protected void focus() {
    }

    protected boolean isOrHasAncestor(Component content) {
        if (content instanceof com.vaadin.flow.component.HasComponents || content instanceof HasComponents) {
            if (Objects.equals(this, content)) {
                return true;
            }
            Optional optionalParent = this.getParent();
            while (optionalParent.isPresent()) {
                Component parent = (Component)optionalParent.get();
                if (parent.equals(content)) {
                    return true;
                }
                optionalParent = parent.getParent();
            }
        }
        return false;
    }

    @Override
    public void setWidth(float width, Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit can not be null");
        }
        this.doSetWidth(new SizeWithUnit(width, unit));
    }

    @Override
    public void setHeight(float height, Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit can not be null");
        }
        this.doSetHeight(new SizeWithUnit(height, unit));
    }

    @Override
    public void setWidth(String width) {
        FAbstractComponent.super.setWidth(width);
    }

    @Override
    public void setSizeFull() {
        FAbstractComponent.super.setSizeFull();
    }

    @Override
    public void setWidthFull() {
        FAbstractComponent.super.setWidthFull();
    }

    @Override
    public void setHeightFull() {
        FAbstractComponent.super.setHeightFull();
    }

    @Override
    public void setSizeUndefined() {
        FAbstractComponent.super.setSizeUndefined();
    }

    @Override
    public void setWidthUndefined() {
        FAbstractComponent.super.setWidthUndefined();
    }

    @Override
    public void setHeightUndefined() {
        FAbstractComponent.super.setHeightUndefined();
    }

    @Override
    public float getWidth() {
        SizeWithUnit cachedWidth = (SizeWithUnit)ComponentUtil.getData((Component)this.getFlowComponent(), (String)"component-cachedWidth");
        return cachedWidth == null ? -1.0f : cachedWidth.getSize();
    }

    @Override
    public float getHeight() {
        SizeWithUnit cachedHeight = (SizeWithUnit)ComponentUtil.getData((Component)this.getFlowComponent(), (String)"component-cachedHeight");
        return cachedHeight == null ? -1.0f : cachedHeight.getSize();
    }

    @Override
    public Unit getWidthUnits() {
        return FAbstractComponent.super.getWidthUnits();
    }

    @Override
    public Unit getHeightUnits() {
        return FAbstractComponent.super.getHeightUnits();
    }

    @Override
    public void setHeight(String height) {
        FAbstractComponent.super.setHeight(height);
    }

    private String getCSSHeight() {
        return this.getHeight() + this.getHeightUnits().getSymbol();
    }

    private String getCSSWidth() {
        return this.getWidth() + this.getWidthUnits().getSymbol();
    }

    protected void doSetWidth(SizeWithUnit width) {
        ComponentUtil.setData((Component)this.getFlowComponent(), (String)"component-cachedWidth", (Object)width);
        this.getParent().ifPresent(parent -> {
            if (parent instanceof AbstractComponentContainer) {
                ((AbstractComponentContainer)parent).markAsDirtyRecursive();
            } else {
                this.markAsDirty();
            }
        });
    }

    protected void doSetHeight(SizeWithUnit height) {
        ComponentUtil.setData((Component)this.getFlowComponent(), (String)"component-cachedHeight", (Object)height);
        this.getParent().ifPresent(parent -> {
            if (parent instanceof AbstractComponentContainer) {
                ((AbstractComponentContainer)parent).markAsDirtyRecursive();
            } else {
                this.markAsDirty();
            }
        });
    }

    protected void addInternalStyles(String ... internalStyles) {
        FAbstractComponent.getInternalStyles(this).addAll(Arrays.asList(internalStyles));
        this.markAsDirty();
    }

    protected void removeInternalStyles(String ... internalStyles) {
        FAbstractComponent.getInternalStyles(this).removeAll(Arrays.asList(internalStyles));
        this.markAsDirty();
    }

    protected Collection<String> getInternalStyles() {
        if (FAbstractComponent.getInternalStyles(this) == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(FAbstractComponent.getInternalStyles(this));
    }

    protected Collection<String> getCustomStyles() {
        if (FAbstractComponent.getCustomStyles(this) == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(FAbstractComponent.getCustomStyles(this));
    }

    public void onEnabledStateChanged(boolean enabled) {
        if (!enabled) {
            this.addInternalStyles("v-disabled");
        } else {
            this.removeInternalStyles("v-disabled");
        }
    }

    public Locale getLocale() {
        Locale locale = (Locale)ComponentUtil.getData((Component)this.getFlowComponent(), (String)"component-locale");
        if (locale != null) {
            return locale;
        }
        Optional<AbstractComponent> parent = this.getFirstAbstractComponentParent(this.getFlowComponent());
        if (parent.isPresent()) {
            return parent.get().getLocale();
        }
        VaadinSession session = this.getFlowComponent().getUI().map(UI::getSession).orElse(null);
        if (session != null) {
            return session.getLocale();
        }
        return null;
    }

    private Optional<AbstractComponent> getFirstAbstractComponentParent(Component component) {
        Optional parent = component.getParent();
        if (parent.isPresent() && parent.get() instanceof AbstractComponent) {
            return Optional.of((AbstractComponent)parent.get());
        }
        if (parent.isPresent()) {
            return this.getFirstAbstractComponentParent((Component)parent.get());
        }
        return Optional.empty();
    }

    public boolean isVisible() {
        return super.isVisible();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public Tooltip setTooltipText(String text) {
        return super.setTooltipText(text);
    }

    public Tooltip getTooltip() {
        return super.getTooltip();
    }

    public void addClassName(String className) {
        this.addStyleName(className);
    }

    public boolean removeClassName(String className) {
        if (this.hasClassName(className)) {
            this.removeStyleName(className);
            return true;
        }
        return false;
    }

    public void setClassName(String className) {
        this.setStyleName(className);
    }

    public String getClassName() {
        return this.getStyleName();
    }

    public ClassList getClassNames() {
        super.getClassNames().clear();
        String classNames = this.getStyleName();
        for (String className : classNames.split(" ")) {
            if (className.isEmpty()) continue;
            super.getClassNames().set(className, true);
        }
        return super.getClassNames();
    }

    public void setClassName(String className, boolean set) {
        if (set) {
            this.setStyleName(className);
        } else {
            this.removeStyleName(className);
        }
    }

    public boolean hasClassName(String className) {
        return this.getStyleName().contains(className);
    }

    public Style getStyle() {
        return super.getStyle();
    }

    public void addClassNames(String ... classNames) {
        this.addStyleNames(classNames);
    }

    public void removeClassNames(String ... classNames) {
        this.removeStyleNames(classNames);
    }

    protected void fireEvent(ComponentEvent<?> componentEvent) {
        FAbstractComponent.super.fireEvent((EventObject)componentEvent, this.getEventBus());
    }
}

