/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.server;

import com.vaadin.featurepack.server.AbstractErrorMessage;
import com.vaadin.featurepack.shared.ui.ErrorLevel;

public class SystemError
extends AbstractErrorMessage {
    public SystemError(String message) {
        super(message);
        this.setErrorLevel(ErrorLevel.SYSTEM);
        this.setMode(AbstractErrorMessage.ContentMode.HTML);
        this.setMessage(this.getHtmlMessage());
    }

    public SystemError(String message, Throwable cause) {
        this(message);
        this.addCause(AbstractErrorMessage.getErrorMessageForException(cause));
    }

    public SystemError(Throwable cause) {
        this(null, cause);
    }

    protected String getHtmlMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.getMessage() != null) {
            sb.append("<h2>");
            sb.append(AbstractErrorMessage.safeEscapeForHtml(this.getMessage()));
            sb.append("</h2>");
        }
        return sb.toString();
    }
}

