/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.event;

import com.vaadin.featurepack.data.Item;
import com.vaadin.featurepack.data.ItemDataProvider;
import com.vaadin.featurepack.event.MouseEvents;
import com.vaadin.featurepack.shared.MouseEventDetails;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.grid.Grid;
import java.io.Serializable;
import java.lang.reflect.Method;

@DomEvent(value="item-click")
public class ItemClickEvent
extends MouseEvents.AbstractClickEvent
implements Serializable {
    private final Item item;
    private final Object itemId;
    private final Object propertyId;
    public static final Method ITEM_CLICK_METHOD;

    public ItemClickEvent(Component source, Item item, Object itemId, Object propertyId, MouseEventDetails details) {
        super(source, details);
        this.item = item;
        this.itemId = itemId;
        this.propertyId = propertyId;
    }

    public ItemClickEvent(Grid<Item> source, boolean fromClient, @EventData(value="event.detail.itemKey") String itemKey, @EventData(value="event.detail.internalColumnId") String internalColumnId, @EventData(value="event.detail.screenX") int screenX, @EventData(value="event.detail.screenY") int screenY, @EventData(value="event.detail.clientX") int clientX, @EventData(value="event.detail.clientY") int clientY, @EventData(value="event.detail.detail") int clickCount, @EventData(value="event.detail.button") int button, @EventData(value="event.detail.ctrlKey") boolean ctrlKey, @EventData(value="event.detail.shiftKey") boolean shiftKey, @EventData(value="event.detail.altKey") boolean altKey, @EventData(value="event.detail.metaKey") boolean metaKey, @EventData(value="event.clientX - element.getBoundingClientRect().x") int relativeX, @EventData(value="event.clientY - element.getBoundingClientRect().y") int relativeY) {
        super((Component)source, fromClient, clickCount, button, clientX, clientY, ctrlKey, shiftKey, altKey, metaKey, relativeX, relativeY);
        this.item = (Item)source.getDataCommunicator().getKeyMapper().get(itemKey);
        this.itemId = ((ItemDataProvider)source.getDataCommunicator().getDataProvider()).getItemId(this.item);
        Grid.Column<Item> column = this.readPropertyId(internalColumnId);
        this.propertyId = column != null ? column.getKey() : null;
    }

    private Grid.Column<Item> readPropertyId(String internalColumnId) {
        try {
            Method method = Grid.class.getDeclaredMethod("getColumnByInternalId", String.class);
            method.setAccessible(true);
            return (Grid.Column)method.invoke(this.source, internalColumnId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Item getItem() {
        return this.item;
    }

    public Object getItemId() {
        return this.itemId;
    }

    public Object getPropertyId() {
        return this.propertyId;
    }

    static {
        try {
            ITEM_CLICK_METHOD = ItemClickListener.class.getDeclaredMethod("itemClick", ItemClickEvent.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException();
        }
    }

    public static interface ItemClickListener
    extends Serializable {
        public void itemClick(ItemClickEvent var1);
    }

    public static interface ItemClickNotifier
    extends Serializable {
        public void addItemClickListener(ItemClickListener var1);

        public void removeItemClickListener(ItemClickListener var1);
    }
}

