/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop.layouts;

import com.vaadin.featurepack.desktop.layouts.AbstractLayout;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import java.util.Objects;

public class GridLayout
extends AbstractLayout {
    private int horizontalGap = 0;
    private int verticalGap = 0;
    private int rows;
    private int columns;

    public GridLayout() {
        this(1, 0, 0, 0);
    }

    public GridLayout(int rows, int columns) {
        this(rows, columns, 0, 0);
    }

    public GridLayout(int rows, int columns, int hgap, int vgap) {
        if (rows == 0 && columns == 0) {
            throw new IllegalArgumentException("rows and columns cannot both be zero");
        }
        this.rows = rows;
        this.columns = columns;
        this.setHgap(hgap);
        this.setVgap(vgap);
    }

    protected void onContainerAttach(AttachEvent event) {
        event.getUI().getPage().addStyleSheet("vfp-grid-layout.css");
    }

    public void setContainer(Component container) {
        Component current = this.getContainer();
        if (current != null) {
            current.getElement().removeAttribute("vfp-grid-layout");
            current.getStyle().remove("--vfp-column-count");
            current.getStyle().remove("--vfp-horizontal-gap");
            current.getStyle().remove("--vfp-vertical-gap");
        }
        super.setContainer(container);
        if (container != null) {
            container.getElement().setAttribute("vfp-grid-layout", "");
            this.updateHgap();
            this.updateVgap();
            this.calculateColumns();
        }
    }

    public void addComponent(Component component) {
        Objects.requireNonNull(component, "Component must not be null");
        this.calculateColumns();
    }

    public void removeComponent(Component component) {
        Objects.requireNonNull(component, "Component must not be null");
        this.calculateColumns();
    }

    private void calculateColumns() {
        Component container = this.getContainer();
        long count = container.getChildren().count();
        int cols = this.columns;
        if (this.rows > 0) {
            cols = (int)Math.ceil((double)count / (double)this.rows);
        }
        container.getStyle().set("--vfp-column-count", Integer.toString(cols));
    }

    public int getHgap() {
        return this.horizontalGap;
    }

    public void setHgap(int hgap) {
        this.horizontalGap = hgap;
        this.updateHgap();
    }

    private void updateHgap() {
        Component container = this.getContainer();
        if (container != null) {
            container.getStyle().set("--vfp-horizontal-gap", this.horizontalGap + "px");
        }
    }

    public int getVgap() {
        return this.verticalGap;
    }

    public void setVgap(int vgap) {
        this.verticalGap = vgap;
        this.updateVgap();
    }

    private void updateVgap() {
        Component container = this.getContainer();
        if (container != null) {
            container.getStyle().set("--vfp-vertical-gap", this.verticalGap + "px");
        }
    }

    public void setConstraints(Component component, Object constraints) {
        throw new UnsupportedOperationException("GridLayout does not support constraints");
    }

    public Object getConstraints(Component component) {
        throw new UnsupportedOperationException("GridLayout does not support constraints");
    }
}

