/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop.layouts;

import com.vaadin.featurepack.desktop.geometry.Insets;
import com.vaadin.featurepack.desktop.layouts.AbstractLayout;
import com.vaadin.featurepack.desktop.layouts.GridBagConstraints;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class GridBagLayout
extends AbstractLayout {
    private final HashMap<Component, GridBagConstraints> constraintMap = new HashMap();
    private final Map<Integer, Integer> availableColumnByRowMap = new LinkedHashMap<Integer, Integer>();
    private final Map<Integer, Integer> availableRowByColumnMap = new LinkedHashMap<Integer, Integer>();
    private int rowCount = 0;
    private int columnCount = 0;

    protected void onContainerAttach(AttachEvent event) {
        event.getUI().getPage().addStyleSheet("vfp-grid-bag-layout.css");
        event.getUI().getPage().addJavaScript("vfp-grid-bag-layout.js");
        this.getContainer().getElement().executeJs("window.Vaadin.Flow.gridBagLayout.init($0)", new Object[0]);
    }

    public void setContainer(Component container) {
        Component current = this.getContainer();
        if (current != null) {
            current.getElement().removeAttribute("vfp-grid-bag-layout");
            current.getChildren().forEach(this::clearComponentState);
            if (current.isAttached()) {
                current.getElement().executeJs("window.Vaadin.Flow.gridBagLayout.destroy($0)", new Object[0]);
            }
            this.constraintMap.clear();
        }
        super.setContainer(container);
        if (container != null) {
            container.getElement().setAttribute("vfp-grid-bag-layout", "");
        }
    }

    public void addComponent(Component component) {
        Objects.requireNonNull(component, "Component must not be null");
    }

    public void removeComponent(Component component) {
        Objects.requireNonNull(component, "Component must not be null");
        this.constraintMap.remove(component);
        this.clearComponentState(component);
    }

    private void clearComponentState(Component component) {
        component.getElement().removeAttribute("vfp-fill");
        component.getStyle().remove("--vfp-margin-top");
        component.getStyle().remove("--vfp-margin-right");
        component.getStyle().remove("--vfp-margin-bottom");
        component.getStyle().remove("--vfp-margin-left");
        component.getStyle().remove("--vfp-align-self");
        component.getStyle().remove("--vfp-justify-self");
        component.getStyle().remove("--vfp-padding-width");
        component.getStyle().remove("--vfp-padding-height");
        component.getStyle().remove("--vfp-grid-column");
        component.getStyle().remove("--vfp-grid-row");
    }

    public void setConstraints(Component component, Object constraintsObject) {
        if (!(constraintsObject instanceof GridBagConstraints)) {
            throw new IllegalArgumentException("Constraints must be an instance of GridBagConstraints");
        }
        GridBagConstraints constraints = (GridBagConstraints)constraintsObject;
        this.constraintMap.put(component, constraints.clone());
        this.update();
    }

    private void update() {
        this.updateComponentPositions();
        this.getComponents().forEach(component -> {
            GridBagConstraints constraints = this.getInternalConstraints((Component)component);
            this.setComponentInsets((Component)component, constraints);
            this.setComponentAnchor((Component)component, constraints);
            this.setComponentFill((Component)component, constraints);
            this.setComponentIpad((Component)component, constraints);
        });
    }

    private void updateComponentPositions() {
        this.availableColumnByRowMap.clear();
        this.availableRowByColumnMap.clear();
        this.rowCount = 0;
        this.columnCount = 0;
        this.getComponents().forEach(component -> {
            GridBagConstraints constraints = this.getInternalConstraints((Component)component);
            if (constraints.gridx == -1 && constraints.gridy == -1) {
                constraints.effectiveY = this.getAvailableRow(0);
                constraints.effectiveX = this.getAvailableColumnByRow(constraints.effectiveY);
            } else if (constraints.gridx == -1) {
                constraints.effectiveY = constraints.gridy;
                constraints.effectiveX = this.getAvailableColumnByRow(constraints.gridy);
            } else if (constraints.gridy == -1) {
                constraints.effectiveX = constraints.gridx;
                constraints.effectiveY = this.getAvailableRowByColumn(constraints.gridx);
            } else {
                constraints.effectiveX = constraints.gridx;
                constraints.effectiveY = constraints.gridy;
            }
            constraints.effectiveWidth = constraints.gridwidth == -2 ? 1 : constraints.gridwidth;
            constraints.effectiveHeight = constraints.gridheight == -2 ? 1 : constraints.gridheight;
            this.updateAvailableColumnByRowMap(constraints);
            this.updateAvailableRowByColumnMap(constraints);
            this.rowCount = Math.max(this.rowCount, constraints.getY1());
            this.columnCount = Math.max(this.columnCount, constraints.getX1());
        });
        this.getComponents().forEach(component -> {
            GridBagConstraints constraints = this.getInternalConstraints((Component)component);
            if (constraints.gridwidth == -2) {
                constraints.effectiveWidth = this.columnCount - constraints.effectiveX;
            }
            if (constraints.gridheight == -2) {
                constraints.effectiveHeight = this.rowCount - constraints.effectiveY;
            }
            this.setComponentPosition((Component)component, constraints);
        });
    }

    private int getAvailableRow(int startRow) {
        int row = startRow;
        while (this.availableColumnByRowMap.getOrDefault(row, 0) == -2) {
            ++row;
        }
        return row;
    }

    private int getAvailableRowByColumn(int column) {
        int row = this.availableRowByColumnMap.getOrDefault(column, 0);
        return row == -2 ? 0 : row;
    }

    private int getAvailableColumnByRow(int row) {
        int column = this.availableColumnByRowMap.getOrDefault(row, 0);
        return column == -2 ? 0 : column;
    }

    private void updateAvailableColumnByRowMap(GridBagConstraints constraints) {
        for (int row = constraints.getY0(); row < constraints.getY1(); ++row) {
            int column = this.availableColumnByRowMap.getOrDefault(row, 0);
            if (constraints.gridwidth == -2) {
                column = -2;
            }
            if (column != -2) {
                column = Math.max(column, constraints.getX1());
            }
            this.availableColumnByRowMap.put(row, column);
        }
    }

    private void updateAvailableRowByColumnMap(GridBagConstraints constraints) {
        for (int column = constraints.getX0(); column < constraints.getX1(); ++column) {
            int row = this.availableRowByColumnMap.getOrDefault(column, 0);
            if (constraints.gridheight == -2) {
                row = -2;
            }
            if (row != -2) {
                row = Math.max(row, constraints.getY1());
            }
            this.availableRowByColumnMap.put(column, row);
        }
    }

    private void setComponentPosition(Component component, GridBagConstraints constraints) {
        component.getStyle().set("--vfp-grid-column", String.format("%d / %d", constraints.getX0() + 1, constraints.getX1() + 1));
        component.getStyle().set("--vfp-grid-row", String.format("%d / %d", constraints.getY0() + 1, constraints.getY1() + 1));
    }

    private void setComponentFill(Component component, GridBagConstraints constraints) {
        String fill;
        switch (constraints.fill) {
            case 2: {
                String string = "horizontal";
                break;
            }
            case 3: {
                String string = "vertical";
                break;
            }
            case 1: {
                String string = "both";
                break;
            }
            default: {
                String string = fill = null;
            }
        }
        if (fill != null) {
            component.getElement().setAttribute("vfp-fill", fill);
        } else {
            component.getElement().removeAttribute("vfp-fill");
        }
    }

    private void setComponentAnchor(Component component, GridBagConstraints constraints) {
        switch (constraints.anchor) {
            case 19: {
                component.getStyle().set("--vfp-align-self", "start");
                component.getStyle().set("--vfp-justify-self", "center");
                break;
            }
            case 20: {
                component.getStyle().set("--vfp-align-self", "end");
                component.getStyle().set("--vfp-justify-self", "center");
                break;
            }
            case 21: {
                component.getStyle().set("--vfp-align-self", "center");
                component.getStyle().set("--vfp-justify-self", "start");
                break;
            }
            case 22: {
                component.getStyle().set("--vfp-align-self", "center");
                component.getStyle().set("--vfp-justify-self", "end");
                break;
            }
            case 23: {
                component.getStyle().set("--vfp-align-self", "start");
                component.getStyle().set("--vfp-justify-self", "start");
                break;
            }
            case 24: {
                component.getStyle().set("--vfp-align-self", "start");
                component.getStyle().set("--vfp-justify-self", "end");
                break;
            }
            case 25: {
                component.getStyle().set("--vfp-align-self", "end");
                component.getStyle().set("--vfp-justify-self", "start");
                break;
            }
            case 26: {
                component.getStyle().set("--vfp-align-self", "end");
                component.getStyle().set("--vfp-justify-self", "end");
                break;
            }
            default: {
                component.getStyle().remove("--vfp-align-self");
                component.getStyle().remove("--vfp-justify-self");
            }
        }
    }

    private void setComponentInsets(Component component, GridBagConstraints constraints) {
        Insets insets = constraints.insets;
        if (insets.left > 0 || insets.right > 0 || insets.top > 0 || insets.bottom > 0) {
            component.getStyle().set("--vfp-margin-top", String.format("%dpx", insets.top));
            component.getStyle().set("--vfp-margin-right", String.format("%dpx", insets.right));
            component.getStyle().set("--vfp-margin-bottom", String.format("%dpx", insets.bottom));
            component.getStyle().set("--vfp-margin-left", String.format("%dpx", insets.left));
        } else {
            component.getStyle().remove("--vfp-margin-top");
            component.getStyle().remove("--vfp-margin-right");
            component.getStyle().remove("--vfp-margin-bottom");
            component.getStyle().remove("--vfp-margin-left");
        }
    }

    private void setComponentIpad(Component component, GridBagConstraints constraints) {
        if (constraints.ipadx > 0) {
            component.getStyle().set("--vfp-padding-width", String.format("%dpx", constraints.ipadx));
        } else {
            component.getStyle().remove("--vfp-padding-width");
        }
        if (constraints.ipady > 0) {
            component.getStyle().set("--vfp-padding-height", String.format("%dpx", constraints.ipady));
        } else {
            component.getStyle().remove("--vfp-padding-height");
        }
    }

    public Object getConstraints(Component component) {
        GridBagConstraints constraints = this.constraintMap.get(component);
        return constraints == null ? new GridBagConstraints() : constraints.clone();
    }

    private GridBagConstraints getInternalConstraints(Component component) {
        GridBagConstraints constraints = this.constraintMap.get(component);
        return constraints == null ? new GridBagConstraints() : constraints;
    }
}

