/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop.layouts;

import com.vaadin.featurepack.desktop.layouts.AbstractLayout;
import com.vaadin.featurepack.desktop.layouts.BaseFlowLayout;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;

public class FlowLayout
extends AbstractLayout {
    BaseFlowLayout baseFlowLayout;

    public FlowLayout() {
        this.baseFlowLayout = new BaseFlowLayout(0, 5, 5);
    }

    public FlowLayout(int align) {
        this.baseFlowLayout = new BaseFlowLayout(align, 5, 5);
    }

    public FlowLayout(int align, int hgap, int vgap) {
        this.baseFlowLayout = new BaseFlowLayout(align, hgap, vgap);
        this.baseFlowLayout.setAlignment(align, this.getContainer());
    }

    protected void onContainerAttach(AttachEvent event) {
        event.getUI().getPage().addStyleSheet("vfp-flow-layout.css");
    }

    public void setContainer(Component container) {
        Component current = this.getContainer();
        if (current != null) {
            current.getElement().removeAttribute("vfp-flow-layout");
            current.getStyle().remove("--vfp-justify-content");
            current.getStyle().remove("--vfp-horizontal-gap");
            current.getStyle().remove("--vfp-vertical-gap");
        }
        super.setContainer(container);
        if (container != null) {
            container.getElement().setAttribute("vfp-flow-layout", "");
            this.updateHgap();
            this.updateVgap();
            this.baseFlowLayout.updateAlignment(this.getContainer());
        }
    }

    public int getHgap() {
        return this.baseFlowLayout.getHorizontalGap();
    }

    public void setHgap(int hgap) {
        this.baseFlowLayout.setHorizontalGap(hgap);
        this.updateHgap();
    }

    private void updateHgap() {
        Component container = this.getContainer();
        if (container != null) {
            container.getStyle().set("--vfp-horizontal-gap", this.baseFlowLayout.getHorizontalGap() + "px");
        }
    }

    public int getVgap() {
        return this.baseFlowLayout.getVerticalGap();
    }

    public void setVgap(int vgap) {
        this.baseFlowLayout.setVerticalGap(vgap);
        this.updateVgap();
    }

    private void updateVgap() {
        Component container = this.getContainer();
        if (container != null) {
            container.getStyle().set("--vfp-vertical-gap", this.baseFlowLayout.getVerticalGap() + "px");
        }
    }

    public void setConstraints(Component component, Object constraints) {
        throw new UnsupportedOperationException("FlowLayout does not support constraints");
    }

    public Object getConstraints(Component component) {
        throw new UnsupportedOperationException("FlowLayout does not support constraints");
    }

    public void setAlignment(int align) {
        this.baseFlowLayout.setAlignment(align, this.getContainer());
    }

    public int getAlignment() {
        return this.baseFlowLayout.getAlignment();
    }
}

