/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop.layouts;

import com.vaadin.featurepack.desktop.AbstractContainer;
import com.vaadin.featurepack.desktop.ComponentGeometryUtil;
import com.vaadin.featurepack.desktop.geometry.Dimension;
import com.vaadin.featurepack.desktop.layouts.LayoutManager;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.page.BrowserWindowResizeEvent;
import com.vaadin.flow.component.page.BrowserWindowResizeListener;
import com.vaadin.flow.component.splitlayout.SplitLayout;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class CustomLayoutResizeListener
implements BrowserWindowResizeListener,
ComponentEventListener<Dialog.DialogResizeEvent> {
    private Map<AbstractContainer, LayoutManager> registrations = new HashMap<AbstractContainer, LayoutManager>();
    private Map<SplitLayout, Registration> splitLayouts = new HashMap<SplitLayout, Registration>();

    public void register(AbstractContainer container, LayoutManager layout) {
        this.registrations.put(container, layout);
    }

    private LinkedList<AbstractContainer> findToCalculate() {
        return this.findToCalculate((Component)UI.getCurrent());
    }

    private LinkedList<AbstractContainer> findToCalculate(Component root) {
        LinkedList<AbstractContainer> result = new LinkedList<AbstractContainer>();
        for (Component children : root.getChildren().toList()) {
            this.fill(result, children);
            this.findToCalculate(result, children);
        }
        return result;
    }

    private void findToCalculate(List<AbstractContainer> result, Component root) {
        for (Component children : root.getChildren().toList()) {
            this.fill(result, children);
            this.findToCalculate(result, children);
        }
    }

    private void fill(List<AbstractContainer> result, Component children) {
        SplitLayout childSplit;
        if (children instanceof AbstractContainer && this.registrations.containsKey(children)) {
            result.add((AbstractContainer)children);
        }
        if (children instanceof SplitLayout && !this.splitLayouts.containsKey(childSplit = (SplitLayout)children)) {
            Registration reg = childSplit.addSplitterDragEndListener((ComponentEventListener & Serializable)o -> {
                LinkedList<AbstractContainer> toResize = this.findToCalculate((Component)childSplit);
                this.resizeAll(toResize, true);
            });
            this.splitLayouts.put(childSplit, reg);
            childSplit.addDetachListener((ComponentEventListener & Serializable)o -> {
                reg.remove();
                this.splitLayouts.remove(childSplit);
            });
        }
    }

    public void browserWindowResized(BrowserWindowResizeEvent event) {
        System.out.println("Window (BrowserWindow) resized " + String.valueOf(event) + " " + event.getWidth() + " " + event.getHeight());
        LinkedList<AbstractContainer> toResize = this.findToCalculate();
        System.out.println("Containers to resize " + String.valueOf(toResize));
        this.resizeAll(toResize, true);
    }

    private void resizeAll(LinkedList<AbstractContainer> toResize, boolean first) {
        toResize.getFirst().getElement().executeJs("return [$0.clientWidth,$0.clientHeight]", new Object[]{toResize.getFirst().getElement()}).then((SerializableConsumer & Serializable)val -> {
            try {
                String size = val.asString();
                int width = (int)Double.valueOf(size.split(",")[0].trim()).doubleValue();
                int height = (int)Double.valueOf(size.split(",")[1].trim()).doubleValue();
                ComponentGeometryUtil.setSize((Component)toResize.getFirst(), new Dimension(width, height));
                this.registrations.get(toResize.getFirst()).layoutContainer((Component)toResize.getFirst());
                if (first || ((AbstractContainer)toResize.getFirst()).getParent().get() instanceof SplitLayout) {
                    ((AbstractContainer)toResize.getFirst()).setSizeFull();
                }
                toResize.removeFirst();
                if (!toResize.isEmpty()) {
                    this.resizeAll(toResize, false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void onComponentEvent(Dialog.DialogResizeEvent event) {
        System.out.println("Window (BrowserWindow) resized " + String.valueOf(event) + " " + event.getWidth() + " " + event.getHeight());
        LinkedList<AbstractContainer> toResize = this.findToCalculate(event.getSource());
        System.out.println("Containers to resize " + String.valueOf(toResize));
        this.resizeAll(toResize, true);
    }
}

