/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop.layouts;

import com.vaadin.featurepack.desktop.layouts.AbstractLayout;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import java.util.Objects;

public class BorderLayout
extends AbstractLayout {
    private int horizontalGap = 0;
    private int verticalGap = 0;
    public static final String CENTER = "center";
    public static final String PAGE_START = "page-start";
    public static final String PAGE_END = "page-end";
    public static final String LINE_START = "line-start";
    public static final String LINE_END = "line-end";

    public BorderLayout() {
        this(0, 0);
    }

    public BorderLayout(int hgap, int vgap) {
        this.setHgap(hgap);
        this.setVgap(vgap);
    }

    protected void onContainerAttach(AttachEvent event) {
        event.getUI().getPage().addStyleSheet("vfp-border-layout.css");
    }

    public void setContainer(Component container) {
        Component current = this.getContainer();
        if (current != null) {
            current.getElement().removeAttribute("vfp-border-layout");
            current.getStyle().remove("--vfp-horizontal-gap");
            current.getStyle().remove("--vfp-vertical-gap");
            current.getChildren().forEach(child -> child.getElement().removeAttribute("vfp-border-layout-region"));
        }
        super.setContainer(container);
        if (container != null) {
            container.getElement().setAttribute("vfp-border-layout", "");
            this.updateHgap();
            this.updateVgap();
        }
    }

    public void addComponent(Component component) {
        Objects.requireNonNull(component, "Component must not be null");
        this.setConstraints(component, CENTER);
    }

    public void removeComponent(Component component) {
        Objects.requireNonNull(component, "Component must not be null");
        component.getElement().removeAttribute("vfp-border-layout-region");
    }

    public void setConstraints(Component component, Object constraints) {
        Objects.requireNonNull(component, "Component must not be null");
        if (constraints != null && !(constraints instanceof String)) {
            throw new IllegalArgumentException("Constraints must be a String or null");
        }
        String region = (String)constraints;
        if (region == null) {
            region = CENTER;
        }
        component.getElement().setAttribute("vfp-border-layout-region", region);
    }

    public Object getConstraints(Component component) {
        Objects.requireNonNull(component, "Component must not be null");
        String region = component.getElement().getAttribute("vfp-border-layout-region");
        if (region == null) {
            region = CENTER;
        }
        return region;
    }

    public int getHgap() {
        return this.horizontalGap;
    }

    public void setHgap(int hgap) {
        this.horizontalGap = hgap;
        this.updateHgap();
    }

    private void updateHgap() {
        Component container = this.getContainer();
        if (container != null) {
            container.getStyle().set("--vfp-horizontal-gap", this.horizontalGap + "px");
        }
    }

    public int getVgap() {
        return this.verticalGap;
    }

    public void setVgap(int vgap) {
        this.verticalGap = vgap;
        this.updateVgap();
    }

    private void updateVgap() {
        Component container = this.getContainer();
        if (container != null) {
            container.getStyle().set("--vfp-vertical-gap", this.verticalGap + "px");
        }
    }
}

