/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop;

import com.vaadin.featurepack.desktop.AbstractContainer;
import com.vaadin.featurepack.desktop.Panel;
import com.vaadin.featurepack.desktop.layouts.AbstractLayout;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.dom.Element;
import java.util.Objects;

@Tag(value="div")
@StyleSheet(value="context://vfp-root-container.css")
public class RootContainer
extends AbstractContainer {
    private Component contentContainer;
    private Component menuBar;

    public RootContainer() {
        this.getElement().setAttribute("vfp-root-container", "");
        this.setLayout(new RootContainerLayout());
        this.setContentContainer(new Panel());
    }

    public void setMenuBar(Component menuBar) {
        if (this.menuBar != null) {
            this.menuBar.getElement().removeAttribute("vfp-root-container-menu-bar");
            this.getElement().removeChild(new Element[]{this.menuBar.getElement()});
        }
        this.menuBar = menuBar;
        if (menuBar != null) {
            this.menuBar.getElement().setAttribute("vfp-root-container-menu-bar", "");
            this.getElement().insertChild(0, new Element[]{this.menuBar.getElement()});
        }
    }

    public Component getMenuBar() {
        return this.menuBar;
    }

    public void setContentContainer(Component contentContainer) {
        Objects.requireNonNull(contentContainer, "contentContainer must not be null");
        if (this.contentContainer != null) {
            this.contentContainer.getElement().removeAttribute("vfp-root-container-content");
            this.getElement().removeChild(new Element[]{this.contentContainer.getElement()});
        }
        this.contentContainer = contentContainer;
        this.contentContainer.getElement().setAttribute("vfp-root-container-content", "");
        this.getElement().appendChild(new Element[]{this.contentContainer.getElement()});
    }

    public Component getContentContainer() {
        return this.contentContainer;
    }

    public static class RootContainerLayout
    extends AbstractLayout {
        public void setConstraints(Component component, Object constraints) {
            throw new UnsupportedOperationException("RootContainerLayout does not support constraints");
        }

        public Object getConstraints(Component component) {
            throw new UnsupportedOperationException("RootContainerLayout does not support constraints");
        }
    }
}

