/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.data.util.filter;

import com.vaadin.featurepack.data.Container;
import com.vaadin.featurepack.data.Item;
import com.vaadin.featurepack.data.Property;

public final class SimpleStringFilter
implements Container.Filter {
    final Object propertyId;
    final String filterString;
    final boolean ignoreCase;
    final boolean onlyMatchPrefix;

    public SimpleStringFilter(Object propertyId, String filterString, boolean ignoreCase, boolean onlyMatchPrefix) {
        this.propertyId = propertyId;
        this.filterString = ignoreCase ? filterString.toLowerCase() : filterString;
        this.ignoreCase = ignoreCase;
        this.onlyMatchPrefix = onlyMatchPrefix;
    }

    @Override
    public boolean passesFilter(Object itemId, Item item) {
        String value;
        Property p = item.getItemProperty(this.propertyId);
        if (p == null) {
            return false;
        }
        Object propertyValue = p.getValue();
        if (propertyValue == null) {
            return false;
        }
        String string = value = this.ignoreCase ? propertyValue.toString().toLowerCase() : propertyValue.toString();
        return !(this.onlyMatchPrefix ? !value.startsWith(this.filterString) : !value.contains(this.filterString));
    }

    @Override
    public boolean appliesToProperty(Object propertyId) {
        return this.propertyId.equals(propertyId);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleStringFilter)) {
            return false;
        }
        SimpleStringFilter o = (SimpleStringFilter)obj;
        if (this.propertyId != o.propertyId && o.propertyId != null && !o.propertyId.equals(this.propertyId)) {
            return false;
        }
        if (this.filterString != o.filterString && o.filterString != null && !o.filterString.equals(this.filterString)) {
            return false;
        }
        if (this.ignoreCase != o.ignoreCase) {
            return false;
        }
        return this.onlyMatchPrefix == o.onlyMatchPrefix;
    }

    public int hashCode() {
        return (this.propertyId != null ? this.propertyId.hashCode() : 0) ^ (this.filterString != null ? this.filterString.hashCode() : 0);
    }

    public Object getPropertyId() {
        return this.propertyId;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public boolean isOnlyMatchPrefix() {
        return this.onlyMatchPrefix;
    }
}

