/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.data.fieldgroup;

import com.vaadin.featurepack.data.Item;
import com.vaadin.featurepack.data.fieldgroup.FieldGroup;
import com.vaadin.featurepack.data.fieldgroup.FieldGroupFieldFactory;
import com.vaadin.featurepack.data.ui.Field;
import com.vaadin.featurepack.data.ui.Select;
import com.vaadin.featurepack.ui.FAbstractComponent;
import com.vaadin.featurepack.ui.FAbstractTextField;
import com.vaadin.featurepack.ui.FCheckBox;
import com.vaadin.featurepack.ui.FComboBox;
import com.vaadin.featurepack.ui.FListSelect;
import com.vaadin.featurepack.ui.FTextField;
import com.vaadin.featurepack.ui.Table;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.textfield.TextFieldBase;
import java.util.EnumSet;

public class DefaultFieldGroupFieldFactory
implements FieldGroupFieldFactory {
    private static final DefaultFieldGroupFieldFactory INSTANCE = new DefaultFieldGroupFieldFactory();
    public static final Object CAPTION_PROPERTY_ID = "Caption";

    protected DefaultFieldGroupFieldFactory() {
    }

    public static DefaultFieldGroupFieldFactory get() {
        return INSTANCE;
    }

    @Override
    public <T extends Field> T createField(Class<?> type, Class<T> fieldType) {
        if (Enum.class.isAssignableFrom(type)) {
            return this.createEnumField(type, fieldType);
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
            return this.createBooleanField(fieldType);
        }
        if (TextFieldBase.class.isAssignableFrom(fieldType)) {
            return (T)((Field)fieldType.cast(this.createAbstractTextField(fieldType.asSubclass(TextFieldBase.class))));
        }
        return this.createDefaultField(type, fieldType);
    }

    private <T extends Field> T createEnumField(Class<?> type, Class<T> fieldType) {
        Class<Object> selectClass = null;
        if (Select.class.isAssignableFrom(fieldType)) {
            selectClass = fieldType;
        } else if (this.anySelect(fieldType)) {
            selectClass = Select.class;
        }
        if (selectClass != null) {
            Select s = this.createCompatibleSelect(selectClass);
            this.populateWithEnumData(s, type);
            return (T)s;
        }
        if (FAbstractTextField.class.isAssignableFrom(fieldType)) {
            return (T)((Field)this.createAbstractTextField(fieldType));
        }
        return null;
    }

    protected Select createCompatibleSelect(Class<?> fieldType) {
        FAbstractComponent select;
        if (fieldType.isAssignableFrom(FListSelect.class)) {
            select = new FListSelect();
            select.setMultiSelect(false);
        } else if (fieldType.isAssignableFrom(Table.class)) {
            Table t = new Table();
            t.setSelectable(true);
            select = t;
        } else {
            select = new FComboBox(null);
        }
        select.setNullSelectionAllowed(false);
        return select;
    }

    protected boolean anyField(Class<?> fieldType) {
        return fieldType == Field.class || fieldType == AbstractField.class;
    }

    protected boolean anySelect(Class<? extends Field> fieldType) {
        return this.anyField(fieldType) || fieldType == Select.class;
    }

    protected <T extends Field> T createBooleanField(Class<T> fieldType) {
        if (fieldType.isAssignableFrom(FCheckBox.class)) {
            FCheckBox cb = new FCheckBox(null);
            return (T)cb;
        }
        if (TextFieldBase.class.isAssignableFrom(fieldType)) {
            return (T)((Field)this.createAbstractTextField(fieldType));
        }
        return null;
    }

    protected <T extends TextFieldBase> T createAbstractTextField(Class<T> fieldType) {
        if (fieldType == TextFieldBase.class) {
            fieldType = FTextField.class;
        }
        try {
            TextFieldBase field = (TextFieldBase)fieldType.newInstance();
            return (T)field;
        }
        catch (Exception e) {
            throw new FieldGroup.BindException("Could not create a field of type " + String.valueOf(fieldType), e);
        }
    }

    protected <T extends Field> T createDefaultField(Class<?> type, Class<T> fieldType) {
        if (fieldType.isAssignableFrom(FTextField.class)) {
            return (T)((Field)fieldType.cast(this.createAbstractTextField(FTextField.class)));
        }
        return null;
    }

    protected void populateWithEnumData(Select select, Class<? extends Enum> enumClass) {
        select.removeAllItems();
        for (Object p : select.getContainerPropertyIds()) {
            select.removeContainerProperty(p);
        }
        select.addContainerProperty(CAPTION_PROPERTY_ID, String.class, "");
        select.setItemCaptionPropertyId(CAPTION_PROPERTY_ID);
        EnumSet<? extends Enum> enumSet = EnumSet.allOf(enumClass);
        for (Object e : enumSet) {
            Item newItem = select.addItem(e);
            newItem.getItemProperty(CAPTION_PROPERTY_ID).setValue(e.toString());
        }
    }
}

