/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.data.converter;

import com.vaadin.featurepack.data.converter.AbstractStringToNumberConverter;
import com.vaadin.featurepack.data.converter.Converter;
import java.text.NumberFormat;
import java.util.Locale;

public class StringToShortConverter
extends AbstractStringToNumberConverter<Short> {
    @Override
    protected NumberFormat getFormat(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return NumberFormat.getIntegerInstance(locale);
    }

    @Override
    public Short convertToModel(String value, Class<? extends Short> targetType, Locale locale) throws Converter.ConversionException {
        Number n = this.convertToNumber(value, targetType, locale);
        if (n == null) {
            return null;
        }
        short shortValue = n.shortValue();
        if ((long)shortValue == n.longValue()) {
            return shortValue;
        }
        throw new Converter.ConversionException("Could not convert '" + value + "' to " + Short.class.getName() + ": value out of range");
    }

    @Override
    public Class<Short> getModelType() {
        return Short.class;
    }
}

