/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.data.converter;

import com.vaadin.featurepack.data.converter.AbstractStringToNumberConverter;
import com.vaadin.featurepack.data.converter.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class StringToBigIntegerConverter
extends AbstractStringToNumberConverter<BigInteger> {
    @Override
    protected NumberFormat getFormat(Locale locale) {
        NumberFormat numberFormat = super.getFormat(locale);
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).setParseBigDecimal(true);
        }
        return numberFormat;
    }

    @Override
    public BigInteger convertToModel(String value, Class<? extends BigInteger> targetType, Locale locale) throws Converter.ConversionException {
        BigDecimal bigDecimalValue = (BigDecimal)this.convertToNumber(value, BigDecimal.class, locale);
        return bigDecimalValue != null ? bigDecimalValue.toBigInteger() : null;
    }

    @Override
    public Class<BigInteger> getModelType() {
        return BigInteger.class;
    }
}

