/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.data.converter;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValueContext;
import java.io.Serializable;
import java.util.Locale;

public interface Converter<PRESENTATION, MODEL>
extends Serializable,
com.vaadin.flow.data.converter.Converter<PRESENTATION, MODEL> {
    default public Result<MODEL> convertToModel(PRESENTATION value, ValueContext context) {
        try {
            MODEL result = this.convertToModel(value, this.getModelType(), this.getLocale(context));
            return Result.ok(result);
        }
        catch (ConversionException e) {
            return Result.error((String)e.getMessage());
        }
    }

    default public PRESENTATION convertToPresentation(MODEL value, ValueContext context) {
        return this.convertToPresentation(value, this.getPresentationType(), this.getLocale(context));
    }

    private Locale getLocale(ValueContext context) {
        if (context != null) {
            return context.getLocale().orElse(UI.getCurrent().getLocale());
        }
        return UI.getCurrent().getLocale();
    }

    public MODEL convertToModel(PRESENTATION var1, Class<? extends MODEL> var2, Locale var3) throws ConversionException;

    public PRESENTATION convertToPresentation(MODEL var1, Class<? extends PRESENTATION> var2, Locale var3) throws ConversionException;

    public Class<MODEL> getModelType();

    public Class<PRESENTATION> getPresentationType();

    public static class ConversionException
    extends RuntimeException {
        public ConversionException() {
        }

        public ConversionException(String msg) {
            super(msg);
        }

        public ConversionException(Throwable cause) {
            super(cause);
        }

        public ConversionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

