/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.data.converter;

import com.vaadin.featurepack.data.converter.Converter;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public abstract class AbstractStringToNumberConverter<T>
implements Converter<String, T> {
    protected NumberFormat getFormat(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return NumberFormat.getNumberInstance(locale);
    }

    protected Number convertToNumber(String value, Class<? extends Number> targetType, Locale locale) throws Converter.ConversionException {
        if (value == null) {
            return null;
        }
        value = value.trim();
        ParsePosition parsePosition = new ParsePosition(0);
        Number parsedValue = this.getFormat(locale).parse(value, parsePosition);
        if (parsePosition.getIndex() != value.length()) {
            throw new Converter.ConversionException("Could not convert '" + value + "' to " + this.getModelType().getName());
        }
        if (parsedValue == null) {
            return null;
        }
        return parsedValue;
    }

    @Override
    public String convertToPresentation(T value, Class<? extends String> targetType, Locale locale) throws Converter.ConversionException {
        if (value == null) {
            return null;
        }
        return this.getFormat(locale).format(value);
    }

    @Override
    public Class<String> getPresentationType() {
        return String.class;
    }
}

