/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.data;

import com.vaadin.featurepack.server.AbstractErrorMessage;
import java.io.Serializable;

public interface Validator
extends Serializable {
    public void validate(Object var1) throws InvalidValueException;

    public static class EmptyValueException
    extends InvalidValueException {
        public EmptyValueException(String message) {
            super(message);
        }
    }

    public static class InvalidValueException
    extends RuntimeException {
        private InvalidValueException[] causes = null;

        public InvalidValueException(String message) {
            this(message, new InvalidValueException[0]);
        }

        public InvalidValueException(String message, InvalidValueException ... causes) {
            super(message);
            if (causes == null) {
                throw new NullPointerException("Possible causes array must not be null");
            }
            this.causes = causes;
        }

        public boolean isInvisible() {
            String msg = this.getMessage();
            if (msg != null && msg.length() > 0) {
                return false;
            }
            if (this.causes != null) {
                for (int i = 0; i < this.causes.length; ++i) {
                    if (this.causes[i].isInvisible()) continue;
                    return false;
                }
            }
            return true;
        }

        public String getHtmlMessage() {
            return AbstractErrorMessage.safeEscapeForHtml(this.getLocalizedMessage());
        }

        public InvalidValueException[] getCauses() {
            return this.causes;
        }
    }
}

