/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.util;

import com.vaadin.featurepack.server.AbstractErrorMessage;
import com.vaadin.featurepack.shared.ui.ContentMode;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.popover.Popover;
import com.vaadin.flow.component.shared.HasTooltip;
import com.vaadin.flow.component.shared.Tooltip;
import com.vaadin.flow.dom.Element;
import java.lang.reflect.Field;

public class TooltipUtils {
    public static boolean hasTooltip(Component component) {
        return ComponentUtil.getData((Component)component, (String)"tooltip") != null;
    }

    public static void setDescription(Component component, String description) {
        TooltipUtils.setDescription(component, description, ContentMode.PREFORMATTED);
    }

    public static void setDescription(Component component, String description, ContentMode mode) {
        if (component == null) {
            return;
        }
        TooltipUtils.setDescriptionValue(component, description);
        TooltipUtils.setDescriptionContentMode(component, mode);
    }

    public static void setTooltip(Component component, String description, ContentMode mode) {
        TooltipUtils.setupPopover(component, description, mode);
    }

    private static void setupTooltip(Component component, String description, ContentMode mode) {
        if (!(component instanceof HasTooltip)) {
            return;
        }
        HasTooltip hasTooltip = (HasTooltip)component;
        Tooltip tooltip = null;
        switch (mode) {
            case HTML: {
                tooltip = hasTooltip.setTooltipText("<span>" + description + "</span>");
                break;
            }
            case PREFORMATTED: {
                tooltip = hasTooltip.setTooltipText("<pre>" + description + "</pre>");
                break;
            }
            default: {
                hasTooltip.setTooltipText(description);
            }
        }
        if (tooltip != null) {
            try {
                Field field = tooltip.getClass().getDeclaredField("tooltipElement");
                field.setAccessible(true);
                ((Element)field.get(tooltip)).executeJs("function htmlTooltipRenderer(root) {\n      var contentInHTML = this.text;\n      if (contentInHTML !== undefined) {\n          root.innerHTML = contentInHTML;\n      } else {\n          root.textContent = \"\";\n      }\n  };\nthis._renderer = htmlTooltipRenderer.bind(this);\n", new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void setupPopover(Component component, String description, ContentMode mode) {
        Popover popover = TooltipUtils.getPopover(component);
        if (mode == null && description == null) {
            if (popover != null) {
                popover.removeFromParent();
            }
            TooltipUtils.setPopover(component, null);
            return;
        }
        if (popover == null) {
            popover = new Popover();
            popover.setOpenOnClick(false);
            popover.setOpenOnHover(true);
            popover.setTarget(component);
            TooltipUtils.setPopover(component, popover);
        } else {
            popover.removeAll();
        }
        switch (mode) {
            case HTML: {
                popover.add(new Component[]{new Html("<span>" + description + "</span>")});
                break;
            }
            case PREFORMATTED: {
                popover.add(new Component[]{new Html("<pre>" + description + "</pre>")});
                break;
            }
            default: {
                popover.add(new Component[]{new Text(description)});
            }
        }
    }

    public static String getDescription(Component component) {
        if (component != null) {
            return (String)ComponentUtil.getData((Component)component, (String)"tooltip-description");
        }
        return null;
    }

    public static void setDescriptionValue(Component component, String description) {
        if (component != null) {
            ComponentUtil.setData((Component)component, (String)"tooltip-description", (Object)description);
        }
    }

    public static ContentMode getDescriptionContentMode(Component component) {
        if (component != null) {
            return (ContentMode)((Object)ComponentUtil.getData((Component)component, (String)"tooltip-descriptionContentMode"));
        }
        return null;
    }

    public static void setDescriptionContentMode(Component component, ContentMode descriptionContentMode) {
        if (component != null) {
            ComponentUtil.setData((Component)component, (String)"tooltip-descriptionContentMode", (Object)((Object)descriptionContentMode));
        }
    }

    public static Popover getPopover(Component component) {
        if (component != null) {
            return (Popover)ComponentUtil.getData((Component)component, (String)"tooltip-popover");
        }
        return null;
    }

    public static void setPopover(Component component, Popover popover) {
        if (component != null) {
            ComponentUtil.setData((Component)component, (String)"tooltip-popover", (Object)popover);
        }
    }

    public static String getFormattedMessage(String message, ContentMode mode) {
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case ContentMode.TEXT -> AbstractErrorMessage.safeEscapeForHtml(message);
            case ContentMode.PREFORMATTED -> "<pre>" + AbstractErrorMessage.safeEscapeForHtml(message) + "</pre>";
            case ContentMode.HTML -> message;
        };
    }
}

