/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.util;

import com.vaadin.featurepack.shared.ui.BorderStyle;
import com.vaadin.featurepack.util.V8Utils;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WebBrowser;
import java.io.Serializable;
import java.util.Objects;

public class PageUtils {
    public static WebBrowser getWebBrowser() {
        return VaadinSession.getCurrent().getBrowser();
    }

    public static WebBrowser getWebBrowser(Page p) {
        return PageUtils.getWebBrowser();
    }

    public static int getBrowserWindowHeight() {
        if (UI.getCurrent().getInternals().getExtendedClientDetails() != null) {
            return UI.getCurrent().getInternals().getExtendedClientDetails().getWindowInnerHeight();
        }
        return -1;
    }

    public static int getBrowserWindowHeight(Page p) {
        return PageUtils.getBrowserWindowHeight();
    }

    public static int getBrowserWindowWidth() {
        if (UI.getCurrent().getInternals().getExtendedClientDetails() != null) {
            return UI.getCurrent().getInternals().getExtendedClientDetails().getWindowInnerWidth();
        }
        return -1;
    }

    public static int getBrowserWindowWidth(Page p) {
        return PageUtils.getBrowserWindowWidth();
    }

    public static String getUriFragment() {
        return (String)ComponentUtil.getData((Component)UI.getCurrent(), (String)"uriFragment");
    }

    public static String getUriFragment(Page p) {
        return PageUtils.getUriFragment();
    }

    public static void setUriFragment(String newUriFragment) {
        PageUtils.setUriFragment(newUriFragment, true);
        PageUtils.initHashchangeEventListener();
    }

    public static void setUriFragment(Page p, String newUriFragment) {
        PageUtils.setUriFragment(newUriFragment);
    }

    public static void addUriFragmentChangedListener(UriFragmentChangedListener listener) {
        ComponentUtil.addListener((Component)UI.getCurrent(), UriFragmentChangedEvent.class, (ComponentEventListener)listener);
        PageUtils.initHashchangeEventListener();
    }

    public static void addUriFragmentChangedListener(Page p, UriFragmentChangedListener listener) {
        PageUtils.addUriFragmentChangedListener(listener);
    }

    public static void initHashchangeEventListener() {
        if (ComponentUtil.getData((Component)UI.getCurrent(), (String)"hashchangeListener") == null) {
            ComponentUtil.setData((Component)UI.getCurrent(), (String)"hashchangeListener", (Object)UI.getCurrent().getElement().addEventListener("flowhashchange", (DomEventListener & Serializable)event -> {
                String uriFragment = (String)ComponentUtil.getData((Component)UI.getCurrent(), (String)"uriFragment");
                uriFragment = uriFragment.substring(uriFragment.indexOf("#") + 1);
                ComponentUtil.setData((Component)UI.getCurrent(), (String)"uriFragment", (Object)uriFragment);
            }).addEventData("event.detail"));
            UI.getCurrent().getElement().executeJs("window.addEventListener('hashchange', function(event) { $0.dispatchEvent(new CustomEvent('flowhashchange', { detail: event.newURL })); })", new Object[]{UI.getCurrent()});
        }
    }

    public static void removeUriFragmentChangedListener(UriFragmentChangedListener listener) {
        V8Utils.removeListener((Component)UI.getCurrent(), listener);
    }

    public static void removeUriFragmentChangedListener(Page p, UriFragmentChangedListener listener) {
        PageUtils.removeUriFragmentChangedListener(listener);
    }

    public static void setUriFragment(String newUriFragment, boolean fireEvents) {
        String oldUriFragment = PageUtils.getUriFragment();
        if (newUriFragment == null && oldUriFragment != null) {
            newUriFragment = "";
        }
        if (Objects.equals(newUriFragment, oldUriFragment)) {
            return;
        }
        UI.getCurrent().getPage().executeJs("window.location.hash = $0", new Object[]{newUriFragment});
        ComponentUtil.setData((Component)UI.getCurrent(), (String)"uriFragment", (Object)newUriFragment);
        if (fireEvents) {
            ComponentUtil.fireEvent((Component)UI.getCurrent(), (ComponentEvent)new UriFragmentChangedEvent(UI.getCurrent().getPage(), newUriFragment));
        }
    }

    public static void setUriFragment(Page p, String newUriFragment, boolean fireEvents) {
        PageUtils.setUriFragment(newUriFragment, fireEvents);
    }

    public static void open(String url, String windowName) {
        PageUtils.open(url, windowName, true);
    }

    public static void open(Page p, String url, String windowName) {
        PageUtils.open(url, windowName);
    }

    public static void open(String url, String windowName, boolean tryToOpenAsPopup) {
        if (tryToOpenAsPopup) {
            PageUtils.open(url, windowName, -1, -1, BorderStyle.DEFAULT, tryToOpenAsPopup);
        } else {
            UI.getCurrent().getPage().open(url, windowName);
        }
    }

    public static void open(Page p, String url, String windowName, boolean tryToOpenAsPopup) {
        PageUtils.open(url, windowName, tryToOpenAsPopup);
    }

    public static void open(String url, String windowName, int width, int height, BorderStyle border) {
        PageUtils.open(url, windowName, width, height, border, true);
    }

    public static void open(Page p, String url, String windowName, int width, int height, BorderStyle border) {
        PageUtils.open(url, windowName, width, height, border);
    }

    private static void open(String url, String windowName, int width, int height, BorderStyle border, boolean tryToOpenAsPopup) {
        if (windowName == null) {
            UI.getCurrent().getPage().setLocation(url);
        } else if (windowName.equals("_self")) {
            UI.getCurrent().getPage().setLocation(url);
        } else if (tryToOpenAsPopup) {
            Object options = BorderStyle.MINIMAL.equals((Object)border) ? "menubar=yes,location=no,status=no" : (BorderStyle.NONE.equals((Object)border) ? "menubar=no,location=no,status=no" : "resizable=yes,menubar=yes,toolbar=yes,directories=yes,location=yes,scrollbars=yes,status=yes");
            if (width > 0) {
                options = (String)options + ",width=" + width;
            }
            if (height > 0) {
                options = (String)options + ",height=" + height;
            }
            PageUtils.open(url, windowName, (String)options);
        } else {
            UI.getCurrent().getPage().open(url, windowName);
        }
    }

    private static void open(String url, String windowName, String features) {
        UI.getCurrent().getPage().executeJs("if ($1 == '_self') this.stopApplication(); window.open($0, $1, $2)", new Object[]{url, windowName, features});
    }

    public static class UriFragmentChangedEvent
    extends ComponentEvent<Component> {
        private final String uriFragment;
        private final Page page;

        public UriFragmentChangedEvent(Page source, String uriFragment) {
            super((Component)source.getHistory().getUI(), false);
            this.page = source;
            this.uriFragment = uriFragment;
        }

        public Page getPage() {
            return (Page)this.source;
        }

        public String getUriFragment() {
            return this.uriFragment;
        }
    }

    public static interface UriFragmentChangedListener
    extends ComponentEventListener<UriFragmentChangedEvent> {
        public void uriFragmentChanged(UriFragmentChangedEvent var1);

        default public void onComponentEvent(UriFragmentChangedEvent uriFragmentChangedEvent) {
            this.uriFragmentChanged(uriFragmentChangedEvent);
        }
    }
}

