/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui.renderers;

import com.vaadin.featurepack.data.Item;
import com.vaadin.featurepack.ui.FGrid;
import com.vaadin.featurepack.util.GridRendererAdapter;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.Optional;

public class FComponentRenderer<T>
extends FGrid.AbstractRenderer<T> {
    protected GridRendererAdapter renderer;
    private final ValueProvider<T, Component> componentProvider;

    public FComponentRenderer(Class<T> presentationType, ValueProvider<T, Component> componentProvider) {
        this(presentationType, null, componentProvider);
    }

    public FComponentRenderer(Class<T> presentationType, String nullRepresentation, ValueProvider<T, Component> componentProvider) {
        super(presentationType, nullRepresentation);
        this.componentProvider = componentProvider;
    }

    @Override
    public Renderer<T> getRenderer() {
        if (this.renderer == null) {
            this.renderer = new GridRendererAdapter((ValueProvider & Serializable)item -> item, (Renderer)this.createComponentRenderer(), null){

                @Override
                protected boolean isValueProviderConverted() {
                    return false;
                }
            };
        }
        return this.renderer;
    }

    protected ComponentRenderer<Component, Item> createComponentRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)item -> {
            Object value = item.getItemProperty(this.getPropertyId()).getValue();
            if (this.renderer.getConverter() != null) {
                value = this.renderer.getConverter().convertToPresentation(value, new ValueContext((Binder)null));
            }
            if (value == null) {
                return new Span(Optional.ofNullable(this.getNullRepresentation()).orElse(""));
            }
            return (Component)this.componentProvider.apply(value);
        });
    }
}

