/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui;

import com.vaadin.featurepack.data.Container;
import com.vaadin.featurepack.data.Item;
import com.vaadin.featurepack.data.Property;
import com.vaadin.featurepack.data.ui.Select;
import com.vaadin.featurepack.data.util.IndexedContainer;
import com.vaadin.featurepack.ui.AbstractComponentContainer;
import com.vaadin.featurepack.ui.ItemDescriptionGenerator;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.grid.ColumnReorderEvent;
import com.vaadin.flow.component.grid.ColumnResizeEvent;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.grid.ItemClickEvent;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.menubar.MenuBarVariant;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.shared.Tooltip;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.provider.AbstractBackEndDataProvider;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

@Tag(value="div")
@CssImport(value="@vaadin/vaadin-lumo-styles/lumo.css")
public class Table
extends AbstractComponentContainer
implements Select,
HasValue {
    private static final String V_CAPTION = "v-caption";
    private static final String V_CAPTIONTEXT = "v-captiontext";
    private static final String V_TABLE = "v-table";
    private static final String V_TABLE_COLUMN_COLLAPSING_MENU = "v-table-column-collapsing-menu";
    private final Grid<Item> grid;
    private final Map<String, ColumnSettings<?>> columnSettingsMap;
    private final Map<String, Converter<String, Object>> propertyValueConverters;
    private final List<String> nonCollapsibleColumns;
    private boolean columnCollapsingAllowed;
    private MenuBar columnCollapsingMenuBar;
    private boolean readOnly = false;
    private boolean selectable = false;
    private boolean updatingMultiSelect = false;
    private boolean sortEnabled = true;
    private boolean hasDefinedHeight = false;
    private int pageLength = 15;
    private int approximateRowHeightInPixels = 36;
    private int approximateNonRowHeightInPixels = 56;
    private transient Object oldValueWhileUpdatingMultiSelect;
    private final Map<HasValue.ValueChangeListener, Registration> valueChangeListeners = new LinkedHashMap<HasValue.ValueChangeListener, Registration>();
    private Component captionComponent;
    private final Map<Property<?>, Object> currentPropertiesToListenWithItemIds = new HashMap();
    private Object sortContainerPropertyId;
    private boolean sortAscending;
    private Registration selectionListenerRegistration;
    private boolean requiredIndicatorVisible;
    private LinkedList<Object> visibleColumns = new LinkedList();

    public Table() {
        this.grid = new Grid();
        this.grid.setId(UUID.randomUUID().toString());
        this.grid.addClassNames(new String[]{V_TABLE});
        this.grid.addSortListener((ComponentEventListener & Serializable)event -> {
            if (event.isFromClient()) {
                boolean newSortAscending = !event.getSortOrder().isEmpty() && ((GridSortOrder)event.getSortOrder().get(0)).getDirection() == SortDirection.ASCENDING;
                this.setSortAscending(newSortAscending);
                this.sortContainerPropertyId = Optional.ofNullable(event.getSortOrder()).orElseGet(Collections::emptyList).stream().findFirst().map(GridSortOrder::getSorted).map(Grid.Column::getKey).orElse(null);
                this.sort();
            }
        });
        this.grid.setDataProvider((DataProvider)new TableDataProvider());
        this.setContainerDataSource(null);
        this.columnSettingsMap = new HashMap();
        this.propertyValueConverters = new HashMap<String, Converter<String, Object>>();
        this.nonCollapsibleColumns = new ArrayList<String>();
        this.sortAscending = true;
        this.addComponent((Component)this.grid);
        this.getStyle().setPosition(Style.Position.RELATIVE);
        this.getFAbstractSelect();
        this.refreshItemSelectable();
        this.addItemSetChangeListener(e -> this.grid.getDataProvider().refreshAll());
        this.addPropertySetChangeListener(e -> this.grid.getDataProvider().refreshAll());
        this.setPageLength(this.pageLength);
        this.setupSelectionListener();
    }

    public Table(String captionText) {
        this();
        this.setCaption(captionText);
    }

    @Override
    public void setLabelComponent(Component labelComponent) {
        Component component;
        if (this.captionComponent != null) {
            this.removeComponent(this.captionComponent);
        }
        if ((component = (this.captionComponent = labelComponent)) instanceof Span) {
            Span captionSpan = (Span)component;
            captionSpan.addClassNames(new String[]{V_CAPTION});
            captionSpan.getChildren().filter(child -> child instanceof Span).findFirst().ifPresent(child -> child.addClassNames(new String[]{V_CAPTIONTEXT}));
        }
        this.addComponentAsFirst(this.captionComponent);
        String captionId = UUID.randomUUID().toString();
        this.captionComponent.setId(captionId);
        this.grid.getElement().setAttribute("labelledBy", captionId);
        this.grid.getId().ifPresent(gridId -> this.captionComponent.getElement().setAttribute("for", gridId));
    }

    @Override
    public void setContainerDataSource(Container newDataSource) {
        newDataSource = this.prepareNewDataSource(newDataSource);
        this.setVisibleColumns(newDataSource.getContainerPropertyIds().toArray());
        Select.super.setContainerDataSource(newDataSource);
    }

    public void setContainerDataSource(Container newDataSource, Collection<?> visibleIds) {
        newDataSource = this.prepareNewDataSource(newDataSource);
        this.setVisibleColumns(visibleIds != null ? visibleIds.toArray() : new Object[]{});
        Select.super.setContainerDataSource(newDataSource);
    }

    private Container prepareNewDataSource(Container newDataSource) {
        if (newDataSource == null) {
            newDataSource = new IndexedContainer();
        }
        for (Object propId : newDataSource.getContainerPropertyIds()) {
            this.addContainerProperty(this.propertyIdToColumnKey(propId), newDataSource.getType(propId), null);
        }
        return newDataSource;
    }

    public void setColumnWidth(Object propertyId, int width) {
        Grid.Column column = this.grid.getColumnByKey(this.propertyIdToColumnKey(propertyId));
        if (column != null) {
            if (width < 0) {
                column.setAutoWidth(true);
                column.setFlexGrow(1);
                column.setWidth(null);
            } else {
                column.setAutoWidth(false);
                column.setFlexGrow(0);
                column.setWidth("%dpx".formatted(width));
            }
        }
    }

    public int getColumnWidth(Object propertyId) {
        Grid.Column column = this.grid.getColumnByKey(this.propertyIdToColumnKey(propertyId));
        if (column != null && column.getWidth() != null && !column.getWidth().isEmpty()) {
            return (int)Unit.getSize((String)column.getWidth());
        }
        return -1;
    }

    public void setCellStyleGenerator(CellStyleGenerator cellStyleGenerator) {
        this.grid.getColumns().forEach(column -> column.setPartNameGenerator((SerializableFunction & Serializable)item -> {
            String styleName = cellStyleGenerator.getStyle(this, this.toItemId((Item)item), column.getKey());
            return styleName != null ? "v-table-cell-content-" + styleName : null;
        }));
    }

    public void setPartNameGenerator(SerializableFunction<Item, String> partNameGenerator) {
        this.grid.setPartNameGenerator(partNameGenerator);
    }

    public void setItemDescriptionGenerator(ItemDescriptionGenerator generator) {
        this.grid.getColumns().forEach(column -> column.setTooltipGenerator((SerializableFunction & Serializable)item -> generator.generateDescription(this, this.toItemId((Item)item), column.getKey())));
        this.applyTooltipHtmlSupport();
    }

    private void applyTooltipHtmlSupport() {
        Element tooltipElement = this.grid.getElement().getChildren().filter(child -> Objects.equals(child.getAttribute("slot"), "tooltip")).findFirst().orElse(null);
        if (tooltipElement == null) {
            return;
        }
        tooltipElement.executeJs("function htmlTooltipRenderer(root) {\n      var contentInHTML = this.generator(this.context);\n      if (contentInHTML !== undefined) {\n          root.innerHTML = contentInHTML;\n      } else {\n          root.textContent = \"\";\n      }\n  };\nthis._renderer = htmlTooltipRenderer.bind(this);\n", new Object[0]);
    }

    public void setTooltipPosition(Tooltip.TooltipPosition position) {
        String expression = "this.querySelector('vaadin-tooltip').position = '%s';".formatted(position.getPosition());
        this.grid.getElement().executeJs(expression, new Object[0]);
    }

    public void setSelectable(boolean selectable) {
        boolean selectableChanged = this.selectable != selectable;
        this.selectable = selectable;
        if (!selectableChanged || selectable && this.isReadOnly()) {
            return;
        }
        this.refreshItemSelectable();
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setPageLength(int pageLength) {
        if (pageLength < 0) {
            return;
        }
        this.pageLength = pageLength;
        if (pageLength == 0) {
            this.grid.setPageSize(0xCCCCCCC);
            if (!this.hasDefinedHeight) {
                this.grid.setHeightFull();
                this.grid.setAllRowsVisible(true);
            }
            return;
        }
        if (this.grid.getPageSize() != pageLength) {
            this.grid.setPageSize(pageLength);
        }
        this.grid.setAllRowsVisible(false);
        if (!this.hasDefinedHeight) {
            this.grid.setHeight(this.getGridHeightForPageLength(pageLength));
        }
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public boolean isSortEnabled() {
        return this.sortEnabled;
    }

    public void setSortEnabled(boolean sortEnabled) {
        if (this.sortEnabled == sortEnabled) {
            return;
        }
        this.sortEnabled = sortEnabled;
        this.grid.getColumns().forEach(col -> col.setSortable(sortEnabled));
    }

    public void sort() {
        if (this.getSortContainerPropertyId() == null) {
            return;
        }
        this.sort(new Object[]{this.sortContainerPropertyId}, new boolean[]{this.sortAscending});
    }

    public void sort(Object[] propertyId, boolean[] ascending) {
        if (propertyId == null || ascending == null || propertyId.length != ascending.length) {
            throw new IllegalArgumentException("Invalid arguments to sort");
        }
        if (propertyId.length > 0) {
            this.sortAscending = ascending[0];
            this.sortContainerPropertyId = propertyId[0];
            List<GridSortOrder<Item>> sortOrders = IntStream.range(0, propertyId.length).boxed().map(idx -> {
                String columnKey = this.propertyIdToColumnKey(propertyId[idx]);
                SortDirection direction = ascending[idx] ? SortDirection.ASCENDING : SortDirection.DESCENDING;
                return new GridSortOrder(this.grid.getColumnByKey(columnKey), direction);
            }).toList();
            ((Container.Sortable)this.getContainerDataSource()).sort(propertyId, ascending);
            this.grid.getDataProvider().refreshAll();
            this.doUpdateClientSideSorterIndicators(sortOrders);
        } else {
            this.sortAscending = true;
            this.sortContainerPropertyId = null;
        }
    }

    private void doUpdateClientSideSorterIndicators(List<GridSortOrder<Item>> sortOrders) {
        try {
            Method method = ReflectTools.findMethod(this.grid.getClass(), (String)"updateClientSideSorterIndicators", (Class[])new Class[]{List.class});
            method.setAccessible(true);
            method.invoke(this.grid, sortOrders);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void setSortAscending(boolean ascending) {
        if (this.sortAscending != ascending) {
            this.sortAscending = ascending;
            this.sort();
        }
    }

    public Object getSortContainerPropertyId() {
        return this.sortContainerPropertyId;
    }

    public void setSortContainerPropertyId(Object propertyId) {
        this.sortContainerPropertyId = propertyId;
        this.sort();
    }

    @Override
    public boolean isEmpty() {
        Object value = this.getValue();
        if (value == null) {
            return true;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.isEmpty();
        }
        return false;
    }

    public void setReadOnly(boolean readOnly) {
        boolean readOnlyChanged = this.readOnly != readOnly;
        this.readOnly = readOnly;
        if (!readOnlyChanged || !readOnly && !this.isSelectable()) {
            return;
        }
        this.refreshItemSelectable();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setRequiredIndicatorVisible(boolean visible) {
        this.requiredIndicatorVisible = visible;
        this.getElement().setAttribute("required", visible);
    }

    public boolean isRequiredIndicatorVisible() {
        return this.requiredIndicatorVisible;
    }

    public void setColumnReorderingAllowed(boolean columnReorderingAllowed) {
        this.grid.setColumnReorderingAllowed(columnReorderingAllowed);
    }

    public boolean isColumnReorderingAllowed() {
        return this.grid.isColumnReorderingAllowed();
    }

    public String[] getColumnHeaders() {
        Object[] visibleColumns = this.getVisibleColumns();
        String[] headers = new String[visibleColumns.length];
        int i = 0;
        for (Object propertyId : visibleColumns) {
            headers[i++] = this.getColumnHeader(propertyId);
        }
        return headers;
    }

    public void setColumnHeaders(String ... columnHeaders) {
        Object[] visibleColumns = this.getVisibleColumns();
        if (columnHeaders.length != visibleColumns.length) {
            throw new IllegalArgumentException("The length of the headers array must match the number of visible columns");
        }
        int index = 0;
        for (Object propertyId : visibleColumns) {
            Grid.Column column = this.grid.getColumnByKey(this.propertyIdToColumnKey(propertyId));
            column.setHeader(columnHeaders[index++]);
        }
    }

    public String getColumnHeader(Object propertyId) {
        Grid.Column column = this.grid.getColumnByKey(this.propertyIdToColumnKey(propertyId));
        if (column == null) {
            return propertyId.toString();
        }
        String header = column.getHeaderText();
        if (header == null) {
            header = propertyId.toString();
        }
        return header;
    }

    @Override
    public Object getValue() {
        return switch (this.grid.getSelectionMode()) {
            default -> throw new MatchException(null, null);
            case Grid.SelectionMode.SINGLE -> {
                if (this.grid.getSelectedItems().isEmpty()) {
                    yield null;
                }
                yield this.toItemId((Item)this.grid.getSelectedItems().iterator().next());
            }
            case Grid.SelectionMode.MULTI -> this.grid.getSelectedItems().stream().map(Item.class::cast).map(this::toItemId).collect(Collectors.toCollection(LinkedHashSet::new));
            case Grid.SelectionMode.NONE -> null;
        };
    }

    @Override
    public void setHeight(String height) {
        this.hasDefinedHeight = height != null;
        super.setHeight(height);
    }

    @Override
    public void setHeight(float height, Unit unit) {
        this.hasDefinedHeight = height >= 0.0f;
        super.setHeight(height, unit);
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener valueChangeListener) {
        HasValue.ValueChangeListener & Serializable modifiedListener = (HasValue.ValueChangeListener & Serializable)event -> {
            if (this.updatingMultiSelect) {
                if (!this.isValueEmpty(event.getOldValue()) && this.isValueEmpty(event.getValue())) {
                    this.oldValueWhileUpdatingMultiSelect = event.getOldValue();
                } else if (this.oldValueWhileUpdatingMultiSelect != null && this.isValueEmpty(event.getOldValue()) && !this.isValueEmpty(event.getValue())) {
                    HasValue.ValueChangeEvent modifiedEvent = new HasValue.ValueChangeEvent(){

                        public HasValue getHasValue() {
                            return event.getHasValue();
                        }

                        public boolean isFromClient() {
                            return event.isFromClient();
                        }

                        public Object getOldValue() {
                            return Table.this.oldValueWhileUpdatingMultiSelect;
                        }

                        public Object getValue() {
                            return event.getValue();
                        }
                    };
                    valueChangeListener.valueChanged(modifiedEvent);
                    this.oldValueWhileUpdatingMultiSelect = null;
                }
                return;
            }
            valueChangeListener.valueChanged(event);
        };
        Registration registration = this.isMultiSelect() ? this.grid.asMultiSelect().addValueChangeListener((HasValue.ValueChangeListener)modifiedListener) : this.grid.asSingleSelect().addValueChangeListener((HasValue.ValueChangeListener)modifiedListener);
        Registration & Serializable modifiedRegistration = (Registration & Serializable)() -> {
            this.valueChangeListeners.remove(valueChangeListener);
            registration.remove();
        };
        this.valueChangeListeners.put(valueChangeListener, modifiedRegistration);
        return modifiedRegistration;
    }

    private void refreshValueChangeListeners() {
        ArrayList<HasValue.ValueChangeListener> listeners = new ArrayList<HasValue.ValueChangeListener>(this.valueChangeListeners.keySet());
        new ArrayList<Registration>(this.valueChangeListeners.values()).stream().filter(Objects::nonNull).forEach(Registration::remove);
        listeners.forEach(this::addValueChangeListener);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.grid.deselectAll();
            return;
        }
        switch (this.grid.getSelectionMode()) {
            case SINGLE: {
                if (value instanceof Collection) {
                    value = ((Collection)value).iterator().next();
                }
                Item item = this.getItem(value);
                ((TableDataProvider)this.grid.getDataProvider()).put(item, value);
                this.grid.select((Object)item);
                break;
            }
            case MULTI: {
                Stream<Object> valueStream = value instanceof Collection ? ((Collection)value).stream() : Stream.of(value);
                this.grid.asMultiSelect().setValue((Set)valueStream.map(val -> {
                    Item item = this.getItem(val);
                    ((TableDataProvider)this.grid.getDataProvider()).put(item, val);
                    return item;
                }).collect(Collectors.toCollection(LinkedHashSet::new)));
                break;
            }
        }
    }

    @Override
    public void setMultiSelect(boolean multiSelect) {
        if (multiSelect == this.isMultiSelect()) {
            return;
        }
        this.updatingMultiSelect = true;
        try {
            Object value = this.getValue();
            this.grid.setSelectionMode(multiSelect ? Grid.SelectionMode.MULTI : Grid.SelectionMode.SINGLE);
            this.getFAbstractSelect().setMultiSelect(multiSelect);
            this.refreshValueChangeListeners();
            this.refreshValue(value, multiSelect);
        }
        finally {
            this.updatingMultiSelect = false;
        }
        Optional.ofNullable(this.selectionListenerRegistration).ifPresent(Registration::remove);
        this.setupSelectionListener();
        this.grid.getDataProvider().refreshAll();
    }

    private void setupSelectionListener() {
        if (this.grid.getSelectionMode() != Grid.SelectionMode.NONE) {
            this.selectionListenerRegistration = this.grid.addSelectionListener((SelectionListener & Serializable)event -> this.getFAbstractSelect().setValue(this.getValue()));
        }
    }

    public boolean isColumnCollapsed(Object propertyId) {
        Grid.Column col = this.grid.getColumnByKey(this.propertyIdToColumnKey(propertyId));
        return col != null && !col.isVisible();
    }

    public void setColumnCollapsible(Object propertyId, boolean collapsible) {
        String columnKey = this.propertyIdToColumnKey(propertyId);
        if (collapsible) {
            this.nonCollapsibleColumns.remove(columnKey);
        } else {
            this.nonCollapsibleColumns.add(columnKey);
            this.setColumnVisibility(columnKey, true);
        }
        if (this.columnCollapsingAllowed) {
            this.createColumnCollapsingMenuItems(this.columnCollapsingMenuBar);
        }
    }

    public boolean isColumnCollapsible(Object propertyId) {
        return !this.nonCollapsibleColumns.contains(this.propertyIdToColumnKey(propertyId));
    }

    public void setColumnCollapsed(Object propertyId, boolean collapsed) throws IllegalStateException {
        String columnKey = this.propertyIdToColumnKey(propertyId);
        if (!this.isColumnCollapsingAllowed()) {
            throw new IllegalStateException("Column collapsing not allowed!");
        }
        if (collapsed && this.nonCollapsibleColumns.contains(columnKey)) {
            throw new IllegalStateException("The column is noncollapsible!");
        }
        if (!this.getContainerPropertyIds().contains(propertyId)) {
            throw new IllegalArgumentException("Property '" + String.valueOf(propertyId) + "' was not found in the container");
        }
        this.setColumnVisibility(columnKey, !collapsed);
        this.createColumnCollapsingMenuItems(this.columnCollapsingMenuBar);
    }

    public boolean isColumnCollapsingAllowed() {
        return this.columnCollapsingAllowed;
    }

    public void setColumnCollapsingAllowed(boolean columnCollapsingAllowed) {
        this.columnCollapsingAllowed = columnCollapsingAllowed;
        if (this.columnCollapsingMenuBar != null) {
            this.remove(new Component[]{this.columnCollapsingMenuBar});
        }
        if (columnCollapsingAllowed) {
            this.columnCollapsingMenuBar = this.getColumnSelector();
            this.add(new Component[]{this.columnCollapsingMenuBar});
        }
    }

    @Override
    public Class<?> getType() {
        return this.getFAbstractSelect().getType();
    }

    private MenuBar getColumnSelector() {
        MenuBar menuBar = new MenuBar();
        menuBar.addClassName(V_TABLE_COLUMN_COLLAPSING_MENU);
        menuBar.addThemeVariants((ThemeVariant[])new MenuBarVariant[]{MenuBarVariant.LUMO_TERTIARY_INLINE, MenuBarVariant.LUMO_SMALL});
        menuBar.getStyle().setPosition(Style.Position.ABSOLUTE);
        menuBar.getStyle().setRight("16px");
        menuBar.getStyle().setTop("0");
        menuBar.getStyle().setTransform("translateY(100%) translateX(10%)");
        this.createColumnCollapsingMenuItems(menuBar);
        return menuBar;
    }

    private void createColumnCollapsingMenuItems(MenuBar menuBar) {
        menuBar.removeAll();
        SubMenu submenu = (SubMenu)menuBar.addItem((Component)VaadinIcon.COG.create()).getSubMenu();
        for (Object gridColumnKey : this.getVisibleColumns()) {
            boolean collapsingAllowed;
            Grid.Column gridColumn = this.grid.getColumnByKey(this.propertyIdToColumnKey(gridColumnKey));
            boolean bl = collapsingAllowed = !this.nonCollapsibleColumns.contains(gridColumn.getKey());
            if (!collapsingAllowed) continue;
            String headerText = gridColumn.getHeaderText();
            Component component = gridColumn.getHeaderComponent();
            if (component instanceof HasLabel) {
                HasLabel hasLabel = (HasLabel)component;
                headerText = hasLabel.getLabel();
            }
            MenuItem item = (MenuItem)submenu.addItem(headerText);
            item.setCheckable(true);
            item.setChecked(gridColumn.isVisible());
            item.addClickListener((ComponentEventListener & Serializable)e -> gridColumn.setVisible(item.isChecked()));
        }
    }

    public Object[] getVisibleColumns() {
        if (this.visibleColumns == null) {
            return null;
        }
        return this.visibleColumns.toArray();
    }

    public void setVisibleColumns(Object ... visibleColumns) {
        if (visibleColumns == null) {
            throw new NullPointerException("Can not set visible columns to null value");
        }
        LinkedHashMap<String, Grid.Column> orderedColumnsMap = new LinkedHashMap<String, Grid.Column>();
        for (Object visibleColumn : visibleColumns) {
            if (visibleColumn == null) {
                throw new NullPointerException("Ids must be non-nulls");
            }
            String visibleColumnKey = this.propertyIdToColumnKey(visibleColumn);
            Grid.Column gridCol = this.grid.getColumnByKey(visibleColumnKey);
            if (gridCol == null) {
                throw new IllegalArgumentException("Ids must exist in the Container " + visibleColumnKey);
            }
            if (orderedColumnsMap.containsKey(visibleColumnKey)) {
                throw new IllegalArgumentException("Ids must be unique, duplicate id: " + visibleColumnKey);
            }
            orderedColumnsMap.put(visibleColumnKey, gridCol);
        }
        this.visibleColumns = new LinkedList(orderedColumnsMap.keySet());
        this.grid.getColumns().stream().filter(col -> !orderedColumnsMap.containsKey(col.getKey())).forEach(col -> {
            col.setVisible(false);
            orderedColumnsMap.put(col.getKey(), (Grid.Column)col);
        });
        this.grid.setColumnOrder(new ArrayList(orderedColumnsMap.values()));
        if (this.columnCollapsingAllowed) {
            this.createColumnCollapsingMenuItems(this.columnCollapsingMenuBar);
        }
    }

    public <PROPERTY_TYPE> void setConverter(Object propertyId, Converter<String, PROPERTY_TYPE> converter) {
        String columnKey = this.propertyIdToColumnKey(propertyId);
        if (!this.getContainerPropertyIds().contains(columnKey)) {
            throw new IllegalArgumentException("PropertyId " + columnKey + " must be in the container");
        }
        this.propertyValueConverters.put(columnKey, converter);
        this.grid.getDataCommunicator().reset();
    }

    protected boolean hasConverter(Object propertyId) {
        String columnKey = this.propertyIdToColumnKey(propertyId);
        return this.propertyValueConverters.containsKey(columnKey);
    }

    public Converter<String, Object> getConverter(Object propertyId) {
        String columnKey = this.propertyIdToColumnKey(propertyId);
        return this.propertyValueConverters.get(columnKey);
    }

    @Override
    public Class<?> getType(Object propertyId) {
        String key = this.propertyIdToColumnKey(propertyId);
        return this.columnSettingsMap.get(key).type();
    }

    @Override
    public boolean addContainerProperty(Object propertyId, Class<?> type, Object defaultValue) {
        String key = this.propertyIdToColumnKey(propertyId);
        if (defaultValue != null && !type.isAssignableFrom(defaultValue.getClass())) {
            throw new IllegalArgumentException("Default value is not assignable to property " + String.valueOf(propertyId));
        }
        boolean visibleColAdded = false;
        if (!this.visibleColumns.contains(propertyId)) {
            this.visibleColumns.add(propertyId);
            visibleColAdded = true;
        }
        if (!this.columnSettingsMap.containsKey(key)) {
            ColumnSettings columnSettings = new ColumnSettings(type, defaultValue);
            if (Component.class.isAssignableFrom(type)) {
                this.grid.addComponentColumn((ValueProvider & Serializable)item -> this.createComponentValue(Optional.ofNullable(item.getItemProperty(key)).map(Property::getValue).orElse(null), columnSettings)).setKey(key).setHeader(key).setSortable(this.sortEnabled).setResizable(true);
            } else {
                this.grid.addColumn((ValueProvider & Serializable)item -> this.displayValue(propertyId, item.getItemProperty(propertyId).getValue(), columnSettings)).setKey(key).setHeader(key).setSortable(this.sortEnabled).setResizable(true);
            }
            this.columnSettingsMap.put(key, columnSettings);
        }
        if (!this.getContainerDataSource().addContainerProperty(key, type, defaultValue)) {
            if (visibleColAdded) {
                this.visibleColumns.remove(propertyId);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean removeContainerProperty(Object propertyId) {
        String key = this.propertyIdToColumnKey(propertyId);
        if (this.columnSettingsMap.remove(key) != null) {
            this.grid.removeColumnByKey(this.propertyIdToColumnKey(propertyId));
        }
        return Select.super.removeContainerProperty(propertyId);
    }

    public Object addItem(Object[] cells, Object itemId) throws UnsupportedOperationException {
        Item item;
        LinkedList<Object> availableCols = new LinkedList<Object>(List.of(this.getVisibleColumns()));
        if (cells.length != availableCols.size()) {
            return null;
        }
        if (itemId == null) {
            itemId = this.getContainerDataSource().addItem();
            if (itemId == null) {
                return null;
            }
            item = this.getContainerDataSource().getItem(itemId);
        } else {
            item = this.getContainerDataSource().addItem(itemId);
        }
        if (item == null) {
            return null;
        }
        for (int i = 0; i < availableCols.size(); ++i) {
            item.getItemProperty(availableCols.get(i)).setValue(cells[i]);
        }
        if (!(this.getContainerDataSource() instanceof Container.ItemSetChangeNotifier)) {
            this.grid.getDataProvider().refreshAll();
        }
        return itemId;
    }

    private <PROPERTY_TYPE> Component createComponentValue(Object rowValue, ColumnSettings<PROPERTY_TYPE> columnSettings) {
        if (rowValue == null) {
            rowValue = columnSettings.defaultValue;
        }
        if (rowValue == null) {
            rowValue = new Span();
        }
        if (rowValue instanceof Component) {
            Component component = (Component)rowValue;
            return component;
        }
        return new Span();
    }

    private <PROPERTY_TYPE> String displayValue(Object propertyId, Object rowValue, ColumnSettings<PROPERTY_TYPE> columnSettings) {
        if (rowValue == null) {
            rowValue = columnSettings.defaultValue;
        }
        if (rowValue == null) {
            return "";
        }
        if (this.hasConverter(propertyId)) {
            Converter<String, Object> converter = this.getConverter(propertyId);
            return (String)converter.convertToPresentation(rowValue, new ValueContext(new Binder(), this.getLocale()));
        }
        return rowValue.toString();
    }

    @Override
    public void replaceComponent(Component oldComponent, Component newComponent) {
        int index = this.getChildren().toList().indexOf(oldComponent);
        if (index >= 0) {
            this.addComponentAtIndex(index, newComponent);
            this.removeComponent(oldComponent);
        }
    }

    @Override
    public int getComponentCount() {
        return (int)this.getChildren().count();
    }

    @Override
    public Collection<?> getContainerPropertyIds() {
        return this.grid.getColumns().stream().map(Grid.Column::getKey).toList();
    }

    public void addColumnReorderListener(ComponentEventListener<ColumnReorderEvent<Item>> listener) {
        this.grid.addColumnReorderListener(listener);
    }

    public void addColumnResizeListener(ComponentEventListener<ColumnResizeEvent<Item>> listener) {
        this.grid.addColumnResizeListener(listener);
    }

    public void addItemClickListener(ComponentEventListener<ItemClickEvent<Item>> listener) {
        this.grid.addItemClickListener(listener);
    }

    private void setColumnVisibility(String columnKey, boolean visible) {
        Grid.Column col = this.grid.getColumnByKey(columnKey);
        if (col != null) {
            col.setVisible(visible);
        }
    }

    private String propertyIdToColumnKey(Object propertyId) {
        if (propertyId == null) {
            throw new IllegalStateException("Column property id cannot be null!");
        }
        String stringValue = propertyId.toString();
        if (stringValue == null) {
            throw new IllegalStateException("Column property id toString cannot be null!");
        }
        return stringValue;
    }

    @Override
    public void valueChange(Property.ValueChangeEvent arg0) {
        this.grid.getDataProvider().refreshItem((Object)this.getItem(this.currentPropertiesToListenWithItemIds.get(arg0.getProperty())));
        this.markAsDirty();
    }

    private void clearPropertyListeners() {
        Iterator<Property<?>> iterProps = this.currentPropertiesToListenWithItemIds.keySet().iterator();
        while (iterProps.hasNext()) {
            Property<?> prop = iterProps.next();
            ((Property.ValueChangeNotifier)((Object)prop)).removeValueChangeListener(this);
            iterProps.remove();
        }
        if (this.currentPropertiesToListenWithItemIds.size() > 0) {
            throw new RuntimeException("Property tracking is broken.");
        }
    }

    private void updatePropertyListeners(List<Object> itemIds) {
        itemIds.forEach(itemId -> this.getItem(itemId).getItemPropertyIds().forEach(propId -> {
            Property prop = this.getContainerProperty(itemId, propId);
            if (prop instanceof Property.ValueChangeNotifier) {
                Property.ValueChangeNotifier propVN = (Property.ValueChangeNotifier)((Object)prop);
                propVN.addValueChangeListener(this);
                this.currentPropertiesToListenWithItemIds.put(prop, itemId);
            }
        }));
    }

    @Override
    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.doConnectorOnAttach(attachEvent);
        this.getElement().addEventListener("table-dimension-set", (DomEventListener & Serializable)e -> {
            int rowHeight = e.getEventData().get("event.detail.rowHeight").asInt();
            int nonRowHeight = e.getEventData().get("event.detail.nonRowHeight").asInt();
            if (rowHeight > 0) {
                this.approximateRowHeightInPixels = rowHeight;
            }
            this.approximateNonRowHeightInPixels = nonRowHeight;
            this.setPageLength(this.getPageLength());
        }).addEventData("event.detail.rowHeight").addEventData("event.detail.nonRowHeight");
        this.getElement().executeJs("requestAnimationFrame(() => {\n  let nonRowHeight = 0;\n  const grid = this.querySelector(\"vaadin-grid\");\n  const headerHeight = grid.shadowRoot.querySelector(\"thead\")?.offsetHeight;\n  if (headerHeight) {\n    nonRowHeight += headerHeight;\n  }\n  const footerHeight = grid.shadowRoot.querySelector(\"tfoot\")?.offsetHeight;\n  if (footerHeight) {\n    nonRowHeight += footerHeight;\n  }\n  const rows = this.querySelector(\"vaadin-grid\").shadowRoot.querySelectorAll(\"tbody tr\");\n  const rowHeight = rows ? (rows.length == 1 ? rows[0].offsetHeight : rows[1].offsetHeight) : 0;\n  this.dispatchEvent(new CustomEvent('table-dimension-set', {\n    detail: { rowHeight, nonRowHeight }\n  }));\n});", new Object[0]);
    }

    @Override
    protected void onDetach(DetachEvent detachEvent) {
        Iterator<Property<?>> iterProps = this.currentPropertiesToListenWithItemIds.keySet().iterator();
        while (iterProps.hasNext()) {
            ((Property.ValueChangeNotifier)((Object)iterProps.next())).removeValueChangeListener(this);
            iterProps.remove();
        }
        super.onDetach(detachEvent);
        this.doConnectorOnDetach(detachEvent);
    }

    private void refreshValue(Object value, boolean isMultiSelect) {
        if (value == null) {
            return;
        }
        if (isMultiSelect) {
            if (value instanceof Set) {
                Set castSetValue = (Set)value;
                this.setValue(castSetValue);
            } else {
                this.setValue(Set.of(value));
            }
        } else if (value instanceof Set) {
            Set castSetValue = (Set)value;
            if (castSetValue.isEmpty()) {
                this.setValue((Object)null);
            } else {
                this.setValue(castSetValue.iterator().next());
            }
        } else {
            this.setValue(value);
        }
    }

    private boolean isValueEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Set) {
            Set set = (Set)value;
            return set.isEmpty();
        }
        return false;
    }

    private void refreshItemSelectable() {
        this.grid.setItemSelectableProvider((SerializablePredicate & Serializable)item -> this.isSelectable() && !this.isReadOnly());
    }

    private String getGridHeightForPageLength(int pageLength) {
        return this.approximateRowHeightInPixels * pageLength + this.approximateNonRowHeightInPixels + "px";
    }

    private Object toItemId(Item item) {
        if (this.grid.getDataProvider() instanceof TableDataProvider) {
            return ((TableDataProvider)this.grid.getDataProvider()).getItemId(item);
        }
        return this.getItemIdByItem(item);
    }

    class TableDataProvider
    extends AbstractBackEndDataProvider<Item, Void> {
        Map<Item, Object> itemToItemIdMap = new HashMap<Item, Object>();

        protected Stream<Item> fetchFromBackEnd(Query<Item, Void> query) {
            Table.this.clearPropertyListeners();
            List<Object> itemIds = null;
            Container container = Table.this.getContainerDataSource();
            itemIds = container instanceof Container.Indexed ? ((Container.Indexed)container).getItemIds(query.getOffset(), query.getLimit()) : container.getItemIds().stream().skip(query.getOffset()).limit(query.getLimit()).collect(Collectors.toList());
            Table.this.updatePropertyListeners(itemIds);
            return itemIds.stream().map(id -> {
                Item item = Table.this.getContainerDataSource().getItem(id);
                this.itemToItemIdMap.put(item, id);
                return item;
            });
        }

        protected int sizeInBackEnd(Query<Item, Void> query) {
            return Table.this.getContainerDataSource().size();
        }

        public Object getItemId(Item item) {
            return this.itemToItemIdMap.get(item);
        }

        public void clear() {
            this.itemToItemIdMap.clear();
        }

        public void put(Item item, Object itemId) {
            this.itemToItemIdMap.put(item, itemId);
        }
    }

    @FunctionalInterface
    public static interface CellStyleGenerator
    extends Serializable {
        public String getStyle(Table var1, Object var2, Object var3);
    }

    private record ColumnSettings<PROPERTY_TYPE>(Class<PROPERTY_TYPE> type, Object defaultValue) implements Serializable
    {
    }
}

