/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui;

import com.vaadin.featurepack.data.ui.Field;
import com.vaadin.featurepack.event.ContextClickEvent;
import com.vaadin.featurepack.event.ShortcutAction;
import com.vaadin.featurepack.event.ShortcutListener;
import com.vaadin.featurepack.server.ErrorMessage;
import com.vaadin.featurepack.server.FAbstractClientConnector;
import com.vaadin.featurepack.server.FSizeable;
import com.vaadin.featurepack.server.Helpers;
import com.vaadin.featurepack.server.IconResource;
import com.vaadin.featurepack.server.Resource;
import com.vaadin.featurepack.shared.ui.ContentMode;
import com.vaadin.featurepack.ui.AbstractOrderedLayout;
import com.vaadin.featurepack.ui.Event;
import com.vaadin.featurepack.ui.FormLayout;
import com.vaadin.featurepack.ui.HasComponents;
import com.vaadin.featurepack.ui.Listener;
import com.vaadin.featurepack.ui.TableDataCell;
import com.vaadin.featurepack.util.TooltipUtils;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutRegistration;
import com.vaadin.flow.component.Shortcuts;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.IconFactory;
import com.vaadin.flow.component.popover.Popover;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import org.slf4j.LoggerFactory;

@CssImport.Container(value={@CssImport(value="./tooltip.css"), @CssImport(value="./errors.css")})
public interface FAbstractComponent
extends FAbstractClientConnector,
FSizeable,
HasEnabled,
Serializable {
    default public String getFId() {
        return this.getFlowComponent().getId().orElse(null);
    }

    @Override
    default public HasComponents getFParent() {
        return this.getFlowComponent().getParent().filter(HasComponents.class::isInstance).orElse(null);
    }

    @Override
    default public void beforeClientResponse(boolean initial) {
        FAbstractClientConnector.super.beforeClientResponse(initial);
        String styleName = FAbstractComponent.createClassName(this);
        this.getFlowComponent().getElement().setAttribute("class", styleName);
        this.updateForTooltipAndErrorMessage();
        this.showRequiredErrorTooltip();
    }

    private void showRequiredErrorTooltip() {
        Popover tooltip;
        Field field;
        Component component = this.getFlowComponent();
        if (component instanceof Field && (field = (Field)component).isRequired() && field.isEmpty() && field.getRequiredError() != null && (tooltip = TooltipUtils.getPopover(this.getFlowComponent())) != null) {
            tooltip.setOpened(true);
        }
    }

    private void updateForTooltipAndErrorMessage() {
        ErrorMessage error = this.getFErrorMessage();
        if (error != null) {
            String className = "v-errormessage-" + error.getErrorLevel().name().toLowerCase(Locale.ENGLISH);
            if (this.getDescription() != null) {
                TooltipUtils.setTooltip(this.getFlowComponent(), "<div><div class=\"v-errormessage " + className + "\">" + error.getFormattedHtmlMessage() + "</div><div class=\"v-tooltip-text\">" + TooltipUtils.getFormattedMessage(this.getDescription(), TooltipUtils.getDescriptionContentMode(this.getFlowComponent())) + "</div></div>", ContentMode.HTML);
            } else {
                TooltipUtils.setTooltip(this.getFlowComponent(), "<div><div class=\"v-errormessage " + className + "\">" + error.getFormattedHtmlMessage() + "</div></div>", ContentMode.HTML);
            }
        } else if (this.getDescription() != null) {
            TooltipUtils.setTooltip(this.getFlowComponent(), this.getDescription(), TooltipUtils.getDescriptionContentMode(this.getFlowComponent()));
        } else {
            TooltipUtils.setTooltip(this.getFlowComponent(), null, null);
        }
        this.updateErrorIndicator();
    }

    private static String createClassName(FAbstractComponent abstractComponent) {
        List<String> customStyles;
        List<String> internalStyles;
        StringBuilder builder = new StringBuilder();
        String primaryStyleName = abstractComponent.getPrimaryStyleName();
        if (primaryStyleName != null) {
            builder.append(primaryStyleName);
        }
        if ((internalStyles = FAbstractComponent.getInternalStyles(abstractComponent.getFlowComponent())) != null && !internalStyles.isEmpty()) {
            builder.append(" ").append(String.join((CharSequence)" ", internalStyles));
        }
        if ((customStyles = FAbstractComponent.getCustomStyles(abstractComponent.getFlowComponent())) != null) {
            customStyles.forEach(style -> {
                if (primaryStyleName != null) {
                    builder.append(" ").append(primaryStyleName).append("-").append((String)style);
                }
                builder.append(" ").append((String)style);
            });
        }
        return builder.toString();
    }

    default public Registration addListener(Listener listener) {
        return ComponentUtil.addListener((Component)this.getFlowComponent(), Event.class, (ComponentEventListener)listener);
    }

    default public void setData(Object data) {
        ComponentUtil.setData((Component)this.getFlowComponent(), DataKey.class, (Object)new DataKey(data));
    }

    default public Object getData() {
        DataKey data = (DataKey)ComponentUtil.getData((Component)this.getFlowComponent(), DataKey.class);
        if (data != null) {
            return data.getValue();
        }
        return null;
    }

    default public void setLocale(Locale locale) {
        ComponentUtil.setData((Component)this.getFlowComponent(), (String)"component-locale", (Object)locale);
        this.markAsDirty();
    }

    default public void setCaption(String caption) {
        ComponentUtil.setData((Component)this.getFlowComponent(), (String)"component-caption", (Object)caption);
        Object labelComponent = this.isCaptionAsHtml() ? new Html("<span>" + (caption == null ? "" : caption) + "</span>") : new Span(this.getCaption());
        labelComponent = this.getIcon() != null ? new Span(new Component[]{this.getIcon(), labelComponent, this.getFErrorIndicator()}) : new Span(new Component[]{labelComponent, this.getFErrorIndicator()});
        labelComponent.addClassName("v-caption");
        this.setLabelComponent((Component)labelComponent);
    }

    default public void setLabelComponent(Component labelComponent) {
    }

    default public String getCaption() {
        return (String)ComponentUtil.getData((Component)this.getFlowComponent(), (String)"component-caption");
    }

    default public void setCaptionAsHtml(boolean captionAsHtml) {
        ComponentUtil.setData((Component)this.getFlowComponent(), (String)"component-caption-as-html", (Object)captionAsHtml);
        this.setCaption(this.getCaption());
    }

    default public boolean isCaptionAsHtml() {
        return Optional.ofNullable(ComponentUtil.getData((Component)this.getFlowComponent(), (String)"component-caption-as-html")).map(Boolean.class::cast).orElse(false);
    }

    default public String getDescription() {
        return TooltipUtils.getDescription(this.getFlowComponent());
    }

    default public void setDescription(String description) {
        TooltipUtils.setDescription(this.getFlowComponent(), description);
    }

    default public void setDescription(String description, ContentMode mode) {
        TooltipUtils.setDescription(this.getFlowComponent(), description, mode);
    }

    default public Component getIcon() {
        return (Component)this.getIconResource();
    }

    default public Resource getIconResource() {
        return (IconResource)ComponentUtil.getData((Component)this.getFlowComponent(), (String)"component-icon");
    }

    default public void setIcon(Icon icon) {
        IconResource iconResource = null;
        if (icon != null) {
            iconResource = new IconResource(icon);
        }
        this.setIconResource(iconResource);
    }

    default public void setIcon(IconFactory icon) {
        this.setIcon(icon.create());
    }

    default public void setIconResource(Resource icon) {
        ComponentUtil.setData((Component)this.getFlowComponent(), (String)"component-icon", (Object)icon);
        this.setCaption(this.getCaption());
    }

    public static List<String> getCustomStyles(Component component) {
        return (List)ComponentUtil.getData((Component)component, (String)"component-customStyles");
    }

    private static void setCustomStyles(Component component, List<String> customStyles) {
        ComponentUtil.setData((Component)component, (String)"component-customStyles", customStyles);
    }

    public static List<String> getInternalStyles(Component component) {
        return (List)ComponentUtil.getData((Component)component, (String)"component-internalStyles");
    }

    public static void setInternalStyles(Component component, List<String> customStyles) {
        ComponentUtil.setData((Component)component, (String)"component-internalStyles", customStyles);
    }

    default public String getStyleName() {
        return FAbstractComponent.getCustomStyles(this.getFlowComponent()) == null ? "" : String.join((CharSequence)" ", FAbstractComponent.getCustomStyles(this.getFlowComponent()));
    }

    default public void setStyleName(String style) {
        List<String> customStyles = FAbstractComponent.getCustomStyles(this.getFlowComponent());
        if (style == null || style.isEmpty()) {
            FAbstractComponent.setCustomStyles(this.getFlowComponent(), null);
            this.markAsDirty();
            return;
        }
        if (customStyles == null) {
            customStyles = new ArrayList<String>();
        } else {
            customStyles.clear();
        }
        StringTokenizer tokenizer = new StringTokenizer(style, " ");
        while (tokenizer.hasMoreTokens()) {
            customStyles.add(tokenizer.nextToken());
        }
        FAbstractComponent.setCustomStyles(this.getFlowComponent(), customStyles);
        this.markAsDirty();
        this.notifyParentAboutStyleChanges();
    }

    default public void setStyleName(String style, boolean add) {
        if (add) {
            this.addStyleName(style);
        } else {
            this.removeStyleName(style);
        }
    }

    default public void addStyleName(String style) {
        if (style == null || style.isEmpty()) {
            return;
        }
        List<String> customStyles = FAbstractComponent.getCustomStyles(this.getFlowComponent());
        if (customStyles != null && customStyles.contains(style)) {
            return;
        }
        if (style.contains(" ")) {
            StringTokenizer tokenizer = new StringTokenizer(style, " ");
            while (tokenizer.hasMoreTokens()) {
                this.addStyleName(tokenizer.nextToken());
            }
            return;
        }
        if (customStyles == null) {
            customStyles = new ArrayList<String>();
        }
        customStyles.add(style);
        FAbstractComponent.setCustomStyles(this.getFlowComponent(), customStyles);
        this.markAsDirty();
        this.notifyParentAboutStyleChanges();
    }

    default public void addStyleNames(String ... styles) {
        for (String style : styles) {
            this.addStyleName(style);
        }
    }

    default public void removeStyleName(String style) {
        if (FAbstractComponent.getCustomStyles(this.getFlowComponent()) == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(style, " ");
        List<String> customStyles = FAbstractComponent.getCustomStyles(this.getFlowComponent());
        while (tokenizer.hasMoreTokens()) {
            customStyles.remove(tokenizer.nextToken());
        }
        FAbstractComponent.setCustomStyles(this.getFlowComponent(), customStyles);
        this.markAsDirty();
        this.notifyParentAboutStyleChanges();
    }

    default public void removeStyleNames(String ... styles) {
        for (String style : styles) {
            this.removeStyleName(style);
        }
    }

    default public String getPrimaryStyleName() {
        return (String)ComponentUtil.getData((Component)this.getFlowComponent(), (String)"component-primaryStyleName");
    }

    default public void setPrimaryStyleName(String style) {
        if (!Objects.equals(style, this.getPrimaryStyleName())) {
            ComponentUtil.setData((Component)this.getFlowComponent(), (String)"component-primaryStyleName", (Object)style);
            this.markAsDirty();
        }
    }

    default public void notifyParentAboutStyleChanges() {
        this.getFlowComponent().getParent().ifPresent(parent -> {
            if (parent instanceof AbstractOrderedLayout) {
                ((AbstractOrderedLayout)parent).markAsDirty();
            }
        });
    }

    default public void setImmediate(boolean immediate) {
        ComponentUtil.setData((Component)this.getFlowComponent(), (String)"explicitImmediateValue", (Object)immediate);
        if (!immediate) {
            LoggerFactory.getLogger(FAbstractComponent.class).warn("setImmediate(false) is not supported in feature-pack. Client-side acts as if it was set to true.");
        }
    }

    default public boolean isImmediate() {
        if (ComponentUtil.getData((Component)this.getFlowComponent(), (String)"explicitImmediateValue") != null) {
            return (Boolean)ComponentUtil.getData((Component)this.getFlowComponent(), (String)"explicitImmediateValue");
        }
        if (Helpers.isVaadin7Defaults()) {
            return ComponentUtil.hasEventListener((Component)this.getFlowComponent(), AbstractField.ComponentValueChangeEvent.class);
        }
        return true;
    }

    default public ErrorMessage getFErrorMessage() {
        FAbstractComponent fAbstractComponent;
        ErrorMessage error = (ErrorMessage)ComponentUtil.getData((Component)this.getFlowComponent(), (String)"component-componentError");
        if (error == null && (fAbstractComponent = this) instanceof Field) {
            Field field = (Field)((Object)fAbstractComponent);
            return field.getFAbstractField().getErrorMessage();
        }
        return error;
    }

    default public ErrorMessage getComponentError() {
        return (ErrorMessage)ComponentUtil.getData((Component)this.getFlowComponent(), (String)"component-componentError");
    }

    default public void setComponentError(ErrorMessage componentError) {
        ComponentUtil.setData((Component)this.getFlowComponent(), (String)"component-componentError", (Object)componentError);
        this.markAsDirty();
    }

    default public Component getFErrorIndicator() {
        ErrorMessage error;
        Component indicator = (Component)ComponentUtil.getData((Component)this.getFlowComponent(), (String)"component-errorIndicator");
        if (indicator == null) {
            indicator = new Span();
            ComponentUtil.setData((Component)this.getFlowComponent(), (String)"component-errorIndicator", (Object)indicator);
        }
        if ((error = this.getFErrorMessage()) != null && this.showErrorIndicator()) {
            indicator.addClassNames(new String[]{"v-errorindicator", "v-errorindicator-" + error.getErrorLevel().name().toLowerCase(Locale.ENGLISH)});
            indicator.getStyle().setDisplay(Style.Display.INLINE);
        } else {
            indicator.getClassNames().clear();
            indicator.getStyle().setDisplay(Style.Display.NONE);
        }
        return indicator;
    }

    private void updateErrorIndicator() {
        TableDataCell cell;
        HasComponents hasComponents;
        this.getFErrorIndicator();
        HasComponents hasComponents2 = this.getFParent();
        if (hasComponents2 instanceof TableDataCell && (hasComponents = (cell = (TableDataCell)hasComponents2).getFParent()) instanceof FormLayout.FormRow) {
            FormLayout.FormRow row = (FormLayout.FormRow)hasComponents;
            row.updateCaption();
        }
    }

    private boolean showErrorIndicator() {
        Field field;
        if (!(this.getFlowComponent() instanceof Field)) {
            return true;
        }
        Component component = this.getFlowComponent();
        return component instanceof Field && !(field = (Field)component).getFAbstractField().shouldHideErrors();
    }

    default public Registration addShortcutListener(ShortcutListener listener) {
        HashMap<ShortcutListener, ShortcutRegistration> listeners = (HashMap<ShortcutListener, ShortcutRegistration>)ComponentUtil.getData((Component)this.getFlowComponent(), (String)"component-shortcutListeners");
        if (listeners == null) {
            listeners = new HashMap<ShortcutListener, ShortcutRegistration>();
            ComponentUtil.setData((Component)this.getFlowComponent(), (String)"component-shortcutListeners", listeners);
        }
        listeners.put(listener, Shortcuts.addShortcutListener((Component)this.getFlowComponent(), (Command & Serializable)() -> listener.handleAction(this.getFlowComponent(), this.getFlowComponent()), (Key)ShortcutAction.toKey(listener.getKeyCode()), (KeyModifier[])((KeyModifier[])Arrays.stream(listener.getModifiers()).mapToObj(ShortcutAction::toKeyModifier).toArray(KeyModifier[]::new))));
        return (Registration)listeners.get(listener);
    }

    default public void removeShortcutListener(ShortcutListener listener) {
        Map listeners = (Map)ComponentUtil.getData((Component)this.getFlowComponent(), (String)"component-shortcutListeners");
        if (listeners != null && listeners.containsKey(listener)) {
            ((Registration)listeners.remove(listener)).remove();
        }
    }

    default public Registration addContextClickListener(ContextClickEvent.ContextClickListener listener) {
        HashMap<ContextClickEvent.ContextClickListener, Registration> listeners = (HashMap<ContextClickEvent.ContextClickListener, Registration>)ComponentUtil.getData((Component)this.getFlowComponent(), (String)"component-contextClickListeners");
        if (listeners == null) {
            listeners = new HashMap<ContextClickEvent.ContextClickListener, Registration>();
            ComponentUtil.setData((Component)this.getFlowComponent(), (String)"component-contextClickListeners", listeners);
        }
        listeners.put(listener, ComponentUtil.addListener((Component)this.getFlowComponent(), ContextClickEvent.class, listener::contextClick));
        return (Registration)listeners.get(listener);
    }

    default public void removeContextClickListener(ContextClickEvent.ContextClickListener listener) {
        Map listeners = (Map)ComponentUtil.getData((Component)this.getFlowComponent(), (String)"component-contextClickListeners");
        if (listeners != null && listeners.containsKey(listener)) {
            ((Registration)listeners.remove(listener)).remove();
        }
    }

    default public void setResponsive(boolean responsive) {
        ComponentUtil.setData((Component)this.getFlowComponent(), (String)"component-responsive", (Object)responsive);
    }

    default public boolean isResponsive() {
        return Optional.ofNullable(ComponentUtil.getData((Component)this.getFlowComponent(), (String)"component-responsive")).map(Boolean.class::cast).orElse(false);
    }

    public static class DataKey
    implements Serializable {
        private final Object value;

        public DataKey(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

