/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.server;

import com.vaadin.featurepack.event.ListenerMethod;
import com.vaadin.featurepack.server.ClientConnector;
import com.vaadin.featurepack.server.Resource;
import com.vaadin.featurepack.ui.Event;
import com.vaadin.featurepack.ui.HasComponents;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventBus;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.ExecutionContext;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface FAbstractClientConnector
extends ClientConnector,
Serializable {
    default public Component getFlowComponent() {
        return (Component)this;
    }

    default public void doConnectorOnAttach(AttachEvent attachEvent) {
        this.attach();
    }

    default public void doConnectorOnDetach(DetachEvent detachEvent) {
        this.detach();
        StateTree.ExecutionRegistration beforeClientResponseRegistration = (StateTree.ExecutionRegistration)ComponentUtil.getData((Component)this.getFlowComponent(), (String)"connector-beforeClientResponseRegistration");
        if (beforeClientResponseRegistration != null) {
            beforeClientResponseRegistration.remove();
            ComponentUtil.setData((Component)this.getFlowComponent(), (String)"connector-beforeClientResponseRegistration", null);
        }
    }

    @Override
    default public void attach() {
        this.markAsDirty();
        ComponentUtil.fireEvent((Component)this.getFlowComponent(), (ComponentEvent)new ClientConnector.AttachEvent(this.getFlowComponent()));
    }

    @Override
    default public void detach() {
        ComponentUtil.fireEvent((Component)this.getFlowComponent(), (ComponentEvent)new ClientConnector.DetachEvent(this.getFlowComponent()));
    }

    @Override
    default public void markAsDirty() {
        if (!FAbstractClientConnector.isBeforeClientResponseRegistered(this.getFlowComponent())) {
            VaadinSession session = this.getFlowComponent().getUI().map(UI::getSession).orElse(null);
            if (!1.$assertionsDisabled && session != null && !session.hasLock()) {
                throw new AssertionError();
            }
            if (this.isAttached()) {
                FAbstractClientConnector.registerInternalBeforeClientResponse(this, this.getFlowComponent());
            }
        }
    }

    public static void registerInternalBeforeClientResponse(FAbstractClientConnector connector, Component component) {
        if (!FAbstractClientConnector.isBeforeClientResponseRegistered(component)) {
            component.getUI().ifPresent(ui -> ComponentUtil.setData((Component)component, (String)"connector-beforeClientResponseRegistration", (Object)ui.beforeClientResponse(component, connector::internalBeforeClientResponse)));
        }
    }

    public static boolean isBeforeClientResponseRegistered(Component component) {
        StateTree.ExecutionRegistration beforeClientResponseRegistration = (StateTree.ExecutionRegistration)ComponentUtil.getData((Component)component, (String)"connector-beforeClientResponseRegistration");
        return beforeClientResponseRegistration != null;
    }

    private void internalBeforeClientResponse(ExecutionContext executionContext) {
        boolean initialResponse = Optional.ofNullable(ComponentUtil.getData((Component)this.getFlowComponent(), (String)"connector-initialResponse")).map(Boolean.class::cast).orElse(true);
        this.beforeClientResponse(initialResponse);
        ComponentUtil.setData((Component)this.getFlowComponent(), (String)"connector-initialResponse", (Object)false);
        ComponentUtil.setData((Component)this.getFlowComponent(), (String)"connector-beforeClientResponseRegistration", null);
    }

    @Override
    default public void beforeClientResponse(boolean initial) {
    }

    @Override
    default public boolean isAttached() {
        return this.getFlowComponent().isAttached();
    }

    @Override
    default public void markAsDirtyRecursive() {
        this.markAsDirty();
        this.getFlowComponent().getChildren().forEach(FAbstractClientConnector::markAsDirtyRecursive);
    }

    private static void markAsDirtyRecursive(Component child) {
        if (child instanceof FAbstractClientConnector) {
            ((FAbstractClientConnector)child).markAsDirtyRecursive();
        } else {
            child.getChildren().forEach(FAbstractClientConnector::markAsDirtyRecursive);
        }
    }

    @Override
    default public Registration addLegacyAttachListener(ClientConnector.AttachListener listener) {
        HashMap<ClientConnector.AttachListener, Registration> listeners = (HashMap<ClientConnector.AttachListener, Registration>)ComponentUtil.getData((Component)this.getFlowComponent(), (String)"client-connector-attachListeners");
        if (listeners == null) {
            listeners = new HashMap<ClientConnector.AttachListener, Registration>();
            ComponentUtil.setData((Component)this.getFlowComponent(), (String)"client-connector-attachListeners", listeners);
        }
        listeners.put(listener, ComponentUtil.addListener((Component)this.getFlowComponent(), ClientConnector.AttachEvent.class, (ComponentEventListener)listener));
        return (Registration)listeners.get(listener);
    }

    @Override
    default public Registration addLegacyDetachListener(ClientConnector.DetachListener listener) {
        HashMap<ClientConnector.DetachListener, Registration> listeners = (HashMap<ClientConnector.DetachListener, Registration>)ComponentUtil.getData((Component)this.getFlowComponent(), (String)"client-connector-detachListeners");
        if (listeners == null) {
            listeners = new HashMap<ClientConnector.DetachListener, Registration>();
            ComponentUtil.setData((Component)this.getFlowComponent(), (String)"client-connector-detachListeners", listeners);
        }
        listeners.put(listener, ComponentUtil.addListener((Component)this.getFlowComponent(), ClientConnector.DetachEvent.class, (ComponentEventListener)listener));
        return (Registration)listeners.get(listener);
    }

    default public void removeAttachListener(ClientConnector.AttachListener listener) {
        Map listeners = (Map)ComponentUtil.getData((Component)this.getFlowComponent(), (String)"client-connector-attachListeners");
        if (listeners != null && listeners.containsKey(listener)) {
            ((Registration)listeners.remove(listener)).remove();
        }
    }

    default public void removeDetachListener(ClientConnector.DetachListener listener) {
        Map listeners = (Map)ComponentUtil.getData((Component)this.getFlowComponent(), (String)"client-connector-detachListeners");
        if (listeners != null && listeners.containsKey(listener)) {
            ((Registration)listeners.remove(listener)).remove();
        }
    }

    @Override
    default public boolean isConnectorEnabled() {
        return this.isAttached() && this.getFlowComponent().isVisible() && this.getFlowComponent().getElement().isEnabled();
    }

    default public boolean hasListeners(Class<? extends ComponentEvent> eventType) {
        if (!ComponentUtil.hasEventListener((Component)this.getFlowComponent(), eventType)) {
            Map listeners = (Map)ComponentUtil.getData((Component)this.getFlowComponent(), (String)"component-methodEventListeners");
            return listeners != null && listeners.keySet().stream().anyMatch(listener -> listener.getEventType().equals(eventType));
        }
        return true;
    }

    default public Collection<?> getFListeners(Class<? extends ComponentEvent> eventType) {
        Map listeners = (Map)ComponentUtil.getData((Component)this.getFlowComponent(), (String)"component-methodEventListeners");
        if (listeners != null) {
            return Stream.concat(listeners.keySet().stream().filter(listener -> listener.getEventType().equals(eventType)), ComponentUtil.getListeners((Component)this.getFlowComponent(), eventType).stream()).distinct().collect(Collectors.toList());
        }
        return ComponentUtil.getListeners((Component)this.getFlowComponent(), eventType);
    }

    default public Registration addListener(String eventIdentifier, Class<?> eventType, Object target, Method method) {
        return this.addListener(eventType, target, method);
    }

    default public Registration addListener(Class<?> eventType, Object target, Method method) {
        ListenerMethod listenerMethod = new ListenerMethod(eventType, target, method);
        HashMap<ListenerMethod, Registration> listeners = (HashMap<ListenerMethod, Registration>)ComponentUtil.getData((Component)this.getFlowComponent(), (String)"component-methodEventListeners");
        if (listeners == null) {
            listeners = new HashMap<ListenerMethod, Registration>();
            ComponentUtil.setData((Component)this.getFlowComponent(), (String)"component-methodEventListeners", listeners);
        }
        listeners.put(listenerMethod, ComponentUtil.addListener((Component)this.getFlowComponent(), LegacyMethodEvent.class, (ComponentEventListener & Serializable)event -> {
            if (eventType.isAssignableFrom(event.getLegacyEvent().getClass())) {
                listenerMethod.receiveEvent(event.getLegacyEvent());
            }
        }));
        return (Registration)listeners.get(listenerMethod);
    }

    default public void removeListener(Class<?> eventType, Object target) {
        Map listeners = (Map)ComponentUtil.getData((Component)this.getFlowComponent(), (String)"component-methodEventListeners");
        if (listeners != null) {
            for (ListenerMethod listener : new HashSet(listeners.keySet())) {
                if (!listener.getEventType().equals(eventType) || !listener.getTarget().equals(target)) continue;
                ((Registration)listeners.remove(listener)).remove();
            }
        }
    }

    default public void removeListener(Class<?> eventType, Object target, Method method) {
        ListenerMethod listenerMethod = new ListenerMethod(eventType, target, method);
        Map listeners = (Map)ComponentUtil.getData((Component)this.getFlowComponent(), (String)"component-methodEventListeners");
        if (listeners != null && listeners.containsKey(listenerMethod)) {
            ((Registration)listeners.remove(listenerMethod)).remove();
        }
    }

    default public void fireEvent(EventObject event) {
        ComponentUtil.fireEvent((Component)this.getFlowComponent(), (ComponentEvent)new LegacyMethodEvent(this.getFlowComponent(), event));
    }

    default public void fireEvent(EventObject event, ComponentEventBus eventBus) {
        if (event instanceof ComponentEvent && ComponentUtil.hasEventListener((Component)this.getFlowComponent(), event.getClass())) {
            eventBus.fireEvent((ComponentEvent)event);
        } else if (event instanceof Event || !(event instanceof ComponentEvent)) {
            eventBus.fireEvent((ComponentEvent)new LegacyMethodEvent(this.getFlowComponent(), event));
        }
    }

    default public Iterable<? extends ClientConnector> getAllChildrenIterable(ClientConnector connector) {
        boolean hasComponents = connector instanceof HasComponents;
        if (!hasComponents) {
            return Collections.emptyList();
        }
        return (Iterable)((Object)connector);
    }

    default public Resource getResource(String key) {
        return (Resource)ComponentUtil.getData((Component)this.getFlowComponent(), (String)key);
    }

    default public void setResource(String key, Resource resource) {
        ComponentUtil.setData((Component)this.getFlowComponent(), (String)key, (Object)resource);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static class LegacyMethodEvent
    extends ComponentEvent<Component> {
        private EventObject legacyEvent;

        public LegacyMethodEvent(Component source, EventObject legacyEvent) {
            super(source, false);
            this.legacyEvent = legacyEvent;
        }

        public EventObject getLegacyEvent() {
            return this.legacyEvent;
        }
    }
}

