/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.server;

import com.vaadin.featurepack.data.Buffered;
import com.vaadin.featurepack.data.Validator;
import com.vaadin.featurepack.server.ErrorMessage;
import com.vaadin.featurepack.server.SystemError;
import com.vaadin.featurepack.server.UserError;
import com.vaadin.featurepack.shared.ui.ErrorLevel;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class AbstractErrorMessage
implements ErrorMessage {
    private ContentMode mode = ContentMode.TEXT;
    private String message;
    private ErrorLevel level = ErrorLevel.ERROR;
    private List<ErrorMessage> causes = new ArrayList<ErrorMessage>();

    protected AbstractErrorMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    protected void setMessage(String message) {
        this.message = message;
    }

    @Override
    public ErrorLevel getErrorLevel() {
        return this.level;
    }

    protected void setErrorLevel(ErrorLevel level) {
        this.level = level;
    }

    protected void setErrorLevel(ErrorMessage.ErrorLevel level) {
        switch (level) {
            case SYSTEMERROR: {
                this.setErrorLevel(ErrorLevel.SYSTEM);
                break;
            }
            case CRITICAL: {
                this.setErrorLevel(ErrorLevel.CRITICAL);
                break;
            }
            case ERROR: {
                this.setErrorLevel(ErrorLevel.ERROR);
                break;
            }
            case WARNING: {
                this.setErrorLevel(ErrorLevel.WARNING);
                break;
            }
            case INFORMATION: {
                this.setErrorLevel(ErrorLevel.INFO);
                break;
            }
            default: {
                this.setErrorLevel((ErrorLevel)null);
            }
        }
    }

    protected ContentMode getMode() {
        return this.mode;
    }

    protected void setMode(ContentMode mode) {
        this.mode = mode;
    }

    protected List<ErrorMessage> getCauses() {
        return this.causes;
    }

    protected void addCause(ErrorMessage cause) {
        this.causes.add(cause);
    }

    @Override
    public String getFormattedHtmlMessage() {
        Object result = null;
        switch (this.getMode().ordinal()) {
            case 0: {
                result = AbstractErrorMessage.safeEscapeForHtml(this.getMessage());
                break;
            }
            case 1: {
                result = "<pre>" + AbstractErrorMessage.safeEscapeForHtml(this.getMessage()) + "</pre>";
                break;
            }
            case 2: {
                result = this.getMessage();
            }
        }
        if (null == result && null != this.getCauses() && this.getCauses().size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (ErrorMessage cause : this.getCauses()) {
                String childMessage = cause.getFormattedHtmlMessage();
                if (null == childMessage || childMessage.isEmpty()) continue;
                sb.append("<div>");
                sb.append(childMessage);
                sb.append("</div>\n");
            }
            if (sb.length() > 0) {
                result = sb.toString();
            }
        }
        if (null == result) {
            result = "";
        }
        return result;
    }

    public static ErrorMessage getErrorMessageForException(Throwable t) {
        if (null == t) {
            return null;
        }
        if (t instanceof ErrorMessage) {
            return (ErrorMessage)((Object)t);
        }
        if (t instanceof Validator.InvalidValueException) {
            UserError error = new UserError(((Validator.InvalidValueException)t).getHtmlMessage(), ContentMode.HTML, ErrorLevel.ERROR);
            for (Validator.InvalidValueException nestedException : ((Validator.InvalidValueException)t).getCauses()) {
                error.addCause(AbstractErrorMessage.getErrorMessageForException(nestedException));
            }
            return error;
        }
        if (t instanceof Buffered.SourceException) {
            UserError error = new UserError(null);
            error.setErrorLevel(ErrorLevel.ERROR);
            for (Throwable nestedException : ((Buffered.SourceException)t).getCauses()) {
                error.addCause(AbstractErrorMessage.getErrorMessageForException(nestedException));
            }
            return error;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return new SystemError(sw.toString());
    }

    public String toString() {
        return this.getMessage();
    }

    public static final String safeEscapeForHtml(String unsafe) {
        if (null == unsafe) {
            return null;
        }
        StringBuilder safe = new StringBuilder();
        char[] charArray = unsafe.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (AbstractErrorMessage.isSafe(c)) {
                safe.append(c);
                continue;
            }
            safe.append("&#");
            safe.append((int)c);
            safe.append(";");
        }
        return safe.toString();
    }

    private static boolean isSafe(char c) {
        return c > '/' && c < ':' || c > '@' && c < '[' || c > '`' && c < '{';
    }

    public static enum ContentMode {
        TEXT,
        PREFORMATTED,
        HTML;

    }
}

