/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.event;

import com.vaadin.featurepack.event.Action;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.icon.Icon;
import java.io.Serializable;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ShortcutAction
extends Action {
    private final int keyCode;
    private int[] modifiers;
    public static final char SHORTHAND_CHAR_ALT = '&';
    public static final char SHORTHAND_CHAR_SHIFT = '_';
    public static final char SHORTHAND_CHAR_CTRL = '^';
    private static final String SHORTHAND_ALT = Pattern.quote(Character.toString('&'));
    private static final String SHORTHAND_SHIFT = Pattern.quote(Character.toString('_'));
    private static final String SHORTHAND_CTRL = Pattern.quote(Character.toString('^'));
    private static final Pattern SHORTHAND_ESCAPE = Pattern.compile("(" + SHORTHAND_ALT + "?)" + SHORTHAND_ALT + "|(" + SHORTHAND_SHIFT + "?)" + SHORTHAND_SHIFT + "|(" + SHORTHAND_CTRL + "?)" + SHORTHAND_CTRL);
    private static final Pattern SHORTHAND_REMOVE = Pattern.compile("([" + SHORTHAND_ALT + "|" + SHORTHAND_SHIFT + "|" + SHORTHAND_CTRL + "])\\1");
    private static final Pattern SHORTHANDS = Pattern.compile("(" + SHORTHAND_ALT + "|" + SHORTHAND_SHIFT + "|" + SHORTHAND_CTRL + ")(?!\\1)(?:(" + SHORTHAND_ALT + "|" + SHORTHAND_SHIFT + "|" + SHORTHAND_CTRL + ")(?!\\1|\\2))?(?:(" + SHORTHAND_ALT + "|" + SHORTHAND_SHIFT + "|" + SHORTHAND_CTRL + ")(?!\\1|\\2|\\3))?.");

    public ShortcutAction(String caption, int kc, int ... m) {
        super(caption);
        this.keyCode = kc;
        this.setModifiers(m);
    }

    public ShortcutAction(String caption, Icon icon, int kc, int ... m) {
        super(caption, icon);
        this.keyCode = kc;
        this.setModifiers(m);
    }

    public ShortcutAction(String shorthandCaption) {
        this(shorthandCaption, (int[])null);
    }

    public ShortcutAction(String shorthandCaption, int ... modifierKeys) {
        super(SHORTHAND_ESCAPE.matcher(shorthandCaption).replaceAll("$1$2$3"));
        shorthandCaption = SHORTHAND_REMOVE.matcher(shorthandCaption).replaceAll("\u001a");
        Matcher matcher = SHORTHANDS.matcher(shorthandCaption);
        if (matcher.find()) {
            String match = matcher.group();
            this.keyCode = Character.toUpperCase(matcher.group().charAt(match.length() - 1));
            if (modifierKeys != null) {
                this.setModifiers(modifierKeys);
            } else {
                int[] mod = new int[match.length() - 1];
                block5: for (int i = 0; i < mod.length; ++i) {
                    char kc = match.charAt(i);
                    switch (kc) {
                        case '&': {
                            mod[i] = 18;
                            continue block5;
                        }
                        case '^': {
                            mod[i] = 17;
                            continue block5;
                        }
                        case '_': {
                            mod[i] = 16;
                        }
                    }
                }
                this.setModifiers(mod);
            }
        } else {
            this.keyCode = -1;
            this.setModifiers(modifierKeys);
        }
    }

    private void setModifiers(int ... modifiers) {
        this.modifiers = modifiers == null ? new int[0] : modifiers;
        Arrays.sort(this.modifiers);
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public int[] getModifiers() {
        return this.modifiers;
    }

    public static Key toKey(int keyCode) {
        switch (keyCode) {
            case 13: {
                return Key.ENTER;
            }
            case 27: {
                return Key.ESCAPE;
            }
            case 33: {
                return Key.PAGE_UP;
            }
            case 34: {
                return Key.PAGE_DOWN;
            }
            case 9: {
                return Key.TAB;
            }
            case 37: {
                return Key.ARROW_LEFT;
            }
            case 38: {
                return Key.ARROW_UP;
            }
            case 39: {
                return Key.ARROW_RIGHT;
            }
            case 40: {
                return Key.ARROW_DOWN;
            }
            case 8: {
                return Key.BACKSPACE;
            }
            case 46: {
                return Key.DELETE;
            }
            case 45: {
                return Key.INSERT;
            }
            case 35: {
                return Key.END;
            }
            case 36: {
                return Key.HOME;
            }
            case 112: {
                return Key.F1;
            }
            case 113: {
                return Key.F2;
            }
            case 114: {
                return Key.F3;
            }
            case 115: {
                return Key.F4;
            }
            case 116: {
                return Key.F5;
            }
            case 117: {
                return Key.F6;
            }
            case 65: {
                return Key.KEY_A;
            }
            case 66: {
                return Key.KEY_B;
            }
            case 67: {
                return Key.KEY_C;
            }
            case 68: {
                return Key.KEY_D;
            }
            case 69: {
                return Key.KEY_E;
            }
            case 70: {
                return Key.KEY_F;
            }
            case 71: {
                return Key.KEY_G;
            }
            case 72: {
                return Key.KEY_H;
            }
            case 73: {
                return Key.KEY_I;
            }
            case 74: {
                return Key.KEY_J;
            }
            case 75: {
                return Key.KEY_K;
            }
            case 76: {
                return Key.KEY_L;
            }
            case 77: {
                return Key.KEY_M;
            }
            case 78: {
                return Key.KEY_N;
            }
            case 79: {
                return Key.KEY_O;
            }
            case 80: {
                return Key.KEY_P;
            }
            case 81: {
                return Key.KEY_Q;
            }
            case 82: {
                return Key.KEY_R;
            }
            case 83: {
                return Key.KEY_S;
            }
            case 84: {
                return Key.KEY_T;
            }
            case 85: {
                return Key.KEY_U;
            }
            case 86: {
                return Key.KEY_V;
            }
            case 87: {
                return Key.KEY_W;
            }
            case 88: {
                return Key.KEY_X;
            }
            case 89: {
                return Key.KEY_Y;
            }
            case 90: {
                return Key.KEY_Z;
            }
            case 48: {
                return Key.DIGIT_0;
            }
            case 49: {
                return Key.DIGIT_1;
            }
            case 50: {
                return Key.DIGIT_2;
            }
            case 51: {
                return Key.DIGIT_3;
            }
            case 52: {
                return Key.DIGIT_4;
            }
            case 53: {
                return Key.DIGIT_5;
            }
            case 54: {
                return Key.DIGIT_6;
            }
            case 55: {
                return Key.DIGIT_7;
            }
            case 56: {
                return Key.DIGIT_8;
            }
            case 57: {
                return Key.DIGIT_9;
            }
            case 32: {
                return Key.SPACE;
            }
        }
        return Key.UNIDENTIFIED;
    }

    public static KeyModifier toKeyModifier(int keyCode) {
        switch (keyCode) {
            case 16: {
                return KeyModifier.SHIFT;
            }
            case 17: {
                return KeyModifier.CONTROL;
            }
            case 18: {
                return KeyModifier.ALT;
            }
            case 91: {
                return KeyModifier.META;
            }
        }
        return null;
    }

    public static interface ModifierKey
    extends Serializable {
        public static final int SHIFT = 16;
        public static final int CTRL = 17;
        public static final int ALT = 18;
        public static final int META = 91;
    }

    public static interface KeyCode
    extends Serializable {
        public static final int ENTER = 13;
        public static final int ESCAPE = 27;
        public static final int PAGE_UP = 33;
        public static final int PAGE_DOWN = 34;
        public static final int TAB = 9;
        public static final int ARROW_LEFT = 37;
        public static final int ARROW_UP = 38;
        public static final int ARROW_RIGHT = 39;
        public static final int ARROW_DOWN = 40;
        public static final int BACKSPACE = 8;
        public static final int DELETE = 46;
        public static final int INSERT = 45;
        public static final int END = 35;
        public static final int HOME = 36;
        public static final int F1 = 112;
        public static final int F2 = 113;
        public static final int F3 = 114;
        public static final int F4 = 115;
        public static final int F5 = 116;
        public static final int F6 = 117;
        public static final int F7 = 118;
        public static final int F8 = 119;
        public static final int F9 = 120;
        public static final int F10 = 121;
        public static final int F11 = 122;
        public static final int F12 = 123;
        public static final int A = 65;
        public static final int B = 66;
        public static final int C = 67;
        public static final int D = 68;
        public static final int E = 69;
        public static final int F = 70;
        public static final int G = 71;
        public static final int H = 72;
        public static final int I = 73;
        public static final int J = 74;
        public static final int K = 75;
        public static final int L = 76;
        public static final int M = 77;
        public static final int N = 78;
        public static final int O = 79;
        public static final int P = 80;
        public static final int Q = 81;
        public static final int R = 82;
        public static final int S = 83;
        public static final int T = 84;
        public static final int U = 85;
        public static final int V = 86;
        public static final int W = 87;
        public static final int X = 88;
        public static final int Y = 89;
        public static final int Z = 90;
        public static final int NUM0 = 48;
        public static final int NUM1 = 49;
        public static final int NUM2 = 50;
        public static final int NUM3 = 51;
        public static final int NUM4 = 52;
        public static final int NUM5 = 53;
        public static final int NUM6 = 54;
        public static final int NUM7 = 55;
        public static final int NUM8 = 56;
        public static final int NUM9 = 57;
        public static final int SPACEBAR = 32;
    }
}

