/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.desktop;

import com.vaadin.featurepack.desktop.Window;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.html.NativeButton;
import com.vaadin.flow.function.SerializableConsumer;
import elemental.json.JsonObject;
import java.io.Serializable;

@Tag(value="div")
@StyleSheet(value="context://vfp-window-buttons-bar.css")
public class WindowButtonsBar
extends Component
implements HasComponents {
    private Window window;
    private NativeButton minimize;
    private NativeButton maximize;
    private NativeButton close;
    private boolean minimizable = true;
    private boolean maximizable = true;
    private boolean closable = true;
    private boolean maximized = false;
    private boolean minimized = false;
    private String prevWidth = null;
    private String prevHeight = null;
    private boolean draggable;
    private boolean resizable;
    private JsonObject bounds;
    private JsonObject height;

    public WindowButtonsBar(Window window) {
        this.window = window;
        this.getElement().setAttribute("vfp-window-buttons-bar", "");
        this.initButtons();
    }

    private void initButtons() {
        this.minimize = new NativeButton();
        this.minimize.getElement().setAttribute("vfp-window-buttons-bar-minimize", "");
        this.minimize.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.minimized) {
                this.restoreMinimized();
            } else {
                if (this.maximized) {
                    this.restoreMaximized();
                }
                this.minimizeDialog();
            }
        });
        this.maximize = new NativeButton();
        this.maximize.getElement().setAttribute("vfp-window-buttons-bar-maximize", "");
        this.maximize.addClickListener((ComponentEventListener & Serializable)e -> {
            if (this.maximized) {
                this.restoreMaximized();
            } else {
                if (this.minimized) {
                    this.restoreMinimized();
                }
                this.maximizeDialog();
            }
        });
        this.close = new NativeButton();
        this.close.getElement().setAttribute("vfp-window-buttons-bar-close", "");
        this.close.addClickListener((ComponentEventListener & Serializable)e -> this.window.setVisible(false));
        this.add(new Component[]{this.minimize, this.maximize, this.close});
    }

    public boolean isClosable() {
        return this.closable;
    }

    public void setClosable(boolean closable) {
        this.closable = closable;
        this.close.setVisible(closable);
    }

    public boolean isMinimizable() {
        return this.minimizable;
    }

    public void setMinimizable(boolean minimizable) {
        this.minimizable = minimizable;
        this.minimize.setVisible(minimizable);
    }

    public boolean isMaximizable() {
        return this.maximizable;
    }

    public void setMaximizable(boolean maximizable) {
        this.maximizable = maximizable;
        this.maximize.setVisible(maximizable);
    }

    private void minimizeDialog() {
        this.window.getElement().executeJs("return { height: this.$.overlay.$.overlay.style.height || '' }", new Object[0]).then((SerializableConsumer & Serializable)jsonValue -> {
            this.window.getRootContainer().setVisible(false);
            this.height = (JsonObject)jsonValue;
            this.window.getElement().executeJs("this.$.overlay.$.overlay.style.height = 'auto'", new Object[0]);
        });
        this.minimized = true;
    }

    private void restoreMinimized() {
        this.window.getRootContainer().setVisible(true);
        this.window.getElement().executeJs("Object.assign(this.$.overlay.$.overlay.style, $0)", new Object[]{this.height});
        this.minimized = false;
    }

    private void maximizeDialog() {
        this.draggable = this.window.isDraggable();
        this.resizable = this.window.isResizable();
        this.prevWidth = this.window.getWidth();
        this.prevHeight = this.window.getHeight();
        this.window.getElement().executeJs("return this.$.overlay.getBounds()", new Object[0]).then((SerializableConsumer & Serializable)jsonValue -> {
            this.bounds = (JsonObject)jsonValue;
            this.window.setWidth("100vw");
            this.window.setHeight("100vh");
            this.window.getElement().executeJs("this.$.overlay.setBounds({ top: null, left: null });Object.assign(this.$.overlay.style, { top: 0, bottom: 0 })", new Object[0]);
        });
        this.window.setDraggable(false);
        this.window.setResizable(false);
        this.maximized = true;
    }

    private void restoreMaximized() {
        this.window.setDraggable(this.draggable);
        this.window.setResizable(this.resizable);
        this.window.setWidth(this.prevWidth);
        this.window.setHeight(this.prevHeight);
        this.window.getElement().executeJs("this.$.overlay.setBounds($0);Object.assign(this.$.overlay.style, { top: null, bottom: null });", new Object[]{this.bounds});
        this.maximized = false;
    }
}

