/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.data.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;

public class FSharedUtil
implements Serializable {
    public static final String SIZE_PATTERN = "^(-?\\d*(?:\\.\\d+)?)(%|px|em|rem|ex|in|cm|mm|pt|pc)?$";

    public static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static String trimTrailingSlashes(String value) {
        return value.replaceAll("/*$", "");
    }

    public static String[] splitCamelCase(String camelCaseString) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < camelCaseString.length(); ++i) {
            char c = camelCaseString.charAt(i);
            if (Character.isUpperCase(c) && FSharedUtil.isWordComplete(camelCaseString, i)) {
                sb.append(' ');
            }
            sb.append(c);
        }
        return sb.toString().split(" ");
    }

    private static boolean isWordComplete(String camelCaseString, int i) {
        if (i == 0) {
            return false;
        }
        if (!Character.isUpperCase(camelCaseString.charAt(i - 1))) {
            return true;
        }
        return i + 1 < camelCaseString.length() && !Character.isUpperCase(camelCaseString.charAt(i + 1));
    }

    public static String camelCaseToHumanFriendly(String camelCaseString) {
        String[] parts = FSharedUtil.splitCamelCase(camelCaseString);
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = FSharedUtil.capitalize(parts[i]);
        }
        return FSharedUtil.join(parts, " ");
    }

    public static String upperCaseUnderscoreToHumanFriendly(String upperCaseUnderscoreString) {
        String[] parts = upperCaseUnderscoreString.replaceFirst("^_*", "").split("_");
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = FSharedUtil.capitalize(parts[i].toLowerCase(Locale.ENGLISH));
        }
        return FSharedUtil.join(parts, " ");
    }

    private static boolean isAllUpperCase(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c) || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static String join(String[] parts, String separator) {
        if (parts.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            sb.append(parts[i]);
            sb.append(separator);
        }
        return sb.substring(0, sb.length() - separator.length());
    }

    public static String capitalize(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() <= 1) {
            return string.toUpperCase();
        }
        return string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
    }

    public static String propertyIdToHumanFriendly(Object propertyId) {
        String string = propertyId.toString();
        if (string.isEmpty()) {
            return "";
        }
        int dotLocation = string.lastIndexOf(46);
        if (dotLocation > 0 && dotLocation < string.length() - 1) {
            string = string.substring(dotLocation + 1);
        }
        if (string.matches("^[0-9A-Z_]+$")) {
            return FSharedUtil.upperCaseUnderscoreToHumanFriendly(string);
        }
        return FSharedUtil.camelCaseToHumanFriendly(string);
    }

    public static String addGetParameters(String uri, String extraParams) {
        if (extraParams == null || extraParams.length() == 0) {
            return uri;
        }
        String fragment = null;
        int hashPosition = ((String)uri).indexOf(35);
        if (hashPosition != -1) {
            fragment = ((String)uri).substring(hashPosition);
            uri = ((String)uri).substring(0, hashPosition);
        }
        uri = ((String)uri).contains("?") ? (String)uri + "&" : (String)uri + "?";
        uri = (String)uri + extraParams;
        if (fragment != null) {
            uri = (String)uri + fragment;
        }
        return uri;
    }

    public static String dashSeparatedToCamelCase(String dashSeparated) {
        if (dashSeparated == null) {
            return null;
        }
        String[] parts = dashSeparated.split("-");
        for (int i = 1; i < parts.length; ++i) {
            parts[i] = FSharedUtil.capitalize(parts[i]);
        }
        return FSharedUtil.join(parts, "");
    }

    public static boolean containsDuplicates(Object[] values) {
        int uniqueCount = new HashSet<Object>(Arrays.asList(values)).size();
        return uniqueCount != values.length;
    }

    public static String getDuplicates(Object[] values) {
        HashSet<Object> set = new HashSet<Object>();
        LinkedHashSet<String> duplicates = new LinkedHashSet<String>();
        for (Object o : values) {
            if (set.add(o)) continue;
            duplicates.add(String.valueOf(o));
        }
        return FSharedUtil.join(duplicates.toArray(new String[duplicates.size()]), ", ");
    }
}

