/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.util;

import com.vaadin.featurepack.util.RendererAdapter;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventBus;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.grid.SortOrderProvider;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class V8Utils {
    public static <T> Grid.Column<T> addColumn(Grid<T> grid, ValueProvider<T, ?> valueProvider, Renderer<T> renderer) {
        return grid.addColumn(new RendererAdapter(valueProvider, renderer));
    }

    public static void center(Dialog dialog) {
        dialog.getElement().executeJs("this._overlayElement.$.overlay.style.inset = ''", new Serializable[0]);
    }

    public static <T> void sort(Grid<T> grid, String columnKey) {
        V8Utils.sort(grid, columnKey, SortDirection.ASCENDING);
    }

    public static <T> void sort(Grid<T> grid, String columnKey, SortDirection dir) {
        grid.sort(Arrays.asList(new GridSortOrder(grid.getColumnByKey(columnKey), dir)));
    }

    public static <T> void setColumnOrder(Grid<T> grid, String ... columns) {
        grid.setColumnOrder(Stream.of(columns).map(key -> grid.getColumnByKey(key)).collect(Collectors.toList()));
    }

    public static <T> Binder.Binding<T, ?> getEditorBinding(Grid.Column<T> column) {
        return column.getGrid().getEditor().getBinder().getBinding(column.getKey()).orElse(null);
    }

    public static <T> boolean isHidden(Grid.Column<T> column) {
        return !column.isVisible();
    }

    public static <T> Grid.Column<T> setRenderer(Grid.Column<T> column, Renderer renderer) {
        ArrayList<Grid.Column> columns = new ArrayList<Grid.Column>(column.getGrid().getColumns());
        column.getGrid().removeColumnByKey(column.getKey());
        Grid.Column newColumn = column.getGrid().addColumn(renderer).setKey(column.getKey()).setClassNameGenerator(column.getClassNameGenerator()).setEditorComponent(column.getEditorComponent()).setComparator((Comparator)((SerializableComparator)V8Utils.getByField(column, "comparator"))).setSortOrderProvider((SortOrderProvider)V8Utils.getByField(column, "sortOrderProvider")).setAutoWidth(column.isAutoWidth()).setWidth(column.getWidth()).setFlexGrow(column.getFlexGrow()).setSortable(column.isSortable());
        newColumn.setTextAlign(column.getTextAlign());
        newColumn.setVisible(column.isVisible());
        V8Utils.invoke(newColumn, "com.vaadin.flow.component.grid.AbstractColumn", "setHeaderRenderer", Renderer.class, V8Utils.get(column, "com.vaadin.flow.component.grid.AbstractColumn", "getHeaderRenderer"));
        V8Utils.invoke(newColumn, "com.vaadin.flow.component.grid.AbstractColumn", "setFooterRenderer", Renderer.class, V8Utils.get(column, "com.vaadin.flow.component.grid.AbstractColumn", "getFooterRenderer"));
        columns.set(columns.indexOf(column), newColumn);
        column.getGrid().setColumnOrder(columns);
        return newColumn;
    }

    public static void setHeightByRows(Grid<?> grid, double rows) {
        if (rows < 1.0) {
            rows = 1.0;
        }
        int numOfHeaderRows = grid.getHeaderRows().size();
        int numOfFooterRows = grid.getFooterRows().size();
        grid.getStyle().set("height", String.format("calc((%d * var(--lumo-size-xl)) + (%d * var(--lumo-size-m)) + ((%.0f * var(--lumo-size-m)) - var(--_lumo-grid-border-width)))", numOfHeaderRows, numOfFooterRows, rows));
    }

    public static void addWindow(UI ui, Dialog dialog) {
        dialog.open();
    }

    public static void removeWindow(UI ui, Dialog dialog) {
        dialog.close();
    }

    public static void setClosable(Dialog dialog, boolean closable) {
        dialog.setCloseOnEsc(closable);
        dialog.setCloseOnOutsideClick(closable);
    }

    public static void setContent(Component component, Component componentToSet) {
        if (component instanceof HasComponents) {
            HasComponents hasComponents = (HasComponents)component;
            hasComponents.removeAll();
            if (componentToSet != null) {
                hasComponents.add(new Component[]{componentToSet});
            }
        } else {
            component.getElement().removeAllChildren();
            if (componentToSet != null) {
                component.getElement().appendChild(new Element[]{componentToSet.getElement()});
            }
        }
    }

    public static void setWidth(Component component, float width, Unit unit) {
        if (component instanceof HasSize) {
            HasSize hasSize = (HasSize)component;
            hasSize.setWidth(width, unit);
        } else {
            if (unit == null) {
                throw new IllegalArgumentException("Unit can not be null");
            }
            component.getElement().getStyle().set("width", HasSize.getCssSize((float)width, (Unit)unit));
        }
    }

    public static void setHeight(Component component, float height, Unit unit) {
        if (component instanceof HasSize) {
            HasSize hasSize = (HasSize)component;
            hasSize.setHeight(height, unit);
        } else {
            if (unit == null) {
                throw new IllegalArgumentException("Unit can not be null");
            }
            component.getElement().getStyle().set("height", HasSize.getCssSize((float)height, (Unit)unit));
        }
    }

    private static Object getByField(Object target, String fieldName) {
        try {
            Field field = target.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(target);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Object get(Object target, String declaringClassQualifiedName, String methodName) {
        try {
            Method method = Class.forName(declaringClassQualifiedName).getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return method.invoke(target, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void invoke(Object target, String declaringClassQualifiedName, String methodName, Class argType, Object arg) {
        try {
            Method method = Class.forName(declaringClassQualifiedName).getDeclaredMethod(methodName, argType);
            method.setAccessible(true);
            method.invoke(target, arg);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static void invoke(Object target, String declaringClassQualifiedName, String methodName, Class argType1, Object arg1, Class argType2, Object arg2) {
        try {
            Method method = Class.forName(declaringClassQualifiedName).getDeclaredMethod(methodName, argType1, argType2);
            method.setAccessible(true);
            method.invoke(target, arg1, arg2);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void setLabel(Object component, String content) {
        if (component != null) {
            if (component instanceof HasLabel) {
                ((HasLabel)component).setLabel(content);
            } else if (component instanceof Button) {
                ((Button)component).setText(content);
            }
        }
    }

    public static String getLabel(Object component) {
        if (component != null) {
            if (component instanceof HasLabel) {
                return ((HasLabel)component).getLabel();
            }
            if (component instanceof Button) {
                return ((Button)component).getText();
            }
        }
        return null;
    }

    public static <T extends ComponentEvent<?>> void removeListener(Component component, ComponentEventListener<T> listener) {
        if (component != null && listener != null) {
            ComponentEventBus componentEventBus = V8Utils.getComponentEventBus(component);
            HashMap componentEventData = (HashMap)V8Utils.getByField(componentEventBus, "componentEventData");
            assert (componentEventData != null);
            HashMap<Class, List> wrappers = new HashMap<Class, List>();
            componentEventData.forEach((key, value) -> {
                List list = (List)value;
                wrappers.put((Class)key, list.stream().filter(wrapper -> V8Utils.getByField(wrapper, "listener") == listener).toList());
            });
            wrappers.forEach((key, value) -> value.forEach(wrapper -> V8Utils.invoke(componentEventBus, "com.vaadin.flow.component.ComponentEventBus", "removeListener", Class.class, key, wrapper.getClass(), wrapper)));
        }
    }

    private static ComponentEventBus getComponentEventBus(Component component) {
        if (component != null) {
            return (ComponentEventBus)V8Utils.get(component, Component.class.getName(), "getEventBus");
        }
        return null;
    }
}

