/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui;

import com.vaadin.featurepack.data.Property;
import com.vaadin.featurepack.data.converter.Converter;
import com.vaadin.featurepack.data.util.converter.ConverterUtil;
import com.vaadin.featurepack.server.Helpers;
import com.vaadin.featurepack.shared.ui.ContentMode;
import com.vaadin.featurepack.ui.AbstractComponent;
import com.vaadin.featurepack.ui.Event;
import com.vaadin.featurepack.util.TooltipUtils;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tag(value="div")
@CssImport(value="./label.css")
@JsModule(value="@vaadin/vaadin-lumo-styles/font-icons.js")
public class Label
extends AbstractComponent
implements Property<String>,
Property.Viewer,
Property.ValueChangeListener,
Property.ValueChangeNotifier {
    private static final String V_CAPTION = "v-caption";
    private static final String V_CAPTIONTEXT = "v-captiontext";
    private static final String V_HAS_CAPTION = "v-has-caption";
    private static final String V_CAPTION_ON_TOP = "v-caption-on-top";
    private static long idCounter = 0L;
    private Element vCaption;
    private Element vCaptionText;
    private final VLabel vLabel;
    private final String captionId;
    private boolean isLabelUsingServerGeneratedId;
    private com.vaadin.flow.data.converter.Converter<String, Object> converter = null;
    private Property<String> dataSource = null;
    private Map<Object, Registration> valueChangeListeners = new HashMap<Object, Registration>();

    @Override
    public void beforeClientResponse(boolean initial) {
        this.getElement().setAttribute("class", String.join((CharSequence)" ", this.getInternalStyles()));
        if (this.vCaption != null) {
            this.vCaption.setAttribute("class", this.createVCaptionClassNames());
        }
    }

    public Label() {
        this("");
    }

    public Label(String text) {
        this(text, ContentMode.TEXT);
    }

    public Label(String text, ContentMode contentMode) {
        this.getElement().getStyle().set("display", "contents");
        this.captionId = this.generateId();
        this.vLabel = new VLabel(text, contentMode);
        this.getElement().appendChild(new Element[]{this.vLabel.getElement()});
        if (Helpers.isVaadin7Defaults()) {
            this.setWidth(100.0f, Unit.PERCENTAGE);
        }
    }

    public Label(Property contentSource) {
        this(contentSource, ContentMode.TEXT);
    }

    public Label(Property contentSource, ContentMode contentMode) {
        this((String)null, contentMode);
        this.setPropertyDataSource(contentSource);
    }

    @Override
    public void setDescription(String description) {
        TooltipUtils.setDescription(this.vLabel, description);
    }

    @Override
    public void setDescription(String description, ContentMode contentMode) {
        TooltipUtils.setDescription(this.vLabel, description, contentMode);
    }

    @Override
    public String getCaption() {
        return super.getCaption();
    }

    @Override
    public void setCaption(String caption) {
        if (Objects.equals(caption, this.getCaption())) {
            return;
        }
        super.setCaption(caption);
        if (this.getCaption() == null) {
            this.removeCaption();
        } else {
            this.addCaption();
        }
        this.markAsDirty();
    }

    public void setLabel(String label) {
        super.setLabel(label);
        this.setCaption(label);
    }

    public ContentMode getContentMode() {
        return this.vLabel.getContentMode();
    }

    public void setContentMode(ContentMode contentMode) {
        this.vLabel.setContentMode(contentMode);
    }

    @Override
    public void setValue(String value) {
        if (this.getPropertyDataSource() == null) {
            String oldTextValue = this.vLabel.getValue();
            if (!Objects.equals(oldTextValue, value)) {
                this.vLabel.setValue(value);
                this.fireValueChange();
            }
        } else {
            throw new IllegalStateException("Label is only a Property.Viewer and cannot update its data source");
        }
    }

    @Override
    public String getValue() {
        if (this.getPropertyDataSource() == null) {
            return this.vLabel.getValue();
        }
        return this.getDataSourceValue();
    }

    @Override
    public void setCaptionAsHtml(boolean captionAsHtml) {
        super.setCaptionAsHtml(captionAsHtml);
        this.updateVCaptionText();
    }

    @Override
    public boolean isCaptionAsHtml() {
        return super.isCaptionAsHtml();
    }

    public Stream<Component> getChildren() {
        return Stream.empty();
    }

    @Override
    public void setWidth(String width) {
        this.vLabel.setWidth(width);
    }

    @Override
    public void setWidth(float width, Unit unit) {
        this.vLabel.setWidth(width, unit);
    }

    @Override
    public float getWidth() {
        return this.vLabel.getWidth();
    }

    @Override
    public Unit getWidthUnits() {
        return this.vLabel.getWidthUnits();
    }

    @Override
    public void setHeight(String height) {
        this.vLabel.setHeight(height);
    }

    @Override
    public void setHeight(float height, Unit unit) {
        this.vLabel.setHeight(height, unit);
    }

    @Override
    public float getHeight() {
        return this.vLabel.getHeight();
    }

    @Override
    public Unit getHeightUnits() {
        return this.vLabel.getHeightUnits();
    }

    @Override
    public void setSizeFull() {
        this.vLabel.setSizeFull();
    }

    @Override
    public void setWidthFull() {
        this.vLabel.setWidthFull();
    }

    @Override
    public void setHeightFull() {
        this.vLabel.setHeightFull();
    }

    @Override
    public void setSizeUndefined() {
        this.vLabel.setSizeUndefined();
    }

    @Override
    public void setWidthUndefined() {
        this.vLabel.setWidthUndefined();
    }

    @Override
    public void setHeightUndefined() {
        this.vLabel.setHeightUndefined();
    }

    @Override
    public String getStyleName() {
        return this.vLabel.getStyleName();
    }

    @Override
    public void setStyleName(String style) {
        this.vLabel.setStyleName(style);
    }

    @Override
    public void setStyleName(String style, boolean add) {
        this.vLabel.setStyleName(style, add);
    }

    @Override
    public void addStyleName(String style) {
        this.vLabel.addStyleName(style);
    }

    @Override
    public void addStyleNames(String ... styles) {
        this.vLabel.addStyleNames(styles);
    }

    @Override
    public void removeStyleName(String style) {
        this.vLabel.removeStyleName(style);
    }

    @Override
    public void removeStyleNames(String ... styles) {
        this.vLabel.removeStyleNames(styles);
    }

    @Override
    public String getPrimaryStyleName() {
        return this.vLabel.getPrimaryStyleName();
    }

    @Override
    public void setPrimaryStyleName(String style) {
        this.vLabel.setPrimaryStyleName(style);
    }

    @Override
    protected Collection<String> getCustomStyles() {
        return this.vLabel.getCustomStyles();
    }

    public boolean isEnabled() {
        return this.vLabel.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.markAsDirty();
        this.vLabel.setEnabled(enabled);
    }

    public void setId(String id) {
        if (this.isLabelUsingServerGeneratedId && "".equals(id)) {
            return;
        }
        this.vLabel.setId(id);
        this.isLabelUsingServerGeneratedId = false;
        this.setCaptionHtmlForAttribute();
    }

    public Optional<String> getId() {
        return this.vLabel.getId();
    }

    @Override
    public Class<String> getType() {
        return String.class;
    }

    private String getDataSourceValue() {
        return ConverterUtil.convertFromModel(this, this.getPropertyDataSource().getValue(), String.class, this.getConverter());
    }

    @Override
    public boolean isPropertyReadOnly() {
        return true;
    }

    @Override
    public void setPropertyReadOnly(boolean newStatus) {
    }

    @Override
    public Property getPropertyDataSource() {
        return this.dataSource;
    }

    @Override
    public void setPropertyDataSource(Property newDataSource) {
        if (this.dataSource != null && Property.ValueChangeNotifier.class.isAssignableFrom(this.dataSource.getClass())) {
            ((Property.ValueChangeNotifier)((Object)this.dataSource)).removeValueChangeListener(this);
        }
        if (newDataSource != null && !ConverterUtil.canConverterPossiblyHandle(this.getConverter(), this.getType(), newDataSource.getType())) {
            Converter c = ConverterUtil.getConverter(String.class, newDataSource.getType());
            this.setConverter(c);
        }
        this.dataSource = newDataSource;
        if (this.dataSource != null) {
            this.updateValueFromDataSource();
        }
        if (this.dataSource != null && Property.ValueChangeNotifier.class.isAssignableFrom(this.dataSource.getClass())) {
            ((Property.ValueChangeNotifier)((Object)this.dataSource)).addValueChangeListener(this);
        }
        this.markAsDirty();
    }

    @Override
    public void valueChange(Property.ValueChangeEvent event) {
        this.updateValueFromDataSource();
    }

    private void updateValueFromDataSource() {
        String newConvertedValue = this.getDataSourceValue();
        if (!Objects.equals(newConvertedValue, this.vLabel.getValue())) {
            this.vLabel.setValue(newConvertedValue);
            this.fireValueChange();
        }
    }

    protected void fireValueChange() {
        this.fireEvent(new ValueChangeEvent(this));
    }

    public com.vaadin.flow.data.converter.Converter<String, Object> getConverter() {
        return this.converter;
    }

    public void setConverter(com.vaadin.flow.data.converter.Converter<String, ?> converter) {
        this.converter = converter;
        this.markAsDirty();
    }

    @Override
    public void addValueChangeListener(Property.ValueChangeListener listener) {
        this.valueChangeListeners.put(listener, ComponentUtil.addListener((Component)this, ValueChangeEvent.class, (ComponentEventListener & Serializable)event -> listener.valueChange((Property.ValueChangeEvent)event)));
    }

    @Override
    public void removeValueChangeListener(Property.ValueChangeListener listener) {
        if (this.valueChangeListeners.containsKey(listener)) {
            this.valueChangeListeners.get(listener).remove();
        }
    }

    private String createVCaptionClassNames() {
        Stream<String> vCaptionClasses = Stream.concat(Stream.of(V_CAPTION, this.isEnabled() ? "" : "v-disabled"), this.getCustomStyles().stream().map(styleClass -> "v-caption-" + styleClass));
        return String.join((CharSequence)" ", vCaptionClasses.collect(Collectors.toSet()));
    }

    private void removeCaption() {
        this.getElement().getStyle().set("display", "contents");
        this.getElement().removeChild(new Element[]{this.vCaption});
        this.vCaption = null;
        this.vCaptionText = null;
        this.removeInternalStyles(V_HAS_CAPTION, V_CAPTION_ON_TOP);
        this.vLabel.removeAriaLabelledBy();
    }

    private void addCaption() {
        if (this.vCaption != null) {
            this.updateVCaptionText();
            return;
        }
        this.getElement().getStyle().remove("display");
        this.addCaptionElements();
        this.setCaptionHtmlForAttribute();
        this.addInternalStyles(V_HAS_CAPTION, V_CAPTION_ON_TOP);
        this.vLabel.setAriaLabelledBy(this.captionId);
    }

    private void updateVCaptionText() {
        String text;
        if (this.getCaption() == null) {
            return;
        }
        String string = text = this.getCaption().isEmpty() ? "\u00a0" : this.getCaption();
        if (this.isCaptionAsHtml()) {
            this.vCaptionText.setProperty("innerHTML", text);
        } else {
            this.vCaptionText.setText(text);
        }
    }

    private void addCaptionElements() {
        if (this.vCaption != null) {
            return;
        }
        this.vCaptionText = ElementFactory.createSpan();
        this.vCaptionText.getClassList().add((Object)V_CAPTIONTEXT);
        this.updateVCaptionText();
        this.vCaption = ElementFactory.createDiv();
        this.vCaption.setAttribute("id", this.captionId);
        this.vCaption.appendChild(new Element[]{this.vCaptionText});
        this.getElement().insertChild(0, new Element[]{this.vCaption});
    }

    private void setCaptionHtmlForAttribute() {
        if (this.vCaption == null) {
            return;
        }
        if (!this.getId().isPresent()) {
            this.vLabel.setId(this.generateId());
            this.isLabelUsingServerGeneratedId = true;
        }
        this.vCaption.setAttribute("for", this.getId().get());
    }

    private String generateId() {
        return "lcp-label-" + ++idCounter;
    }

    @Tag(value="div")
    static class VLabel
    extends AbstractComponent {
        private static final String defaultPrimaryStyle = "v-label";
        private static final String V_LABEL_UNDEF_W = "v-label-undef-w";
        private ContentMode contentMode;
        private String value;

        @Override
        public void beforeClientResponse(boolean initial) {
            super.beforeClientResponse(initial);
            String primaryStyleName = this.getPrimaryStyleName();
            if (primaryStyleName != null && !defaultPrimaryStyle.equals(primaryStyleName)) {
                this.getElement().getClassList().set(primaryStyleName + "-undef-w", this.getWidth() == -1.0f);
            }
            this.getElement().getClassList().set(V_LABEL_UNDEF_W, this.getWidth() == -1.0f);
        }

        public VLabel(String text, ContentMode contentMode) {
            this.setPrimaryStyleName(defaultPrimaryStyle);
            this.value = text;
            this.contentMode = contentMode;
            this.updatePresentation();
        }

        public ContentMode getContentMode() {
            return this.contentMode;
        }

        public void setContentMode(ContentMode contentMode) {
            if (contentMode == this.contentMode) {
                return;
            }
            this.contentMode = contentMode;
            this.updatePresentation();
        }

        public void setValue(String value) {
            this.value = value == null ? "" : value;
            this.updatePresentation();
        }

        public String getValue() {
            return this.value;
        }

        public void removeAriaLabelledBy() {
            this.getElement().removeAttribute("aria-labelledby");
        }

        public void setAriaLabelledBy(String id) {
            this.getElement().setAttribute("aria-labelledby", id);
        }

        @Override
        public void notifyParentAboutStyleChanges() {
            this.getParent().ifPresent(parent -> {
                ((Label)parent).markAsDirty();
                ((Label)parent).notifyParentAboutStyleChanges();
            });
        }

        private void updatePresentation() {
            switch (this.contentMode) {
                case TEXT: {
                    this.getElement().setText(this.value);
                    break;
                }
                case PREFORMATTED: {
                    this.getElement().removeAllChildren();
                    this.getElement().appendChild(new Element[]{ElementFactory.createPreformatted((String)this.value)});
                    break;
                }
                case HTML: {
                    this.getElement().setProperty("innerHTML", this.value);
                }
            }
        }
    }

    public static class ValueChangeEvent
    extends Event
    implements Property.ValueChangeEvent {
        public ValueChangeEvent(Label source) {
            super(source);
        }

        @Override
        public Property getProperty() {
            return (Property)this.getSource();
        }
    }
}

