/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui;

import com.vaadin.featurepack.ui.ValueToDisplayedTextConverter;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.HasValueAndElement;
import com.vaadin.flow.dom.DomEventListener;
import java.io.Serializable;

public class InputSelectionController<V>
implements Serializable {
    private final HasValueAndElement<?, V> inputComponent;
    private final ValueToDisplayedTextConverter<V> valueToDisplayedText;
    private int lastKnownCursorPosition;

    public InputSelectionController(HasValueAndElement<?, V> inputComponent, ValueToDisplayedTextConverter<V> valueToDisplayedText) {
        this.inputComponent = inputComponent;
        this.valueToDisplayedText = valueToDisplayedText;
        this.lastKnownCursorPosition = this.getValueLength();
        inputComponent.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            this.lastKnownCursorPosition = this.getValueLength();
        });
        this.initClientSideCursorEventListeners(inputComponent);
    }

    void setCursorPosition(int pos) {
        this.setSelectionRange(pos, 0);
        this.lastKnownCursorPosition = pos;
    }

    int getCursorPosition() {
        return this.lastKnownCursorPosition;
    }

    void selectAll() {
        this.setSelectionRange(0, this.getValueLength());
    }

    void setSelectionRange(int pos, int length) {
        HasValueAndElement<?, V> hasValueAndElement = this.inputComponent;
        if (hasValueAndElement instanceof Focusable) {
            Focusable focusable = (Focusable)hasValueAndElement;
            focusable.focus();
        }
        this.inputComponent.getElement().executeJs("this.inputElement.setSelectionRange($0, $1)", new Serializable[]{Integer.valueOf(pos), Integer.valueOf(pos + length)});
        this.lastKnownCursorPosition = pos + length;
    }

    private int getValueLength() {
        String text = (String)this.valueToDisplayedText.apply(this.inputComponent.getValue());
        return text == null ? 0 : text.length();
    }

    private void initClientSideCursorEventListeners(HasValueAndElement<?, V> inputComponent) {
        inputComponent.getElement().addEventListener("cursor-position-changed", (DomEventListener & Serializable)e -> {
            this.lastKnownCursorPosition = (int)e.getEventData().getNumber("event.detail.position");
        }).addEventData("event.detail.position").debounce(200);
        inputComponent.getElement().executeJs("const input = this.inputElement;\nconst dispatchCursorPosition = () => {\n  this.dispatchEvent(new CustomEvent('cursor-position-changed', {\n    detail: { position: input.selectionEnd }\n  }));\n};\n['click', 'keyup', 'input', 'focus', 'blur'].forEach((eventType) =>\n  input.addEventListener(eventType, dispatchCursorPosition));", new Serializable[0]);
    }
}

