/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui;

import com.vaadin.featurepack.shared.ui.gridlayout.GridLayoutState;
import com.vaadin.featurepack.ui.AbstractLayout;
import com.vaadin.featurepack.ui.AbstractSingleComponentContainer;
import com.vaadin.featurepack.ui.Alignment;
import com.vaadin.featurepack.ui.Layout;
import com.vaadin.featurepack.ui.MarginInfo;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.function.SerializableConsumer;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

@Tag(value="div")
@JsModule(value="./grid-layout.js")
@CssImport(value="./grid-layout.css")
public class GridLayout
extends AbstractLayout
implements Layout.SpacingHandler,
Layout.AlignmentHandler,
Layout.MarginHandler {
    public static final String PRIMARY_STYLE_NAME = "v-gridlayout";
    private int columns;
    private int rows;
    private Cell[][] cells;
    private final HashMap<Component, Cell> componentCellMap = new HashMap();
    private final LinkedList<Component> components = new LinkedList();
    private int cursorX;
    private int cursorY;
    private float[] colExpandRatios;
    private float[] rowExpandRatios;
    private boolean spacing = false;
    private Alignment defaultAlignment = Alignment.TOP_LEFT;
    private boolean hideEmptyRowsAndColumns = false;
    private MarginInfo marginInfo = new MarginInfo(false);
    private boolean pendingUpdate = false;
    private Component labelComponent;

    public GridLayout() {
        this(1, 1);
    }

    public GridLayout(int columns, int rows) {
        this.setPrimaryStyleName(PRIMARY_STYLE_NAME);
        this.addInternalStyles("v-layout");
        this.addInternalStyles("v-widget");
        this.cells = new Cell[rows][columns];
        this.rowExpandRatios = new float[rows];
        this.colExpandRatios = new float[columns];
        Arrays.fill(this.rowExpandRatios, 0.0f);
        Arrays.fill(this.colExpandRatios, 0.0f);
        this.setColumns(columns);
        this.setRows(rows);
        this.getElement().executeJs("window.Vaadin.ClassicComponents.gridLayoutConnector.initLazy(this)", new Serializable[0]);
    }

    public GridLayout(int columns, int rows, Component ... children) {
        this(columns, rows);
        this.addComponents(children);
    }

    @Override
    public void beforeClientResponse(boolean initial) {
        super.beforeClientResponse(initial);
        if (!initial) {
            this.getElement().executeJs("window.Vaadin.ClassicComponents.gridLayoutConnector.initLazy(this)", new Serializable[0]);
        }
    }

    @Override
    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
    }

    @Override
    public void addComponent(Component component) {
        Objects.requireNonNull(component, "Component must not be null");
        boolean done = false;
        do {
            Cell availableArea = new Cell(null, this.cursorX, this.cursorY, this.cursorX, this.cursorY);
            try {
                this.checkExistingOverlaps(availableArea);
                done = true;
            }
            catch (OverlapsException e) {
                if (this.cursorX == this.columns - 1 && this.cursorY == this.rows - 1) {
                    this.appendRow();
                }
                this.space();
            }
        } while (!done);
        this.addComponent(component, this.cursorX, this.cursorY);
    }

    public void addComponent(Component component, int column, int row) throws OverlapsException, OutOfBoundsException {
        this.addComponent(component, column, row, column, row);
    }

    public void add(Component component, int column, int row) throws OverlapsException, OutOfBoundsException {
        this.addComponent(component, column, row, column, row);
    }

    public void addComponent(Component component, int column1, int row1, int column2, int row2) throws OverlapsException, OutOfBoundsException {
        Objects.requireNonNull(component, "Component must not be null");
        if (this.components.contains(component)) {
            throw new IllegalArgumentException("Component is already in container");
        }
        Cell cell = new Cell(component, column1, row1, column2, row2);
        cell.setAlignment(this.defaultAlignment);
        if (column2 < column1 || row2 < row1) {
            throw new IllegalArgumentException(String.format("Illegal coordinates for the component: %s!<=%s, %s!<=%s", column1, column2, row1, row2));
        }
        if (column1 < 0 || row1 < 0 || column2 >= this.columns || row2 >= this.rows) {
            throw new OutOfBoundsException(cell);
        }
        this.checkExistingOverlaps(cell);
        boolean added = false;
        int index = 0;
        for (Component c : this.components) {
            Cell existingArea = this.componentCellMap.get(c);
            if (existingArea.y1 >= row1 && existingArea.x1 > column1 || existingArea.y1 > row1) {
                this.components.add(index, component);
                added = true;
                break;
            }
            ++index;
        }
        if (!added) {
            this.components.addLast(component);
        }
        this.componentCellMap.put(component, cell);
        try {
            cell.getElement().setAttribute("x", String.valueOf(column1));
            cell.getElement().setAttribute("y", String.valueOf(row1));
            super.addComponentAtIndex(index, (Component)cell);
            this.cells[column1][row1] = cell;
        }
        catch (IllegalArgumentException e) {
            this.componentCellMap.remove(component);
            this.components.remove(component);
            throw e;
        }
        if (this.cursorX >= column1 && this.cursorX <= column2 && this.cursorY >= row1 && this.cursorY <= row2) {
            this.cursorX = column2 + 1;
            if (this.cursorX >= this.columns) {
                if (row2 + 1 == this.rows) {
                    this.cursorX = column2;
                    this.cursorY = row2;
                } else {
                    this.cursorX = 0;
                    this.cursorY = (column1 == 0 ? row2 : row1) + 1;
                }
            } else {
                this.cursorY = row1;
            }
        }
        this.scheduleUpdate();
    }

    public void add(Component component, int column1, int row1, int column2, int row2) {
        this.addComponent(component, column1, row1, column2, row2);
    }

    @Override
    public void removeComponent(Component component) {
        if (component == null || !this.components.contains(component)) {
            return;
        }
        Cell cell = this.componentCellMap.remove(component);
        this.components.remove(component);
        super.removeComponent(cell);
        this.scheduleUpdate();
    }

    public void removeComponent(int column, int row) {
        this.componentCellMap.values().stream().filter(cell -> cell.x1 == column && cell.y1 == row).findFirst().map(AbstractSingleComponentContainer::getContent).ifPresent(this::removeComponent);
    }

    public void remove(int column, int row) {
        this.removeComponent(column, row);
    }

    @Override
    public void removeAllComponents() {
        super.removeAllComponents();
        this.setCursorX(0);
        this.setCursorY(0);
    }

    public Component getComponent(int x, int y) {
        return this.componentCellMap.values().stream().filter(cell -> cell.x1 <= x && x <= cell.x2 && cell.y1 <= y && y <= cell.y2).findFirst().map(AbstractSingleComponentContainer::getContent).orElse(null);
    }

    public Area getComponentArea(Component component) {
        Cell cell = this.componentCellMap.get(component);
        if (cell == null) {
            return null;
        }
        return new Area(component, cell.x1, cell.y1, cell.x2, cell.y2);
    }

    @Override
    public void setComponentAlignment(Component childComponent, Alignment alignment) {
        Cell cell = this.componentCellMap.get(childComponent);
        if (cell != null) {
            cell.setAlignment(alignment);
            this.scheduleUpdate();
        }
    }

    @Override
    public Alignment getComponentAlignment(Component childComponent) {
        Cell cell = this.componentCellMap.get(childComponent);
        return cell == null ? null : cell.getAlignment();
    }

    @Override
    public void setDefaultComponentAlignment(Alignment defaultComponentAlignment) {
        this.defaultAlignment = defaultComponentAlignment;
    }

    @Override
    public Alignment getDefaultComponentAlignment() {
        return this.defaultAlignment;
    }

    @Override
    public void setMargin(boolean enabled) {
        this.setMargin(new MarginInfo(enabled));
    }

    @Override
    public void setMargin(MarginInfo marginInfo) {
        this.marginInfo = marginInfo;
        if (marginInfo.hasTop()) {
            this.addStyleName("margin-top");
        } else {
            this.removeStyleName("margin-top");
        }
        if (marginInfo.hasRight()) {
            this.addStyleName("margin-right");
        } else {
            this.removeStyleName("margin-right");
        }
        if (marginInfo.hasBottom()) {
            this.addStyleName("margin-bottom");
        } else {
            this.removeStyleName("margin-bottom");
        }
        if (marginInfo.hasLeft()) {
            this.addStyleName("margin-left");
        } else {
            this.removeStyleName("margin-left");
        }
        this.scheduleUpdate();
    }

    @Override
    public MarginInfo getMargin() {
        return this.marginInfo;
    }

    public void setHideEmptyRowsAndColumns(boolean hideEmptyRowsAndColumns) {
        this.hideEmptyRowsAndColumns = hideEmptyRowsAndColumns;
        this.getElement().executeJs("setTimeout(() => { this.$connector.hideEmptyRowsAndColumns = " + hideEmptyRowsAndColumns + "; this.$connector.update(); })", new Serializable[0]);
    }

    public boolean isHideEmptyRowsAndColumns() {
        return this.hideEmptyRowsAndColumns;
    }

    public void setRowExpandRatio(int rowIndex, float ratio) {
        this.rowExpandRatios[rowIndex] = ratio;
        JsonArray rowExpandRatios = Json.createArray();
        for (int i = 0; i < this.rowExpandRatios.length; ++i) {
            rowExpandRatios.set(i, (double)this.rowExpandRatios[i]);
        }
        this.getElement().setPropertyJson("rowExpandRatios", (JsonValue)rowExpandRatios);
        this.scheduleUpdate();
        this.markAsDirty();
    }

    public float getRowExpandRatio(int rowIndex) {
        return this.rowExpandRatios[rowIndex];
    }

    public void setColumnExpandRatio(int colIndex, float ratio) {
        this.colExpandRatios[colIndex] = ratio;
        JsonArray colExpandRatios = Json.createArray();
        for (int i = 0; i < this.colExpandRatios.length; ++i) {
            colExpandRatios.set(i, (double)this.colExpandRatios[i]);
        }
        this.getElement().setPropertyJson("colExpandRatios", (JsonValue)colExpandRatios);
        this.scheduleUpdate();
        this.markAsDirty();
    }

    public float getColumnExpandRatio(int colIndex) {
        return this.colExpandRatios[colIndex];
    }

    public void insertRow(int index) {
        if (index > this.rows) {
            throw new IllegalArgumentException("Cannot insert row at " + index + " in a gridlayout with height: " + this.rows);
        }
        for (Map.Entry<Component, Cell> entry : this.componentCellMap.entrySet()) {
            Cell existingArea = entry.getValue();
            if (existingArea.y2 < index) continue;
            ++existingArea.y2;
            if (existingArea.y1 < index) continue;
            ++existingArea.y1;
        }
        if (this.cursorY >= index) {
            ++this.cursorY;
        }
        this.setRows(this.rows + 1);
        this.markAsDirty();
    }

    public void setColumns(int columns) {
        if (columns < 1) {
            throw new IllegalArgumentException("The number of columns in the grid must be at least 1");
        }
        if (this.columns == columns) {
            return;
        }
        if (columns < this.columns) {
            for (Cell area : this.componentCellMap.values()) {
                if (area.x2 < columns) continue;
                throw new OutOfBoundsException(area);
            }
        }
        this.columns = columns;
        this.getElement().setProperty("columns", (double)columns);
        this.updateCellsArray();
        this.colExpandRatios = Arrays.copyOf(this.colExpandRatios, columns);
        JsonArray jsonColExpandRatios = Json.createArray();
        for (int i = 0; i < columns; ++i) {
            jsonColExpandRatios.set(i, (double)this.colExpandRatios[i]);
        }
        this.getElement().setPropertyJson("colExpandRatios", (JsonValue)jsonColExpandRatios);
    }

    public int getColumns() {
        return this.columns;
    }

    public void setRows(int rows) {
        if (rows < 1) {
            throw new IllegalArgumentException("The number of rows in the grid must be at least 1");
        }
        if (this.rows == rows) {
            return;
        }
        if (rows < this.rows) {
            for (Cell existingArea : this.componentCellMap.values()) {
                if (existingArea.y2 < rows) continue;
                throw new OutOfBoundsException(existingArea);
            }
        }
        this.rows = rows;
        this.getElement().setProperty("rows", (double)rows);
        this.updateCellsArray();
        this.rowExpandRatios = Arrays.copyOf(this.rowExpandRatios, rows);
        JsonArray jsonRowExpandRatios = Json.createArray();
        for (int i = 0; i < rows; ++i) {
            jsonRowExpandRatios.set(i, (double)this.rowExpandRatios[i]);
        }
        this.getElement().setPropertyJson("rowExpandRatios", (JsonValue)jsonRowExpandRatios);
    }

    public int getRows() {
        return this.rows;
    }

    public int getCursorX() {
        return this.cursorX;
    }

    public void setCursorX(int cursorX) throws IndexOutOfBoundsException {
        if (cursorX < 0 || cursorX >= this.getColumns()) {
            throw new IndexOutOfBoundsException("Cursor's X coordinate cannot be set at :" + cursorX + " on a grid with " + this.getColumns() + " columns.");
        }
        this.cursorX = cursorX;
    }

    public int getCursorY() {
        return this.cursorY;
    }

    public void setCursorY(int cursorY) throws IndexOutOfBoundsException {
        if (cursorY < 0 || cursorY >= this.getRows()) {
            throw new IndexOutOfBoundsException("Cursor's Y coordinate cannot be set at :" + cursorY + " on a grid with " + this.getRows() + " rows.");
        }
        this.cursorY = cursorY;
    }

    public void appendRow() {
        this.insertRow(this.cursorY + 1);
    }

    public void removeRow(int row) {
        if (row < 0 || row >= this.getRows()) {
            throw new IllegalArgumentException("Cannot delete row " + row + " from a grid-layout with height " + this.getRows());
        }
        for (int col = 0; col < this.getColumns(); ++col) {
            this.removeComponent(col, row);
        }
        for (Cell cell : this.componentCellMap.values()) {
            if (cell.y2 < row) continue;
            --cell.y2;
            if (cell.y1 <= row) continue;
            --cell.y1;
        }
        if (this.rows == 1) {
            this.cursorX = 0;
            this.cursorY = 0;
        } else {
            this.setRows(this.rows - 1);
        }
        this.markAsDirty();
    }

    public void space() {
        ++this.cursorX;
        if (this.cursorX >= this.columns) {
            this.cursorX = 0;
            ++this.cursorY;
        }
        if (this.cursorY >= this.rows) {
            this.cursorX = this.columns - 1;
            this.cursorY = this.rows - 1;
        }
    }

    public void newLine() {
        if (this.cursorY < this.rows - 1) {
            this.cursorX = 0;
            ++this.cursorY;
        }
    }

    @Override
    public void setSpacing(boolean spacing) {
        this.spacing = spacing;
        if (spacing) {
            this.getElement().setAttribute("spacing", true);
        } else {
            this.getElement().removeAttribute("spacing");
        }
        this.scheduleUpdate();
    }

    @Override
    public boolean isSpacing() {
        return this.spacing;
    }

    public Stream<Component> getChildren() {
        return this.components.stream();
    }

    public void replace(Component oldComponent, Component newComponent) {
        this.replaceComponent(oldComponent, newComponent);
    }

    @Override
    public void replaceComponent(Component oldComponent, Component newComponent) {
        Cell oldCell = this.componentCellMap.get(oldComponent);
        Cell newCell = this.componentCellMap.get(newComponent);
        if (oldCell == null) {
            this.addComponent(newComponent);
        } else if (newCell == null) {
            int index = this.components.indexOf(oldComponent);
            this.components.add(index, newComponent);
            this.components.remove(oldComponent);
            Cell cell = this.componentCellMap.get(oldComponent);
            cell.setContent(newComponent);
            this.componentCellMap.remove(oldComponent);
            this.componentCellMap.put(newComponent, cell);
        } else {
            Alignment oldAlignment = oldCell.getAlignment();
            oldCell.setContent(newComponent);
            newCell.setContent(oldComponent);
            oldCell.setAlignment(newCell.getAlignment());
            newCell.setAlignment(oldAlignment);
            this.componentCellMap.replace(newComponent, oldCell);
            this.componentCellMap.replace(oldComponent, newCell);
        }
        this.scheduleUpdate();
    }

    @Override
    public int getComponentCount() {
        return this.components.size();
    }

    @Override
    public Iterator<Component> iterator() {
        return Collections.unmodifiableCollection(this.components).iterator();
    }

    private void updateCellsArray() {
        if (this.cells == null) {
            this.cells = new Cell[this.columns][this.rows];
        } else if (this.cells.length != this.columns || this.cells[0].length != this.rows) {
            Cell[][] newCells = new Cell[this.columns][this.rows];
            for (int i = 0; i < this.cells.length; ++i) {
                for (int j = 0; j < this.cells[i].length; ++j) {
                    if (i >= this.columns || j >= this.rows) continue;
                    newCells[i][j] = this.cells[i][j];
                }
            }
            this.cells = newCells;
        }
    }

    private void checkExistingOverlaps(Cell area) throws OverlapsException {
        for (Cell existingArea : this.componentCellMap.values()) {
            if (!GridLayout.areasOverlap(area, existingArea)) continue;
            throw new OverlapsException(existingArea);
        }
    }

    private static boolean areasOverlap(Cell a, Cell b) {
        return a.x1 <= b.x2 && a.y1 <= b.y2 && a.x2 >= b.x1 && a.y2 >= b.y1;
    }

    private void scheduleUpdate() {
        if (!this.pendingUpdate) {
            this.pendingUpdate = true;
            this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)ctx -> {
                this.getElement().executeJs("this.$connector.update()", new Serializable[0]);
                this.pendingUpdate = false;
            }));
        }
    }

    @Override
    public void setLabelComponent(Component labelComponent) {
        if (this.labelComponent != null) {
            this.labelComponent.removeFromParent();
        }
        this.labelComponent = labelComponent;
        if (labelComponent == null) {
            this.getStyle().remove("margin-top");
            this.getStyle().remove("overflow");
        } else {
            labelComponent.getStyle().setPosition(Style.Position.ABSOLUTE);
            labelComponent.getStyle().set("top", "calc(var(--lumo-space-xl) * -1)");
            this.getStyle().setMarginTop("var(--lumo-space-xl)");
            this.getStyle().setOverflow(Style.Overflow.VISIBLE);
            this.getElement().insertChild(0, new Element[]{labelComponent.getElement()});
        }
    }

    @Tag(value="div")
    class Cell
    extends AbstractSingleComponentContainer {
        int x1;
        int y1;
        int x2;
        int y2;
        Alignment alignment;

        Cell(int x1, int y1, Component child) {
            this.x1 = this.x2 = x1;
            this.y1 = this.y2 = y1;
            this.updateCoordinates(x1, y1, this.x2, this.y2);
            this.setPrimaryStyleName("v-gridlayout-slot");
            this.setContent(child);
        }

        Cell(Component child, int x1, int y1, int x2, int y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.updateCoordinates(x1, y1, x2, y2);
            this.setPrimaryStyleName("v-gridlayout-slot");
            this.setContent(child);
        }

        private void updateCoordinates(int x1, int y1, int x2, int y2) {
            this.getElement().setProperty("x1", (double)x1);
            this.getElement().setProperty("y1", (double)y1);
            this.getElement().setProperty("x2", (double)x2);
            this.getElement().setProperty("y2", (double)y2);
        }

        void setAlignment(Alignment alignment) {
            this.alignment = alignment;
            if (!(alignment == null || alignment.isLeft() && alignment.isTop())) {
                this.getElement().setProperty("horizontalAlignment", alignment.getHorizontalAlignment());
                this.getElement().setProperty("verticalAlignment", alignment.getVerticalAlignment());
                this.getContent().getElement().getStyle().set("position", "absolute");
            } else {
                this.getElement().removeProperty("horizontalAlignment");
                this.getElement().removeProperty("verticalAlignment");
                this.getContent().getElement().getStyle().set("position", "relative");
            }
        }

        Alignment getAlignment() {
            return this.alignment;
        }
    }

    public static class OverlapsException
    extends RuntimeException {
        private final Cell existingArea;

        private OverlapsException(Cell existingArea) {
            this.existingArea = existingArea;
        }

        @Override
        public String getMessage() {
            StringBuilder sb = new StringBuilder();
            Component component = this.existingArea.getContent();
            sb.append(component);
            sb.append("( type = ");
            sb.append(component.getClass().getName());
            sb.append(")");
            sb.append(" is already added to ");
            sb.append(this.existingArea.y1);
            sb.append(",");
            sb.append(this.existingArea.x1);
            sb.append(",");
            sb.append(this.existingArea.y2);
            sb.append(",");
            sb.append(this.existingArea.x2);
            sb.append("(row1, column1, row2, column2).");
            return sb.toString();
        }

        public Cell getArea() {
            return this.existingArea;
        }
    }

    public static class OutOfBoundsException
    extends RuntimeException {
        private final Cell areaOutOfBounds;

        private OutOfBoundsException(Cell areaOutOfBounds) {
            this.areaOutOfBounds = areaOutOfBounds;
        }

        public Cell getArea() {
            return this.areaOutOfBounds;
        }
    }

    public class Area
    implements Serializable {
        private final GridLayoutState.ChildComponentData childData;
        private final Component component;

        public Area(Component component, int column1, int row1, int column2, int row2) {
            this.component = component;
            this.childData = new GridLayoutState.ChildComponentData();
            this.childData.alignment = GridLayout.this.getDefaultComponentAlignment().getBitMask();
            this.childData.column1 = column1;
            this.childData.row1 = row1;
            this.childData.column2 = column2;
            this.childData.row2 = row2;
        }

        public Area(GridLayoutState.ChildComponentData childData, Component component) {
            this.childData = childData;
            this.component = component;
        }

        public boolean overlaps(Area other) {
            GridLayoutState.ChildComponentData a = this.childData;
            GridLayoutState.ChildComponentData b = other.childData;
            return a.column1 <= b.column2 && a.row1 <= b.row2 && a.column2 >= b.column1 && a.row2 >= b.row1;
        }

        public Component getComponent() {
            return this.component;
        }

        public int getColumn1() {
            return this.childData.column1;
        }

        public int getColumn2() {
            return this.childData.column2;
        }

        public int getRow1() {
            return this.childData.row1;
        }

        public int getRow2() {
            return this.childData.row2;
        }

        public String toString() {
            return String.format("Area{%s,%s - %s,%s}", this.getColumn1(), this.getRow1(), this.getColumn2(), this.getRow2());
        }
    }
}

