/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui;

import com.vaadin.featurepack.data.Container;
import com.vaadin.featurepack.data.Item;
import com.vaadin.featurepack.data.ItemDataProvider;
import com.vaadin.featurepack.data.ui.FAbstractSelect;
import com.vaadin.featurepack.data.ui.Select;
import com.vaadin.featurepack.data.util.IndexedContainer;
import com.vaadin.featurepack.server.HasSizeable;
import com.vaadin.featurepack.server.Resource;
import com.vaadin.featurepack.ui.FAbstractComponent;
import com.vaadin.featurepack.ui.Label;
import com.vaadin.featurepack.ui.LabelSlotController;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.listbox.ListBox;
import com.vaadin.flow.component.listbox.ListBoxBase;
import com.vaadin.flow.component.listbox.MultiSelectListBox;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.ConfigurableFilterDataProvider;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.selection.MultiSelect;
import com.vaadin.flow.data.selection.SingleSelect;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.SerializableSupplier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class FTwinColSelect
extends CustomField<Object>
implements FAbstractComponent,
Select,
HasSizeable {
    private static final String DEFAULT_LIST_WIDTH = "var(--vaadin-field-default-width, 12em)";
    private Div rootLayout;
    private final LabelSlotController labelSlotController = new LabelSlotController((HasLabel)this, "label");
    private Div leftListLayout;
    private Label leftListLabel;
    private ListBoxBase<?, Item, ?> leftList;
    private ItemDataProvider leftDataProvider;
    private ConfigurableFilterDataProvider<Item, Void, SerializablePredicate<Item>> leftFilterableDataProviderWrapper;
    private Div rightListLayout;
    private Label rightListLabel;
    private ListBoxBase<?, Item, ?> rightList;
    private Map<Object, Item> selectedItems = new LinkedHashMap<Object, Item>();
    private Button addButton;
    private Button removeButton;
    private int rows = 10;

    public FTwinColSelect() {
        this.init();
    }

    public FTwinColSelect(String caption) {
        this();
        this.setCaption(caption);
    }

    public FTwinColSelect(String caption, Collection<?> options) {
        this();
        this.setCaption(caption);
        if (options != null) {
            IndexedContainer container = new IndexedContainer(options);
            this.setContainerDataSource(container);
        }
    }

    public FTwinColSelect(String caption, Container dataSource) {
        this();
        this.setCaption(caption);
        this.setContainerDataSource(dataSource);
    }

    private void init() {
        this.setMultiSelect(true);
        this.leftList = this.buildLeftListBox(this.isMultiSelect());
        this.leftListLabel = new Label();
        this.leftListLabel.setLabelComponent((Component)this.leftList);
        this.leftListLayout = this.createListBoxLayout(this.leftList, this.leftListLabel);
        this.rightList = this.buildRightListBox(this.isMultiSelect());
        this.rightListLabel = new Label();
        this.rightListLabel.setLabelComponent((Component)this.rightList);
        this.rightListLayout = this.createListBoxLayout(this.rightList, this.rightListLabel);
        this.addButton = new Button((Component)VaadinIcon.CHEVRON_RIGHT_SMALL.create());
        this.addButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        this.addButton.addClickListener(this::onAddClick);
        this.addButton.setTooltipText("Move selected items to the right");
        this.removeButton = new Button((Component)VaadinIcon.CHEVRON_LEFT_SMALL.create());
        this.removeButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        this.removeButton.addClickListener(this::onRemoveClick);
        this.removeButton.setTooltipText("Move selected items to the left");
        Div buttonBar = new Div(new Component[]{this.addButton, this.removeButton});
        buttonBar.getStyle().set("display", "flex").set("flex-direction", "column").set("margin-top", "var(--lumo-space-l)");
        this.rootLayout = new Div(new Component[]{this.leftListLayout, buttonBar, this.rightListLayout});
        this.rootLayout.getStyle().set("display", "flex").set("flex-direction", "row").set("align-items", "stretch").set("gap", "var(--lumo-space-m)");
        this.add(new Component[]{this.rootLayout});
        this.applyDefaultWidth();
        this.applyDefaultHeight();
        this.updateComponentStates();
    }

    private ListBoxBase<?, Item, ?> buildLeftListBox(boolean isMultiSelect) {
        ListBoxBase<?, Item, ?> list = this.buildListBox(isMultiSelect);
        this.leftDataProvider = new ItemDataProvider((SerializableSupplier<Container>)((SerializableSupplier & Serializable)this::getContainerDataSource));
        this.leftFilterableDataProviderWrapper = this.leftDataProvider.withConfigurableFilter();
        this.leftFilterableDataProviderWrapper.setFilter((SerializablePredicate & Serializable)item -> !this.selectedItems.containsValue(item));
        list.setDataProvider(this.leftFilterableDataProviderWrapper);
        return list;
    }

    private ListBoxBase<?, Item, ?> buildRightListBox(boolean isMultiSelect) {
        ListBoxBase<?, Item, ?> list = this.buildListBox(isMultiSelect);
        CallbackDataProvider dp = DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> this.selectedItems.values().stream().skip(query.getOffset()).limit(query.getLimit()), (CallbackDataProvider.CountCallback & Serializable)query -> this.selectedItems.size());
        list.setDataProvider((DataProvider)dp);
        return list;
    }

    private ListBoxBase<?, Item, ?> buildListBox(boolean isMultiSelect) {
        MultiSelectListBox list = isMultiSelect ? new MultiSelectListBox() : new ListBox();
        list.setItemLabelGenerator((ItemLabelGenerator & Serializable)item -> this.getItemCaption(this.toItemId((Item)item)));
        list.getStyle().set("border", "solid 1px var(--lumo-contrast-20pct)").set("border-radius", "var(--lumo-border-radius-m)").set("flex", "1 1 auto").set("overflow", "hidden");
        list.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.updateComponentStates());
        return list;
    }

    private Div createListBoxLayout(ListBoxBase<?, Item, ?> list, Label label) {
        Div layout = new Div(new Component[]{label, list});
        layout.getStyle().set("display", "flex").set("flex-direction", "column").set("flex", "1 1 0").set("min-width", "0").set("overflow", "hidden").set("width", DEFAULT_LIST_WIDTH);
        return layout;
    }

    public String getLeftColumnCaption() {
        return this.leftListLabel.getCaption();
    }

    public void setLeftColumnCaption(String caption) {
        this.leftListLabel.setCaption(caption);
    }

    public String getRightColumnCaption() {
        return this.rightListLabel.getCaption();
    }

    public void setRightColumnCaption(String caption) {
        this.rightListLabel.setCaption(caption);
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        if (rows < 0) {
            rows = 0;
        }
        if (this.rows != rows) {
            this.rows = rows;
            this.markAsDirty();
            this.applyRows((HasSize)this.leftList);
            this.applyRows((HasSize)this.rightList);
        }
    }

    @Override
    public void setHeight(float height, Unit unit) {
        HasSizeable.super.setHeight(height, unit);
        if (height >= 0.0f) {
            if (this.getCaption() != null || this.getIcon() != null || this.getComponentError() != null) {
                this.rootLayout.setHeight("calc(" + height + unit.getSymbol() + " - var(--lumo-space-xl))");
            } else {
                this.rootLayout.setHeight(height, unit);
            }
            this.leftListLayout.setHeightFull();
            this.rightListLayout.setHeightFull();
            this.leftList.setHeightFull();
            this.rightList.setHeightFull();
        } else {
            this.applyDefaultHeight();
        }
    }

    @Override
    public void setWidth(float width, Unit unit) {
        HasSizeable.super.setWidth(width, unit);
        if (width >= 0.0f) {
            this.leftListLayout.getStyle().remove("width");
            this.rightListLayout.getStyle().remove("width");
        } else {
            this.applyDefaultWidth();
        }
    }

    private void applyDefaultHeight() {
        this.rootLayout.getStyle().remove("height");
        this.leftListLayout.getStyle().remove("height");
        this.rightListLayout.getStyle().remove("height");
        this.applyRows((HasSize)this.leftList);
        this.applyRows((HasSize)this.rightList);
    }

    private void applyDefaultWidth() {
        this.leftListLayout.getStyle().set("width", DEFAULT_LIST_WIDTH);
        this.rightListLayout.getStyle().set("width", DEFAULT_LIST_WIDTH);
    }

    @Override
    public void setMultiSelect(boolean isMultiSelect) {
        if (isMultiSelect == this.isMultiSelect()) {
            return;
        }
        if (this.leftList != null && this.rightList != null) {
            ListBoxBase<?, Item, ?> newLeftList = this.buildLeftListBox(isMultiSelect);
            this.leftListLayout.replace(this.leftList, newLeftList);
            this.leftList = newLeftList;
            ListBoxBase<?, Item, ?> newRightList = this.buildRightListBox(isMultiSelect);
            this.rightListLayout.replace(this.rightList, newRightList);
            this.rightList = newRightList;
        }
        Select.super.setMultiSelect(isMultiSelect);
    }

    @Override
    public void setLabelComponent(Component labelComponent) {
        this.labelSlotController.setLabelComponent(labelComponent);
        this.setHeight(this.getFHeight(), this.getHeightUnits());
    }

    @Override
    public void setContainerDataSource(Container newDataSource) {
        this.leftDataProvider.clear();
        this.selectedItems.clear();
        Select.super.setContainerDataSource(newDataSource);
        this.refreshDataProviders();
    }

    public void setItemCaption(Object itemId, String caption) {
        this.getFAbstractSelect().setItemCaption(itemId, caption);
        this.refreshDataProviders();
    }

    @Override
    public Class<Object> getType() {
        return Object.class;
    }

    @Override
    public boolean removeItem(Object itemId) throws UnsupportedOperationException {
        boolean result = Select.super.removeItem(itemId);
        this.refreshDataProviders();
        return result;
    }

    @Override
    public Object addItem() throws UnsupportedOperationException {
        Object item = Select.super.addItem();
        this.refreshDataProviders();
        return item;
    }

    @Override
    public Item addItem(Object itemId) throws UnsupportedOperationException {
        Item item = Select.super.addItem(itemId);
        this.refreshDataProviders();
        return item;
    }

    @Override
    public void setItemCaptionPropertyId(Object propertyId) {
        Select.super.setItemCaptionPropertyId(propertyId);
        this.refreshDataProviders();
    }

    @Override
    public void setItemIcon(Object itemId, Resource icon) {
        Select.super.setItemIcon(itemId, icon);
        this.refreshDataProviders();
    }

    @Override
    public void setItemIconPropertyId(Object propertyId) {
        Select.super.setItemIconPropertyId(propertyId);
        this.refreshDataProviders();
    }

    @Override
    public void setItemCaptionMode(FAbstractSelect.ItemCaptionMode mode) {
        Select.super.setItemCaptionMode(mode);
        this.refreshDataProviders();
    }

    private void refreshDataProviders() {
        if (this.leftList != null && this.rightList != null) {
            this.leftFilterableDataProviderWrapper.refreshAll();
            this.rightList.getDataProvider().refreshAll();
        }
    }

    private void applyRows(HasSize list) {
        if (this.getRows() > 0) {
            list.setHeight("calc(var(--lumo-size-m) * " + this.getRows() + ")");
        } else {
            list.setHeight("calc(var(--lumo-size-m) * 10)");
        }
    }

    private void onAddClick(ClickEvent<Button> event) {
        List<Item> items = this.getSelectionForList(this.leftList);
        if (items.isEmpty()) {
            return;
        }
        items.forEach(item -> this.selectedItems.put(this.toItemId((Item)item), (Item)item));
        this.deselectAllFromList(this.leftList);
        this.updateValue();
        this.refreshDataProviders();
    }

    private void onRemoveClick(ClickEvent<Button> event) {
        List<Item> items = this.getSelectionForList(this.rightList);
        if (items.isEmpty()) {
            return;
        }
        items.forEach(item -> this.selectedItems.remove(this.toItemId((Item)item)));
        this.deselectAllFromList(this.rightList);
        this.updateValue();
        this.refreshDataProviders();
    }

    private List<Item> getSelectionForList(ListBoxBase<?, Item, ?> list) {
        ArrayList<Item> items = new ArrayList<Item>();
        if (!this.isMultiSelect()) {
            Item val = (Item)list.getValue();
            if (val != null) {
                items.add(val);
            }
        } else {
            Set val = (Set)list.getValue();
            if (val != null) {
                items.addAll(val);
            }
        }
        return items;
    }

    private void deselectAllFromList(ListBoxBase<?, Item, ?> list) {
        if (this.isMultiSelect()) {
            ((MultiSelect)list).deselectAll();
        } else {
            ((SingleSelect)list).clear();
        }
    }

    private Object toItemId(Item item) {
        return this.leftDataProvider.getItemId(item);
    }

    private void updateComponentStates() {
        this.addButton.setEnabled(!this.getSelectionForList(this.leftList).isEmpty());
        this.removeButton.setEnabled(!this.getSelectionForList(this.rightList).isEmpty());
    }

    protected Object generateModelValue() {
        if (!this.isMultiSelect()) {
            if (!this.selectedItems.isEmpty()) {
                return this.toItemId(this.selectedItems.values().iterator().next());
            }
            return null;
        }
        return this.selectedItems.values().stream().map(this::toItemId).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected void setPresentationValue(Object newValue) {
        this.selectedItems.clear();
        if (newValue != null) {
            if (this.isMultiSelect()) {
                Set ids = (Set)newValue;
                ids.stream().filter(Objects::nonNull).map(this::getItem).forEach(item -> this.selectedItems.put(this.toItemId((Item)item), (Item)item));
            } else {
                this.selectedItems.put(newValue, this.getItem(newValue));
            }
        }
        this.refreshDataProviders();
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.doConnectorOnAttach(attachEvent);
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.doConnectorOnDetach(detachEvent);
    }

    protected void fireEvent(ComponentEvent<?> componentEvent) {
        FAbstractComponent.super.fireEvent((EventObject)componentEvent, this.getEventBus());
    }
}

