/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui;

import com.vaadin.featurepack.data.Property;
import com.vaadin.featurepack.ui.FAbstractTextField;
import com.vaadin.featurepack.ui.InputColumnController;
import com.vaadin.featurepack.ui.InputSelectionController;
import com.vaadin.featurepack.ui.LabelSlotController;
import com.vaadin.featurepack.ui.NullValueController;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import java.util.EventObject;

public class FTextField
extends TextField
implements FAbstractTextField {
    private final NullValueController<String> nullValueController = new NullValueController<String>((HasValue<?, String>)this, "null");
    private final InputSelectionController<String> inputSelectionController = new InputSelectionController(this, s -> s);
    private final InputColumnController inputColumnController = new InputColumnController(this);
    private final LabelSlotController labelSlotController = new LabelSlotController((HasLabel)this, "label");

    public FTextField() {
        super.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.getNullValueController().processSetValue((String)e.getValue()));
    }

    public FTextField(String caption) {
        this();
        this.setCaption(caption);
    }

    public FTextField(String caption, String value) {
        this();
        this.setCaption(caption);
        this.setValue(value);
    }

    public FTextField(Property dataSource) {
        this.setPropertyDataSource(dataSource);
    }

    public FTextField(String caption, Property dataSource) {
        this(dataSource);
        this.setCaption(caption);
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public void setValue(String value) {
        super.setValue(this.getNullValueController().processSetValue(value));
    }

    @Override
    public String getValue() {
        return this.getNullValueController().processGetValue(super.getValue());
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() || this.getValue() == null;
    }

    public void setLabel(String label) {
        this.labelSlotController.setLabel(label);
    }

    @Override
    public void setLabelComponent(Component labelComponent) {
        this.labelSlotController.setLabelComponent(labelComponent);
    }

    @Override
    public NullValueController<String> getNullValueController() {
        return this.nullValueController;
    }

    @Override
    public InputSelectionController<String> getInputSelectionController() {
        return this.inputSelectionController;
    }

    @Override
    public InputColumnController getInputColumnController() {
        return this.inputColumnController;
    }

    @Override
    public Class<? extends String> getType() {
        return String.class;
    }

    @Override
    public void clear() {
        super.clear();
    }

    public boolean isReadOnly() {
        return this.getFAbstractField().isPropertyReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        this.getFAbstractField().setPropertyReadOnly(readOnly);
    }

    @Override
    public void setRequired(boolean required) {
        FAbstractTextField.super.setRequired(required);
    }

    @Override
    public boolean isRequired() {
        return FAbstractTextField.super.isRequired();
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.doConnectorOnAttach(attachEvent);
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.doConnectorOnDetach(detachEvent);
    }

    protected void fireEvent(ComponentEvent<?> componentEvent) {
        FAbstractTextField.super.fireEvent((EventObject)componentEvent, this.getEventBus());
    }
}

