/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui;

import com.vaadin.featurepack.server.HasSizeable;
import com.vaadin.featurepack.server.IconResource;
import com.vaadin.featurepack.server.Resource;
import com.vaadin.featurepack.ui.FAbstractComponent;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.contextmenu.HasMenuItems;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.html.Hr;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Style;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;

@JsModule(value="./menu-bar-styles.js")
public class FMenuBar
extends MenuBar
implements FAbstractComponent,
Focusable<FMenuBar>,
HasSizeable {
    private final List<MenuItem> menuItems = new ArrayList<MenuItem>();
    private int numberOfItems = 0;
    private MenuItem moreItem;
    private boolean openRootOnHover;
    private boolean htmlContentAllowed;
    private Component labelComponent;

    public FMenuBar() {
        this.setMoreMenuItem(null);
    }

    protected void fireEvent(ComponentEvent<?> componentEvent) {
        FAbstractComponent.super.fireEvent((EventObject)componentEvent, this.getEventBus());
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.doConnectorOnAttach(attachEvent);
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.doConnectorOnDetach(detachEvent);
    }

    @Override
    public void beforeClientResponse(boolean initial) {
        FAbstractComponent.super.beforeClientResponse(initial);
        this.setOpenOnHover(this.openRootOnHover);
        if (this.moreItem != null && this.moreItem.getText() != null && !this.moreItem.getText().isBlank()) {
            MenuBar.MenuBarI18n i18n = new MenuBar.MenuBarI18n();
            i18n.setMoreOptions(this.moreItem.getText());
            this.setI18n(i18n);
        } else {
            this.setI18n(new MenuBar.MenuBarI18n());
        }
        this.removeAll();
        for (MenuItem item : this.menuItems) {
            if (!item.isVisible()) continue;
            if (item.isSeparator()) {
                super.addItem((Component)new Hr());
                continue;
            }
            com.vaadin.flow.component.contextmenu.MenuItem flowMenuItem = this.createMenuItem(item, (HasMenuItems)this);
            if (!item.hasChildren()) continue;
            SubMenu subMenu = (SubMenu)flowMenuItem.getSubMenu();
            for (MenuItem child : item.getChildren()) {
                if (child.isSeparator()) {
                    subMenu.add(new Component[]{new Hr()});
                    continue;
                }
                this.createMenuItem(child, (HasMenuItems)subMenu);
            }
        }
    }

    private com.vaadin.flow.component.contextmenu.MenuItem createMenuItem(MenuItem item, HasMenuItems menu) {
        com.vaadin.flow.component.contextmenu.MenuItem flowMenuItem = menu.addItem(this.createItemCaptionComponent(item), (ComponentEventListener & Serializable)event -> Optional.ofNullable(item.getCommand()).ifPresent(cmd -> cmd.menuSelected(item)));
        this.setTooltipText(flowMenuItem, item.getDescription());
        flowMenuItem.setEnabled(item.isEnabled());
        flowMenuItem.setVisible(item.isVisible());
        flowMenuItem.setClassName(item.getStyleName());
        flowMenuItem.setCheckable(item.isCheckable());
        flowMenuItem.setChecked(item.isChecked());
        return flowMenuItem;
    }

    private Component createItemCaptionComponent(MenuItem item) {
        Resource resource;
        Object labelComponent = this.isHtmlContentAllowed() ? new Html("<span>" + (item.getText() == null ? "" : item.getText()) + "</span>") : new Span(item.getText());
        if (item.getIcon() != null && (resource = item.getIcon()) instanceof IconResource) {
            IconResource iconResource = (IconResource)resource;
            return new Span(new Component[]{iconResource, labelComponent});
        }
        return labelComponent;
    }

    @Override
    public void setLabelComponent(Component labelComponent) {
        this.labelComponent = labelComponent;
        if (labelComponent == null) {
            this.getElement().setAttribute("has-label-component", false);
            SlotUtils.getElementsInSlot((HasElement)this, (String)"").filter(el -> el.getTag().equals(labelComponent.getElement().getTag())).toList().forEach(element -> {
                element.removeAttribute("slot");
                this.getElement().removeChild(new Element[]{element});
            });
        } else {
            this.getElement().setAttribute("has-label-component", true);
            labelComponent.getStyle().setPosition(Style.Position.ABSOLUTE);
            labelComponent.getStyle().setTop("calc(var(--lumo-space-xl) * -1)");
            SlotUtils.getElementsInSlot((HasElement)this, (String)"").filter(el -> el.getTag().equals(labelComponent.getElement().getTag())).toList().forEach(element -> {
                element.removeAttribute("slot");
                this.getElement().removeChild(new Element[]{element});
            });
            SlotUtils.addToSlot((HasElement)this, (String)"", (Component[])new Component[]{labelComponent});
        }
    }

    public MenuItem addItem(String caption, Command command) {
        return this.addItem(caption, (Resource)null, command);
    }

    public MenuItem addItem(String caption, Icon icon, Command command) {
        if (caption == null) {
            throw new IllegalArgumentException("caption cannot be null");
        }
        MenuItem newItem = new MenuItem(caption, icon != null ? new IconResource(icon) : null, command);
        this.menuItems.add(newItem);
        this.markAsDirty();
        return newItem;
    }

    public MenuItem addItem(String caption, Resource icon, Command command) {
        if (caption == null) {
            throw new IllegalArgumentException("caption cannot be null");
        }
        MenuItem newItem = new MenuItem(caption, icon, command);
        this.menuItems.add(newItem);
        this.markAsDirty();
        return newItem;
    }

    public MenuItem addItemBefore(String caption, Resource icon, Command command, MenuItem itemToAddBefore) {
        if (caption == null) {
            throw new IllegalArgumentException("caption cannot be null");
        }
        MenuItem newItem = new MenuItem(caption, icon, command);
        if (this.menuItems.contains(itemToAddBefore)) {
            int index = this.menuItems.indexOf(itemToAddBefore);
            this.menuItems.add(index, newItem);
        } else {
            this.menuItems.add(newItem);
        }
        this.markAsDirty();
        return newItem;
    }

    public List<MenuItem> getFItems() {
        return this.menuItems;
    }

    public void removeItem(MenuItem item) {
        if (item != null) {
            this.menuItems.remove(item);
        }
        this.markAsDirty();
    }

    public void removeItems() {
        this.menuItems.clear();
        this.markAsDirty();
    }

    public int getSize() {
        return this.menuItems.size();
    }

    public void setMoreMenuItem(MenuItem item) {
        this.moreItem = item != null ? item : new MenuItem("", null, null);
        this.markAsDirty();
    }

    public MenuItem getMoreMenuItem() {
        return this.moreItem;
    }

    public void setAutoOpen(boolean autoOpenTopLevelMenu) {
        if (autoOpenTopLevelMenu != this.openRootOnHover) {
            this.openRootOnHover = autoOpenTopLevelMenu;
            this.markAsDirty();
        }
    }

    public boolean isAutoOpen() {
        return this.openRootOnHover;
    }

    public void setHtmlContentAllowed(boolean htmlContentAllowed) {
        this.htmlContentAllowed = htmlContentAllowed;
        this.markAsDirty();
    }

    public boolean isHtmlContentAllowed() {
        return this.htmlContentAllowed;
    }

    public class MenuItem
    implements Serializable {
        private final int itsId;
        private Command itsCommand;
        private String itsText;
        private List<MenuItem> itsChildren;
        private Resource itsIcon;
        private MenuItem itsParent;
        private boolean enabled = true;
        private boolean visible = true;
        private boolean isSeparator = false;
        private String styleName;
        private String description;
        private boolean checkable = false;
        private boolean checked = false;

        public MenuItem(String caption, Resource icon, Command command) {
            if (caption == null) {
                throw new IllegalArgumentException("caption cannot be null");
            }
            this.itsId = ++FMenuBar.this.numberOfItems;
            this.itsText = caption;
            this.itsIcon = icon;
            this.itsCommand = command;
        }

        public boolean hasChildren() {
            return !this.isSeparator() && this.itsChildren != null;
        }

        public MenuItem addSeparator() {
            MenuItem item = this.addItem("", null, null);
            item.setSeparator(true);
            return item;
        }

        public MenuItem addSeparatorBefore(MenuItem itemToAddBefore) {
            MenuItem item = this.addItemBefore("", null, null, itemToAddBefore);
            item.setSeparator(true);
            return item;
        }

        public MenuItem addItem(String caption, Command command) {
            return this.addItem(caption, null, command);
        }

        public MenuItem addItem(String caption, Resource icon, Command command) throws IllegalStateException {
            if (this.isSeparator()) {
                throw new UnsupportedOperationException("Cannot add items to a separator");
            }
            if (this.isCheckable()) {
                throw new IllegalStateException("A checkable item cannot have children");
            }
            if (caption == null) {
                throw new IllegalArgumentException("Caption cannot be null");
            }
            if (this.itsChildren == null) {
                this.itsChildren = new ArrayList<MenuItem>();
            }
            MenuItem newItem = new MenuItem(caption, icon, command);
            newItem.setParent(this);
            this.itsChildren.add(newItem);
            FMenuBar.this.markAsDirty();
            return newItem;
        }

        public MenuItem addItemBefore(String caption, Resource icon, Command command, MenuItem itemToAddBefore) throws IllegalStateException {
            if (this.isCheckable()) {
                throw new IllegalStateException("A checkable item cannot have children");
            }
            MenuItem newItem = null;
            if (this.hasChildren() && this.itsChildren.contains(itemToAddBefore)) {
                int index = this.itsChildren.indexOf(itemToAddBefore);
                newItem = new MenuItem(caption, icon, command);
                newItem.setParent(this);
                this.itsChildren.add(index, newItem);
            } else {
                newItem = this.addItem(caption, icon, command);
            }
            FMenuBar.this.markAsDirty();
            return newItem;
        }

        public Command getCommand() {
            return this.itsCommand;
        }

        public Resource getIcon() {
            return this.itsIcon;
        }

        public MenuItem getParent() {
            return this.itsParent;
        }

        public List<MenuItem> getChildren() {
            return this.itsChildren;
        }

        public String getText() {
            return this.itsText;
        }

        public int getSize() {
            if (this.itsChildren != null) {
                return this.itsChildren.size();
            }
            return -1;
        }

        public int getId() {
            return this.itsId;
        }

        public void setCommand(Command command) {
            this.itsCommand = command;
        }

        public void setIcon(Resource icon) {
            this.itsIcon = icon;
            FMenuBar.this.markAsDirty();
        }

        public void setText(String text) {
            if (text != null) {
                this.itsText = text;
            }
            FMenuBar.this.markAsDirty();
        }

        public void removeChild(MenuItem item) {
            if (item != null && this.itsChildren != null) {
                this.itsChildren.remove(item);
                if (this.itsChildren.isEmpty()) {
                    this.itsChildren = null;
                }
                FMenuBar.this.markAsDirty();
            }
        }

        public void removeChildren() {
            if (this.itsChildren != null) {
                this.itsChildren.clear();
                this.itsChildren = null;
                FMenuBar.this.markAsDirty();
            }
        }

        protected void setParent(MenuItem parent) {
            this.itsParent = parent;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            FMenuBar.this.markAsDirty();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
            FMenuBar.this.markAsDirty();
        }

        public boolean isVisible() {
            return this.visible;
        }

        private void setSeparator(boolean isSeparator) {
            this.isSeparator = isSeparator;
            FMenuBar.this.markAsDirty();
        }

        public boolean isSeparator() {
            return this.isSeparator;
        }

        public void setStyleName(String styleName) {
            this.styleName = styleName;
            FMenuBar.this.markAsDirty();
        }

        public String getStyleName() {
            return this.styleName;
        }

        public void setDescription(String description) {
            this.description = description;
            FMenuBar.this.markAsDirty();
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isCheckable() {
            return this.checkable;
        }

        public void setCheckable(boolean checkable) throws IllegalStateException {
            if (this.hasChildren()) {
                throw new IllegalStateException("A menu item with children cannot be checkable");
            }
            this.checkable = checkable;
            FMenuBar.this.markAsDirty();
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean checked) {
            this.checked = checked;
            FMenuBar.this.markAsDirty();
        }
    }

    public static interface Command
    extends Serializable {
        public void menuSelected(MenuItem var1);
    }
}

