/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui;

import com.vaadin.featurepack.data.Container;
import com.vaadin.featurepack.data.Item;
import com.vaadin.featurepack.data.ItemDataProvider;
import com.vaadin.featurepack.data.ui.Select;
import com.vaadin.featurepack.server.HasSizeable;
import com.vaadin.featurepack.ui.FAbstractComponent;
import com.vaadin.featurepack.ui.LabelSlotController;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.listbox.ListBox;
import com.vaadin.flow.component.listbox.ListBoxBase;
import com.vaadin.flow.component.listbox.MultiSelectListBox;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.selection.MultiSelect;
import com.vaadin.flow.data.selection.SingleSelect;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableSupplier;
import java.io.Serializable;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class FListSelect
extends CustomField<Object>
implements FAbstractComponent,
Select,
HasSizeable {
    private final LabelSlotController labelSlotController = new LabelSlotController((HasLabel)this, "label");
    private ListBoxBase<?, Item, ?> listBoxBase = this.buildListBox(false);
    private int rows = 0;

    public FListSelect() {
        this.add(new Component[]{this.listBoxBase});
        this.getFAbstractSelect();
        this.addItemSetChangeListener(e -> this.listBoxBase.getDataProvider().refreshAll());
        this.addPropertySetChangeListener(e -> this.listBoxBase.getDataProvider().refreshAll());
    }

    public FListSelect(String caption, Collection<?> options) {
        this();
        this.setCaption(caption);
        if (options != null) {
            for (Object option : options) {
                this.getContainerDataSource().addItem(option);
            }
        }
    }

    public FListSelect(String caption, Container dataSource) {
        this();
        this.setCaption(caption);
        this.setContainerDataSource(dataSource);
    }

    public FListSelect(String caption) {
        this();
        this.setCaption(caption);
    }

    private ListBoxBase<?, Item, ?> buildListBox(boolean multiSelect) {
        Object list = multiSelect ? new MultiSelectListBox() : new ListBox();
        list.setItemLabelGenerator(arg_0 -> this.lambda$buildListBox$dfce4014$1((ListBoxBase)list, arg_0));
        list.setDataProvider((DataProvider)new ItemDataProvider((SerializableSupplier<Container>)((SerializableSupplier & Serializable)this::getContainerDataSource)));
        list.addValueChangeListener(arg_0 -> this.lambda$buildListBox$6f7d6c2a$1((ListBoxBase)list, arg_0));
        this.applyRows((ListBoxBase<?, Item, ?>)list);
        return list;
    }

    private void applyRows(ListBoxBase<?, Item, ?> list) {
        if (this.rows > 0) {
            list.setHeight("calc(var(--lumo-size-m) * " + this.getRows() + ")");
        } else {
            list.setHeight("calc(var(--lumo-size-m) * 10)");
        }
    }

    private Object toItemId(ListBoxBase<?, Item, ?> list, Item item) {
        if (list.getDataProvider() instanceof ItemDataProvider) {
            return ((ItemDataProvider)list.getDataProvider()).getItemId(item);
        }
        return this.getItemIdByItem(item);
    }

    @Override
    public void setLabelComponent(Component labelComponent) {
        this.labelSlotController.setLabelComponent(labelComponent);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.doConnectorOnAttach(attachEvent);
    }

    protected Object generateModelValue() {
        if (this.listBoxBase instanceof SingleSelect) {
            return this.toItemId(this.listBoxBase, (Item)this.listBoxBase.getValue());
        }
        return ((Collection)this.listBoxBase.getValue()).stream().map(val -> this.toItemId(this.listBoxBase, (Item)val)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected void setPresentationValue(Object newValue) {
        if (this.listBoxBase instanceof SingleSelect) {
            Item item = this.getItem(newValue);
            ((ItemDataProvider)this.listBoxBase.getDataProvider()).put(item, newValue);
            ((SingleSelect)this.listBoxBase).setValue((Object)item);
        } else if (this.listBoxBase instanceof MultiSelect && newValue instanceof Set) {
            ((MultiSelect)this.listBoxBase).setValue((Set)((Set)newValue).stream().map(val -> {
                Item item = this.getItem(val);
                ((ItemDataProvider)this.listBoxBase.getDataProvider()).put(item, val);
                return item;
            }).collect(Collectors.toCollection(LinkedHashSet::new)));
        }
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.doConnectorOnDetach(detachEvent);
    }

    @Override
    public Class<Object> getType() {
        return Object.class;
    }

    @Override
    public void setMultiSelect(boolean multiSelect) {
        if (multiSelect == this.isMultiSelect()) {
            return;
        }
        ListBoxBase<?, Item, ?> newComponent = this.buildListBox(multiSelect);
        List children = this.getElement().getChildren().toList();
        int index = children.indexOf(this.listBoxBase.getElement());
        if (index >= 0) {
            this.getElement().insertChild(index, new Element[]{newComponent.getElement()});
            this.listBoxBase.removeFromParent();
        }
        this.listBoxBase = newComponent;
        Select.super.setMultiSelect(multiSelect);
    }

    @Override
    public void setContainerDataSource(Container newDataSource) {
        Select.super.setContainerDataSource(newDataSource);
        ((ItemDataProvider)this.listBoxBase.getDataProvider()).clear();
        this.listBoxBase.getDataProvider().refreshAll();
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        if (rows < 0) {
            rows = 0;
        }
        if (this.rows != rows) {
            this.rows = rows;
            this.markAsDirty();
            this.applyRows(this.listBoxBase);
        }
    }

    protected void fireEvent(ComponentEvent<?> componentEvent) {
        FAbstractComponent.super.fireEvent((EventObject)componentEvent, this.getEventBus());
    }

    private /* synthetic */ void lambda$buildListBox$6f7d6c2a$1(ListBoxBase list, AbstractField.ComponentValueChangeEvent event) {
        if (event.getValue() instanceof Collection) {
            Select.super.setValue(((Collection)event.getValue()).stream().map(val -> this.toItemId(list, (Item)val)).collect(Collectors.toCollection(LinkedHashSet::new)));
        } else {
            Select.super.setValue(this.toItemId(list, (Item)event.getValue()));
        }
    }

    private /* synthetic */ String lambda$buildListBox$dfce4014$1(ListBoxBase list, Item item) {
        return this.getItemCaption(((ItemDataProvider)list.getDataProvider()).getItemId(item));
    }
}

