/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui;

import com.vaadin.featurepack.data.Property;
import com.vaadin.featurepack.data.Validatable;
import com.vaadin.featurepack.data.Validator;
import com.vaadin.featurepack.data.converter.Converter;
import com.vaadin.featurepack.data.ui.Field;
import com.vaadin.featurepack.data.validator.DateRangeValidator;
import com.vaadin.featurepack.event.FieldEvents;
import com.vaadin.featurepack.server.HasSizeable;
import com.vaadin.featurepack.shared.ui.datefield.Resolution;
import com.vaadin.featurepack.ui.FAbstractComponent;
import com.vaadin.featurepack.ui.LabelSlotController;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.datetimepicker.DateTimePicker;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.component.timepicker.TimePicker;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.Locale;
import java.util.TimeZone;

public class FDateField
extends CustomField<Date>
implements FAbstractComponent,
Field<Date>,
FieldEvents.FocusNotifier,
FieldEvents.BlurNotifier,
Validatable,
HasSizeable {
    private final LabelSlotController labelSlotController = new LabelSlotController((HasLabel)this, "label");
    private DateTimePicker dateTimePicker = new DateTimePicker();
    private TimePicker timePicker;
    private Resolution resolution = Resolution.DAY;
    private transient Calendar calendar;
    private String dateFormat;
    private boolean lenient = false;
    private boolean uiHasValidDateString = true;
    private boolean showISOWeekNumbers = false;
    private String currentParseErrorMessage;
    private String defaultParseErrorMessage = "Date format not recognized";
    private TimeZone timeZone = null;
    private String dateOutOfRangeMessage = "Date is out of allowed range";
    private DateRangeValidator currentRangeValidator;

    public FDateField() {
        this.add(new Component[]{this.dateTimePicker});
        DatePicker datePicker = (DatePicker)SlotUtils.getChildInSlot((HasElement)this.dateTimePicker, (String)"date-picker");
        this.timePicker = (TimePicker)SlotUtils.getChildInSlot((HasElement)this.dateTimePicker, (String)"time-picker");
        this.timePicker.setStep(Duration.ofSeconds(1L));
        this.updateTimePicker(this.resolution);
        datePicker.getElement().addEventListener("unparsable-change", (DomEventListener & Serializable)event -> {
            this.uiHasValidDateString = false;
            this.doHandleUnparsableDateString();
        });
        datePicker.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (event.isFromClient()) {
                this.uiHasValidDateString = true;
                LocalDate value = (LocalDate)event.getValue();
                if (value != null && this.timePicker.getValue() != null) {
                    this.getFAbstractField().setValue(this.convertToDate(((LocalDate)event.getValue()).atTime((LocalTime)this.timePicker.getValue())));
                } else if (value != null) {
                    this.getFAbstractField().setValue(this.convertToDate((LocalDate)event.getValue()));
                } else {
                    this.doHandleUnparsableDateString();
                }
            }
        });
        this.timePicker.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            if (event.isFromClient()) {
                LocalTime value = (LocalTime)event.getValue();
                if (value != null && datePicker.getValue() != null) {
                    this.getFAbstractField().setValue(this.convertToDate(((LocalTime)event.getValue()).atDate((LocalDate)datePicker.getValue())));
                } else if (datePicker.getValue() != null) {
                    this.getFAbstractField().setValue(this.convertToDate((LocalDate)datePicker.getValue()));
                } else {
                    this.getFAbstractField().setValue(null);
                }
            }
        });
    }

    public FDateField(String caption) {
        this();
        this.setCaption(caption);
    }

    public FDateField(String caption, Property dataSource) {
        this(dataSource);
        this.setCaption(caption);
    }

    public FDateField(Property dataSource) throws IllegalArgumentException {
        this();
        if (!Date.class.isAssignableFrom(dataSource.getType())) {
            throw new IllegalArgumentException("Can't use " + dataSource.getType().getName() + " typed property as datasource");
        }
        this.setPropertyDataSource(dataSource);
    }

    public FDateField(String caption, Date value) {
        this();
        this.setValue(value);
        this.setCaption(caption);
    }

    @Override
    public void setLabelComponent(Component labelComponent) {
        this.labelSlotController.setLabelComponent(labelComponent);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.doConnectorOnAttach(attachEvent);
    }

    protected Date generateModelValue() {
        return this.convertToDate((LocalDateTime)this.dateTimePicker.getValue());
    }

    protected void setPresentationValue(Date date) {
        this.dateTimePicker.setValue(this.convertToLocalDateTime(date));
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.doConnectorOnDetach(detachEvent);
    }

    @Override
    public Class<Date> getType() {
        return Date.class;
    }

    private LocalDateTime convertToLocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(this.getZoneId()).toLocalDateTime();
    }

    private Date convertToDate(LocalDate date) {
        if (date == null) {
            return null;
        }
        return Date.from(date.atStartOfDay(this.getZoneId()).toInstant());
    }

    private Date convertToDate(LocalDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return Date.from(dateTime.atZone(this.getZoneId()).toInstant());
    }

    @Override
    public void validate() throws Validator.InvalidValueException {
        if (!this.uiHasValidDateString) {
            throw new UnparsableDateString(this.currentParseErrorMessage);
        }
        this.getFAbstractField().validate();
    }

    @Override
    public boolean isValid() {
        return this.uiHasValidDateString && this.getFAbstractField().isValid();
    }

    @Override
    public Date getValue() {
        return (Date)super.getValue();
    }

    @Override
    public void setValue(Date value) {
        super.setValue((Object)value);
    }

    protected boolean shouldHideErrors() {
        return this.getFAbstractField().shouldHideErrors() && this.uiHasValidDateString;
    }

    public void setRangeStart(Date startDate) {
        if (startDate != null && this.dateTimePicker.getMax() != null && startDate.after(this.convertToDate(this.dateTimePicker.getMax()))) {
            throw new IllegalStateException("startDate cannot be later than endDate");
        }
        this.dateTimePicker.setMin(this.convertToLocalDateTime(startDate != null ? new Date(startDate.getTime()) : null));
        this.updateRangeValidator();
    }

    public void setDateOutOfRangeMessage(String dateOutOfRangeMessage) {
        this.dateOutOfRangeMessage = dateOutOfRangeMessage;
        this.updateRangeValidator();
    }

    private Date getRangeEnd(Resolution forResolution) {
        Date rangeEnd = this.convertToDate(this.dateTimePicker.getMax());
        if (rangeEnd == null) {
            return null;
        }
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(rangeEnd);
        if (forResolution == Resolution.YEAR) {
            endCal.set(endCal.get(1) + 1, 0, 1, 0, 0, 0);
        } else if (forResolution == Resolution.MONTH) {
            endCal.set(endCal.get(1), endCal.get(2) + 1, 1, 0, 0, 0);
        } else {
            endCal.set(endCal.get(1), endCal.get(2), endCal.get(5) + 1, 0, 0, 0);
        }
        endCal.set(14, -1);
        return endCal.getTime();
    }

    private Date getRangeStart(Resolution forResolution) {
        if (this.dateTimePicker.getMin() == null) {
            return null;
        }
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(this.convertToDate(this.dateTimePicker.getMin()));
        if (forResolution == Resolution.YEAR) {
            startCal.set(startCal.get(1), 0, 1, 0, 0, 0);
        } else if (forResolution == Resolution.MONTH) {
            startCal.set(startCal.get(1), startCal.get(2), 1, 0, 0, 0);
        } else {
            startCal.set(startCal.get(1), startCal.get(2), startCal.get(5), 0, 0, 0);
        }
        startCal.set(14, 0);
        return startCal.getTime();
    }

    private void updateRangeValidator() {
        if (this.currentRangeValidator != null) {
            this.removeValidator(this.currentRangeValidator);
            this.currentRangeValidator = null;
        }
        if (this.getRangeStart() != null || this.getRangeEnd() != null) {
            this.currentRangeValidator = new DateRangeValidator(this.dateOutOfRangeMessage, this.getRangeStart(this.resolution), this.getRangeEnd(this.resolution), null);
            this.addValidator(this.currentRangeValidator);
        }
    }

    public void setRangeEnd(Date endDate) {
        if (endDate != null && this.dateTimePicker.getMin() != null && this.convertToDate(this.dateTimePicker.getMin()).after(endDate)) {
            throw new IllegalStateException("endDate cannot be earlier than startDate");
        }
        this.dateTimePicker.setMax(this.convertToLocalDateTime(endDate != null ? new Date(endDate.getTime()) : null));
        this.updateRangeValidator();
    }

    public Date getRangeStart() {
        return this.convertToDate(this.dateTimePicker.getMin());
    }

    public Date getRangeEnd() {
        return this.convertToDate(this.dateTimePicker.getMax());
    }

    @Override
    public void discard() {
        Property prop = this.getPropertyDataSource();
        if (prop != null) {
            Object value = prop.getValue();
            if (!this.uiHasValidDateString && value == null) {
                this.dateTimePicker.getElement().executeJs("        this.__datePicker.inputElement.value='';\n        this.__timePicker.inputElement.value='';\n", new Serializable[0]);
                this.uiHasValidDateString = true;
                this.dateTimePicker.setInvalid(false);
                this.markAsDirty();
            } else {
                this.getFAbstractField().discard();
                if (!this.uiHasValidDateString) {
                    this.uiHasValidDateString = true;
                    if (!this.isInvalidCommitted() && value != null) {
                        this.getFAbstractField().setFInternalValue((Date)value);
                        this.markAsDirty();
                    }
                }
            }
        }
    }

    protected Date handleUnparsableDateString(String dateString) throws Converter.ConversionException {
        this.currentParseErrorMessage = null;
        throw new Converter.ConversionException(this.getParseErrorMessage());
    }

    private void doHandleUnparsableDateString() {
        DatePicker datePicker = (DatePicker)SlotUtils.getChildInSlot((HasElement)this.dateTimePicker, (String)"date-picker");
        if (!this.isInvalidCommitted()) {
            ComponentUtil.setData((Component)this, (String)"value-change-listener-disabled", (Object)"true");
        }
        datePicker.getElement().executeJs("return this.__unparsableValue;", new Serializable[0]).then((SerializableConsumer & Serializable)value -> {
            try {
                boolean empty;
                String dateString = value.asString();
                boolean bl = empty = dateString == null || dateString.isEmpty();
                if (!empty) {
                    this.handleUnparsableDateString(dateString);
                }
                boolean wasUiHasValidDateString = this.uiHasValidDateString;
                this.uiHasValidDateString = true;
                if (empty && (this.getValue() != null || !wasUiHasValidDateString)) {
                    this.getFAbstractField().setValue(null);
                    this.markAsDirty();
                }
            }
            catch (Converter.ConversionException e) {
                this.currentParseErrorMessage = e.getLocalizedMessage();
                this.uiHasValidDateString = false;
                this.getFAbstractField().setValue(null);
                this.markAsDirty();
            }
            finally {
                ComponentUtil.setData((Component)this, (String)"value-change-listener-disabled", null);
            }
        }, (SerializableConsumer & Serializable)error -> {
            try {
                if (this.getValue() != null) {
                    this.getFAbstractField().setValue(null);
                }
            }
            finally {
                ComponentUtil.setData((Component)this, (String)"value-change-listener-disabled", null);
            }
        });
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public void setResolution(Resolution resolution) {
        this.resolution = resolution;
        this.updateTimePicker(resolution);
        this.updateRangeValidator();
        this.markAsDirty();
    }

    private void updateTimePicker(Resolution resolution) {
        switch (resolution != null ? resolution : Resolution.DAY) {
            case SECOND: 
            case MINUTE: 
            case HOUR: {
                this.timePicker.getStyle().remove("display");
                break;
            }
            default: {
                this.timePicker.getStyle().setDisplay(Style.Display.NONE);
            }
        }
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        DatePicker.DatePickerI18n i18n = this.dateTimePicker.getDatePickerI18n();
        if (i18n == null) {
            i18n = new DatePicker.DatePickerI18n();
        }
        i18n.setDateFormat(dateFormat);
        this.dateTimePicker.setDatePickerI18n(i18n);
        this.markAsDirty();
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
        this.markAsDirty();
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public boolean isShowISOWeekNumbers() {
        return this.showISOWeekNumbers;
    }

    public void setShowISOWeekNumbers(boolean showWeekNumbers) {
        this.showISOWeekNumbers = showWeekNumbers;
        this.dateTimePicker.setWeekNumbersVisible(showWeekNumbers);
        this.markAsDirty();
    }

    public String getParseErrorMessage() {
        return this.defaultParseErrorMessage;
    }

    public void setParseErrorMessage(String parsingErrorMessage) {
        this.defaultParseErrorMessage = parsingErrorMessage;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        this.markAsDirty();
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    private ZoneId getZoneId() {
        return this.getTimeZone() != null ? this.getTimeZone().toZoneId() : ZoneId.systemDefault();
    }

    public String getDateOutOfRangeMessage() {
        return this.dateOutOfRangeMessage;
    }

    @Override
    public void setLocale(Locale locale) {
        this.dateTimePicker.setLocale(locale);
        FAbstractComponent.super.setLocale(locale);
    }

    public void setStep(Duration step) {
        this.dateTimePicker.setStep(step);
    }

    public Duration getStep() {
        return this.dateTimePicker.getStep();
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.dateTimePicker.setReadOnly(readOnly);
    }

    protected void fireEvent(ComponentEvent<?> componentEvent) {
        FAbstractComponent.super.fireEvent((EventObject)componentEvent, this.getEventBus());
    }

    public static class UnparsableDateString
    extends Validator.InvalidValueException {
        public UnparsableDateString(String message) {
            super(message);
        }
    }
}

