/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.featurepack.ui;

import com.vaadin.featurepack.data.Container;
import com.vaadin.featurepack.data.ui.FAbstractSelect;
import com.vaadin.featurepack.data.ui.Select;
import com.vaadin.featurepack.event.FieldEvents;
import com.vaadin.featurepack.server.HasSizeable;
import com.vaadin.featurepack.shared.ui.combobox.FilteringMode;
import com.vaadin.featurepack.shared.ui.combobox.ItemStyleGenerator;
import com.vaadin.featurepack.ui.FAbstractComponent;
import com.vaadin.featurepack.ui.LabelSlotController;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.provider.IdentifierProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableFunction;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;

public class FComboBox
extends ComboBox<Object>
implements Select,
FAbstractComponent,
FieldEvents.FocusNotifier,
FieldEvents.BlurNotifier,
HasSizeable {
    private static final String PROP_SELECTED_ITEM = "selectedItem";
    private static final String PROP_VALUE = "value";
    private final LabelSlotController labelSlotController = new LabelSlotController((HasLabel)this, "label");
    private boolean textInputAllowed = true;
    private boolean scrollToSelectedItem = true;
    private String popupWidth = null;
    private ItemStyleGenerator itemStyleGenerator = null;
    private FilteringMode filteringMode = FilteringMode.STARTSWITH;
    private boolean refreshing = false;

    public FComboBox() {
        this.setPageLength(10);
        this.setNullSelectionAllowed(true);
        this.setNewItemsAllowed(false);
        this.setItemLabelGenerator(null);
        this.setClearButtonVisible(true);
        this.addItemSetChangeListener(event -> this.refreshItems());
        this.getElement().addPropertyChangeListener("opened", "opened-changed", (PropertyChangeListener & Serializable)event -> this.onOpenedChanged());
        this.setItemsWithFilterConverter(this::fetchItems, this::countItems, this::convertFilter);
        this.getLazyDataView().setIdentifierProvider((IdentifierProvider & Serializable)itemId -> itemId == null ? NullItemId.INSTANCE : this.getDataProvider().getId(itemId));
        this.getFAbstractSelect();
    }

    public FComboBox(String caption) {
        this();
        this.setCaption(caption);
    }

    public FComboBox(String caption, Collection<?> options) {
        this(caption);
        this.addItems(options);
    }

    public FComboBox(String caption, Container dataSource) {
        this(caption);
        this.setContainerDataSource(dataSource);
    }

    protected void fireEvent(ComponentEvent<?> componentEvent) {
        FAbstractComponent.super.fireEvent((EventObject)componentEvent, this.getEventBus());
    }

    @Override
    public void setValue(Object value) {
        if (this.getDataCommunicator() == null || this.getDataProvider() instanceof DataCommunicator.EmptyDataProvider) {
            value = null;
        } else if (value == null) {
            value = this.getNullSelectionItemId() == null ? NullItemId.INSTANCE : this.getNullSelectionItemId();
        }
        super.setValue(value);
    }

    @Override
    public Object getValue() {
        if (!this.isComponentInitialized()) {
            return null;
        }
        Object value = super.getValue();
        return this.isNullItem(value) ? null : value;
    }

    public void setTextInputAllowed(boolean textInputAllowed) {
        this.textInputAllowed = textInputAllowed;
        if (textInputAllowed) {
            this.getElement().executeJs("this.inputElement.removeAttribute('readonly');", new Serializable[0]);
        } else {
            this.getElement().executeJs("this.inputElement.setAttribute('readonly', true);", new Serializable[0]);
        }
    }

    public boolean isTextInputAllowed() {
        return this.textInputAllowed;
    }

    public void setScrollToSelectedItem(boolean scrollToSelectedItem) {
        this.scrollToSelectedItem = scrollToSelectedItem;
    }

    public boolean isScrollToSelectedItem() {
        return this.scrollToSelectedItem;
    }

    public void setPageLength(int pageLength) {
        this.setPageSize(pageLength);
    }

    public int getPageLength() {
        return this.getPageSize();
    }

    public void setPopupWidth(String popupWidth) {
        this.popupWidth = popupWidth;
        this.setOverlayWidth(popupWidth);
    }

    public String getPopupWidth() {
        return this.popupWidth;
    }

    public void setItemLabelGenerator(ItemLabelGenerator<Object> itemLabelGenerator) {
        super.setItemLabelGenerator(this.getModifiedItemLabelGenerator(itemLabelGenerator));
    }

    public void setFilteringMode(FilteringMode filteringMode) {
        boolean needsRefresh = this.filteringMode != filteringMode;
        this.filteringMode = filteringMode;
        if (needsRefresh) {
            this.refreshItems();
        }
    }

    public FilteringMode getFilteringMode() {
        return this.filteringMode;
    }

    public void setItemStyleGenerator(ItemStyleGenerator itemStyleGenerator) {
        this.itemStyleGenerator = itemStyleGenerator;
        this.setClassNameGenerator(this.getClassNameGenerator());
    }

    public ItemStyleGenerator getItemStyleGenerator() {
        return this.itemStyleGenerator;
    }

    @Override
    public void setNullSelectionAllowed(boolean nullSelectionAllowed) {
        boolean needsRefresh = this.isNullSelectionAllowed() != nullSelectionAllowed;
        this.getFAbstractSelect().setNullSelectionAllowed(nullSelectionAllowed);
        if (needsRefresh) {
            this.refreshItems();
        }
    }

    @Override
    public void setNullSelectionItemId(Object nullSelectionItemId) {
        boolean needsRefresh = this.getNullSelectionItemId() != nullSelectionItemId;
        Select.super.setNullSelectionItemId(nullSelectionItemId);
        if (needsRefresh) {
            this.refreshItems();
        }
    }

    public void setLabel(String label) {
        this.labelSlotController.setLabel(label);
    }

    @Override
    public void setLabelComponent(Component labelComponent) {
        this.labelSlotController.setLabelComponent(labelComponent);
    }

    @Override
    public void setMultiSelect(boolean multiSelect) {
        if (multiSelect) {
            throw new UnsupportedOperationException("Multiselect not supported by ComboBox");
        }
    }

    @Override
    public boolean isMultiSelect() {
        return false;
    }

    @Override
    public void validate() {
        Select.super.validate();
    }

    public void addItems(Object ... itemIds) throws UnsupportedOperationException {
        this.getFAbstractSelect().addItems(itemIds);
    }

    public void addItems(Collection<?> itemIds) throws UnsupportedOperationException {
        this.getFAbstractSelect().addItems(itemIds);
    }

    public void setItemCaption(Object itemId, String caption) {
        this.getFAbstractSelect().setItemCaption(itemId, caption);
    }

    @Override
    public void setItemCaptionMode(FAbstractSelect.ItemCaptionMode mode) {
        this.getFAbstractSelect().setItemCaptionMode(mode);
    }

    @Override
    public FAbstractSelect.ItemCaptionMode getItemCaptionMode() {
        return this.getFAbstractSelect().getItemCaptionMode();
    }

    public void setNewItemHandler(FAbstractSelect.NewItemHandler newItemHandler) {
        this.getFAbstractSelect().setNewItemHandler(newItemHandler);
    }

    public FAbstractSelect.NewItemHandler getNewItemHandler() {
        return this.getFAbstractSelect().getNewItemHandler();
    }

    @Override
    public Class<?> getType() {
        return this.getFAbstractSelect().getType();
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.doConnectorOnAttach(attachEvent);
        this.patchWebComponent();
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.doConnectorOnDetach(detachEvent);
    }

    @Override
    public void setRequired(boolean required) {
        Select.super.setRequired(required);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshValue() {
        if (this.refreshing) {
            return;
        }
        this.refreshing = true;
        try {
            Object value = this.getValue();
            if (value == null && this.isNullSelectionAllowed()) {
                Object object = value = this.getNullSelectionItemId() == null ? NullItemId.INSTANCE : this.getNullSelectionItemId();
            }
            if (NullItemId.INSTANCE.equals(value) && !this.isNullSelectionAllowed()) {
                value = null;
            }
            DataKeyMapper keyMapper = this.getKeyMapper();
            if (value != null && keyMapper.has(value)) {
                value = keyMapper.get(keyMapper.key(value));
            }
            if (value == null && !this.isNullSelectionAllowed()) {
                this.getElement().setProperty(PROP_SELECTED_ITEM, null);
                this.getElement().setProperty(PROP_VALUE, "");
                this.getElement().executeJs("this._inputElementValue = $0", new Serializable[]{""});
                return;
            }
            JsonObject json = Json.createObject();
            json.put("key", keyMapper.key(value));
            this.getDataGenerator().generateData(value, json);
            this.getElement().setPropertyJson(PROP_SELECTED_ITEM, (JsonValue)json);
            this.getElement().setProperty(PROP_VALUE, keyMapper.key(value));
            this.getElement().executeJs("this._inputElementValue = $0", new Serializable[]{this.getItemLabelGenerator().apply(value)});
        }
        finally {
            this.refreshing = false;
        }
    }

    private void refreshItems() {
        if (this.getContainerDataSource() == null) {
            return;
        }
        this.getDataProvider().refreshAll();
        if (this.isNullSelectionAllowed() && this.getValue() == null) {
            this.setValue(this.getValue());
        }
    }

    private Stream<Object> fetchItems(Query<Object, SerializableFunction<Object, Boolean>> query) {
        return this.getFilteredItemIdStream(query).skip(query.getOffset()).limit(query.getLimit());
    }

    private int countItems(Query<Object, SerializableFunction<Object, Boolean>> query) {
        return (int)this.getFilteredItemIdStream(query).count();
    }

    private SerializableFunction<Object, Boolean> convertFilter(String filterText) {
        return (SerializableFunction & Serializable)itemId -> {
            if (filterText == null || filterText.isEmpty()) {
                return true;
            }
            return switch (this.filteringMode) {
                case FilteringMode.STARTSWITH -> this.getItemLabelGenerator().apply(itemId).toLowerCase().startsWith(filterText.toLowerCase());
                case FilteringMode.CONTAINS -> this.getItemLabelGenerator().apply(itemId).toLowerCase().contains(filterText.toLowerCase());
                default -> true;
            };
        };
    }

    private void scrollToIndex() {
        Object value = this.getValue();
        if (value != null) {
            this.getGenericDataView().getItemIndex(value).ifPresent(index -> this.getElement().executeJs("this._scroller.__virtualizer.scrollToIndex($0)", new Serializable[]{index}));
        }
    }

    private void onOpenedChanged() {
        if (this.isScrollToSelectedItem() && this.isOpened()) {
            this.scrollToIndex();
        }
    }

    private SerializableFunction<Object, String> getClassNameGenerator() {
        if (this.itemStyleGenerator == null) {
            return (SerializableFunction & Serializable)item -> null;
        }
        return (SerializableFunction & Serializable)item -> {
            String style = this.itemStyleGenerator.getStyle(this, item);
            if (style == null || style.isEmpty()) {
                return null;
            }
            return "v-filterselect-item-" + style;
        };
    }

    private ItemLabelGenerator<Object> getModifiedItemLabelGenerator(ItemLabelGenerator<Object> itemLabelGenerator) {
        return (ItemLabelGenerator & Serializable)itemId -> {
            if (itemId == null) {
                itemId = this.getNullSelectionItemId();
            }
            if (this.isNullItem(itemId) && !new HashSet(this.getItemIds()).contains(itemId)) {
                return "";
            }
            if (itemLabelGenerator == null) {
                return this.getItemCaption(itemId);
            }
            return itemLabelGenerator.apply(itemId);
        };
    }

    private Stream<Object> getFilteredItemIdStream(Query<Object, SerializableFunction<Object, Boolean>> query) {
        ArrayList<NullItemId> finalItemIds = new ArrayList<NullItemId>();
        Collection itemIds = this.getItemIds();
        if (this.isNullSelectionAllowed() && !new HashSet(itemIds).contains(this.getNullSelectionItemId())) {
            finalItemIds.add((NullItemId)((Object)(this.getNullSelectionItemId() == null ? NullItemId.INSTANCE : this.getNullSelectionItemId())));
        }
        finalItemIds.addAll(itemIds);
        return finalItemIds.stream().map(Object.class::cast).filter(itemId -> {
            AtomicBoolean passes = new AtomicBoolean(true);
            query.getFilter().ifPresent(filter -> passes.set((Boolean)filter.apply(itemId)));
            return passes.get();
        });
    }

    private boolean isNullItem(Object itemId) {
        return this.isNullSelectionAllowed() && (Objects.equals(this.getNullSelectionItemId(), itemId) || Objects.equals((Object)NullItemId.INSTANCE, itemId));
    }

    private boolean isComponentInitialized() {
        return ComponentUtil.getData((Component)this, (String)"FeaturePack.DataBinding.FAbstractSelect") != null;
    }

    private void handleProbableNewItem(String filter) {
        if (!this.isNewItemsAllowed() || filter == null || filter.isEmpty()) {
            return;
        }
        if (this.getItemIds().stream().map(this.getItemLabelGenerator()).noneMatch(filter::equals)) {
            this.getNewItemHandler().addNewItem(filter);
            this.setValue(filter);
        }
    }

    private void patchWebComponent() {
        this.getElement().addEventListener("combo-box-value-committed", (DomEventListener & Serializable)e -> this.handleProbableNewItem(e.getEventData().getString("event.detail.inputElementValue"))).addEventData("event.detail.inputElementValue");
        this.getElement().executeJs("this._commitValue = () => {\n        this.dispatchEvent(new CustomEvent('combo-box-value-committed', {\n          detail: { inputElementValue: this._inputElementValue }\n        }));\n        if (this._focusedIndex > -1) {\n          const focusedItem = this._dropdownItems[this._focusedIndex];\n          if (this.selectedItem !== focusedItem) {\n            this.selectedItem = focusedItem;\n          }\n          this._inputElementValue = this._getItemLabel(this.selectedItem);\n        } else if (this._inputElementValue === '' || this._inputElementValue === undefined) {\n          this.selectedItem = null;\n          if (this.allowCustomValue) {\n            this.value = '';\n          }\n        } else {\n          const items = [this.selectedItem, ...(this._dropdownItems || [])];\n          const itemMatchingInputValue = items[this.__getItemIndexByLabel(items, this._inputElementValue)];\n          if (\n            this.allowCustomValue &&\n            !itemMatchingInputValue\n          ) {\n            const customValue = this._inputElementValue;\n            this._lastCustomValue = customValue;\n            const e = new CustomEvent('custom-value-set', {\n              detail: customValue,\n              composed: true,\n              cancelable: true,\n              bubbles: true,\n            });\n            this.dispatchEvent(e);\n            if (!e.defaultPrevented) {\n              this.value = customValue;\n            }\n          } else if (!this.allowCustomValue && !this.opened && itemMatchingInputValue) {\n            this.value = this._getItemValue(itemMatchingInputValue);\n          } else {\n            this._revertInputValueToValue();\n          }\n        }\n        this._detectAndDispatchChange();\n        this._clearSelectionRange();\n        this._clearFilter();\n};", new Serializable[0]);
        this.getElement().executeJs("const originalOnOpened = this._onOpened;\nthis._onOpened = () => {\n  requestAnimationFrame(() => {\n    this._scrollIntoView(this._focusedIndex);\n    this._updateActiveDescendant(this._focusedIndex);\n  });\n  originalOnOpened.apply(this);\n};", new Serializable[0]);
        this.getElement().executeJs("const originalSelectedItemChanged = this._selectedItemChanged;\nthis._selectedItemChanged = (selectedItem) => {\n  originalSelectedItemChanged.call(this, selectedItem);\n  if (this.filteredItems) {\n    const newFocusedIndex = this.filteredItems.findIndex((item) => item.key === selectedItem.key);\n    if (newFocusedIndex != null) {\n      this._focusedIndex = newFocusedIndex;\n    }\n  }\n};", new Serializable[0]);
        this.getElement().executeJs("this.__getItemIndexByLabel = function (items, label) {\n      if (!items || label == null) {\n        return -1;\n      }\n      const callback = (item) => {\n        return this._getItemLabel(item).toString().toLowerCase() === label.toString().toLowerCase();\n      };\n      return items.findIndex((item) => {\n          return callback(item);\n        });\n    }", new Serializable[0]);
        this.getElement().executeJs("this._setDropdownItems = (newItems) => {\n  const oldItems = this._dropdownItems;\n  this._dropdownItems = newItems;\n  const focusedItem = oldItems ? oldItems[this._focusedIndex] : null;\n  const valueIndex = this.__getItemIndexByValue(newItems, this.value);\n  if ((this.selectedItem === null || this.selectedItem === undefined) && valueIndex >= 0) {\n    this.selectedItem = newItems[valueIndex];\n  }\n  const focusedItemIndex = this.__getItemIndexByValue(newItems, this._getItemValue(focusedItem));\n  if (focusedItemIndex > -1) {\n    this._focusedIndex = focusedItemIndex;\n  } else {\n    const inputValue = this._inputElementValue;\n    if (!!this.selectedItem && (!inputValue || inputValue === this._getItemLabel(this.selectedItem))) {\n      this._focusedIndex = this.__getItemIndexByLabel(this.filteredItems, this._getItemLabel(this.selectedItem));\n    } else if (!inputValue && !!this.filteredItems) {\n      this._focusedIndex = 0;\n    } else {\n      this._focusedIndex = this.__getItemIndexByLabel(this.filteredItems, this.filter);\n    }\n  }\n};", new Serializable[0]);
        this.getElement().executeJs("this._overlayElement.addEventListener('vaadin-overlay-outside-click', (event) => {\n  if (!this.opened || event.defaultPrevented) {\n    return;\n  }\n  if (this.selectedItem) {\n    this._focusedIndex = this.filteredItems.findIndex((item) => item.key === this.selectedItem.key);\n    this._inputElementValue = this._getItemLabel(this.selectedItem);\n  } else {\n    this._focusedIndex = -1;\n    this._inputElementValue = '';\n  }\n});", new Serializable[0]);
    }

    static enum NullItemId {
        INSTANCE;

    }
}

